/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.yunzhijia.diff.impl.org;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kd.bos.base.utils.msg.OrgMessage;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.utils.DynamicObjectUtils;
import kd.bos.org.utils.OrgViewUtils;
import kd.bos.org.utils.Utils;
import kd.bos.org.yunzhijia.diff.impl.YzjSyncReport;
import kd.bos.org.yunzhijia.diff.impl.utils.YzjSyncImplUtils;
import kd.bos.org.yunzhijia.model.DifferenceType;
import kd.bos.org.yunzhijia.model.SyncReport;
import kd.bos.org.yunzhijia.model.SyncReportEntry;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class OrgSyncBackup {
    private static final Log log = LogFactory.getLog(OrgSyncBackup.class);

    public static boolean saveYzjData(long taskId, String yzjRootName, TreeMap<Integer, Map<String, Map<String, Object>>> levelMap, List<String> parentList) {
        log.debug("\u5f00\u59cb\u5907\u4efd\u4e91\u4e4b\u5bb6\u7ec4\u7ec7\u6570\u636e");
        if (CollectionUtils.isEmpty(levelMap)) {
            return true;
        }
        if (parentList == null) {
            parentList = new ArrayList<String>(0);
        }
        ArrayList<DynamicObject> orgList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> orgStructureList = new ArrayList<DynamicObject>();
        long userId = RequestContext.get().getCurrUserId();
        Date time = new Date();
        HashMap<String, Map<String, Object>> parentMap = new HashMap<String, Map<String, Object>>();
        ArrayList<Map<String, Object>> noParentList = new ArrayList<Map<String, Object>>();
        String fullNameSep = OrgUnitServiceHelper.getOrgSeparation().getFullNameSep();
        long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
        for (Map.Entry<Integer, Map<String, Map<String, Object>>> levelEntry : levelMap.entrySet()) {
            int level = levelEntry.getKey();
            Map<String, Map<String, Object>> yzjOrgMap = levelEntry.getValue();
            for (Map.Entry<String, Map<String, Object>> orgEntry : yzjOrgMap.entrySet()) {
                Map<String, Object> dataMap = orgEntry.getValue();
                String yzjOrgId = dataMap.get("id").toString();
                parentMap.put(yzjOrgId, dataMap);
                String yzjDepartment = dataMap.get("department").toString();
                if (level == 1) {
                    dataMap.put("fullname", yzjDepartment);
                } else {
                    String parentId = dataMap.get("parentId").toString();
                    String erpDepartment = (yzjRootName + fullNameSep + yzjDepartment).replace("\\", fullNameSep);
                    dataMap.put("fullname", erpDepartment);
                    Map parentDataMap = (Map)parentMap.get(parentId);
                    if (parentDataMap == null) {
                        dataMap.put("parent", rootOrgId);
                        dataMap.put("longnumber", dataMap.get("number").toString());
                        noParentList.add(dataMap);
                    } else {
                        dataMap.put("parent", parentDataMap.get("org"));
                        String parentLongnumber = parentDataMap.get("longnumber").toString();
                        String longnumber = parentLongnumber + "!" + dataMap.get("number");
                        dataMap.put("longnumber", longnumber);
                    }
                }
                if (parentList.contains(yzjOrgId)) {
                    dataMap.put("isleaf", 0);
                } else {
                    dataMap.put("isleaf", 1);
                }
                orgList.add(OrgSyncBackup.genOrg(taskId, dataMap, userId, time));
                orgStructureList.add(OrgSyncBackup.genOrgStructure(dataMap, userId, time));
            }
        }
        OrgSyncBackup.saveNoParentReport(taskId, noParentList);
        SaveServiceHelper.save((DynamicObject[])orgList.toArray(new DynamicObject[orgList.size()]));
        SaveServiceHelper.save((DynamicObject[])orgStructureList.toArray(new DynamicObject[orgStructureList.size()]));
        OrgSyncBackup.updateOrg(taskId, "cloud-hub");
        return true;
    }

    private static void saveNoParentReport(long taskId, List<Map<String, Object>> yzjOrgList) {
        if (Utils.isListEmpty(yzjOrgList)) {
            return;
        }
        ArrayList<SyncReport> reportList = new ArrayList<SyncReport>(yzjOrgList.size());
        for (Map<String, Object> orgMap : yzjOrgList) {
            SyncReport report = new SyncReport();
            report.setTaskId(taskId);
            report.setStatus(3);
            report.setDataType(DifferenceType.ORG.getKey());
            report.setSyncObject(orgMap.get("name").toString());
            report.setYzjDataId(orgMap.get("id").toString());
            List<SyncReportEntry> entryList = report.getEntryList();
            SyncReportEntry reportEntry = new SyncReportEntry();
            reportEntry.setOperation("manual");
            reportEntry.setProperty("yzjparentorgid");
            reportEntry.setYzjValue(orgMap.get("fullname").toString());
            reportEntry.setNote(OrgMessage.getMessage((String)"M00055"));
            entryList.add(reportEntry);
            reportList.add(report);
        }
        YzjSyncReport.add(reportList);
    }

    private static DynamicObject genOrg(long taskId, Map<String, Object> dataMap, long userId, Date time) {
        DynamicObject orgObj = BusinessDataServiceHelper.newDynamicObject((String)"bos_yzj_org");
        orgObj.set("id", dataMap.get("org"));
        orgObj.set("task", (Object)taskId);
        orgObj.set("backuptype", (Object)"cloud-hub");
        orgObj.set("number", dataMap.get("number"));
        orgObj.set("name", dataMap.get("name"));
        orgObj.set("fyzjorgid", dataMap.get("id"));
        orgObj.set("creator", (Object)userId);
        orgObj.set("createtime", (Object)time);
        orgObj.set("enable", (Object)1);
        orgObj.set("status", (Object)"C");
        return orgObj;
    }

    private static DynamicObject genOrgStructure(Map<String, Object> dataMap, long userId, Date time) {
        DynamicObject orgStructure = BusinessDataServiceHelper.newDynamicObject((String)"bos_yzj_orgstructure");
        orgStructure.set("view", (Object)1L);
        orgStructure.set("org", dataMap.get("org"));
        orgStructure.set("yzjorgid", dataMap.get("id"));
        orgStructure.set("parent", dataMap.get("parent"));
        orgStructure.set("yzjparentorgid", dataMap.get("parentId"));
        orgStructure.set("level", dataMap.get("level"));
        orgStructure.set("longnumber", dataMap.get("longnumber"));
        orgStructure.set("fullname", dataMap.get("fullname"));
        Object weights = dataMap.get("weights");
        if (StringUtils.isNotBlank((Object)weights)) {
            if ((weights = weights.toString().replace("-", "")).toString().length() <= 10) {
                orgStructure.set("sortcode", weights);
            }
            try {
                long sortNumber = Long.parseLong(weights.toString());
                orgStructure.set("sortnumber", (Object)sortNumber);
            }
            catch (NumberFormatException e) {
                log.info("OrgSyncBackup:weights can not parse to Long,", (Object)e.getMessage());
            }
        }
        orgStructure.set("isleaf", dataMap.get("isleaf"));
        orgStructure.set("creator", (Object)userId);
        orgStructure.set("createtime", (Object)time);
        orgStructure.set("enable", (Object)1);
        orgStructure.set("status", (Object)"C");
        return orgStructure;
    }

    private static void updateOrg(long taskId, String syncBackupType) {
        QFilter typeFilter;
        Map<String, Long> orgIdMap = YzjSyncImplUtils.getOrgIdMap();
        if (orgIdMap == null || orgIdMap.isEmpty()) {
            return;
        }
        String selectFields = "id,org,fyzjorgid";
        QFilter taskFilter = new QFilter("task", "=", (Object)taskId);
        QFilter[] filters = new QFilter[]{taskFilter, typeFilter = new QFilter("backuptype", "=", (Object)syncBackupType)};
        DynamicObject[] orgArr = BusinessDataServiceHelper.load((String)"bos_yzj_org", (String)selectFields, (QFilter[])filters);
        if (orgArr == null || orgArr.length == 0) {
            log.debug("\u65e0\u7ec4\u7ec7\u4fe1\u606f");
            return;
        }
        for (DynamicObject org : orgArr) {
            Long orgId = orgIdMap.get(org.getString("fyzjorgid"));
            if (orgId == null) continue;
            org.set("org", (Object)orgId);
        }
        SaveServiceHelper.save((DynamicObject[])orgArr);
    }

    public static boolean saveErpDataById(long taskId, String syncBackupType, List<Long> orgIds) {
        if (Utils.isListEmpty(orgIds)) {
            return true;
        }
        QFilter taskFilter = new QFilter("task", "=", (Object)taskId);
        QFilter typeFilter = new QFilter("backuptype", "=", (Object)syncBackupType);
        QFilter idFilter = new QFilter("org", "in", orgIds);
        QFilter[] filters = new QFilter[]{taskFilter, typeFilter, idFilter};
        DeleteServiceHelper.delete((String)"bos_yzj_org", (QFilter[])filters);
        return OrgSyncBackup.saveErpDataByFilter(taskId, syncBackupType, idFilter);
    }

    public static boolean saveErpDataByFilter(long taskId, String syncBackupType, QFilter otherFilter) {
        QFilter[] filters;
        DynamicObjectCollection orgCol;
        String selectFields = "id,view,org,org.number number,org.name name,org.enable enable,parent,org.fyzjorgid fyzjorgid,level,longnumber,fullname,isleaf,yzjorgid,yzjparentorgid,isfreeze,sealuptime,sortcode,sortnumber";
        QFilter viewFilter = OrgViewUtils.getOrgViewFilter((String)"01");
        if (otherFilter != null) {
            viewFilter.and(otherFilter);
        }
        if (Utils.isListEmpty((List)(orgCol = QueryServiceHelper.query((String)"bos_org_structure", (String)selectFields, (QFilter[])(filters = new QFilter[]{viewFilter}), (String)"level")))) {
            log.debug("\u65e0\u7ec4\u7ec7\u4fe1\u606f");
            return true;
        }
        HashMap<Long, Long> orgIdMap = new HashMap<Long, Long>(orgCol.size());
        OrgSyncBackup.saveOrg(taskId, syncBackupType, orgCol, orgIdMap);
        OrgSyncBackup.saveOrgStructure(orgCol, orgIdMap);
        return true;
    }

    private static void saveOrg(long taskId, String syncBackupType, DynamicObjectCollection orgCol, Map<Long, Long> orgIdMap) {
        int index = 0;
        int count = orgCol.size();
        DynamicObject[] backupObjArr = new DynamicObject[count];
        long userId = RequestContext.get().getCurrUserId();
        Date time = new Date();
        long[] orgIdArr = ORM.create().genLongIds("bos_org", count);
        int idIndex = 0;
        for (DynamicObject org : orgCol) {
            DynamicObject backupObj = BusinessDataServiceHelper.newDynamicObject((String)"bos_yzj_org");
            DynamicObjectUtils.copy((DynamicObject)org, (DynamicObject)backupObj);
            long id = orgIdArr[idIndex++];
            orgIdMap.put(org.getLong("org"), id);
            backupObj.set("id", (Object)id);
            backupObj.set("task", (Object)taskId);
            backupObj.set("backuptype", (Object)syncBackupType);
            backupObj.set("org", (Object)org.getLong("org"));
            backupObj.set("creator", (Object)userId);
            backupObj.set("createtime", (Object)time);
            backupObj.set("enable", (Object)"1");
            backupObj.set("status", (Object)"C");
            backupObjArr[index++] = backupObj;
        }
        SaveServiceHelper.save((DynamicObject[])backupObjArr);
    }

    private static void saveOrgStructure(DynamicObjectCollection orgCol, Map<Long, Long> orgIdMap) {
        int index = 0;
        DynamicObject[] backupObjArr = new DynamicObject[orgCol.size()];
        for (DynamicObject org : orgCol) {
            DynamicObject backupObj = BusinessDataServiceHelper.newDynamicObject((String)"bos_yzj_orgstructure");
            DynamicObjectUtils.copy((DynamicObject)org, (DynamicObject)backupObj);
            backupObj.set("org", (Object)orgIdMap.get(org.getLong("org")));
            backupObj.set("parent", (Object)orgIdMap.get(org.getLong("parent")));
            backupObj.set("enable", (Object)"1");
            backupObj.set("status", (Object)"C");
            backupObjArr[index++] = backupObj;
        }
        SaveServiceHelper.save((DynamicObject[])backupObjArr);
    }
}

