/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.yunzhijia.diff.impl.org;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.utils.msg.BaseMessage;
import kd.bos.base.utils.msg.OrgMessage;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.manager.CacheManager;
import kd.bos.org.model.OrgDutyView;
import kd.bos.org.model.OrgParam;
import kd.bos.org.utils.OrgUtils;
import kd.bos.org.utils.OrgViewUtils;
import kd.bos.org.utils.Utils;
import kd.bos.org.yunzhijia.diff.impl.org.OrgSyncBackup;
import kd.bos.org.yunzhijia.diff.impl.utils.YzjSyncCache;
import kd.bos.org.yunzhijia.model.SyncContextParam;
import kd.bos.org.yunzhijia.model.SyncInnerObject;
import kd.bos.org.yunzhijia.model.SyncOutterObject;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.yzj.config.YzjConfigServiceHelper;
import kd.bos.yzj.model.YzjConfig;

public class OrgSyncOperation {
    private static final Log log = LogFactory.getLog(OrgSyncOperation.class);
    private final long taskId;
    private final long userId;
    private final Date exeTime;
    private YzjConfig yzjConfig;

    public OrgSyncOperation(SyncContextParam contextParam) {
        this.taskId = contextParam.getTaskId();
        this.userId = RequestContext.get().getCurrUserId();
        this.exeTime = new Date();
    }

    public boolean sync() {
        QFilter taskFilter = new QFilter("task", "=", (Object)this.taskId);
        QFilter typeFilter = new QFilter("datatype", "=", (Object)"org");
        QFilter statusFilter = new QFilter("status", "=", (Object)Integer.toString(0));
        QFilter[] filters = new QFilter[]{taskFilter, typeFilter, statusFilter};
        DynamicObjectCollection reportCol = QueryServiceHelper.query((String)"bos_yzj_syncreport", (String)"id", (QFilter[])filters);
        if (Utils.isListEmpty((List)reportCol)) {
            log.debug("\u65e0\u540c\u6b65\u6570\u636e");
            return true;
        }
        ArrayList<Long> reportIds = new ArrayList<Long>(reportCol.size());
        for (DynamicObject report : reportCol) {
            reportIds.add(report.getLong("id"));
        }
        return this.syncByReportId(reportIds);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean syncByReportId(List<Long> reportIds) {
        if (Utils.isListEmpty(reportIds)) {
            return true;
        }
        YzjSyncCache.updateTaskProgress(ResManager.loadKDString((String)"\u6b63\u5728\u66f4\u65b0\u7ec4\u7ec7\u4fe1\u606f\u5230\u5f53\u524d\u7cfb\u7edf\uff0c\u8bf7\u7a0d\u7b49\u3002", (String)"OrgSyncOperation_0", (String)"bos-org-formplugin", (Object[])new Object[0]));
        DynamicObject[] reportArr = this.getReport(reportIds);
        if (reportArr == null || reportArr.length == 0) {
            log.debug("\u65e0\u540c\u6b65\u6570\u636e");
            return true;
        }
        this.yzjConfig = YzjConfigServiceHelper.getConfig();
        Throwable throwable = null;
        try (TXHandle h = TX.required();){
            if (this.isAddRootOrg(reportArr)) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            h.markRollback();
            log.info("\u540c\u6b65\u6839\u7ec4\u7ec7\u65f6\u53d1\u751f\u5f02\u5e38\uff1a" + e.getMessage(), (Object)e);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u540c\u6b65\u6839\u7ec4\u7ec7\u65f6\u53d1\u751f\u5f02\u5e38\uff1a%1$s", (String)"OrgSyncOperation_1", (String)"bos-org-formplugin", (Object[])new Object[0]), e.getMessage()));
        }
        catch (Throwable e) {
            throwable = e;
            throw e;
        }
        int count = reportArr.length;
        HashMap<String, Long> idMap = new HashMap<String, Long>(count);
        SyncOutterObject addList = new SyncOutterObject();
        SyncInnerObject unFreezeList = new SyncInnerObject();
        SyncInnerObject freezeList = new SyncInnerObject();
        HashMap<String, OrgParam> updateOrgParamMap = new HashMap<String, OrgParam>(count);
        ArrayList<Long> unMoveList = new ArrayList<Long>(count);
        HashMap<String, DynamicObject> reportMap = new HashMap<String, DynamicObject>(count);
        ArrayList<Long> orgIds = new ArrayList<Long>(reportArr.length);
        List orgIgnoreOperations = this.yzjConfig.getOrgIgnoreOperations();
        DynamicObject[] dynamicObjectArray = reportArr;
        int n = dynamicObjectArray.length;
        int n2 = 0;
        while (true) {
            Iterator iterator;
            long erpDataId;
            String yzjDataId;
            DynamicObject report;
            if (n2 < n) {
                report = dynamicObjectArray[n2];
                report.set("status", (Object)1);
                yzjDataId = report.getString("yzjdataid");
                reportMap.put(yzjDataId, report);
                erpDataId = 0L;
                if (StringUtils.isNotBlank((Object)report.get("erpdataid"))) {
                    erpDataId = report.getLong("erpdataid");
                    idMap.put(yzjDataId, erpDataId);
                    orgIds.add(erpDataId);
                }
                DynamicObjectCollection entryentityCol = report.getDynamicObjectCollection("entryentity");
                iterator = entryentityCol.iterator();
            } else {
                try (TXHandle h = TX.required();){
                    try {
                        this.add(addList, idMap, reportMap);
                        this.unFreeze(unFreezeList);
                        this.update(updateOrgParamMap, idMap, unMoveList, reportMap);
                        this.freeze(freezeList);
                        SaveServiceHelper.save((DynamicObject[])reportArr);
                        CacheManager.removeCache((String)"bos_org");
                        CacheManager.removeCache((String)"bos_adminorg");
                        CacheManager.removeCache((String)"bos_org_structure");
                        OrgSyncBackup.saveErpDataById(this.taskId, "after", orgIds);
                        PermissionServiceHelper.clearAllCache();
                        return true;
                    }
                    catch (Exception e) {
                        log.info("\u540c\u6b65\u4e91\u4e4b\u5bb6\u4eba\u5458\u4fe1\u606f\u5230\u82cd\u7a79\u53d1\u751f\u5f02\u5e38\uff1a" + e.getMessage(), (Object)e);
                        h.markRollback();
                        throw new KDBizException(BaseMessage.getMessage((String)"M00061", (Object[])new Object[]{e.getMessage()}));
                    }
                }
            }
            block37: while (iterator.hasNext()) {
                String operation;
                DynamicObject entryObj = (DynamicObject)iterator.next();
                switch (operation = entryObj.getString("operation")) {
                    case "add": {
                        if (orgIgnoreOperations.contains("add")) {
                            report.set("status", (Object)4);
                            entryObj.set("description", (Object)OrgMessage.getMessage((String)"M00056"));
                            continue block37;
                        }
                        addList.getOutterList().add(yzjDataId);
                        addList.getOutterMap().put(yzjDataId, report);
                        continue block37;
                    }
                    case "unfreeze": {
                        if (orgIgnoreOperations.contains("unfreeze")) {
                            report.set("status", (Object)4);
                            entryObj.set("description", (Object)OrgMessage.getMessage((String)"M00059"));
                            continue block37;
                        }
                        unFreezeList.getInnerList().add(erpDataId);
                        unFreezeList.getInnerMap().put(erpDataId, report);
                        continue block37;
                    }
                    case "freeze": {
                        if (orgIgnoreOperations.contains("freeze")) {
                            report.set("status", (Object)4);
                            entryObj.set("description", (Object)OrgMessage.getMessage((String)"M00058"));
                            continue block37;
                        }
                        freezeList.getInnerList().add(erpDataId);
                        freezeList.getInnerMap().put(erpDataId, report);
                        continue block37;
                    }
                    case "move": {
                        if (orgIgnoreOperations.contains("move")) {
                            report.set("status", (Object)4);
                            entryObj.set("description", (Object)OrgMessage.getMessage((String)"M00060"));
                            unMoveList.add(erpDataId);
                            continue block37;
                        }
                        this.putUpdateOrgParamMap(updateOrgParamMap, erpDataId, yzjDataId);
                        continue block37;
                    }
                }
                if (orgIgnoreOperations.contains("edit")) {
                    report.set("status", (Object)4);
                    entryObj.set("description", (Object)OrgMessage.getMessage((String)"M00057"));
                    continue;
                }
                this.putUpdateOrgParamMap(updateOrgParamMap, erpDataId, yzjDataId);
            }
            report.set("modifier", (Object)this.userId);
            report.set("modifytime", (Object)this.exeTime);
            ++n2;
        }
    }

    private boolean isAddRootOrg(DynamicObject[] reportArr) {
        if (reportArr.length != 1) {
            return false;
        }
        DynamicObject reportObj = reportArr[0];
        DynamicObjectCollection proCol = reportObj.getDynamicObjectCollection("entryentity");
        if (Utils.isListEmpty((List)proCol)) {
            return false;
        }
        DynamicObject proEntity = (DynamicObject)proCol.get(0);
        if ("add".equals(proEntity.getString("operation")) && "rootOrg".equals(proEntity.getString("property"))) {
            if (this.yzjConfig.getOrgIgnoreOperations().contains("add")) {
                reportObj.set("status", (Object)4);
                proEntity.set("description", (Object)OrgMessage.getMessage((String)"M00056"));
            } else {
                OrgParam orgParam = new OrgParam();
                orgParam.setName(reportObj.getString("syncobject"));
                orgParam.setYzjOrgId(reportObj.getString("yzjdataid"));
                OrgUnitServiceHelper.addRoot((OrgParam)orgParam);
                reportObj.set("status", (Object)1);
                reportObj.set("modifier", (Object)this.userId);
                reportObj.set("modifytime", (Object)this.exeTime);
            }
            SaveServiceHelper.save((DynamicObject[])reportArr);
            return true;
        }
        return false;
    }

    private boolean add(SyncOutterObject addObj, Map<String, Long> idMap, Map<String, DynamicObject> reportMap) {
        List<String> yzjDataIds = addObj.getOutterList();
        if (Utils.isListEmpty(yzjDataIds)) {
            return true;
        }
        YzjSyncCache.updateTaskProgress(ResManager.loadKDString((String)"\u65b0\u589e\u4e91\u4e4b\u5bb6\u7ec4\u7ec7\u5230\u5f53\u524d\u7cfb\u7edf\u4e2d\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"OrgSyncOperation_2", (String)"bos-org-formplugin", (Object[])new Object[0]));
        TreeMap<Integer, Map<String, DynamicObject>> orgLevelMap = new TreeMap<Integer, Map<String, DynamicObject>>();
        ArrayList<String> parentIds = new ArrayList<String>(yzjDataIds.size());
        int count = this.getYzjOrgDataById(yzjDataIds, orgLevelMap, parentIds);
        if (count == 0) {
            log.info("\u67e5\u8be2\u4e91\u4e4b\u5bb6\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25");
            return false;
        }
        this.getErpOrgDataById(parentIds, idMap);
        ICodeRuleService codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        if (codeRuleService == null) {
            codeRuleService = (ICodeRuleService)TypesContainer.createInstance((String)"kd.bos.coderule.service.CodeRuleServiceImp");
        }
        DynamicObject orgObj = BusinessDataServiceHelper.newDynamicObject((String)"bos_adminorg");
        ArrayList<Long> orgIds = new ArrayList<Long>(count);
        Map patternMap = OrgUtils.getOrgPatternMap();
        String[] orgNumbers = codeRuleService.getBatchNumber("bos_adminorg", orgObj, "", count);
        int numberIndex = 0;
        long[] orgIdArr = ORM.create().genLongIds("bos_adminorg", count);
        int idIndex = 0;
        ArrayList<OrgParam> orgParamList = new ArrayList<OrgParam>(yzjDataIds.size());
        HashMap<String, DynamicObject> yzjIdToStructureMap = new HashMap<String, DynamicObject>(orgLevelMap.values().size());
        HashMap<String, OrgParam> unknownParentMap = new HashMap<String, OrgParam>(yzjDataIds.size());
        for (Map.Entry<Integer, Map<String, DynamicObject>> levelEntry : orgLevelMap.entrySet()) {
            Map<String, DynamicObject> orgMap = levelEntry.getValue();
            for (Map.Entry<String, DynamicObject> entry : orgMap.entrySet()) {
                long orgId = orgIdArr[idIndex++];
                String number = orgNumbers != null && orgNumbers.length > numberIndex ? orgNumbers[numberIndex++] : Long.toString(orgId);
                DynamicObject yzjOrg = entry.getValue();
                String yzjOrgId = yzjOrg.getString("yzjorgid");
                yzjIdToStructureMap.put(yzjOrgId, yzjOrg);
                orgIds.add(orgId);
                idMap.put(yzjOrgId, orgId);
                OrgParam orgParam = new OrgParam();
                orgParamList.add(orgParam);
                orgParam.setCustomOrgId(orgId);
                orgParam.setYzjOrgId(yzjOrgId);
                orgParam.setNumber(number);
                orgParam.setName(yzjOrg.getString("name"));
                orgParam.setDuty("01");
                orgParam.setOrgPatternId(OrgUtils.matchOrgPattern((Map)patternMap, (String)orgParam.getName()));
                String yzjParentOrgId = yzjOrg.getString("yzjparentorgid");
                if (!StringUtils.isNotBlank((CharSequence)yzjParentOrgId)) continue;
                Long parentId = idMap.get(yzjParentOrgId);
                if (parentId == null) {
                    unknownParentMap.put(yzjParentOrgId, orgParam);
                    continue;
                }
                orgParam.setParentId(parentId.longValue());
            }
        }
        this.getParentIdByYzjParentOrg(unknownParentMap);
        if (this.yzjConfig.isSyncOrgSortNumberFromYzj()) {
            this.setSortNumber(orgParamList, yzjIdToStructureMap);
        }
        OrgUnitServiceHelper.add(orgParamList);
        this.feedbackOperationResult(reportMap, null, orgParamList);
        OrgSyncBackup.saveErpDataById(this.taskId, "after", orgIds);
        return true;
    }

    private void update(Map<String, OrgParam> updateOrgParamMap, Map<String, Long> idMap, List<Long> unMoveList, Map<String, DynamicObject> reportMap) {
        if (updateOrgParamMap.isEmpty()) {
            return;
        }
        ArrayList<String> yzjOrgIds = new ArrayList<String>(updateOrgParamMap.keySet());
        DynamicObjectCollection structureCol = this.getYzjOrgDataById(yzjOrgIds);
        if (CollectionUtils.isEmpty((Collection)structureCol)) {
            return;
        }
        YzjSyncCache.updateTaskProgress(ResManager.loadKDString((String)"\u66f4\u65b0\u5f53\u524d\u7cfb\u7edf\u884c\u653f\u7ec4\u7ec7\u4e2d\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"OrgSyncOperation_5", (String)"bos-org-formplugin", (Object[])new Object[0]));
        ArrayList<OrgParam> updateOrgParamList = new ArrayList<OrgParam>(updateOrgParamMap.size());
        HashMap<String, OrgParam> unknownParentMap = new HashMap<String, OrgParam>(updateOrgParamMap.size());
        HashMap<String, DynamicObject> yzjIdToStructureMap = new HashMap<String, DynamicObject>(updateOrgParamMap.size());
        for (DynamicObject structureObj : structureCol) {
            String yzjOrgId = structureObj.getString("yzjorgid");
            yzjIdToStructureMap.put(yzjOrgId, structureObj);
            OrgParam orgParam = updateOrgParamMap.get(yzjOrgId);
            if (orgParam == null) continue;
            updateOrgParamList.add(orgParam);
            orgParam.setName(structureObj.getString("name"));
            Long parentId = null;
            String yzjParentOrgId = structureObj.getString("yzjparentorgid");
            if (!unMoveList.contains(orgParam.getId()) && StringUtils.isNotBlank((CharSequence)yzjParentOrgId) && (parentId = idMap.get(yzjParentOrgId)) == null) {
                unknownParentMap.put(yzjParentOrgId, orgParam);
            }
            if (parentId == null) {
                orgParam.setParentId(-1L);
                continue;
            }
            orgParam.setParentId(parentId.longValue());
        }
        this.getParentIdByYzjParentOrg(unknownParentMap);
        if (this.yzjConfig.isSyncOrgSortNumberFromYzj()) {
            this.setSortNumber(updateOrgParamList, yzjIdToStructureMap);
        }
        OrgUnitServiceHelper.update(updateOrgParamList);
        this.feedbackOperationResult(reportMap, null, updateOrgParamList);
    }

    private void setSortNumber(List<OrgParam> orgParamList, Map<String, DynamicObject> yzjIdToStructureMap) {
        for (OrgParam orgParam : orgParamList) {
            DynamicObject yzjStructure = yzjIdToStructureMap.get(orgParam.getYzjOrgId());
            TreeMap<String, OrgDutyView> multiViewMap = new TreeMap<String, OrgDutyView>();
            OrgDutyView orgDutyView = new OrgDutyView();
            orgDutyView.setParentId(orgParam.getParentId());
            HashMap<String, Object> propertyMap = new HashMap<String, Object>(2);
            propertyMap.put("sortcode", yzjStructure.getString("sortcode"));
            propertyMap.put("sortnumber", yzjStructure.getLong("sortnumber"));
            orgDutyView.setPropertyMap(propertyMap);
            multiViewMap.put(orgParam.getDuty(), orgDutyView);
            orgParam.setMultiViewMap(multiViewMap);
        }
    }

    private boolean unFreeze(SyncInnerObject unFreezeObj) {
        List<Long> orgIds = unFreezeObj.getInnerList();
        if (Utils.isListEmpty(orgIds)) {
            return true;
        }
        YzjSyncCache.updateTaskProgress(ResManager.loadKDString((String)"\u89e3\u5c01\u5f53\u524d\u7cfb\u7edf\u7684\u884c\u653f\u7ec4\u7ec7\u4e2d\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"OrgSyncOperation_4", (String)"bos-org-formplugin", (Object[])new Object[0]));
        ArrayList<Long> updateOrgIds = new ArrayList<Long>(orgIds.size());
        QFilter viewFilter = new QFilter("view", "=", (Object)1L);
        QFilter orgFilter = new QFilter("org", "in", orgIds);
        QFilter freezeFilter = new QFilter("isfreeze", "=", (Object)Boolean.FALSE);
        QFilter[] filters = new QFilter[]{viewFilter, orgFilter, freezeFilter};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"OrgSyncOperation.unFreeze", (String)"bos_org_structure", (String)"org", (QFilter[])filters, (String)"");){
            for (Row row : dataSet) {
                updateOrgIds.add(row.getLong("org"));
            }
        }
        ArrayList<OrgParam> unfreezeOrgParamList = new ArrayList<OrgParam>(orgIds.size());
        ArrayList<OrgParam> updateOrgParamList = new ArrayList<OrgParam>(orgIds.size());
        for (long orgId : orgIds) {
            OrgParam orgParam = new OrgParam();
            orgParam.setId(orgId);
            orgParam.setYzjOrgId(unFreezeObj.getInnerMap().get(orgId).getString("yzjdataid"));
            if (updateOrgIds.contains(orgId)) {
                updateOrgParamList.add(orgParam);
                continue;
            }
            unfreezeOrgParamList.add(orgParam);
        }
        if (!updateOrgParamList.isEmpty()) {
            OrgUnitServiceHelper.update(updateOrgParamList);
            this.feedbackOperationResult(null, unFreezeObj.getInnerMap(), updateOrgParamList);
        }
        if (!unfreezeOrgParamList.isEmpty()) {
            OrgUnitServiceHelper.unFreeze(unfreezeOrgParamList);
            this.feedbackOperationResult(null, unFreezeObj.getInnerMap(), unfreezeOrgParamList);
        }
        return true;
    }

    private boolean freeze(SyncInnerObject freezeObj) {
        List<Long> orgIds = freezeObj.getInnerList();
        if (Utils.isListEmpty(orgIds)) {
            return true;
        }
        YzjSyncCache.updateTaskProgress(ResManager.loadKDString((String)"\u5c01\u5b58\u5f53\u524d\u7cfb\u7edf\u7684\u884c\u653f\u7ec4\u7ec7\u4e2d\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"OrgSyncOperation_3", (String)"bos-org-formplugin", (Object[])new Object[0]));
        ArrayList<OrgParam> orgParamList = new ArrayList<OrgParam>(orgIds.size());
        for (long orgId : orgIds) {
            OrgParam orgParam = new OrgParam();
            orgParam.setId(orgId);
            orgParam.setYzjSync(true);
            orgParamList.add(orgParam);
        }
        OrgUnitServiceHelper.freeze(orgParamList);
        this.feedbackOperationResult(null, freezeObj.getInnerMap(), orgParamList);
        return true;
    }

    private DynamicObject[] getReport(List<Long> reportIds) {
        String selectFields = "id,syncobject,yzjdataid,erpdataid,entryentity.yzjvalue,entryentity.erpvalue,status,modifier,modifytime,entryentity.operation,entryentity.property,entryentity.description";
        QFilter idFilter = new QFilter("id", "in", reportIds);
        QFilter taskFilter = new QFilter("task", "=", (Object)this.taskId);
        QFilter typeFilter = new QFilter("datatype", "=", (Object)"org");
        QFilter statusFilter = new QFilter("status", "=", (Object)Integer.toString(0));
        QFilter[] filters = new QFilter[]{idFilter, taskFilter, typeFilter, statusFilter};
        return BusinessDataServiceHelper.load((String)"bos_yzj_syncreport", (String)selectFields, (QFilter[])filters);
    }

    private void getParentIdByYzjParentOrg(Map<String, OrgParam> unknownParentMap) {
        if (unknownParentMap.isEmpty()) {
            return;
        }
        QFilter yzjOrgFilter = new QFilter("fyzjorgid", "in", unknownParentMap.keySet());
        QFilter[] filters = new QFilter[]{yzjOrgFilter};
        Map orgObjMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"id,fyzjorgid", (QFilter[])filters);
        if (CollectionUtils.isEmpty((Map)orgObjMap)) {
            return;
        }
        for (Map.Entry entry : orgObjMap.entrySet()) {
            DynamicObject orgObj = (DynamicObject)entry.getValue();
            unknownParentMap.get(orgObj.getString("fyzjorgid")).setParentId(orgObj.getLong("id"));
        }
    }

    private void putUpdateOrgParamMap(Map<String, OrgParam> updateOrgParamMap, long erpDataId, String yzjDataId) {
        OrgParam orgParam = updateOrgParamMap.computeIfAbsent(yzjDataId, v -> new OrgParam());
        orgParam.setId(erpDataId);
        orgParam.setYzjOrgId(yzjDataId);
        orgParam.setDuty("01");
    }

    private void getErpOrgDataById(List<String> yzjOrgIds, Map<String, Long> orgIdMap) {
        QFilter idFilter;
        String selectFields = "id,org,yzjorgid,isfreeze";
        QFilter viewFilter = OrgViewUtils.getOrgViewFilter((String)"01");
        QFilter[] filters = new QFilter[]{viewFilter, idFilter = new QFilter("yzjorgid", "in", yzjOrgIds)};
        DynamicObjectCollection orgCol = QueryServiceHelper.query((String)"bos_org_structure", (String)selectFields, (QFilter[])filters, (String)"level");
        if (Utils.isListEmpty((List)orgCol)) {
            return;
        }
        for (DynamicObject org : orgCol) {
            String yzjOrgId = org.getString("yzjorgid");
            if (orgIdMap.containsKey(yzjOrgId) && org.getBoolean("isfreeze")) continue;
            orgIdMap.put(yzjOrgId, org.getLong("org"));
        }
    }

    private int getYzjOrgDataById(List<String> yzjDataIds, TreeMap<Integer, Map<String, DynamicObject>> orgLevelMap, List<String> parentIds) {
        DynamicObjectCollection yzjOrgCol = this.getYzjOrgDataById(yzjDataIds);
        if (Utils.isListEmpty((List)yzjOrgCol)) {
            return 0;
        }
        for (DynamicObject org : yzjOrgCol) {
            int level = org.getInt("level");
            Map<String, DynamicObject> orgMap = orgLevelMap.get(level);
            if (orgMap == null) {
                orgMap = new HashMap<String, DynamicObject>();
            }
            orgMap.put(org.getString("yzjorgid"), org);
            orgLevelMap.put(level, orgMap);
            parentIds.add(org.getString("yzjparentorgid"));
        }
        return yzjOrgCol.size();
    }

    private DynamicObjectCollection getYzjOrgDataById(List<String> yzjDataIds) {
        String selectFields = "id,org,org.name name,org.number number,parent,yzjorgid,yzjparentorgid,longnumber,fullname,level,sortcode,sortnumber,isfreeze,sealuptime,modifier,modifytime";
        QFilter taskFilter = new QFilter("org.task", "=", (Object)this.taskId);
        QFilter idFilter = new QFilter("yzjorgid", "in", yzjDataIds);
        QFilter backTypeFilter = new QFilter("org.backuptype", "=", (Object)"cloud-hub");
        QFilter[] filters = new QFilter[]{taskFilter, idFilter, backTypeFilter};
        DynamicObjectCollection yzjOrgCol = QueryServiceHelper.query((String)"bos_yzj_orgstructure", (String)selectFields, (QFilter[])filters, (String)"level");
        return yzjOrgCol;
    }

    private void feedbackOperationResult(Map<String, DynamicObject> yzjOrgIdReportMap, Map<Long, DynamicObject> erpOrgIdReportMap, List<OrgParam> orgParamList) {
        for (OrgParam orgParam : orgParamList) {
            if (orgParam.isSuccess()) continue;
            DynamicObject report = yzjOrgIdReportMap != null ? yzjOrgIdReportMap.get(orgParam.getYzjOrgId()) : erpOrgIdReportMap.get(orgParam.getId());
            report.set("status", (Object)0);
            DynamicObjectCollection reportEntryCol = report.getDynamicObjectCollection("entryentity");
            if (Utils.isListEmpty((List)reportEntryCol)) continue;
            DynamicObject reportEntryObj = (DynamicObject)reportEntryCol.get(0);
            reportEntryObj.set("description", (Object)orgParam.getMsg());
        }
    }
}

