/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.yunzhijia.diff.impl.org;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kd.bos.base.utils.msg.OrgMessage;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.utils.OrgViewUtils;
import kd.bos.org.utils.Utils;
import kd.bos.org.utils.YzjDiffUtils;
import kd.bos.org.yunzhijia.diff.impl.YzjSyncReport;
import kd.bos.org.yunzhijia.diff.impl.org.GetErpOrgDataImpl;
import kd.bos.org.yunzhijia.diff.impl.org.GetYzjOrgDataImpl;
import kd.bos.org.yunzhijia.diff.impl.org.OrgSyncBackup;
import kd.bos.org.yunzhijia.diff.impl.utils.YzjSyncCache;
import kd.bos.org.yunzhijia.model.CompareRule;
import kd.bos.org.yunzhijia.model.DifferenceType;
import kd.bos.org.yunzhijia.model.OrgCompareRuleSingleton;
import kd.bos.org.yunzhijia.model.SyncContextParam;
import kd.bos.org.yunzhijia.model.SyncReport;
import kd.bos.org.yunzhijia.model.SyncReportEntry;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.yzj.model.YzjConfig;

public class OrgSyncReport {
    private static final Log log = LogFactory.getLog(OrgSyncReport.class);
    private final long taskId;
    protected SyncContextParam contextParam;
    private String yzjRootId = "";
    private String yzjRootName = "";
    private static final String ORG_NUMBER_FORMAT = "%06d";
    private static final String ERP_DATA_MAP = "erp_data_map";

    public OrgSyncReport(SyncContextParam contextParam) {
        this.contextParam = contextParam;
        this.taskId = contextParam.getTaskId();
    }

    public boolean create() {
        YzjSyncCache.updateTaskProgress(ResManager.loadKDString((String)"\u6b63\u5728\u83b7\u53d6\u4e91\u4e4b\u5bb6\u7684\u7ec4\u7ec7\u4fe1\u606f\uff0c\u8bf7\u7a0d\u7b49\u3002", (String)"OrgSyncReport_0", (String)"bos-org-formplugin", (Object[])new Object[0]));
        GetYzjOrgDataImpl yzj = new GetYzjOrgDataImpl(this.contextParam.getYzjConfig());
        Map<String, Object> yzjData = yzj.getBizData();
        if (yzjData == null || yzjData.isEmpty()) {
            String msg = OrgMessage.getMessage((String)"M00062");
            this.createGetDataErrorReport(msg);
            return false;
        }
        String msg = YzjDiffUtils.getErrorMessage(yzjData);
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            this.createGetDataErrorReport(msg);
            return false;
        }
        List yzjOrgList = (List)yzjData.get("yzj_org");
        if (Utils.isListEmpty((List)yzjOrgList)) {
            msg = OrgMessage.getMessage((String)"M00062");
            this.createGetDataErrorReport(msg);
            return false;
        }
        this.contextParam.getOrgList().addAll(yzjOrgList);
        ArrayList<String> parentList = new ArrayList<String>();
        TreeMap<Integer, Map<String, Map<String, Object>>> levelMap = this.initYzjData(yzjOrgList, parentList);
        YzjSyncCache.updateTaskProgress(ResManager.loadKDString((String)"\u6b63\u5728\u5907\u4efd\u4e91\u4e4b\u5bb6\u7684\u7ec4\u7ec7\u4fe1\u606f\uff0c\u8bf7\u7a0d\u7b49\u3002", (String)"OrgSyncReport_1", (String)"bos-org-formplugin", (Object[])new Object[0]));
        if (!OrgSyncBackup.saveYzjData(this.taskId, this.yzjRootName, levelMap, parentList)) {
            return false;
        }
        YzjSyncCache.updateTaskProgress(ResManager.loadKDString((String)"\u6b63\u5728\u5907\u4efd\u5f53\u524d\u7cfb\u7edf\u7684\u7ec4\u7ec7\u4fe1\u606f\uff0c\u8bf7\u7a0d\u7b49\u3002", (String)"OrgSyncReport_2", (String)"bos-org-formplugin", (Object[])new Object[0]));
        OrgSyncBackup.saveErpDataByFilter(this.taskId, "before", null);
        OrgSyncBackup.saveErpDataByFilter(this.taskId, "after", null);
        if (!this.isRootOrgValid()) {
            return false;
        }
        YzjSyncCache.updateTaskProgress(ResManager.loadKDString((String)"\u6b63\u5728\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7684\u7ec4\u7ec7\u4fe1\u606f\uff0c\u8bf7\u7a0d\u7b49\u3002", (String)"OrgSyncReport_3", (String)"bos-org-formplugin", (Object[])new Object[0]));
        List<Map<String, Object>> erpOrgList = this.getErpData();
        YzjSyncCache.updateTaskProgress(ResManager.loadKDString((String)"\u7ec4\u7ec7\u4fe1\u606f\u7684\u5dee\u5f02\u5bf9\u6bd4\u4e2d\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"OrgSyncReport_4", (String)"bos-org-formplugin", (Object[])new Object[0]));
        this.createReport(yzjOrgList, erpOrgList);
        return true;
    }

    private void createGetDataErrorReport(String msg) {
        ArrayList<SyncReport> reportList = new ArrayList<SyncReport>(1);
        String userId = RequestContext.get().getUserId();
        String curTime = Long.toString(Calendar.getInstance().getTimeInMillis());
        SyncReport report = new SyncReport();
        report.setTaskId(this.taskId);
        report.setStatus(3);
        report.setDataType(DifferenceType.ORG.getKey());
        report.setModifier(userId);
        report.setModifyTime(curTime);
        List<SyncReportEntry> entryList = report.getEntryList();
        SyncReportEntry reportEntry = new SyncReportEntry();
        reportEntry.setOperation("manual");
        reportEntry.setNote(msg);
        entryList.add(reportEntry);
        reportList.add(report);
        YzjSyncReport.add(reportList);
    }

    private TreeMap<Integer, Map<String, Map<String, Object>>> initYzjData(List<Map<String, Object>> yzjOrgList, List<String> parentList) {
        TreeMap<Integer, Map<String, Map<String, Object>>> levelMap = new TreeMap<Integer, Map<String, Map<String, Object>>>();
        int index = 1;
        long[] orgIdArr = ORM.create().genLongIds("bos_org", yzjOrgList.size());
        int idIndex = 0;
        long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
        Iterator<Map<String, Object>> iterator = yzjOrgList.iterator();
        while (iterator.hasNext()) {
            Map<String, Object> dtYzj = iterator.next();
            Object idObj = dtYzj.get("id");
            if (StringUtils.isBlank((Object)idObj)) {
                iterator.remove();
                continue;
            }
            String yzjOrgId = idObj.toString();
            Object parentId = dtYzj.get("parentId");
            int level = 1;
            if (StringUtils.isBlank((Object)parentId)) {
                this.yzjRootId = yzjOrgId;
                this.yzjRootName = String.valueOf(dtYzj.get("name"));
            } else {
                parentList.add(parentId.toString());
                String yzjDepartment = String.valueOf(dtYzj.get("department"));
                String[] names = yzjDepartment.split("\\\\");
                level = names.length + 1;
                dtYzj.put("parent", rootOrgId);
            }
            dtYzj.put("org", orgIdArr[idIndex++]);
            String number = String.format(ORG_NUMBER_FORMAT, index++);
            dtYzj.put("number", number);
            dtYzj.put("longnumber", number);
            dtYzj.put("level", level);
            Map<String, Map<String, Object>> yzjOrgMap = levelMap.get(level);
            if (yzjOrgMap == null) {
                yzjOrgMap = new HashMap<String, Map<String, Object>>();
            }
            yzjOrgMap.put(yzjOrgId, dtYzj);
            levelMap.put(level, yzjOrgMap);
        }
        return levelMap;
    }

    private boolean isRootOrgValid() {
        String selectFields = "id,org,org.name name,org.fyzjorgid yzjorgid";
        QFilter viewFilter = OrgViewUtils.getOrgViewFilter((String)"01");
        QFilter orgFilter = new QFilter("org", "=", (Object)OrgUnitServiceHelper.getRootOrgId());
        orgFilter = orgFilter.or(new QFilter("parent", "=", (Object)0));
        QFilter[] filters = new QFilter[]{viewFilter, orgFilter};
        DynamicObjectCollection rootOrgCol = QueryServiceHelper.query((String)"bos_org_structure", (String)selectFields, (QFilter[])filters);
        if (Utils.isListEmpty((List)rootOrgCol)) {
            this.saveAddRootReport();
            return false;
        }
        DynamicObject rootOrg = (DynamicObject)rootOrgCol.get(0);
        String erpRootId = rootOrg.getString("yzjorgid");
        String erpRootName = rootOrg.getString("name");
        boolean isValid = true;
        SyncReport report = null;
        if (!this.yzjRootId.equals(erpRootId)) {
            isValid = false;
            report = this.genRootOrgSyncReport(report, erpRootId, erpRootName, true);
        }
        if (!this.yzjRootName.equals(erpRootName)) {
            report = this.genRootOrgSyncReport(report, erpRootId, erpRootName, false);
        }
        YzjSyncReport.add(report);
        return isValid;
    }

    private void saveAddRootReport() {
        SyncReport report = new SyncReport();
        report.setTaskId(this.taskId);
        report.setDataType(DifferenceType.ORG.getKey());
        report.setSyncObject(this.yzjRootName);
        report.setYzjDataId(this.yzjRootId);
        report.setStatus(0);
        List<SyncReportEntry> entryList = report.getEntryList();
        SyncReportEntry reportEntry = new SyncReportEntry();
        reportEntry.setOperation("add");
        reportEntry.setProperty("rootOrg");
        reportEntry.setYzjValue(this.yzjRootId);
        reportEntry.setNote(OrgMessage.getMessage((String)"M00063"));
        entryList.add(reportEntry);
        YzjSyncReport.add(report);
    }

    private SyncReport genRootOrgSyncReport(SyncReport report, String erpRootId, String erpRootName, boolean isIdPro) {
        if (report == null) {
            report = new SyncReport();
            report.setTaskId(this.taskId);
            report.setStatus(0);
            report.setDataType(DifferenceType.ORG.getKey());
            report.setSyncObject(erpRootName);
            report.setYzjDataId(this.yzjRootId);
            report.setErpDataId(Long.toString(OrgUnitServiceHelper.getRootOrgId()));
        }
        List<SyncReportEntry> entryList = report.getEntryList();
        SyncReportEntry reportEntry = new SyncReportEntry();
        reportEntry.setOperation("edit");
        String note = "";
        if (isIdPro) {
            reportEntry.setProperty("rootId");
            reportEntry.setYzjValue(this.yzjRootId);
            reportEntry.setErpValue(erpRootId);
            note = OrgMessage.getMessage((String)"M00064");
        } else {
            reportEntry.setProperty("rootName");
            reportEntry.setYzjValue(this.yzjRootName);
            reportEntry.setErpValue(erpRootName);
            note = OrgMessage.getMessage((String)"M00065");
        }
        reportEntry.setNote(note);
        entryList.add(reportEntry);
        return report;
    }

    private List<Map<String, Object>> getErpData() {
        GetErpOrgDataImpl erp = new GetErpOrgDataImpl();
        Map<String, Object> erpData = erp.getBizData();
        List erpOrgList = (List)erpData.get("erp_org");
        return erpOrgList;
    }

    private void createReport(List<Map<String, Object>> yzjOrgList, List<Map<String, Object>> erpOrgList) {
        log.debug("\u5f00\u59cb\u751f\u6210\u91d1\u8776\u4e91\u548c\u4e91\u4e4b\u5bb6\u7684\u7ec4\u7ec7\u4fe1\u606f\u5dee\u5f02\u62a5\u544a");
        if (Utils.isListEmpty(yzjOrgList)) {
            String msg = OrgMessage.getMessage((String)"M00062");
            this.createGetDataErrorReport(msg);
            return;
        }
        ArrayList<Map<String, Object>> errorNameList = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> newParentList = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> newFullnameList = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> newProList = new ArrayList<Map<String, Object>>();
        List<String> duplicateNameList = this.getDuplicateYzjFullname(yzjOrgList, erpOrgList);
        List<String> duplicateIdList = this.getDuplicateYzjOrgId(erpOrgList);
        List<String> erpExistsYzjOrgIds = this.getAllErpYzjOrgId(erpOrgList);
        OrgCompareRuleSingleton ruleInstance = OrgCompareRuleSingleton.getInstance();
        List<CompareRule> ruleList = ruleInstance.getRules();
        String fullNameSep = OrgUnitServiceHelper.getOrgSeparation().getFullNameSep();
        long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
        HashMap<String, Map<String, Object>> orgMap = new HashMap<String, Map<String, Object>>(erpOrgList.size());
        Iterator<Map<String, Object>> erpIter = erpOrgList.iterator();
        while (erpIter.hasNext()) {
            Map<String, Object> dtErp = erpIter.next();
            long orgId = Long.parseLong(dtErp.get("orgId").toString());
            Object parentorgid = dtErp.get("parentorgid");
            if (rootOrgId == orgId || StringUtils.isBlank((Object)parentorgid) || 0L == Long.parseLong(parentorgid.toString())) {
                erpIter.remove();
                continue;
            }
            String erpFullname = Utils.nullToEmpty((Object)dtErp.get("fullname")).toString().trim();
            String erpYzjOrgId = Utils.nullToEmpty((Object)dtErp.get("yzjorgid")).toString().trim();
            if (duplicateNameList.contains(erpFullname) || duplicateIdList.contains(erpYzjOrgId)) {
                erpIter.remove();
                continue;
            }
            if (StringUtils.isBlank((CharSequence)erpYzjOrgId) || orgMap.containsKey(erpYzjOrgId)) continue;
            orgMap.put(erpYzjOrgId, dtErp);
        }
        Iterator<Map<String, Object>> yzjIter = yzjOrgList.iterator();
        while (yzjIter.hasNext()) {
            HashMap<String, Object> proMap;
            Map<String, Object> dtYzj = yzjIter.next();
            Object name = dtYzj.get("name");
            if (StringUtils.isBlank((Object)name)) {
                dtYzj.put("error", OrgMessage.getMessage((String)"M00066"));
                errorNameList.add(dtYzj);
                yzjIter.remove();
                continue;
            }
            String msg = OrgViewUtils.isOrgNameValid((String)name.toString());
            if (StringUtils.isNotBlank((CharSequence)msg)) {
                dtYzj.put("error", msg);
                errorNameList.add(dtYzj);
                yzjIter.remove();
                continue;
            }
            if (StringUtils.isBlank((Object)dtYzj.get("parentId"))) {
                yzjIter.remove();
                continue;
            }
            String yzjOrgId = String.valueOf(dtYzj.get("id"));
            String yzjFullname = Utils.nullToEmpty((Object)dtYzj.get("fullname")).toString().trim();
            if (duplicateNameList.contains(yzjFullname) || duplicateIdList.contains(yzjOrgId)) {
                yzjIter.remove();
                continue;
            }
            Map dtErp = (Map)orgMap.get(yzjOrgId);
            if (CollectionUtils.isEmpty((Map)dtErp)) continue;
            String erpFullname = Utils.nullToEmpty(dtErp.get("fullname")).toString().trim();
            dtYzj.put(ERP_DATA_MAP, dtErp);
            String yzjParentId = String.valueOf(dtYzj.get("parentId"));
            String erpParentId = String.valueOf(dtErp.get("yzjparentorgid"));
            if (!yzjParentId.equals(erpParentId)) {
                HashMap<String, Object> proMap2 = new HashMap<String, Object>(dtYzj);
                newParentList.add(proMap2);
            } else {
                String erpParentFullname;
                String yzjParentFullname = StringUtils.substringBeforeLast((String)yzjFullname, (String)fullNameSep);
                if (!yzjParentFullname.equals(erpParentFullname = StringUtils.substringBeforeLast((String)erpFullname, (String)fullNameSep))) {
                    proMap = new HashMap<String, Object>(dtYzj);
                    newFullnameList.add(proMap);
                }
            }
            for (CompareRule rule : ruleList) {
                if ("fullname".equals(rule.getDestFld()) || "yzjparentorgid".equals(rule.getDestFld()) || Utils.nullToEmpty((Object)dtYzj.get(rule.getSrcFld())).toString().trim().equals(Utils.nullToEmpty(dtErp.get(rule.getDestFld())).toString().trim())) continue;
                dtYzj.put("property", rule);
                proMap = new HashMap<String, Object>(dtYzj);
                newProList.add(proMap);
            }
            erpOrgList.remove(dtErp);
            yzjIter.remove();
        }
        this.createInvalidNameReport(errorNameList);
        ArrayList<Map<String, Object>> unFreezeList = new ArrayList<Map<String, Object>>();
        this.compareFullname(yzjOrgList, erpOrgList, unFreezeList, newProList);
        ArrayList<String> errorFreezeList = new ArrayList<String>();
        this.saveFreezeUnableReport(erpOrgList, errorFreezeList);
        this.saveAddNewReport(yzjOrgList, erpExistsYzjOrgIds);
        this.saveUnFreezeReport(unFreezeList);
        this.saveMoveReport(newParentList, errorFreezeList, "yzjparentorgid");
        this.saveMoveReport(newFullnameList, errorFreezeList, "fullname");
        this.saveNewProReport(newProList, errorFreezeList);
        this.saveFreezeReport(erpOrgList);
    }

    private List<String> getAllErpYzjOrgId(List<Map<String, Object>> erpOrgList) {
        ArrayList<String> erpExistsYzjOrgIds = new ArrayList<String>();
        for (Map<String, Object> erpOrg : erpOrgList) {
            if (!StringUtils.isNotBlank((Object)erpOrg.get("yzjorgid"))) continue;
            erpExistsYzjOrgIds.add(erpOrg.get("yzjorgid").toString());
        }
        return erpExistsYzjOrgIds;
    }

    private void createInvalidNameReport(List<Map<String, Object>> yzjDataList) {
        if (Utils.isListEmpty(yzjDataList)) {
            return;
        }
        ArrayList<SyncReport> reportList = new ArrayList<SyncReport>(yzjDataList.size());
        String userId = RequestContext.get().getUserId();
        String curTime = Long.toString(Calendar.getInstance().getTimeInMillis());
        for (Map<String, Object> yzjMap : yzjDataList) {
            SyncReport report = new SyncReport();
            String orgName = String.valueOf(yzjMap.get("name"));
            report.setTaskId(this.taskId);
            report.setStatus(3);
            report.setDataType(DifferenceType.ORG.getKey());
            report.setSyncObject(orgName);
            report.setYzjDataId(String.valueOf(yzjMap.get("id")));
            report.setModifier(userId);
            report.setModifyTime(curTime);
            List<SyncReportEntry> entryList = report.getEntryList();
            SyncReportEntry reportEntry = new SyncReportEntry();
            reportEntry.setOperation("manual");
            reportEntry.setProperty("name");
            reportEntry.setYzjValue(orgName);
            reportEntry.setNote(yzjMap.get("error") + OrgMessage.getMessage((String)"M00067"));
            entryList.add(reportEntry);
            reportList.add(report);
        }
        YzjSyncReport.add(reportList);
    }

    private void compareFullname(List<Map<String, Object>> yzjOrgList, List<Map<String, Object>> erpOrgList, List<Map<String, Object>> unFreezeList, List<Map<String, Object>> newProList) {
        OrgCompareRuleSingleton ruleInstance = OrgCompareRuleSingleton.getInstance();
        List<CompareRule> ruleList = ruleInstance.getRules();
        CompareRule idRule = ruleInstance.getIdRule();
        HashMap<String, Map<String, Object>> orgMap = new HashMap<String, Map<String, Object>>(erpOrgList.size());
        for (Map<String, Object> dtErp : erpOrgList) {
            String erpFullname = String.valueOf(dtErp.get("fullname"));
            if (StringUtils.isBlank((CharSequence)erpFullname) || orgMap.containsKey(erpFullname)) continue;
            orgMap.put(erpFullname, dtErp);
        }
        Iterator<Map<String, Object>> yzjIter = yzjOrgList.iterator();
        while (yzjIter.hasNext()) {
            HashMap<String, Object> proMap;
            Map<String, Object> dtYzj = yzjIter.next();
            String yzjOrgId = String.valueOf(dtYzj.get("id"));
            if (yzjOrgId.equals(this.yzjRootId)) {
                yzjIter.remove();
                continue;
            }
            String yzjFullname = String.valueOf(dtYzj.get("fullname"));
            Map dtErp = (Map)orgMap.get(yzjFullname);
            if (CollectionUtils.isEmpty((Map)dtErp)) continue;
            dtYzj.put(ERP_DATA_MAP, dtErp);
            Object isFreeze = dtErp.get("isfreeze");
            if (null != isFreeze && ((Boolean)isFreeze).booleanValue()) {
                proMap = new HashMap<String, Object>(dtYzj);
                unFreezeList.add(proMap);
            } else {
                dtYzj.put("property", idRule);
                proMap = new HashMap<String, Object>(dtYzj);
                newProList.add(proMap);
            }
            this.compareOtherProperties(newProList, ruleList, dtYzj, dtErp);
            yzjIter.remove();
            erpOrgList.remove(dtErp);
        }
    }

    private void compareOtherProperties(List<Map<String, Object>> newProList, List<CompareRule> ruleList, Map<String, Object> dtYzj, Map<String, Object> dtErp) {
        for (CompareRule rule : ruleList) {
            String destField = rule.getDestFld();
            if ("fullname".equals(destField) || "yzjparentorgid".equals(destField) || "yzjorgid".equals(destField) || Utils.nullToEmpty((Object)dtYzj.get(rule.getSrcFld())).toString().trim().equals(Utils.nullToEmpty((Object)dtErp.get(destField)).toString().trim())) continue;
            dtYzj.put("property", rule);
            HashMap<String, Object> proMap = new HashMap<String, Object>(dtYzj);
            newProList.add(proMap);
        }
    }

    private void saveFreezeUnableReport(List<Map<String, Object>> erpOrgList, List<String> errorFreezeList) {
        if (Utils.isListEmpty(erpOrgList)) {
            this.writeNoFreezeOrgDebugLog();
            return;
        }
        ArrayList<SyncReport> reportList = new ArrayList<SyncReport>(erpOrgList.size());
        Iterator<Map<String, Object>> iterator = erpOrgList.iterator();
        while (iterator.hasNext()) {
            Map<String, Object> orgMap = iterator.next();
            String fullname = String.valueOf(orgMap.get("fullname"));
            String isFreeze = String.valueOf(orgMap.get("isfreeze"));
            if (StringUtils.isNotBlank((CharSequence)isFreeze) && ("1".equals(isFreeze) || Boolean.toString(true).equals(isFreeze))) {
                errorFreezeList.add(fullname);
                iterator.remove();
                continue;
            }
            Object erpYzjOrgId = orgMap.get("yzjorgid");
            if (StringUtils.isBlank((Object)erpYzjOrgId) || "0".equals(erpYzjOrgId.toString())) {
                errorFreezeList.add(fullname);
                SyncReport report = new SyncReport();
                List<SyncReportEntry> entryList = report.getEntryList();
                SyncReportEntry reportEntry = new SyncReportEntry();
                report.setTaskId(this.taskId);
                report.setDataType(DifferenceType.ORG.getKey());
                report.setSyncObject(String.valueOf(orgMap.get("name")));
                report.setErpDataId(String.valueOf(orgMap.get("orgId")));
                reportEntry.setOperation("freeze");
                reportEntry.setErpValue(fullname);
                report.setStatus(3);
                reportEntry.setNote(OrgMessage.getMessage((String)"M00068"));
                entryList.add(reportEntry);
                reportList.add(report);
                iterator.remove();
                continue;
            }
            if (!this.yzjRootId.equals(erpYzjOrgId.toString())) continue;
            iterator.remove();
        }
        YzjSyncReport.add(reportList);
    }

    private List<String> getDuplicateYzjOrgId(List<Map<String, Object>> erpOrgList) {
        return this.saveDuplicateReport(erpOrgList, "yzjorgid", false);
    }

    private List<String> getDuplicateYzjFullname(List<Map<String, Object>> yzjOrgList, List<Map<String, Object>> erpOrgList) {
        List<String> duplicateList = this.saveDuplicateReport(yzjOrgList, "fullname", true);
        duplicateList.addAll(this.saveDuplicateReport(erpOrgList, "fullname", false));
        return duplicateList;
    }

    private List<String> saveDuplicateReport(List<Map<String, Object>> orgDataList, String property, boolean isYzj) {
        if (Utils.isListEmpty(orgDataList)) {
            return new ArrayList<String>(0);
        }
        int count = orgDataList.size();
        ArrayList<String> duplicateList = new ArrayList<String>(count);
        ArrayList<Map> duplicateReportList = new ArrayList<Map>(count);
        HashMap<String, Map<String, Object>> duplicateMap = new HashMap<String, Map<String, Object>>(count);
        ArrayList<Map<String, Object>> uncheckFreezeList = new ArrayList<Map<String, Object>>(count);
        for (Map<String, Object> orgMap : orgDataList) {
            String propertyValue = String.valueOf(orgMap.get(property));
            if (StringUtils.isBlank((CharSequence)propertyValue)) continue;
            Map dupOrgMap = (Map)duplicateMap.get(propertyValue);
            if (dupOrgMap == null) {
                duplicateMap.put(propertyValue, orgMap);
                continue;
            }
            Object isFreeze = dupOrgMap.get("isfreeze");
            Object curIsFreeze = orgMap.get("isfreeze");
            boolean isDuplicate = true;
            if (isFreeze != null && curIsFreeze != null) {
                if (((Boolean)isFreeze).booleanValue() && !((Boolean)curIsFreeze).booleanValue()) {
                    duplicateMap.put(propertyValue, orgMap);
                    isDuplicate = false;
                    uncheckFreezeList.add(dupOrgMap);
                } else if (!((Boolean)isFreeze).booleanValue() && ((Boolean)curIsFreeze).booleanValue()) {
                    isDuplicate = false;
                    uncheckFreezeList.add(orgMap);
                }
            }
            if (!isDuplicate) continue;
            duplicateReportList.add(orgMap);
            if (duplicateList.contains(propertyValue)) continue;
            duplicateReportList.add(dupOrgMap);
            duplicateList.add(propertyValue);
        }
        orgDataList.removeAll(uncheckFreezeList);
        if (!duplicateReportList.isEmpty()) {
            ArrayList<SyncReport> reportList = new ArrayList<SyncReport>(duplicateReportList.size());
            for (Map orgMap : duplicateReportList) {
                SyncReport report = new SyncReport();
                List<SyncReportEntry> entryList = report.getEntryList();
                SyncReportEntry reportEntry = new SyncReportEntry();
                report.setTaskId(this.taskId);
                report.setStatus(3);
                report.setDataType(DifferenceType.ORG.getKey());
                report.setSyncObject(String.valueOf(orgMap.get("name")));
                if ("yzjorgid".equals(property)) {
                    report.setYzjDataId(String.valueOf(orgMap.get(property)));
                    report.setErpDataId(String.valueOf(orgMap.get("orgId")));
                    reportEntry.setErpValue(String.valueOf(orgMap.get("fullname")));
                    reportEntry.setNote(OrgMessage.getMessage((String)"M00069"));
                } else if (isYzj) {
                    report.setYzjDataId(String.valueOf(orgMap.get("id")));
                    reportEntry.setYzjValue(String.valueOf(orgMap.get("fullname")));
                    reportEntry.setNote(OrgMessage.getMessage((String)"M00070"));
                } else {
                    report.setErpDataId(String.valueOf(orgMap.get("orgId")));
                    reportEntry.setErpValue(String.valueOf(orgMap.get("fullname")));
                    reportEntry.setNote(OrgMessage.getMessage((String)"M00071"));
                }
                reportEntry.setProperty(property);
                reportEntry.setOperation("manual");
                entryList.add(reportEntry);
                reportList.add(report);
            }
            YzjSyncReport.add(reportList);
        }
        return duplicateList;
    }

    private void saveAddNewReport(List<Map<String, Object>> yzjOrgList, List<String> erpExistsYzjOrgIds) {
        if (Utils.isListEmpty(yzjOrgList)) {
            log.debug("\u65e0\u65b0\u589e\u7684\u7ec4\u7ec7");
            return;
        }
        int count = yzjOrgList.size();
        ArrayList<Object> parentIds = new ArrayList<Object>(count);
        for (Map<String, Object> orgMap : yzjOrgList) {
            Object parentId = orgMap.get("parentId");
            if (!StringUtils.isNotBlank((Object)parentId)) continue;
            parentIds.add(parentId);
        }
        Map<String, List<String>> subOrgNameMap = this.querySubOrgNameMap(count, parentIds);
        ArrayList<SyncReport> reportList = new ArrayList<SyncReport>(yzjOrgList.size());
        for (Map<String, Object> orgMap : yzjOrgList) {
            List<String> orgNameList;
            Object parentId = orgMap.get("parentId");
            String orgName = String.valueOf(orgMap.get("name"));
            boolean isError = false;
            if (StringUtils.isNotBlank((Object)parentId) && (orgNameList = subOrgNameMap.get(parentId.toString())) != null && orgNameList.contains(orgName)) {
                isError = true;
            }
            SyncReport report = new SyncReport();
            report.setTaskId(this.taskId);
            report.setDataType(DifferenceType.ORG.getKey());
            report.setSyncObject(orgName);
            String yzjOrgId = String.valueOf(orgMap.get("id"));
            report.setYzjDataId(yzjOrgId);
            List<SyncReportEntry> entryList = report.getEntryList();
            SyncReportEntry reportEntry = new SyncReportEntry();
            reportEntry.setOperation("add");
            reportEntry.setYzjValue(String.valueOf(orgMap.get("fullname")));
            if (isError) {
                report.setStatus(3);
                reportEntry.setNote(OrgMessage.getMessage((String)"M00072"));
            } else if (erpExistsYzjOrgIds.contains(yzjOrgId)) {
                report.setStatus(3);
                reportEntry.setNote(OrgMessage.getMessage((String)"M00069"));
            } else {
                report.setStatus(0);
            }
            entryList.add(reportEntry);
            reportList.add(report);
        }
        YzjSyncReport.add(reportList);
    }

    private Map<String, List<String>> querySubOrgNameMap(int count, List<Object> parentIds) {
        HashMap<String, List<String>> subOrgNameMap = new HashMap<String, List<String>>(count);
        if (parentIds.isEmpty()) {
            return subOrgNameMap;
        }
        String selectFields = "org.name name, yzjparentorgid";
        QFilter viewFilter = OrgViewUtils.getOrgViewFilter((String)"01");
        QFilter parentFilter = new QFilter("yzjparentorgid", "in", parentIds);
        QFilter[] filters = new QFilter[]{viewFilter, parentFilter};
        DynamicObjectCollection subOrgCol = QueryServiceHelper.query((String)"bos_org_structure", (String)selectFields, (QFilter[])filters);
        if (Utils.isListEmpty((List)subOrgCol)) {
            return subOrgNameMap;
        }
        for (DynamicObject subOrg : subOrgCol) {
            String name = subOrg.getString("name");
            String yzjparentorgid = subOrg.getString("yzjparentorgid");
            ArrayList<String> orgNameList = (ArrayList<String>)subOrgNameMap.get(yzjparentorgid);
            if (orgNameList == null) {
                orgNameList = new ArrayList<String>();
            }
            orgNameList.add(name);
            subOrgNameMap.put(yzjparentorgid, orgNameList);
        }
        return subOrgNameMap;
    }

    private void saveUnFreezeReport(List<Map<String, Object>> unFreezeList) {
        if (Utils.isListEmpty(unFreezeList)) {
            this.writeNoFreezeOrgDebugLog();
            return;
        }
        ArrayList<SyncReport> reportList = new ArrayList<SyncReport>(unFreezeList.size());
        for (Map<String, Object> orgMap : unFreezeList) {
            SyncReport report = new SyncReport();
            report.setTaskId(this.taskId);
            report.setStatus(0);
            report.setDataType(DifferenceType.ORG.getKey());
            report.setSyncObject(String.valueOf(orgMap.get("name")));
            report.setYzjDataId(String.valueOf(orgMap.get("id")));
            Map erpOrgMap = (Map)orgMap.get(ERP_DATA_MAP);
            report.setErpDataId(String.valueOf(erpOrgMap.get("orgId")));
            List<SyncReportEntry> entryList = report.getEntryList();
            SyncReportEntry reportEntry = new SyncReportEntry();
            reportEntry.setOperation("unfreeze");
            reportEntry.setProperty("yzjorgid");
            reportEntry.setYzjValue(String.valueOf(orgMap.get("fullname")));
            entryList.add(reportEntry);
            reportList.add(report);
        }
        YzjSyncReport.add(reportList);
    }

    private void saveFreezeReport(List<Map<String, Object>> erpOrgList) {
        if (Utils.isListEmpty(erpOrgList)) {
            this.writeNoFreezeOrgDebugLog();
            return;
        }
        int count = erpOrgList.size();
        ArrayList<SyncReport> reportList = new ArrayList<SyncReport>(count);
        for (Map<String, Object> orgMap : erpOrgList) {
            SyncReport report = new SyncReport();
            List<SyncReportEntry> entryList = report.getEntryList();
            SyncReportEntry reportEntry = new SyncReportEntry();
            report.setTaskId(this.taskId);
            report.setDataType(DifferenceType.ORG.getKey());
            report.setSyncObject(String.valueOf(orgMap.get("name")));
            report.setErpDataId(String.valueOf(orgMap.get("orgId")));
            reportEntry.setOperation("freeze");
            reportEntry.setErpValue(String.valueOf(orgMap.get("fullname")));
            report.setStatus(0);
            entryList.add(reportEntry);
            reportList.add(report);
        }
        YzjConfig yzjConfig = this.contextParam.getYzjConfig();
        if (count >= yzjConfig.getOrgDisableLimit()) {
            yzjConfig.setAutoSync(false);
        }
        YzjSyncReport.add(reportList);
    }

    private void saveMoveReport(List<Map<String, Object>> newParentList, List<String> errorFreezeList, String property) {
        if (Utils.isListEmpty(newParentList)) {
            log.debug("\u65e0\u4fee\u6539\u7ed3\u6784\u7684\u7ec4\u7ec7");
            return;
        }
        ArrayList<SyncReport> reportList = new ArrayList<SyncReport>(newParentList.size());
        for (Map<String, Object> yzjMap : newParentList) {
            String yzjOrgId = String.valueOf(yzjMap.get("id"));
            Map erpMap = (Map)yzjMap.get(ERP_DATA_MAP);
            SyncReport report = new SyncReport();
            List<SyncReportEntry> entryList = report.getEntryList();
            SyncReportEntry reportEntry = new SyncReportEntry();
            report.setTaskId(this.taskId);
            String yzjFullname = String.valueOf(yzjMap.get("fullname"));
            if (errorFreezeList.contains(yzjFullname)) {
                report.setStatus(3);
                String note = OrgMessage.getMessage((String)"M00073");
                reportEntry.setNote(note);
            } else if (3 != report.getStatus()) {
                report.setStatus(0);
            }
            report.setDataType(DifferenceType.ORG.getKey());
            report.setSyncObject(String.valueOf(yzjMap.get("name")));
            report.setYzjDataId(yzjOrgId);
            report.setErpDataId(String.valueOf(erpMap.get("orgId")));
            if ("fullname".equals(property)) {
                reportEntry.setOperation("edit");
            } else {
                reportEntry.setOperation("move");
            }
            reportEntry.setProperty(property);
            reportEntry.setYzjValue(yzjFullname);
            reportEntry.setErpValue(String.valueOf(erpMap.get("fullname")));
            entryList.add(reportEntry);
            reportList.add(report);
        }
        YzjSyncReport.add(reportList);
    }

    private void saveNewProReport(List<Map<String, Object>> newProList, List<String> errorFreezeList) {
        if (Utils.isListEmpty(newProList)) {
            log.debug("\u65e0\u4fee\u6539\u540d\u79f0\u7684\u7ec4\u7ec7");
            return;
        }
        HashMap<String, SyncReport> reportMap = new HashMap<String, SyncReport>();
        ArrayList<SyncReport> reportList = new ArrayList<SyncReport>(newProList.size());
        for (Map<String, Object> yzjMap : newProList) {
            CompareRule rule = (CompareRule)yzjMap.get("property");
            if (rule == null) continue;
            String yzjFullname = String.valueOf(yzjMap.get("fullname"));
            String yzjOrgId = String.valueOf(yzjMap.get("id"));
            Map erpMap = (Map)yzjMap.get(ERP_DATA_MAP);
            SyncReport report = (SyncReport)reportMap.get(yzjOrgId);
            if (report == null) {
                report = new SyncReport();
                reportMap.put(yzjOrgId, report);
                reportList.add(report);
            }
            List<SyncReportEntry> entryList = report.getEntryList();
            SyncReportEntry reportEntry = new SyncReportEntry();
            report.setTaskId(this.taskId);
            if ("name".equals(rule.getDestFld()) && errorFreezeList.contains(yzjFullname)) {
                report.setStatus(3);
                reportEntry.setNote(OrgMessage.getMessage((String)"M00074"));
            } else if (3 != report.getStatus()) {
                report.setStatus(0);
            }
            report.setDataType(DifferenceType.ORG.getKey());
            report.setSyncObject(String.valueOf(erpMap.get("name")));
            report.setYzjDataId(yzjOrgId);
            report.setErpDataId(String.valueOf(erpMap.get("orgId")));
            reportEntry.setOperation("edit");
            String property = rule.getDestFld();
            reportEntry.setProperty(property);
            reportEntry.setYzjValue(String.valueOf(yzjMap.get(rule.getSrcFld())));
            reportEntry.setErpValue(String.valueOf(erpMap.get(property)));
            entryList.add(reportEntry);
        }
        YzjSyncReport.add(reportList);
    }

    private void writeNoFreezeOrgDebugLog() {
        log.debug("\u65e0\u5c01\u5b58\u7684\u7ec4\u7ec7");
    }
}

