/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.yunzhijia.diff.impl.user;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.utils.user.UserUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.org.yunzhijia.diff.IGetErpData;
import kd.bos.org.yunzhijia.model.UserDeptPos;
import kd.bos.org.yunzhijia.model.UserJobPropertyEnum;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class GetErpUserDataImpl
implements IGetErpData {
    private static final String PROP_USER_OPEN_ID = "useropenid";

    @Override
    public Map<String, Object> getBizData() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        List<Map<String, Object>> lstUsers = this.getErpUsers();
        data.put("erp_user", lstUsers);
        Map<String, Map<String, List<UserDeptPos>>> lstUserDept = this.getErpUsersDept();
        data.put("erp_user_org", lstUserDept);
        return data;
    }

    private List<Map<String, Object>> getErpUsers() {
        String selectFields = "id,eid,tid,number,name,phone,email,gender,birthday,fuid,useropenid,enable,picturefield,createtime";
        QFilter usertypeFilter = UserUtils.getUserTypeLikeFilter((String)"1");
        QFilter[] filters = new QFilter[]{usertypeFilter};
        ArrayList<Map<String, Object>> lstUser = new ArrayList<Map<String, Object>>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"kd.bos.org.yunzhijia.diff.impl.user.GetErpUserDataImpl.getErpUsers", (String)"bos_user", (String)selectFields, (QFilter[])filters, (String)"");){
            for (Row user : dataSet) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("id", user.get("id"));
                map.put("eid", user.get("eid"));
                map.put("tid", user.get("tid"));
                Object openId = user.get(PROP_USER_OPEN_ID);
                map.put("openId", openId);
                map.put(PROP_USER_OPEN_ID, openId);
                map.put("number", user.get("number"));
                map.put("name", user.get("name"));
                map.put("phone", user.get("phone"));
                map.put("email", user.get("email"));
                map.put("gender", user.get("gender"));
                map.put("birthday", user.get("birthday"));
                map.put("fuid", user.get("fuid"));
                map.put("enable", user.get("enable"));
                map.put("picturefield", user.get("picturefield"));
                map.put("createtime", user.get("createtime"));
                lstUser.add(map);
            }
        }
        return lstUser;
    }

    private Map<String, Map<String, List<UserDeptPos>>> getErpUsersDept() {
        HashMap<String, List<UserDeptPos>> mainJobMap = new HashMap<String, List<UserDeptPos>>();
        HashMap<String, List<UserDeptPos>> partJobMap = new HashMap<String, List<UserDeptPos>>();
        HashMap<String, Map<String, List<UserDeptPos>>> udpMap = new HashMap<String, Map<String, List<UserDeptPos>>>();
        udpMap.put(UserJobPropertyEnum.MAIN_JOB.getKey(), mainJobMap);
        udpMap.put(UserJobPropertyEnum.PART_JOB.getKey(), partJobMap);
        String selectFields = "user.id id,user.name name,user.useropenid useropenid,org.id orgId,org.name orgName,org.fyzjorgid fyzjorgid,position,isincharge,ispartjob,superior.useropenid leaderopenid,superior.name leaderopenname";
        QFilter usertypeFilter = UserUtils.getUserTypeRefLikeFilter((String)"1");
        QFilter enableFilter = new QFilter("user.enable", "=", (Object)Boolean.TRUE);
        QFilter[] filters = new QFilter[]{usertypeFilter, enableFilter};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"kd.bos.org.yunzhijia.diff.impl.user.GetErpUserDataImpl.getErpUsersDept", (String)"bos_userposition", (String)selectFields, (QFilter[])filters, (String)"");){
            for (Row udp : dataSet) {
                String openId = udp.getString(PROP_USER_OPEN_ID);
                if (StringUtils.isBlank((CharSequence)openId)) continue;
                boolean isPartJob = udp.getBoolean("ispartjob");
                UserDeptPos erpDeptPos = new UserDeptPos(udp.getLong("id"), udp.getString("name"), openId, udp.getString("fyzjorgid"), udp.getLong("orgId"), udp.getString("orgName"), udp.getBoolean("isincharge"), isPartJob, udp.getString("position"));
                String leaderopenid = udp.getString("leaderopenid");
                if (StringUtils.isNotBlank((CharSequence)leaderopenid)) {
                    HashMap<String, String> superiorMap = new HashMap<String, String>(1);
                    superiorMap.put(leaderopenid, udp.getString("leaderopenname"));
                    ArrayList<Map<String, String>> superiorList = new ArrayList<Map<String, String>>(1);
                    superiorList.add(superiorMap);
                    erpDeptPos.setSuperiorList(superiorList);
                }
                if (isPartJob) {
                    this.analysisJobTypeMap(partJobMap, openId, erpDeptPos);
                    continue;
                }
                this.analysisJobTypeMap(mainJobMap, openId, erpDeptPos);
            }
        }
        return udpMap;
    }

    private void analysisJobTypeMap(Map<String, List<UserDeptPos>> jobMap, String openId, UserDeptPos erpDeptPos) {
        List<UserDeptPos> jobList = jobMap.get(openId);
        if (jobList == null) {
            jobList = new ArrayList<UserDeptPos>();
            jobList.add(erpDeptPos);
            jobMap.put(openId, jobList);
        } else {
            jobList.add(erpDeptPos);
        }
    }
}

