/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.yunzhijia.diff.impl.user;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.base.utils.BaseBatchHandler;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.lang.HZPinyin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.utils.DynamicObjectUtils;
import kd.bos.org.utils.Utils;
import kd.bos.org.yunzhijia.diff.impl.utils.YzjSyncImplUtils;
import kd.bos.org.yunzhijia.model.CompareRule;
import kd.bos.org.yunzhijia.model.UserCompareRuleSingleton;
import kd.bos.org.yunzhijia.model.UserDeptPos;
import kd.bos.org.yunzhijia.model.UserJobPropertyEnum;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.yzj.model.YzjConfig;

public class UserSyncBackup {
    private static final Log log = LogFactory.getLog(UserSyncBackup.class);
    private static final int LIMIT_COUNT = 1000;

    public static boolean saveYzjData(long taskId, Map<String, Object> yzjData, YzjConfig yzjConfig) {
        if (yzjData == null) {
            return true;
        }
        List yzjUserList = (List)yzjData.get("yzj_user");
        List superiorList = (List)yzjData.get("yzj_superior");
        return UserSyncBackup.saveYzjData(taskId, yzjUserList, yzjConfig, superiorList);
    }

    public static boolean saveYzjData(long taskId, List<Map<String, Object>> yzjUserList, YzjConfig yzjConfig) {
        return UserSyncBackup.saveYzjData(taskId, yzjUserList, yzjConfig, new ArrayList<Map<String, Object>>());
    }

    public static boolean saveYzjData(long taskId, List<Map<String, Object>> yzjUserList, YzjConfig yzjConfig, List<Map<String, Object>> superiorList) {
        if (CollectionUtils.isEmpty(yzjUserList) || yzjConfig == null) {
            return true;
        }
        if (superiorList == null) {
            superiorList = new ArrayList<Map<String, Object>>(0);
        }
        List<CompareRule> proList = UserCompareRuleSingleton.getInstance().getRules();
        try {
            Map<String, Long> orgIdMap = YzjSyncImplUtils.getBackupOrgIdMap(taskId, "cloud-hub");
            String eid = yzjConfig.getEid();
            ArrayList<DynamicObject> saveEntryList = new ArrayList<DynamicObject>(1000);
            long userId = RequestContext.get().getCurrUserId();
            Date time = new Date();
            int count = yzjUserList.size();
            HashMap<String, Long> userIdMap = new HashMap<String, Long>(count);
            ORM orm = ORM.create();
            long[] dbUserIdArr = orm.genLongIds("bos_user", count);
            int idIndex = 0;
            Iterator<Map<String, Object>> yzjDataIt = yzjUserList.iterator();
            while (yzjDataIt.hasNext()) {
                Map<String, Object> dtYzj = yzjDataIt.next();
                String openId = String.valueOf(dtYzj.get("openId"));
                if (userIdMap.containsKey(openId)) {
                    yzjDataIt.remove();
                    continue;
                }
                userIdMap.put(openId, dbUserIdArr[idIndex++]);
            }
            HashMap<String, List<String>> superiorMap = new HashMap<String, List<String>>(count);
            for (Map map : superiorList) {
                String openId = String.valueOf(map.get("openId"));
                ArrayList<String> leaderOpenIds = (ArrayList<String>)superiorMap.get(openId);
                if (leaderOpenIds == null) {
                    leaderOpenIds = new ArrayList<String>();
                    superiorMap.put(openId, leaderOpenIds);
                }
                leaderOpenIds.add(String.valueOf(map.get("leaderOpenId")));
            }
            int currentCount = 0;
            for (Map<String, Object> dtYzj : yzjUserList) {
                Object headSculpture;
                DynamicObject user = BusinessDataServiceHelper.newDynamicObject((String)"bos_yzj_user");
                String openId = String.valueOf(dtYzj.get("openId"));
                user.set("useropenid", (Object)openId);
                long id = (Long)userIdMap.get(openId);
                user.set("id", (Object)id);
                ++currentCount;
                Object birthday = dtYzj.get("birthday");
                if (StringUtils.isNotBlank((Object)birthday)) {
                    if (birthday instanceof Date) {
                        dtYzj.put("birthday", birthday);
                    } else {
                        dtYzj.put("birthday", Utils.strToDate((String)birthday.toString(), (String)"yyyy-MM-dd"));
                    }
                }
                if (StringUtils.isNotBlank((Object)(headSculpture = dtYzj.get("photoUrl"))) && !headSculpture.toString().endsWith("&spec=80")) {
                    headSculpture = headSculpture + "&spec=80";
                    dtYzj.put("photoUrl", headSculpture);
                }
                for (CompareRule rule : proList) {
                    user.set(rule.getDestFld(), dtYzj.get(rule.getSrcFld()));
                }
                if (StringUtils.isBlank((Object)dtYzj.get("uid"))) {
                    user.set("fuid", (Object)0L);
                }
                user.set("status", (Object)"C");
                user.set("task", (Object)taskId);
                user.set("backuptype", (Object)"cloud-hub");
                user.set("usertype", (Object)1);
                if ("1".equals(String.valueOf(dtYzj.get("status")))) {
                    user.set("enable", (Object)1);
                } else {
                    user.set("enable", (Object)0);
                }
                user.set("eid", (Object)eid);
                user.set("tid", (Object)eid);
                user.set("creator", (Object)userId);
                user.set("createtime", (Object)time);
                String name = dtYzj.get("name").toString();
                String fullpinyin = HZPinyin.getFullSpell((String)name, (String)"");
                if (StringUtils.isNotBlank((CharSequence)fullpinyin) && fullpinyin.length() > 100) {
                    fullpinyin = "";
                }
                user.set("fullpinyin", (Object)fullpinyin);
                String simplepinyin = HZPinyin.getFirstSpell((String)name);
                if (StringUtils.isNotBlank((CharSequence)simplepinyin) && simplepinyin.length() > 50) {
                    simplepinyin = "";
                }
                user.set("simplepinyin", (Object)simplepinyin);
                UserSyncBackup.addUserPosition(dtYzj, user, orgIdMap);
                UserSyncBackup.addUserSuperior(user, userIdMap, superiorMap);
                saveEntryList.add(user);
                if (currentCount < 1000) continue;
                SaveServiceHelper.save((DynamicObject[])saveEntryList.toArray(new DynamicObject[saveEntryList.size()]));
                currentCount = 0;
                saveEntryList.clear();
            }
            SaveServiceHelper.save((DynamicObject[])saveEntryList.toArray(new DynamicObject[saveEntryList.size()]));
        }
        catch (UnsupportedEncodingException e) {
            log.info("\u83b7\u53d6\u4eba\u5458\u7684\u5168\u62fc\u6216\u7b80\u62fc\u5931\u8d25\uff1a" + e.getMessage());
        }
        return true;
    }

    private static void addUserSuperior(DynamicObject user, Map<String, Long> userIdMap, Map<String, List<String>> superiorMap) {
        DynamicObjectCollection dpEntity = user.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)dpEntity)) {
            return;
        }
        String openId = user.getString("useropenid");
        List<String> leaderOpenIds = superiorMap.get(openId);
        if (CollectionUtils.isEmpty(leaderOpenIds)) {
            return;
        }
        int posIndex = dpEntity.size() - 1;
        DynamicObjectType entityType = dpEntity.getDynamicObjectType();
        for (String leaderOpenId : leaderOpenIds) {
            Long leaderUserId = userIdMap.get(leaderOpenId);
            if (leaderUserId == null) continue;
            DynamicObject posEntity = null;
            if (posIndex >= 0) {
                posEntity = (DynamicObject)dpEntity.get(posIndex);
                --posIndex;
            } else {
                posEntity = new DynamicObject(entityType);
                posEntity.set("seq", (Object)100000);
                posEntity.set("ispartjob", (Object)Boolean.TRUE);
                dpEntity.add((Object)posEntity);
            }
            posEntity.set("superior", (Object)leaderUserId);
        }
    }

    private static void addUserPosition(Map<String, Object> dtYzj, DynamicObject user, Map<String, Long> orgIdMap) {
        DynamicObjectCollection dpEntity = user.getDynamicObjectCollection("entryentity");
        if (dpEntity == null) {
            return;
        }
        DynamicObjectType entityType = dpEntity.getDynamicObjectType();
        int seq = 1;
        List mainJobList = (List)dtYzj.get(UserJobPropertyEnum.MAIN_JOB.getKey());
        seq = UserSyncBackup.genYzjUserPositionList(orgIdMap, mainJobList, dpEntity, entityType, seq);
        List partJobList = (List)dtYzj.get(UserJobPropertyEnum.PART_JOB.getKey());
        UserSyncBackup.genYzjUserPositionList(orgIdMap, partJobList, dpEntity, entityType, seq);
    }

    private static int genYzjUserPositionList(Map<String, Long> orgIdMap, List<UserDeptPos> jobList, DynamicObjectCollection dpEntity, DynamicObjectType entityType, int seq) {
        if (Utils.isListNotEmpty(jobList)) {
            for (UserDeptPos job : jobList) {
                Long orgId = orgIdMap.get(job.getYzjOrgId());
                if (orgId != null) {
                    job.setErpOrgId(orgId);
                }
                dpEntity.add((Object)UserSyncBackup.genYzjUserPosition(entityType, seq++, job));
            }
        }
        return seq;
    }

    private static DynamicObject genYzjUserPosition(DynamicObjectType entityType, int seq, UserDeptPos pos) {
        DynamicObject userEntity = new DynamicObject(entityType);
        userEntity.set("seq", (Object)seq++);
        userEntity.set("dpt", (Object)pos.getErpOrgId());
        userEntity.set("position", (Object)pos.getJobTitle());
        userEntity.set("isincharge", (Object)pos.isInCharge());
        userEntity.set("ispartjob", (Object)pos.isPartJob());
        return userEntity;
    }

    public static boolean saveErpDataById(long taskId, String syncBackupType, List<Long> userIds) {
        if (Utils.isListEmpty(userIds)) {
            return true;
        }
        QFilter taskFilter = new QFilter("task", "=", (Object)taskId);
        QFilter typeFilter = new QFilter("backuptype", "=", (Object)syncBackupType);
        QFilter idFilter = new QFilter("user", "in", userIds);
        QFilter[] filters = new QFilter[]{taskFilter, typeFilter, idFilter};
        DeleteServiceHelper.delete((String)"bos_yzj_user", (QFilter[])filters);
        int count = userIds.size();
        HashMap<Long, Long> backupIdMap = new HashMap<Long, Long>(count);
        long[] yzjUserIdArr = ORM.create().genLongIds("bos_yzj_user", count);
        int index = 0;
        for (long userId : userIds) {
            backupIdMap.put(userId, yzjUserIdArr[index++]);
        }
        UserSyncBackup.saveUser(taskId, syncBackupType, userIds, backupIdMap);
        return true;
    }

    public static boolean saveErpDataByFilter(long taskId, String syncBackupType, QFilter filter) {
        String selectFields;
        DynamicObjectCollection userCol;
        QFilter[] filters = null;
        if (filter != null) {
            filters = new QFilter[]{filter};
        }
        if (Utils.isListEmpty((List)(userCol = QueryServiceHelper.query((String)"bos_user", (String)(selectFields = "id"), filters)))) {
            log.debug("\u65e0\u4eba\u5458\u4fe1\u606f");
            return false;
        }
        int count = userCol.size();
        ArrayList<Long> userIds = new ArrayList<Long>(count);
        HashMap<Long, Long> backupIdMap = new HashMap<Long, Long>(count);
        long[] yzjUserIdArr = ORM.create().genLongIds("bos_yzj_user", count);
        int index = 0;
        for (DynamicObject userObj : userCol) {
            long userId = userObj.getLong("id");
            backupIdMap.put(userId, yzjUserIdArr[index++]);
            userIds.add(userId);
        }
        BaseBatchHandler.handle(userIds, (int)1000, list -> UserSyncBackup.saveUser(taskId, syncBackupType, list, backupIdMap));
        return true;
    }

    private static void saveUser(long taskId, String syncBackupType, List<Long> userIds, Map<Long, Long> backupIdMap) {
        if (CollectionUtils.isEmpty(userIds)) {
            return;
        }
        DynamicObject userType = BusinessDataServiceHelper.newDynamicObject((String)"bos_user");
        DynamicObject[] userArr = (DynamicObject[])BusinessDataServiceHelper.load((Object[])userIds.toArray(new Object[userIds.size()]), (IDataEntityType)userType.getDataEntityType());
        if (userArr == null || userArr.length == 0) {
            return;
        }
        ArrayList<String> superiorOpenIds = new ArrayList<String>(userArr.length);
        for (DynamicObject user : userArr) {
            DynamicObjectCollection baseEntryCol = user.getDynamicObjectCollection("entryentity");
            if (!Utils.isListNotEmpty((List)baseEntryCol)) continue;
            for (DynamicObject baseEntry : baseEntryCol) {
                DynamicObject superiorObj = baseEntry.getDynamicObject("superior");
                if (superiorObj == null || backupIdMap.containsKey(superiorObj.getLong("id"))) continue;
                superiorOpenIds.add(superiorObj.getString("useropenid"));
            }
        }
        Map<String, Long> superiorOpenIdMap = UserSyncBackup.getBackupSuperiorId(taskId, syncBackupType, superiorOpenIds);
        int index = 0;
        DynamicObject[] backupObjArr = new DynamicObject[userArr.length];
        Map<String, Long> orgNumberIdMap = YzjSyncImplUtils.getBackupOrgNumberIdMap(taskId, syncBackupType);
        for (DynamicObject user : userArr) {
            long userId = user.getLong("id");
            DynamicObject backupObj = BusinessDataServiceHelper.newDynamicObject((String)"bos_yzj_user");
            DynamicObjectUtils.copy((DynamicObject)user, (DynamicObject)backupObj);
            backupObj.set("id", (Object)backupIdMap.get(userId));
            backupObj.set("task", (Object)taskId);
            backupObj.set("backuptype", (Object)syncBackupType);
            backupObj.set("user", (Object)user.getLong("id"));
            DynamicObjectCollection baseEntryCol = user.getDynamicObjectCollection("entryentity");
            if (Utils.isListNotEmpty((List)baseEntryCol)) {
                DynamicObjectCollection entryEntityCol = backupObj.getDynamicObjectCollection("entryentity");
                entryEntityCol.clear();
                DynamicObjectType entityType = entryEntityCol.getDynamicObjectType();
                for (DynamicObject baseEntry : baseEntryCol) {
                    DynamicObject org;
                    DynamicObject dptEntity = new DynamicObject(entityType);
                    dptEntity.set("seq", baseEntry.get("seq"));
                    dptEntity.set("position", baseEntry.get("position"));
                    dptEntity.set("isincharge", baseEntry.get("isincharge"));
                    dptEntity.set("ispartjob", baseEntry.get("ispartjob"));
                    DynamicObject superiorObj = baseEntry.getDynamicObject("superior");
                    if (superiorObj != null) {
                        Long superiorId = superiorOpenIdMap.get(superiorObj.getString("useropenid"));
                        if (superiorId == null) {
                            dptEntity.set("superior", (Object)backupIdMap.get(superiorObj.getLong("id")));
                        } else {
                            dptEntity.set("superior", (Object)superiorId);
                        }
                    }
                    if ((org = baseEntry.getDynamicObject("dpt")) != null) {
                        dptEntity.set("dpt", (Object)orgNumberIdMap.get(org.getString("number")));
                    }
                    entryEntityCol.add((Object)dptEntity);
                }
            }
            backupObjArr[index++] = backupObj;
        }
        SaveServiceHelper.save((DynamicObject[])backupObjArr);
    }

    private static Map<String, Long> getBackupSuperiorId(long taskId, String syncBackupType, List<String> superiorOpenIds) {
        QFilter openIdFilter;
        QFilter backupTypeFilter;
        HashMap<String, Long> superiorOpenIdMap = new HashMap<String, Long>(superiorOpenIds.size());
        if (superiorOpenIds.isEmpty()) {
            return superiorOpenIdMap;
        }
        QFilter taskFilter = new QFilter("task", "=", (Object)taskId);
        QFilter[] filters = new QFilter[]{taskFilter, backupTypeFilter = new QFilter("backuptype", "=", (Object)syncBackupType), openIdFilter = new QFilter("useropenid", "in", superiorOpenIds)};
        DynamicObjectCollection userObjCol = QueryServiceHelper.query((String)"bos_yzj_user", (String)"id,useropenid", (QFilter[])filters);
        if (userObjCol == null || userObjCol.isEmpty()) {
            return superiorOpenIdMap;
        }
        for (DynamicObject userObj : userObjCol) {
            superiorOpenIdMap.put(userObj.getString("useropenid"), userObj.getLong("id"));
        }
        return superiorOpenIdMap;
    }
}

