/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.yunzhijia.diff.impl.user;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.base.utils.BaseBatchHandler;
import kd.bos.base.utils.msg.BaseMessage;
import kd.bos.base.utils.msg.UserMessage;
import kd.bos.base.utils.user.UserUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.history.UserHistoryUtils;
import kd.bos.org.manager.CacheManager;
import kd.bos.org.model.PictureFileItem;
import kd.bos.org.utils.DynamicObjectUtils;
import kd.bos.org.utils.OrgViewUtils;
import kd.bos.org.utils.Utils;
import kd.bos.org.yunzhijia.diff.impl.user.UserSyncBackup;
import kd.bos.org.yunzhijia.diff.impl.utils.YzjSyncCache;
import kd.bos.org.yunzhijia.model.CompareRule;
import kd.bos.org.yunzhijia.model.SyncContextParam;
import kd.bos.org.yunzhijia.model.UserCompareRuleSingleton;
import kd.bos.org.yunzhijia.model.UserJobPropertyEnum;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.yzj.config.YzjConfigServiceHelper;
import kd.bos.yzj.model.YzjConfig;

public class UserSyncOperation {
    private static final Log log = LogFactory.getLog(UserSyncOperation.class);
    private final long taskId;
    private String userId = "100";
    private Date exeTime = null;
    private final Set<String> yzjOrgIds;
    private final Map<String, Long> orgIdMap;
    private final Map<String, Long> structureIdMap;
    private YzjConfig yzjConfig;

    public UserSyncOperation(SyncContextParam contextParam) {
        this.taskId = contextParam.getTaskId();
        this.userId = RequestContext.get().getUserId();
        this.exeTime = new Date();
        this.yzjOrgIds = new HashSet<String>();
        this.orgIdMap = new HashMap<String, Long>();
        this.structureIdMap = new HashMap<String, Long>();
    }

    public boolean sync() {
        QFilter taskFilter = new QFilter("task", "=", (Object)this.taskId);
        QFilter typeFilter = new QFilter("datatype", "=", (Object)"user");
        QFilter statusFilter = new QFilter("status", "=", (Object)Integer.toString(0));
        QFilter[] filters = new QFilter[]{taskFilter, typeFilter, statusFilter};
        Map reportObjMap = BusinessDataServiceHelper.loadFromCache((String)"bos_yzj_syncreport", (String)"id", (QFilter[])filters);
        if (CollectionUtils.isEmpty((Map)reportObjMap)) {
            log.debug("\u65e0\u540c\u6b65\u6570\u636e");
            return true;
        }
        ArrayList<Long> reportIds = new ArrayList<Long>(reportObjMap.size());
        for (DynamicObject report : reportObjMap.values()) {
            reportIds.add(report.getLong("id"));
        }
        return this.syncByReportId(reportIds);
    }

    public boolean syncByReportId(List<Long> reportIds) {
        if (Utils.isListEmpty(reportIds)) {
            log.debug("\u65e0\u540c\u6b65\u6570\u636e");
            return true;
        }
        YzjSyncCache.updateTaskProgress(ResManager.loadKDString((String)"\u6b63\u5728\u66f4\u65b0\u4eba\u5458\u4fe1\u606f\u5230\u5f53\u524d\u7cfb\u7edf\uff0c\u8bf7\u7a0d\u7b49\u3002", (String)"UserSyncOperation_0", (String)"bos-org-formplugin", (Object[])new Object[0]));
        BaseBatchHandler.handle(reportIds, (int)500, list -> this.batchSyncByReportId(list));
        return true;
    }

    private boolean batchSyncByReportId(List<Long> reportIds) {
        QFilter statusFilter;
        QFilter typeFilter;
        if (Utils.isListEmpty(reportIds)) {
            return true;
        }
        String selectFields = "id,yzjdataid,erpdataid,yzjvalue,erpvalue,status,modifier,modifytime,entryentity.operation,entryentity.property,entryentity.description";
        QFilter idFilter = new QFilter("id", "in", reportIds);
        QFilter taskFilter = new QFilter("task", "=", (Object)this.taskId);
        QFilter[] filters = new QFilter[]{idFilter, taskFilter, typeFilter = new QFilter("datatype", "=", (Object)"user"), statusFilter = new QFilter("status", "=", (Object)Integer.toString(0))};
        DynamicObject[] reportArr = BusinessDataServiceHelper.load((String)"bos_yzj_syncreport", (String)selectFields, (QFilter[])filters);
        if (reportArr == null || reportArr.length == 0) {
            log.debug("\u65e0\u540c\u6b65\u6570\u636e");
            return true;
        }
        ArrayList<String> addList = new ArrayList<String>();
        ArrayList<Long> disableList = new ArrayList<Long>();
        ArrayList<Long> enableList = new ArrayList<Long>();
        ArrayList<String> updateList = new ArrayList<String>();
        ArrayList<String> updateProNameList = new ArrayList<String>();
        ArrayList<String> updateIconList = new ArrayList<String>();
        ArrayList<String> postList = new ArrayList<String>();
        ArrayList<Long> userIds = new ArrayList<Long>();
        String exeUserId = RequestContext.get().getUserId();
        Date exeTime = new Date();
        this.yzjConfig = YzjConfigServiceHelper.getConfig();
        List userIgnoreOperations = this.yzjConfig.getUserIgnoreOperations();
        List userIgnoreProperties = this.yzjConfig.getUserIgnoreProperties();
        boolean ignoreMainJob = userIgnoreProperties.contains(UserJobPropertyEnum.MAIN_JOB.getKey());
        boolean ignorePartJob = userIgnoreProperties.contains(UserJobPropertyEnum.PART_JOB.getKey());
        for (DynamicObject report : reportArr) {
            DynamicObjectCollection entryentityCol = report.getDynamicObjectCollection("entryentity");
            if (entryentityCol == null) continue;
            String openId = report.getString("yzjdataid");
            long userId = 0L;
            String erpDataId = report.getString("erpdataid");
            if (StringUtils.isNotBlank((CharSequence)erpDataId)) {
                userId = Long.parseLong(erpDataId);
                userIds.add(userId);
            }
            boolean isProDiff = false;
            boolean doSync = false;
            block24: for (DynamicObject entryObj : entryentityCol) {
                String operation = entryObj.getString("operation");
                String property = entryObj.getString("property");
                switch (operation) {
                    case "add": {
                        boolean isMainJob = UserJobPropertyEnum.MAIN_JOB.getKey().equals(property);
                        boolean isPartJob = UserJobPropertyEnum.PART_JOB.getKey().equals(property);
                        if (isMainJob || isPartJob) {
                            if (isMainJob && userIgnoreProperties.contains(UserJobPropertyEnum.MAIN_JOB.getKey())) {
                                entryObj.set("description", (Object)UserMessage.getMessage((String)"M00044"));
                                continue block24;
                            }
                            if (isPartJob && userIgnoreProperties.contains(UserJobPropertyEnum.PART_JOB.getKey())) {
                                entryObj.set("description", (Object)UserMessage.getMessage((String)"M00045"));
                                continue block24;
                            }
                            postList.add(openId);
                            updateList.add(openId);
                            doSync = true;
                            continue block24;
                        }
                        if (userIgnoreOperations.contains("add")) {
                            entryObj.set("description", (Object)UserMessage.getMessage((String)"M00039"));
                            continue block24;
                        }
                        addList.add(openId);
                        doSync = true;
                        continue block24;
                    }
                    case "delete": {
                        if (!UserJobPropertyEnum.MAIN_JOB.getKey().equals(property) && !UserJobPropertyEnum.PART_JOB.getKey().equals(property)) continue block24;
                        if (ignoreMainJob && UserJobPropertyEnum.MAIN_JOB.getKey().equals(property)) {
                            entryObj.set("description", (Object)UserMessage.getMessage((String)"M00044"));
                            continue block24;
                        }
                        if (ignorePartJob && UserJobPropertyEnum.PART_JOB.getKey().equals(property)) {
                            entryObj.set("description", (Object)UserMessage.getMessage((String)"M00045"));
                            continue block24;
                        }
                        postList.add(openId);
                        updateList.add(openId);
                        doSync = true;
                        continue block24;
                    }
                    case "disable": {
                        if (userIgnoreOperations.contains("disable")) {
                            entryObj.set("description", (Object)UserMessage.getMessage((String)"M00041"));
                            continue block24;
                        }
                        disableList.add(userId);
                        doSync = true;
                        continue block24;
                    }
                    case "enable": {
                        if (userIgnoreOperations.contains("enable")) {
                            entryObj.set("description", (Object)UserMessage.getMessage((String)"M00042"));
                            continue block24;
                        }
                        enableList.add(userId);
                        doSync = true;
                        continue block24;
                    }
                }
                if (userIgnoreOperations.contains("edit")) {
                    entryObj.set("description", (Object)UserMessage.getMessage((String)"M00040"));
                    continue;
                }
                if (userIgnoreProperties.contains(property)) {
                    entryObj.set("description", (Object)UserMessage.getMessage((String)"M00043"));
                    continue;
                }
                boolean isUpdatePosition = false;
                for (UserJobPropertyEnum jobPro : UserJobPropertyEnum.values()) {
                    if (!jobPro.getKey().equals(property)) continue;
                    isUpdatePosition = true;
                    if (ignoreMainJob && property.startsWith("main_") || ignorePartJob && property.startsWith("part_")) {
                        entryObj.set("description", (Object)UserMessage.getMessage((String)"M00043"));
                        break;
                    }
                    postList.add(openId);
                    doSync = true;
                    break;
                }
                if (!isUpdatePosition) {
                    updateProNameList.add(property);
                    doSync = true;
                }
                if ("picturefield".equals(property)) {
                    updateIconList.add(openId);
                }
                isProDiff = true;
            }
            if (isProDiff) {
                updateList.add(openId);
            }
            if (doSync) {
                report.set("status", (Object)1);
            } else {
                report.set("status", (Object)4);
            }
            report.set("modifier", (Object)exeUserId);
            report.set("modifytime", (Object)exeTime);
        }
        this.yzjConfig = YzjConfigServiceHelper.getConfig();
        try (TXHandle h = TX.required();){
            try {
                SaveServiceHelper.save((DynamicObject[])reportArr);
                HashSet<String> existsUserNames = new HashSet<String>(addList.size() + updateList.size());
                this.add(addList, existsUserNames);
                this.enable(disableList, false);
                this.enable(enableList, true);
                this.update(updateList, updateProNameList, postList, existsUserNames);
                this.saveUserIcon(updateIconList);
                CacheManager.removeCache((String)"bos_user");
                UserSyncBackup.saveErpDataById(this.taskId, "after", userIds);
            }
            catch (Exception e) {
                log.info("\u540c\u6b65\u4e91\u4e4b\u5bb6\u4eba\u5458\u4fe1\u606f\u5230\u82cd\u7a79\u53d1\u751f\u5f02\u5e38\uff1a" + e.getMessage(), (Object)e);
                h.markRollback();
                throw new KDBizException(BaseMessage.getMessage((String)"M00061", (Object[])new Object[]{e.getMessage()}));
            }
        }
        return true;
    }

    private boolean add(List<String> openIds, Set<String> existsUserNames) {
        log.debug("\u5f00\u59cb\u4ece\u4e91\u4e4b\u5bb6\u540c\u6b65\u65b0\u589e\u4eba\u5458\u81f3\u91d1\u8776\u4e91");
        if (Utils.isListEmpty(openIds)) {
            return true;
        }
        YzjSyncCache.updateTaskProgress(ResManager.loadKDString((String)"\u65b0\u589e\u4e91\u4e4b\u5bb6\u4eba\u5458\u5230\u5f53\u524d\u7cfb\u7edf\u4e2d\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"UserSyncOperation_1", (String)"bos-org-formplugin", (Object[])new Object[0]));
        String selectFields = "id,entryentity.dpt.fyzjorgid yzjorgid";
        QFilter taskFilter = new QFilter("task", "=", (Object)this.taskId);
        QFilter idFilter = new QFilter("useropenid", "in", openIds);
        QFilter backTypeFilter = new QFilter("backuptype", "=", (Object)"cloud-hub");
        QFilter[] filters = new QFilter[]{taskFilter, idFilter, backTypeFilter};
        DynamicObjectCollection yzjUserCol = QueryServiceHelper.query((String)"bos_yzj_user", (String)selectFields, (QFilter[])filters);
        if (Utils.isListEmpty((List)yzjUserCol)) {
            log.info("\u67e5\u8be2\u4e91\u4e4b\u5bb6\u4eba\u5458\u4fe1\u606f\u5931\u8d25");
            return false;
        }
        int count = yzjUserCol.size();
        ArrayList<Long> idList = new ArrayList<Long>(count);
        for (DynamicObject yzjUser : yzjUserCol) {
            idList.add(yzjUser.getLong("id"));
            this.yzjOrgIds.add(yzjUser.getString("yzjorgid"));
        }
        this.getOrgIdMap();
        DynamicObject yzjUserType = BusinessDataServiceHelper.newDynamicObject((String)"bos_yzj_user");
        DynamicObject[] yzjUserArr = (DynamicObject[])BusinessDataServiceHelper.load((Object[])idList.toArray(new Object[idList.size()]), (IDataEntityType)yzjUserType.getDataEntityType());
        if (yzjUserArr == null || yzjUserArr.length == 0) {
            log.info("\u67e5\u8be2\u4e91\u4e4b\u5bb6\u4eba\u5458\u4fe1\u606f\u5931\u8d25");
            return false;
        }
        ArrayList<String> superiorOpenIds = new ArrayList<String>(yzjUserArr.length);
        HashMap<Integer, Long> idMap = new HashMap<Integer, Long>(yzjUserArr.length);
        HashMap<String, Long> openIdMap = new HashMap<String, Long>(yzjUserArr.length);
        this.getUserIdMap(yzjUserArr, idMap, openIdMap, superiorOpenIds);
        Map<String, Long> superiorIdMap = this.getUserOpenIdMap(superiorOpenIds);
        ArrayList<DynamicObject> userObjList = new ArrayList<DynamicObject>(yzjUserCol.size());
        String userId = RequestContext.get().getUserId();
        Date time = new Date();
        Date startDate = Utils.getDate((int)0);
        Date endDate = Utils.getEndDate();
        ArrayList<String> errorOpenIds = new ArrayList<String>(yzjUserArr.length);
        HashMap<String, Map<String, String>> errorOpenIdMsgMap = new HashMap<String, Map<String, String>>(yzjUserArr.length);
        Map userTypeMap = null;
        DynamicObject nameMergeStyleObj = null;
        for (DynamicObject yzjUser : yzjUserArr) {
            String openId = yzjUser.getString("useropenid");
            DynamicObject erpUser = BusinessDataServiceHelper.newDynamicObject((String)"bos_user");
            DynamicObjectUtils.copy((DynamicObject)yzjUser, (DynamicObject)erpUser);
            if (!this.validate(erpUser, false, errorOpenIdMsgMap)) {
                errorOpenIds.add(openId);
                continue;
            }
            long id = (Long)idMap.get(yzjUser.hashCode());
            erpUser.set("id", (Object)id);
            erpUser.set("masterid", (Object)id);
            erpUser.set("password", (Object)UserServiceHelper.getUserDefaultPsw());
            erpUser.set("psweffectivedate", (Object)startDate);
            erpUser.set("pswstrategy", (Object)338333884850648064L);
            UserUtils.transUserNamePinyin((DynamicObject)erpUser, existsUserNames);
            erpUser.set("creator", (Object)userId);
            erpUser.set("createtime", (Object)time);
            erpUser.set("startdate", (Object)startDate);
            erpUser.set("enddate", (Object)endDate);
            erpUser.set("status", (Object)"C");
            if (nameMergeStyleObj == null) {
                nameMergeStyleObj = UserUtils.getNameMergeStyleDynamicObject((DynamicObject)erpUser);
            }
            if (nameMergeStyleObj != null) {
                erpUser.set("ns_namestyle", (Object)nameMergeStyleObj);
                this.setNsName(erpUser);
            }
            if (userTypeMap == null) {
                userTypeMap = UserUtils.getAllUserType((String)"1", (boolean)true);
            }
            UserUtils.parseUserType((DynamicObject)erpUser, userTypeMap);
            DynamicObjectCollection yzjUserPost = yzjUser.getDynamicObjectCollection("entryentity");
            if (Utils.isListNotEmpty((List)yzjUserPost)) {
                DynamicObjectCollection erpUserPost = erpUser.getDynamicObjectCollection("entryentity");
                if (Utils.isListNotEmpty((List)erpUserPost)) {
                    erpUserPost.clear();
                }
                DynamicObjectType entityType = erpUserPost.getDynamicObjectType();
                int seq = 1;
                for (DynamicObject yzjPost : yzjUserPost) {
                    DynamicObject userEntity = new DynamicObject(entityType);
                    userEntity.set("seq", (Object)seq++);
                    DynamicObject orgObj = yzjPost.getDynamicObject("dpt");
                    Long orgId = null;
                    if (orgObj == null) {
                        HashMap<String, String> errorInfo = new HashMap<String, String>();
                        errorInfo.put("error", UserMessage.getMessage((String)"M00048"));
                        errorOpenIdMsgMap.put(openId, errorInfo);
                        break;
                    }
                    String yzjOrgId = orgObj.getString("fyzjorgid");
                    orgId = this.orgIdMap.get(yzjOrgId);
                    userEntity.set("orgstructure", (Object)this.structureIdMap.get(yzjOrgId));
                    if (orgId == null) {
                        errorOpenIds.add(openId);
                        HashMap<String, String> errorInfo = new HashMap<String, String>();
                        errorInfo.put("property", "position");
                        errorInfo.put("orgName", orgObj.getString("name"));
                        errorInfo.put("error", UserMessage.getMessage((String)"M00048"));
                        errorOpenIdMsgMap.put(openId, errorInfo);
                        break;
                    }
                    userEntity.set("dpt", (Object)orgId);
                    userEntity.set("position", yzjPost.get("position"));
                    userEntity.set("isincharge", yzjPost.get("isincharge"));
                    userEntity.set("ispartjob", yzjPost.get("ispartjob"));
                    DynamicObject superiorObj = yzjPost.getDynamicObject("superior");
                    if (superiorObj != null) {
                        String superiorOpenId = superiorObj.getString("useropenid");
                        Long superiorUserId = (Long)openIdMap.get(superiorOpenId);
                        if (superiorUserId == null) {
                            superiorUserId = superiorIdMap.get(superiorOpenId);
                        }
                        userEntity.set("superior", (Object)superiorUserId);
                    }
                    erpUserPost.add((Object)userEntity);
                }
            }
            userObjList.add(erpUser);
        }
        this.updateReportStatus(errorOpenIdMsgMap, errorOpenIds);
        if (userObjList.isEmpty()) {
            return true;
        }
        Object[] insertedUsers = SaveServiceHelper.save((DynamicObject[])userObjList.toArray(new DynamicObject[userObjList.size()]));
        if (insertedUsers == null || insertedUsers.length == 0) {
            return false;
        }
        ArrayList<Long> userIds = new ArrayList<Long>(insertedUsers.length);
        for (Object userObj : insertedUsers) {
            if (!(userObj instanceof DynamicObject)) continue;
            DynamicObject user = (DynamicObject)userObj;
            userIds.add(user.getLong("id"));
        }
        LicenseServiceHelper.addUsers2LicGroupDif(new HashSet(userIds));
        UserSyncBackup.saveErpDataById(this.taskId, "after", userIds);
        this.saveNewUserChangeAndHistory(openIds);
        return true;
    }

    private void getUserIdMap(DynamicObject[] yzjUserArr, Map<Integer, Long> idMap, Map<String, Long> openIdMap, List<String> superiorOpenIds) {
        long[] userIdArr = ORM.create().genLongIds("bos_user", yzjUserArr.length);
        int idIndex = 0;
        for (DynamicObject yzjUser : yzjUserArr) {
            String openId = yzjUser.getString("useropenid");
            long id = userIdArr[idIndex++];
            idMap.put(yzjUser.hashCode(), id);
            openIdMap.put(openId, id);
            DynamicObjectCollection yzjUserPost = yzjUser.getDynamicObjectCollection("entryentity");
            if (Utils.isListEmpty((List)yzjUserPost)) continue;
            for (DynamicObject yzjPost : yzjUserPost) {
                DynamicObject superiorObj = yzjPost.getDynamicObject("superior");
                if (superiorObj == null) continue;
                superiorOpenIds.add(superiorObj.getString("useropenid"));
            }
        }
    }

    private boolean validate(DynamicObject userObj, boolean update, Map<String, Map<String, String>> errorOpenIdMsgMap) {
        String msg;
        long id = 0L;
        if (update) {
            id = userObj.getLong("id");
        }
        if (StringUtils.isNotBlank((CharSequence)(msg = this.validateNumber(id, userObj.getString("number"))))) {
            this.addErrorMap(userObj, errorOpenIdMsgMap, "number", msg);
            return false;
        }
        msg = this.validatePhone(id, userObj.getString("phone"));
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            this.addErrorMap(userObj, errorOpenIdMsgMap, "phone", msg);
            return false;
        }
        msg = this.validateEmail(id, userObj.getString("email"));
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            this.addErrorMap(userObj, errorOpenIdMsgMap, "email", msg);
            return false;
        }
        return true;
    }

    private void addErrorMap(DynamicObject userObj, Map<String, Map<String, String>> errorOpenIdMsgMap, String proName, String msg) {
        HashMap<String, String> errorInfo = new HashMap<String, String>();
        errorInfo.put("property", proName);
        errorInfo.put("error", msg);
        errorOpenIdMsgMap.put(userObj.getString("useropenid"), errorInfo);
    }

    private String validateNumber(long id, String number) {
        if (StringUtils.isBlank((CharSequence)number)) {
            return UserMessage.getMessage((String)"M00083");
        }
        QFilter filter = new QFilter("number", "=", (Object)number);
        if (id != 0L) {
            filter = filter.and(new QFilter("id", "!=", (Object)id));
        }
        QFilter enableQFliter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter[] filters = new QFilter[]{filter, enableQFliter};
        if (QueryServiceHelper.exists((String)"bos_user", (QFilter[])filters)) {
            return UserMessage.getMessage((String)"M00067");
        }
        return "";
    }

    private String validatePhone(long id, String phone) {
        if (StringUtils.isBlank((CharSequence)phone)) {
            return "";
        }
        QFilter filter = new QFilter("phone", "=", (Object)phone);
        filter = filter.and(new QFilter("usertype", "!=", (Object)"7"));
        if (id != 0L) {
            filter = filter.and(new QFilter("id", "!=", (Object)id));
        }
        QFilter enableQFliter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter[] filters = new QFilter[]{filter, enableQFliter};
        if (QueryServiceHelper.exists((String)"bos_user", (QFilter[])filters)) {
            return UserMessage.getMessage((String)"M00031");
        }
        return "";
    }

    private String validateEmail(long id, String email) {
        if (StringUtils.isBlank((CharSequence)email)) {
            return "";
        }
        QFilter filter = new QFilter("email", "=", (Object)email);
        filter = filter.and(new QFilter("usertype", "!=", (Object)"7"));
        if (id != 0L) {
            filter = filter.and(new QFilter("id", "!=", (Object)id));
        }
        QFilter enableQFliter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter[] filters = new QFilter[]{filter, enableQFliter};
        if (QueryServiceHelper.exists((String)"bos_user", (QFilter[])filters)) {
            return UserMessage.getMessage((String)"M00032");
        }
        return "";
    }

    private void updateReportStatus(Map<String, Map<String, String>> dataMsgMap, List<String> errorOpenIds) {
        QFilter dataFilter;
        QFilter typeFilter;
        if (CollectionUtils.isEmpty(errorOpenIds)) {
            return;
        }
        String selectFields = "id,yzjdataid,status,entryentity.property,entryentity.yzjvalue,entryentity.description";
        QFilter taskFilter = new QFilter("task", "=", (Object)this.taskId);
        QFilter[] filters = new QFilter[]{taskFilter, typeFilter = new QFilter("datatype", "=", (Object)"user"), dataFilter = new QFilter("yzjdataid", "in", errorOpenIds)};
        DynamicObject[] reportArr = BusinessDataServiceHelper.load((String)"bos_yzj_syncreport", (String)selectFields, (QFilter[])filters);
        if (reportArr == null || reportArr.length == 0) {
            return;
        }
        for (DynamicObject reportObj : reportArr) {
            String openId = reportObj.getString("yzjdataid");
            Map<String, String> errorInfoMap = dataMsgMap.get(openId);
            if (errorInfoMap == null) continue;
            reportObj.set("status", (Object)Integer.toString(3));
            DynamicObjectCollection entryEntityCol = reportObj.getDynamicObjectCollection("entryentity");
            boolean includeErrorProperty = false;
            for (DynamicObject entryObj : entryEntityCol) {
                if (!errorInfoMap.containsKey(entryObj.getString("property"))) continue;
                includeErrorProperty = true;
                break;
            }
            for (DynamicObject entryObj : entryEntityCol) {
                if (includeErrorProperty && !this.findErrorProperty(errorInfoMap, entryObj)) continue;
                entryObj.set("description", (Object)errorInfoMap.get("error"));
            }
        }
        SaveServiceHelper.save((DynamicObject[])reportArr);
    }

    private boolean findErrorProperty(Map<String, String> errorInfoMap, DynamicObject entryObj) {
        String errorProperty = errorInfoMap.get("property");
        if (StringUtils.isBlank((CharSequence)errorProperty)) {
            return true;
        }
        String property = entryObj.getString("property");
        if (StringUtils.isBlank((CharSequence)property)) {
            return true;
        }
        boolean addDescription = false;
        String yzjValue = entryObj.getString("yzjvalue");
        if ("position".equals(errorProperty)) {
            String orgName = errorInfoMap.get("orgName");
            if (StringUtils.isBlank((CharSequence)orgName) || StringUtils.isBlank((CharSequence)yzjValue)) {
                addDescription = true;
            } else if (yzjValue.startsWith(orgName + "\\")) {
                addDescription = true;
            }
        } else if (errorProperty.equals(property)) {
            addDescription = true;
        }
        return addDescription;
    }

    private boolean enable(List<Long> userIds, boolean isEnable) {
        if (Utils.isListEmpty(userIds)) {
            return true;
        }
        String selectFields = "id,fuid,useropenid,number,name,phone,enable,modifier,modifytime,disabler,disabledate,isforbidden,userdisablerid,userdisabletime";
        QFilter openIdFilter = new QFilter("id", "in", userIds);
        QFilter[] filters = new QFilter[]{openIdFilter};
        DynamicObject[] userArr = BusinessDataServiceHelper.load((String)"bos_user", (String)selectFields, (QFilter[])filters);
        if (userArr == null || userArr.length == 0) {
            log.info("\u67e5\u8be2\u4e91\u4e4b\u5bb6\u4eba\u5458\u4fe1\u606f\u5931\u8d25");
            return false;
        }
        if (isEnable) {
            YzjSyncCache.updateTaskProgress(ResManager.loadKDString((String)"\u542f\u7528\u5f53\u524d\u7cfb\u7edf\u4eba\u5458\u4e2d\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"UserSyncOperation_2", (String)"bos-org-formplugin", (Object[])new Object[0]));
            LicenseServiceHelper.addUsers2LicGroupDif(new HashSet<Long>(userIds));
        } else {
            YzjSyncCache.updateTaskProgress(ResManager.loadKDString((String)"\u6b63\u5728\u6267\u884c\u7981\u7528\u5f53\u524d\u7cfb\u7edf\u4eba\u5458\u7684\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"UserSyncOperation_3", (String)"bos-org-formplugin", (Object[])new Object[0]));
            LicenseServiceHelper.deleteUserLic(new HashSet<Long>(userIds));
        }
        int count = userArr.length;
        ArrayList<Map<String, Object>> userChangeList = new ArrayList<Map<String, Object>>(count);
        for (DynamicObject user : userArr) {
            user.set("modifier", (Object)this.userId);
            user.set("modifytime", (Object)this.exeTime);
            if (isEnable) {
                if (this.yzjConfig.isDisableuser()) {
                    user.set("enable", (Object)1);
                    user.set("disabler", null);
                    user.set("disabledate", null);
                } else {
                    user.set("isforbidden", (Object)0L);
                    user.set("userdisablerid", null);
                    user.set("userdisabletime", null);
                }
                userChangeList.add(this.genUserChange(user, "5"));
                continue;
            }
            if (this.yzjConfig.isDisableuser()) {
                user.set("fuid", (Object)0L);
                user.set("useropenid", (Object)"");
                user.set("enable", (Object)0);
                user.set("disabler", (Object)this.userId);
                user.set("disabledate", (Object)this.exeTime);
            } else {
                user.set("isforbidden", (Object)1L);
                user.set("userdisablerid", (Object)this.userId);
                user.set("userdisabletime", (Object)this.exeTime);
            }
            userChangeList.add(this.genUserChange(user, "4"));
        }
        SaveServiceHelper.save((DynamicObject[])userArr);
        this.saveUserChange(userChangeList);
        UserHistoryUtils.saveUserHistory(userIds);
        return true;
    }

    private boolean update(List<String> openIds, List<String> updateProNameList, List<String> postList, Set<String> existsUserNames) {
        QFilter enableFilter;
        QFilter adminFilter;
        QFilter[] filters;
        DynamicObject[] userArr;
        if (Utils.isListEmpty(openIds)) {
            return true;
        }
        YzjSyncCache.updateTaskProgress(ResManager.loadKDString((String)"\u66f4\u65b0\u4e91\u4e4b\u5bb6\u4eba\u5458\u4fe1\u606f\u5230\u5f53\u524d\u7cfb\u7edf\u4e2d\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"UserSyncOperation_4", (String)"bos-org-formplugin", (Object[])new Object[0]));
        List<CompareRule> proList = UserCompareRuleSingleton.getInstance().getRules();
        String selectFields = this.getUpdateFields(proList, updateProNameList);
        ArrayList<String> phoneList = new ArrayList<String>(openIds.size());
        ArrayList<String> emaiList = new ArrayList<String>(openIds.size());
        HashMap<String, DynamicObject> yzjUserMap = new HashMap<String, DynamicObject>();
        HashMap<String, DynamicObject> yzjUserIdMap = new HashMap<String, DynamicObject>();
        ArrayList<String> superiorOpenIds = new ArrayList<String>();
        this.getYzjUserMap(openIds, phoneList, emaiList, selectFields, yzjUserMap, yzjUserIdMap, superiorOpenIds);
        if (yzjUserMap.isEmpty() && yzjUserIdMap.isEmpty()) {
            return false;
        }
        QFilter userFilter = new QFilter("useropenid", "in", openIds);
        if (!phoneList.isEmpty()) {
            userFilter = userFilter.or(new QFilter("phone", "in", phoneList));
        }
        if (!emaiList.isEmpty()) {
            userFilter = userFilter.or(new QFilter("email", "in", emaiList));
        }
        if ((userArr = BusinessDataServiceHelper.load((String)"bos_user", (String)selectFields, (QFilter[])(filters = new QFilter[]{userFilter, adminFilter = new QFilter("usertype", "=", (Object)"1"), enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE)}))) == null || userArr.length == 0) {
            log.info("\u9700\u8981\u66f4\u65b0\u7684\u7ec4\u4eba\u5458\u5df2\u627e\u4e0d\u5230");
            return false;
        }
        this.getOrgIdMap();
        Map<String, Long> superiorIdMap = this.getUserOpenIdMap(superiorOpenIds);
        int count = userArr.length;
        ArrayList<Map<String, Object>> userChangeList = new ArrayList<Map<String, Object>>(count);
        ArrayList<Long> userIds = new ArrayList<Long>(count);
        updateProNameList.removeAll(this.yzjConfig.getUserIgnoreProperties());
        ArrayList<String> errorOpenIds = new ArrayList<String>(userArr.length);
        HashMap<String, Map<String, String>> errorOpenIdMsgMap = new HashMap<String, Map<String, String>>(userArr.length);
        ArrayList<DynamicObject> userObjList = new ArrayList<DynamicObject>(userArr.length);
        for (DynamicObject user : userArr) {
            DynamicObject nameStyle;
            String msg = "";
            String openId = user.getString("useropenid");
            String phone = user.getString("phone");
            String email = user.getString("email");
            DynamicObject yzjUser = null;
            if (StringUtils.isNotBlank((CharSequence)phone)) {
                yzjUser = (DynamicObject)yzjUserMap.get(phone);
            }
            if (yzjUser == null && StringUtils.isNotBlank((CharSequence)email)) {
                yzjUser = (DynamicObject)yzjUserMap.get(email);
            }
            if (yzjUser == null && (yzjUser = (DynamicObject)yzjUserIdMap.get(openId)) == null) {
                msg = BaseMessage.getMessage((String)"M00062");
                errorOpenIds.add(openId);
                HashMap errorInfo = new HashMap();
                errorInfo.put("error", msg);
                errorOpenIdMsgMap.put(openId, errorInfo);
                continue;
            }
            for (String proName : updateProNameList) {
                user.set(proName, yzjUser.get(proName));
            }
            if (updateProNameList.contains("name") && (nameStyle = user.getDynamicObject("ns_namestyle")) != null && nameStyle.getLong("id") == 1997239714909794304L) {
                this.setNsName(user);
            }
            if (!this.validate(user, true, errorOpenIdMsgMap)) {
                errorOpenIds.add(openId);
                continue;
            }
            UserUtils.transUserNamePinyin((DynamicObject)user, existsUserNames);
            if (StringUtils.isBlank((Object)user.get("password"))) {
                user.set("password", (Object)UserServiceHelper.getUserDefaultPsw());
            }
            user.set("modifier", (Object)this.userId);
            user.set("modifytime", (Object)this.exeTime);
            if (postList.contains(openId) && !this.updatePosition(user, yzjUser, this.orgIdMap, this.structureIdMap, superiorIdMap, errorOpenIdMsgMap)) {
                errorOpenIds.add(openId);
                continue;
            }
            userObjList.add(user);
            userChangeList.add(this.genUserChange(user, "2"));
            userIds.add(user.getLong("id"));
        }
        SaveServiceHelper.save((DynamicObject[])userObjList.toArray(new DynamicObject[userObjList.size()]));
        this.updateReportStatus(errorOpenIdMsgMap, errorOpenIds);
        LicenseServiceHelper.addUsers2LicGroupDif(new HashSet(userIds));
        this.saveUserChange(userChangeList);
        UserHistoryUtils.saveUserHistory(userIds);
        return true;
    }

    private void setNsName(DynamicObject user) {
        String localeName;
        ILocaleString name = user.getLocaleString("name");
        if (name != null && StringUtils.isNotBlank((CharSequence)(localeName = name.getLocaleValue()))) {
            user.set("ns_firstname", (Object)localeName);
        }
    }

    private String getUpdateFields(List<CompareRule> proList, List<String> updateProNameList) {
        StringBuilder selectFields = new StringBuilder("id");
        ArrayList<String> userProList = new ArrayList<String>(proList.size());
        for (CompareRule rule : proList) {
            String proName = rule.getDestFld();
            userProList.add(proName);
            selectFields.append(",");
            selectFields.append(proName);
        }
        updateProNameList.retainAll(userProList);
        if (updateProNameList.contains("eid")) {
            updateProNameList.add("tid");
        }
        selectFields.append(",");
        selectFields.append("ns_namestyle");
        selectFields.append(",");
        selectFields.append("ns_firstname");
        selectFields.append(",");
        selectFields.append("username");
        selectFields.append(",");
        selectFields.append("fullpinyin");
        selectFields.append(",");
        selectFields.append("simplepinyin");
        selectFields.append(",");
        selectFields.append("modifier");
        selectFields.append(",");
        selectFields.append("modifytime");
        selectFields.append(",");
        selectFields.append("password");
        selectFields.append(",");
        selectFields.append("entryentity");
        selectFields.append(",");
        selectFields.append("entryentity.seq,entryentity.dpt,entryentity.orgstructure,entryentity.position");
        selectFields.append(",entryentity.isincharge,entryentity.ispartjob,entryentity.superior");
        return selectFields.toString();
    }

    private void getYzjUserMap(List<String> openIds, List<String> phoneList, List<String> emailList, String selectFields, Map<String, DynamicObject> yzjUserMap, Map<String, DynamicObject> yzjUserIdMap, List<String> superiorOpenIds) {
        QFilter backTypeFilter;
        QFilter idFilter;
        if (Utils.isListEmpty(openIds)) {
            return;
        }
        QFilter taskFilter = new QFilter("task", "=", (Object)this.taskId);
        QFilter[] filters = new QFilter[]{taskFilter, idFilter = new QFilter("useropenid", "in", openIds), backTypeFilter = new QFilter("backuptype", "=", (Object)"cloud-hub")};
        DynamicObject[] yzjUserArr = BusinessDataServiceHelper.load((String)"bos_yzj_user", (String)selectFields, (QFilter[])filters);
        if (yzjUserArr == null || yzjUserArr.length == 0) {
            log.info("\u67e5\u8be2\u4e91\u4e4b\u5bb6\u4eba\u5458\u4fe1\u606f\u5931\u8d25");
            return;
        }
        for (DynamicObject yzjUser : yzjUserArr) {
            String openId = yzjUser.getString("useropenid");
            String phone = yzjUser.getString("phone");
            String email = yzjUser.getString("email");
            if (StringUtils.isNotBlank((CharSequence)phone)) {
                phoneList.add(phone);
                yzjUserMap.put(phone, yzjUser);
            }
            if (StringUtils.isNotBlank((CharSequence)email)) {
                emailList.add(email);
                yzjUserMap.put(email, yzjUser);
            }
            yzjUserIdMap.put(openId, yzjUser);
            DynamicObjectCollection yzjPostCol = yzjUser.getDynamicObjectCollection("entryentity");
            if (Utils.isListEmpty((List)yzjPostCol)) continue;
            for (DynamicObject yzjPost : yzjPostCol) {
                DynamicObject superior;
                DynamicObject org = yzjPost.getDynamicObject("dpt");
                if (org != null) {
                    this.yzjOrgIds.add(org.getString("fyzjorgid"));
                }
                if ((superior = yzjPost.getDynamicObject("superior")) == null) continue;
                superiorOpenIds.add(superior.getString("useropenid"));
            }
        }
    }

    private void getOrgIdMap() {
        if (this.yzjOrgIds.isEmpty()) {
            return;
        }
        String selectFields = "id,org,yzjorgid,isfreeze";
        QFilter yzjOrgIdFilter = new QFilter("yzjorgid", "in", this.yzjOrgIds);
        QFilter viewQFilter = OrgViewUtils.getOrgViewFilter((String)"01");
        QFilter[] filters = new QFilter[]{yzjOrgIdFilter, viewQFilter};
        Map structureObjMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org_structure", (String)selectFields, (QFilter[])filters);
        if (!CollectionUtils.isEmpty((Map)structureObjMap)) {
            ArrayList<String> yzjOrgIdList = new ArrayList<String>(structureObjMap.size());
            for (DynamicObject structureObj : structureObjMap.values()) {
                String yzjOrgId = structureObj.getString("yzjorgid");
                if (yzjOrgIdList.contains(yzjOrgId) && structureObj.getBoolean("isfreeze")) continue;
                yzjOrgIdList.add(yzjOrgId);
                DynamicObject orgObj = structureObj.getDynamicObject("org");
                if (orgObj != null) {
                    this.orgIdMap.put(yzjOrgId, orgObj.getLong("id"));
                }
                this.structureIdMap.put(yzjOrgId, structureObj.getLong("id"));
            }
        }
        this.yzjOrgIds.clear();
    }

    private boolean updatePosition(DynamicObject user, DynamicObject yzjUser, Map<String, Long> orgIdMap, Map<String, Long> structureIdMap, Map<String, Long> superiorIdMap, Map<String, Map<String, String>> errorOpenIdMsgMap) {
        boolean isPartJob;
        DynamicObjectCollection dpEntity = user.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection yzjPostCol = yzjUser.getDynamicObjectCollection("entryentity");
        if (dpEntity == null || yzjPostCol == null) {
            return true;
        }
        ArrayList<String> yzjSuperiorOpenIds = new ArrayList<String>(yzjPostCol.size());
        for (DynamicObject yzjPost : yzjPostCol) {
            DynamicObject superior = yzjPost.getDynamicObject("superior");
            if (superior == null) continue;
            yzjSuperiorOpenIds.add(superior.getString("useropenid"));
        }
        List userIgnoreProperties = this.yzjConfig.getUserIgnoreProperties();
        boolean ignoreMainJob = userIgnoreProperties.contains(UserJobPropertyEnum.MAIN_JOB.getKey());
        boolean ignorePartJob = userIgnoreProperties.contains(UserJobPropertyEnum.PART_JOB.getKey());
        Iterator erpJobIt = dpEntity.iterator();
        int erpPosCount = dpEntity.size();
        HashMap<String, String> orgPosSuperiorMap = new HashMap<String, String>(erpPosCount);
        HashMap<String, String> orgSuperiorMap = new HashMap<String, String>(erpPosCount);
        ArrayList<String> sameSuperiorOpenIds = new ArrayList<String>(erpPosCount);
        HashMap<String, Object> matchEntryEntityMap = new HashMap<String, Object>(4);
        HashMap<String, DynamicObject> orgPosPartEntryMap = new HashMap<String, DynamicObject>(erpPosCount);
        matchEntryEntityMap.put("orgPosPartEntryMap", orgPosPartEntryMap);
        HashMap<String, DynamicObject> orgPosEntryMap = new HashMap<String, DynamicObject>(erpPosCount);
        matchEntryEntityMap.put("orgPosEntryMap", orgPosEntryMap);
        HashMap<String, DynamicObject> orgPartEntryMap = new HashMap<String, DynamicObject>(erpPosCount);
        matchEntryEntityMap.put("orgPartEntryMap", orgPartEntryMap);
        HashMap<String, DynamicObject> orgEntryMap = new HashMap<String, DynamicObject>(erpPosCount);
        matchEntryEntityMap.put("orgEntryMap", orgEntryMap);
        while (erpJobIt.hasNext()) {
            String superiorOpenId;
            DynamicObject erpDpt = (DynamicObject)erpJobIt.next();
            DynamicObject org = erpDpt.getDynamicObject("dpt");
            String orgId = "";
            if (org != null) {
                orgId = org.getString("id");
            }
            String position = erpDpt.getString("position");
            DynamicObject superior = erpDpt.getDynamicObject("superior");
            if (superior != null && StringUtils.isNotBlank((CharSequence)(superiorOpenId = superior.getString("useropenid"))) && yzjSuperiorOpenIds.contains(superiorOpenId)) {
                orgPosSuperiorMap.put(orgId + position, superiorOpenId);
                orgSuperiorMap.put(orgId, superiorOpenId);
                sameSuperiorOpenIds.add(superiorOpenId);
            }
            if (isPartJob = erpDpt.getBoolean("ispartjob")) {
                if (!ignorePartJob) {
                    erpJobIt.remove();
                }
            } else if (!ignoreMainJob) {
                erpJobIt.remove();
            }
            orgPosPartEntryMap.put(this.getOrgPosEntryMapKey(orgId, position, isPartJob), erpDpt);
            orgPosEntryMap.put(this.getOrgPosEntryMapKey(orgId, position, null), erpDpt);
            orgPartEntryMap.put(this.getOrgPosEntryMapKey(orgId, null, isPartJob), erpDpt);
            orgEntryMap.put(orgId, erpDpt);
        }
        HashSet<Object> erpJobPkValues = new HashSet<Object>(dpEntity.size());
        for (DynamicObject erpJobObj : dpEntity) {
            Object pkValue = erpJobObj.getPkValue();
            if (pkValue == null) continue;
            erpJobPkValues.add(pkValue);
        }
        yzjSuperiorOpenIds.removeAll(sameSuperiorOpenIds);
        int seq = 1;
        DynamicObjectType entityType = dpEntity.getDynamicObjectType();
        for (DynamicObject yzjPost : yzjPostCol) {
            isPartJob = yzjPost.getBoolean("ispartjob");
            if (!isPartJob ? ignoreMainJob : ignorePartJob) continue;
            DynamicObject yzjOrg = yzjPost.getDynamicObject("dpt");
            if (yzjOrg == null || StringUtils.isBlank((CharSequence)yzjOrg.getString("fyzjorgid"))) continue;
            String yzjOrgId = yzjOrg.getString("fyzjorgid");
            Long orgId = orgIdMap.get(yzjOrgId);
            if (orgId == null) {
                HashMap<String, String> errorInfo = new HashMap<String, String>();
                errorInfo.put("property", "position");
                errorInfo.put("orgName", yzjOrg.getString("name"));
                errorInfo.put("error", UserMessage.getMessage((String)"M00048"));
                errorOpenIdMsgMap.put(yzjUser.getString("useropenid"), errorInfo);
                return false;
            }
            yzjOrg.set("id", (Object)orgId);
            DynamicObject userEntity = this.getPositionEntry(yzjPost, matchEntryEntityMap, entityType);
            Object pkValue = userEntity.getPkValue();
            if (pkValue != null) {
                if (erpJobPkValues.contains(pkValue)) {
                    userEntity = new DynamicObject(entityType);
                } else {
                    erpJobPkValues.add(pkValue);
                }
            }
            userEntity.set("seq", (Object)seq++);
            userEntity.set("dpt", (Object)orgId);
            userEntity.set("orgstructure", (Object)structureIdMap.get(yzjOrgId));
            String position = yzjPost.getString("position");
            userEntity.set("position", (Object)position);
            userEntity.set("isincharge", yzjPost.get("isincharge"));
            userEntity.set("ispartjob", yzjPost.get("ispartjob"));
            String superiorOpenId = (String)orgPosSuperiorMap.get(orgId + position);
            if (superiorOpenId == null && (superiorOpenId = (String)orgSuperiorMap.get(Long.toString(orgId))) == null && !yzjSuperiorOpenIds.isEmpty()) {
                superiorOpenId = (String)yzjSuperiorOpenIds.remove(0);
            }
            userEntity.set("superior", (Object)superiorIdMap.get(superiorOpenId));
            dpEntity.add((Object)userEntity);
        }
        return true;
    }

    private DynamicObject getPositionEntry(DynamicObject yzjPost, Map<String, Object> matchEntryEntityMap, DynamicObjectType entityType) {
        DynamicObject positionEntry;
        DynamicObject yzjOrg = yzjPost.getDynamicObject("dpt");
        String orgId = yzjOrg.getString("id");
        String position = yzjPost.getString("position");
        Boolean isPartJob = yzjPost.getBoolean("ispartjob");
        Map orgPosPartEntryMap = (Map)matchEntryEntityMap.get("orgPosPartEntryMap");
        DynamicObject dynamicObject = positionEntry = orgPosPartEntryMap == null ? null : (DynamicObject)orgPosPartEntryMap.remove(this.getOrgPosEntryMapKey(orgId, position, isPartJob));
        if (positionEntry != null) {
            return positionEntry;
        }
        Map orgPosEntryMap = (Map)matchEntryEntityMap.get("orgPosEntryMap");
        DynamicObject dynamicObject2 = positionEntry = orgPosEntryMap == null ? null : (DynamicObject)orgPosEntryMap.remove(this.getOrgPosEntryMapKey(orgId, position, null));
        if (positionEntry != null) {
            return positionEntry;
        }
        Map orgPartEntryMap = (Map)matchEntryEntityMap.get("orgPartEntryMap");
        DynamicObject dynamicObject3 = positionEntry = orgPartEntryMap == null ? null : (DynamicObject)orgPartEntryMap.remove(this.getOrgPosEntryMapKey(orgId, null, isPartJob));
        if (positionEntry != null) {
            return positionEntry;
        }
        Map orgEntryMap = (Map)matchEntryEntityMap.get("orgEntryMap");
        DynamicObject dynamicObject4 = positionEntry = orgEntryMap == null ? null : (DynamicObject)orgEntryMap.remove(orgId);
        if (positionEntry != null) {
            return positionEntry;
        }
        return new DynamicObject(entityType);
    }

    private String getOrgPosEntryMapKey(Object orgId, String position, Boolean isPartJob) {
        StringBuilder key = new StringBuilder();
        key.append(orgId);
        String fullNameSep = OrgUnitServiceHelper.getOrgSeparation().getFullNameSep();
        if (position != null) {
            key.append(fullNameSep);
            key.append("?");
            key.append(position);
        }
        if (isPartJob != null) {
            key.append(fullNameSep);
            key.append("?");
            key.append(isPartJob);
        }
        return key.toString();
    }

    private Map<String, Long> getUserOpenIdMap(List<String> openIds) {
        if (openIds.isEmpty()) {
            return new HashMap<String, Long>(0);
        }
        HashMap<String, Long> userOpenIdMap = new HashMap<String, Long>(openIds.size());
        String selectFields = "id,useropenid";
        QFilter openFilter = new QFilter("useropenid", "in", openIds);
        QFilter enable = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter[] filters = new QFilter[]{openFilter, enable};
        Map userObjMap = BusinessDataServiceHelper.loadFromCache((String)"bos_user", (String)selectFields, (QFilter[])filters);
        if (CollectionUtils.isEmpty((Map)userObjMap)) {
            return userOpenIdMap;
        }
        for (DynamicObject user : userObjMap.values()) {
            userOpenIdMap.put(user.getString("useropenid"), user.getLong("id"));
        }
        return userOpenIdMap;
    }

    private void saveNewUserChangeAndHistory(List<String> openIds) {
        String selectFields = "id,number,name,phone";
        QFilter openFilter = new QFilter("useropenid", "in", openIds);
        QFilter[] filters = new QFilter[]{openFilter};
        Map userObjMap = BusinessDataServiceHelper.loadFromCache((String)"bos_user", (String)selectFields, (QFilter[])filters);
        if (CollectionUtils.isEmpty((Map)userObjMap)) {
            return;
        }
        int count = userObjMap.size();
        ArrayList<Map<String, Object>> userChangeList = new ArrayList<Map<String, Object>>(count);
        ArrayList<Long> userIds = new ArrayList<Long>(count);
        for (DynamicObject user : userObjMap.values()) {
            userChangeList.add(this.genUserChange(user, "1"));
            userIds.add(user.getLong("id"));
        }
        this.saveUserChange(userChangeList);
        UserHistoryUtils.saveUserHistory(userIds);
    }

    private void saveUserChange(List<Map<String, Object>> userChangeList) {
        if (Utils.isListEmpty(userChangeList)) {
            return;
        }
        UserServiceHelper userServiceHelper = new UserServiceHelper();
        userServiceHelper.updateUserChange(userChangeList);
    }

    private Map<String, Object> genUserChange(DynamicObject user, String userChangeType) {
        HashMap<String, Object> userChangeMap = new HashMap<String, Object>();
        userChangeMap.put("userID", user.get("id"));
        userChangeMap.put("number", user.get("number"));
        userChangeMap.put("name", user.get("name"));
        userChangeMap.put("phone", user.get("phone"));
        userChangeMap.put("changeTime", new Date());
        userChangeMap.put("changeType", userChangeType);
        return userChangeMap;
    }

    private void saveUserIcon(List<String> updateOpenIds) {
        if (this.yzjConfig.getUserIgnoreProperties().contains("picturefield")) {
            return;
        }
        if (Utils.isListEmpty(updateOpenIds)) {
            return;
        }
        YzjSyncCache.updateTaskProgress(ResManager.loadKDString((String)"\u540c\u6b65\u4eba\u5458\u5934\u50cf\u5230\u6587\u4ef6\u670d\u52a1\u5668\u4e2d\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"UserSyncOperation_5", (String)"bos-org-formplugin", (Object[])new Object[0]));
        QFilter idFilter = new QFilter("useropenid", "in", updateOpenIds);
        QFilter[] filters = new QFilter[]{idFilter};
        DynamicObjectCollection userCount = QueryServiceHelper.query((String)"bos_user", (String)"count(1) user", (QFilter[])filters);
        if (Utils.isListEmpty((List)userCount)) {
            return;
        }
        int total = ((DynamicObject)userCount.get(0)).getInt("user");
        int limit = 1000;
        int totalTimes = total / limit;
        if (total % limit != 0) {
            ++totalTimes;
        }
        int pageIndex = 0;
        String path = UserUtils.getUserImageAbstractFolder();
        String spec_param = "&spec=";
        while (totalTimes > 0) {
            this.saveUserIcon(filters, limit, pageIndex++, path, spec_param);
            --totalTimes;
        }
    }

    private void saveUserIcon(QFilter[] filters, int limit, int pageIndex, String path, String spec_param) {
        String selectFields = "id,headsculpture,picturefield,modifier,modifytime";
        DynamicObject[] userArr = BusinessDataServiceHelper.load((String)"bos_user", (String)selectFields, (QFilter[])filters, null, (int)pageIndex, (int)limit);
        if (userArr == null || userArr.length == 0) {
            return;
        }
        try {
            for (DynamicObject user : userArr) {
                String filename = user.getLong("id") + ".jpg";
                String filePath = path + filename;
                this.deleteUserIcon(filePath);
                String yzjPath = user.getString("picturefield");
                if (StringUtils.isBlank((CharSequence)yzjPath)) continue;
                if (yzjPath.indexOf(spec_param) > 0) {
                    yzjPath = StringUtils.substringBefore((String)yzjPath, (String)spec_param);
                }
                FileService fileService = FileServiceFactory.getAttachmentFileService();
                String result = fileService.upload((FileItem)new PictureFileItem(filename, filePath, yzjPath));
                user.set("headsculpture", (Object)result);
                user.set("modifier", (Object)this.userId);
                user.set("modifytime", (Object)this.exeTime);
            }
        }
        catch (Exception e) {
            log.info("\u4e0a\u4f20\u4eba\u5458\u5934\u50cf\u5931\u8d25\uff1a" + e.getMessage());
        }
        SaveServiceHelper.save((DynamicObject[])userArr);
    }

    private void deleteUserIcon(String filePath) {
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        fileService.delete(filePath);
    }
}

