/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.yunzhijia.diff.impl.user;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.base.utils.msg.BaseMessage;
import kd.bos.base.utils.msg.UserMessage;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.utils.Utils;
import kd.bos.org.utils.YzjDiffUtils;
import kd.bos.org.yunzhijia.diff.impl.YzjSyncReport;
import kd.bos.org.yunzhijia.diff.impl.user.GetErpUserDataImpl;
import kd.bos.org.yunzhijia.diff.impl.user.GetYzjUserDataImpl;
import kd.bos.org.yunzhijia.diff.impl.user.UserSyncBackup;
import kd.bos.org.yunzhijia.diff.impl.user.UserSyncUtils;
import kd.bos.org.yunzhijia.diff.impl.utils.YzjSyncCache;
import kd.bos.org.yunzhijia.model.CompareRule;
import kd.bos.org.yunzhijia.model.DifferenceType;
import kd.bos.org.yunzhijia.model.SyncContextParam;
import kd.bos.org.yunzhijia.model.SyncReport;
import kd.bos.org.yunzhijia.model.SyncReportEntry;
import kd.bos.org.yunzhijia.model.UserCompareRuleSingleton;
import kd.bos.org.yunzhijia.model.UserDeptPos;
import kd.bos.org.yunzhijia.model.UserJobPropertyEnum;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.yzj.interfaces.IYzjUserService;
import kd.bos.yzj.model.YzjConfig;
import kd.bos.yzj.model.user.YzjUserModel;
import kd.bos.yzj.service.YzjServiceFactory;

public class UserSyncReport {
    private static final Log log = LogFactory.getLog(UserSyncReport.class);
    private static final String KEY_ERROR_OPENID_AND_PHONE_SET = "errorOpenIdAndPhoneSet";
    private static final String SPLIT_CHINESE_COMMA = "\uff0c";
    private final long taskId;
    private final YzjConfig yzjConfig;
    protected SyncContextParam contextParam;

    public UserSyncReport(SyncContextParam contextParam) {
        this.contextParam = contextParam;
        this.taskId = contextParam.getTaskId();
        this.yzjConfig = contextParam.getYzjConfig();
    }

    public boolean create() {
        if (Utils.isListEmpty(this.contextParam.getOrgList())) {
            String msg = UserMessage.getMessage((String)"M00046");
            this.createGetDataErrorReport(msg);
            return false;
        }
        return this.createCommon(true);
    }

    public boolean checkOpenId() {
        return this.createCommon(false);
    }

    private boolean createCommon(boolean isCompareAll) {
        YzjSyncCache.updateTaskProgress(ResManager.loadKDString((String)"\u6b63\u5728\u83b7\u53d6\u4e91\u4e4b\u5bb6\u7684\u4eba\u5458\u4fe1\u606f\uff0c\u8bf7\u7a0d\u7b49\u3002", (String)"UserSyncReport_0", (String)"bos-org-formplugin", (Object[])new Object[0]));
        GetYzjUserDataImpl yzj = new GetYzjUserDataImpl(this.contextParam.getYzjConfig());
        Map<String, Object> yzjData = yzj.getBizData();
        if (yzjData == null || yzjData.isEmpty()) {
            String msg = UserMessage.getMessage((String)"M00047");
            this.createGetDataErrorReport(msg);
            return false;
        }
        String msg = YzjDiffUtils.getErrorMessage(yzjData);
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            this.createGetDataErrorReport(msg);
            return false;
        }
        List yzjUserList = (List)yzjData.get("yzj_user");
        if (Utils.isListEmpty((List)yzjUserList)) {
            msg = UserMessage.getMessage((String)"M00047");
            this.createGetDataErrorReport(msg);
            return false;
        }
        List yzjAdminList = (List)yzjData.get("yzj_orgadmin");
        this.contextParam.setAdminList(yzjAdminList);
        List yzjPartJobList = (List)yzjData.get("yzj_userpartjob");
        this.contextParam.setPartJobList(yzjPartJobList);
        YzjSyncCache.updateTaskProgress(ResManager.loadKDString((String)"\u6b63\u5728\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7684\u4eba\u5458\u4fe1\u606f\uff0c\u8bf7\u7a0d\u7b49\u3002", (String)"UserSyncReport_1", (String)"bos-org-formplugin", (Object[])new Object[0]));
        Map<String, Object> erpData = this.getErpData();
        HashSet<String> erpEnableUser = new HashSet<String>();
        this.findYzjCacheUser(yzjData, erpData, erpEnableUser);
        if (!this.initYzjData(yzjData)) {
            return false;
        }
        YzjSyncCache.updateTaskProgress(ResManager.loadKDString((String)"\u6b63\u5728\u5907\u4efd\u4e91\u4e4b\u5bb6\u7684\u4eba\u5458\u4fe1\u606f\uff0c\u8bf7\u7a0d\u7b49\u3002", (String)"UserSyncReport_2", (String)"bos-org-formplugin", (Object[])new Object[0]));
        UserSyncBackup.saveYzjData(this.taskId, yzjData, this.yzjConfig);
        YzjSyncCache.updateTaskProgress(ResManager.loadKDString((String)"\u6b63\u5728\u5907\u4efd\u5f53\u524d\u7cfb\u7edf\u7684\u4eba\u5458\u4fe1\u606f\uff0c\u8bf7\u7a0d\u7b49\u3002", (String)"UserSyncReport_3", (String)"bos-org-formplugin", (Object[])new Object[0]));
        UserSyncBackup.saveErpDataByFilter(this.taskId, "before", null);
        UserSyncBackup.saveErpDataByFilter(this.taskId, "after", null);
        YzjSyncCache.updateTaskProgress(ResManager.loadKDString((String)"\u6b63\u5728\u6267\u884c\u4eba\u5458\u4fe1\u606f\u7684\u5dee\u5f02\u5bf9\u6bd4\uff0c\u8bf7\u7a0d\u7b49\u3002", (String)"UserSyncReport_4", (String)"bos-org-formplugin", (Object[])new Object[0]));
        this.createReport(yzjData, erpData, erpEnableUser, isCompareAll);
        return true;
    }

    private boolean initYzjData(Map<String, Object> yzjData) {
        HashSet<String> errorOpenIdAndPhoneSet;
        List yzjUserList = (List)yzjData.get("yzj_user");
        HashMap<String, String> openIdNameMap = new HashMap<String, String>();
        this.initYzjSuperior(yzjData, yzjUserList, openIdNameMap);
        List<Map<String, Object>> yzjOrgList = this.contextParam.getOrgList();
        HashMap<String, String> departmentMap = new HashMap<String, String>();
        if (Utils.isListNotEmpty(yzjOrgList)) {
            for (Map<String, Object> orgMap : yzjOrgList) {
                departmentMap.put(orgMap.get("id").toString(), orgMap.get("name").toString());
            }
        }
        if ((errorOpenIdAndPhoneSet = (HashSet<String>)yzjData.get(KEY_ERROR_OPENID_AND_PHONE_SET)) == null) {
            errorOpenIdAndPhoneSet = new HashSet<String>(yzjOrgList.size());
        }
        yzjData.put(KEY_ERROR_OPENID_AND_PHONE_SET, errorOpenIdAndPhoneSet);
        Map<String, List<Map<String, Object>>> userAdminMap = this.getYzjOrgAdmin();
        Map<String, List<UserDeptPos>> userPartJobMap = this.getYzjPartJob(userAdminMap);
        ArrayList<Map<String, Object>> superadminNameList = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> discardList = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> duplicatePhoneUserList = new ArrayList<Map<String, Object>>();
        HashMap<String, Map> phoneMap = new HashMap<String, Map>();
        ArrayList<Map<String, Object>> duplicateEmailUserList = new ArrayList<Map<String, Object>>();
        HashMap<String, Map> emailMap = new HashMap<String, Map>();
        Iterator iterator = yzjUserList.iterator();
        while (iterator.hasNext()) {
            Object headSculpture;
            Map yzjUser = (Map)iterator.next();
            Object birthday = yzjUser.get("birthday");
            if (StringUtils.isNotBlank(birthday)) {
                if (birthday instanceof Date) {
                    yzjUser.put("birthday", birthday);
                } else {
                    yzjUser.put("birthday", Utils.strToDate((String)birthday.toString(), (String)"yyyy-MM-dd"));
                }
            }
            if (StringUtils.isNotBlank(headSculpture = yzjUser.get("photoUrl")) && !headSculpture.toString().endsWith("&spec=80")) {
                headSculpture = headSculpture + "&spec=80";
                yzjUser.put("photoUrl", headSculpture);
            }
            String openId = Utils.nullToEmpty(yzjUser.get("openId")).toString();
            String phone = Utils.nullToEmpty(yzjUser.get("phone")).toString();
            String email = Utils.nullToEmpty(yzjUser.get("email")).toString();
            if (StringUtils.isBlank((CharSequence)openId)) {
                if (StringUtils.isNotBlank((CharSequence)phone)) {
                    errorOpenIdAndPhoneSet.add(phone);
                } else if (StringUtils.isNotBlank((CharSequence)email)) {
                    errorOpenIdAndPhoneSet.add(email);
                }
                iterator.remove();
                continue;
            }
            if (StringUtils.isBlank((CharSequence)phone) && StringUtils.isBlank((CharSequence)email)) {
                discardList.add(yzjUser);
                errorOpenIdAndPhoneSet.add(openId);
                continue;
            }
            this.initUserPosition(yzjUser, userAdminMap, userPartJobMap, departmentMap, openIdNameMap);
            if ("administrator".equals(String.valueOf(yzjUser.get("name")))) {
                superadminNameList.add(yzjUser);
                errorOpenIdAndPhoneSet.add(openId);
                errorOpenIdAndPhoneSet.add(phone);
                iterator.remove();
                continue;
            }
            if (StringUtils.isNotBlank((CharSequence)phone)) {
                Map phoneUser = (Map)phoneMap.get(phone);
                if (phoneUser == null) {
                    phoneMap.put(phone, yzjUser);
                } else {
                    if (duplicatePhoneUserList.isEmpty()) {
                        duplicatePhoneUserList.add(phoneUser);
                    }
                    duplicatePhoneUserList.add(yzjUser);
                    phoneMap.put(phone, yzjUser);
                    errorOpenIdAndPhoneSet.add(openId);
                    errorOpenIdAndPhoneSet.add(phone);
                    continue;
                }
            }
            if (!StringUtils.isNotBlank((CharSequence)email)) continue;
            Map emailUser = (Map)emailMap.get(email);
            if (emailUser == null) {
                emailMap.put(email, yzjUser);
                continue;
            }
            if (duplicateEmailUserList.isEmpty()) {
                duplicateEmailUserList.add(emailUser);
            }
            duplicateEmailUserList.add(yzjUser);
            emailMap.put(email, yzjUser);
            errorOpenIdAndPhoneSet.add(openId);
            errorOpenIdAndPhoneSet.add(email);
        }
        if (!superadminNameList.isEmpty()) {
            UserSyncBackup.saveYzjData(this.taskId, superadminNameList, this.yzjConfig);
            this.createSuperadminNameReport(superadminNameList);
        }
        if (!discardList.isEmpty()) {
            UserSyncBackup.saveYzjData(this.taskId, discardList, this.yzjConfig);
            this.createDiscardReport(discardList);
            yzjUserList.removeAll(discardList);
        }
        if (!duplicatePhoneUserList.isEmpty()) {
            UserSyncBackup.saveYzjData(this.taskId, duplicatePhoneUserList, this.yzjConfig);
            this.createDuplicatePhoneReport(duplicatePhoneUserList, true);
            yzjUserList.removeAll(duplicatePhoneUserList);
        }
        if (!duplicateEmailUserList.isEmpty()) {
            UserSyncBackup.saveYzjData(this.taskId, duplicateEmailUserList, this.yzjConfig);
            this.createDuplicateEmailReport(duplicateEmailUserList, true);
            yzjUserList.removeAll(duplicateEmailUserList);
        }
        return true;
    }

    private void initYzjSuperior(Map<String, Object> yzjData, List<Map<String, Object>> yzjUserList, Map<String, String> openIdNameMap) {
        String openId;
        List superiorList = (List)yzjData.get("yzj_superior");
        HashMap<String, ArrayList<String>> superiorMap = new HashMap<String, ArrayList<String>>(superiorList.size());
        for (Map map : superiorList) {
            openId = String.valueOf(map.get("openId"));
            String leaderOpenId = String.valueOf(map.get("leaderOpenId"));
            ArrayList<String> leaderOpenIds = (ArrayList<String>)superiorMap.get(openId);
            if (!superiorMap.containsKey(openId)) {
                leaderOpenIds = new ArrayList<String>();
            }
            leaderOpenIds.add(leaderOpenId);
            superiorMap.put(openId, leaderOpenIds);
        }
        for (Map map : yzjUserList) {
            openId = String.valueOf(map.get("openId"));
            openIdNameMap.put(openId, String.valueOf(map.get("name")));
            ArrayList leaderOpenIds = (ArrayList)superiorMap.get(openId);
            if (leaderOpenIds == null) {
                leaderOpenIds = new ArrayList(0);
            }
            map.put("leaderOpenId", leaderOpenIds);
        }
    }

    private void createGetDataErrorReport(String msg) {
        ArrayList<SyncReport> reportList = new ArrayList<SyncReport>(1);
        String userId = RequestContext.get().getUserId();
        String curTime = Long.toString(Calendar.getInstance().getTimeInMillis());
        SyncReport report = new SyncReport();
        report.setTaskId(this.taskId);
        report.setStatus(3);
        report.setDataType(DifferenceType.USER.getKey());
        report.setModifier(userId);
        report.setModifyTime(curTime);
        List<SyncReportEntry> entryList = report.getEntryList();
        SyncReportEntry reportEntry = new SyncReportEntry();
        reportEntry.setOperation("manual");
        reportEntry.setNote(msg);
        entryList.add(reportEntry);
        reportList.add(report);
        YzjSyncReport.add(reportList);
    }

    private void initUserPosition(Map<String, Object> yzjUser, Map<String, List<Map<String, Object>>> userAdminMap, Map<String, List<UserDeptPos>> userPartJobMap, Map<String, String> departmentMap, Map<String, String> openIdNameMap) {
        List<UserDeptPos> partJobList;
        String yzjOrgName;
        String openId = yzjUser.get("openId").toString();
        ArrayList<UserDeptPos> mainJobList = new ArrayList<UserDeptPos>(1);
        String yzjOrgId = Utils.nullToEmpty((Object)yzjUser.get("orgId")).toString().trim();
        if (StringUtils.isNotBlank((CharSequence)yzjOrgId) && StringUtils.isNotBlank((CharSequence)(yzjOrgName = departmentMap.get(yzjOrgId)))) {
            String orgUserType = Utils.nullToEmpty((Object)yzjUser.get("orgUserType")).toString().trim();
            boolean isInCharge = "1".equals(orgUserType);
            UserDeptPos mainJob = new UserDeptPos(Utils.nullToEmpty((Object)yzjUser.get("name")).toString(), openId, yzjOrgId, isInCharge, false, String.valueOf(yzjUser.get("jobTitle")));
            mainJob.setOrgName(departmentMap.get(yzjOrgId));
            List superiorIds = (List)yzjUser.get("leaderOpenId");
            if (Utils.isListNotEmpty((List)superiorIds)) {
                ArrayList<Map<String, String>> superiorList = new ArrayList<Map<String, String>>(superiorIds.size());
                for (String superiorId : superiorIds) {
                    HashMap<String, String> superiorMap = new HashMap<String, String>();
                    superiorMap.put(superiorId, Utils.nullToEmpty((Object)openIdNameMap.get(superiorId)).toString());
                    superiorList.add(superiorMap);
                }
                mainJob.setSuperiorList(superiorList);
            }
            mainJobList.add(mainJob);
        }
        yzjUser.put(UserJobPropertyEnum.MAIN_JOB.getKey(), mainJobList);
        List<Map<String, Object>> adminList = userAdminMap.get(openId);
        if (adminList == null) {
            adminList = new ArrayList<Map<String, Object>>(0);
        }
        if ((partJobList = userPartJobMap.get(openId)) != null) {
            Iterator<UserDeptPos> iterator = partJobList.iterator();
            block1: while (iterator.hasNext()) {
                UserDeptPos partJob = iterator.next();
                String partJobOrg = partJob.getYzjOrgId();
                if (StringUtils.isBlank((CharSequence)partJobOrg)) {
                    iterator.remove();
                    continue;
                }
                String orgName = departmentMap.get(partJobOrg);
                if (StringUtils.isBlank((CharSequence)orgName)) {
                    iterator.remove();
                    continue;
                }
                partJob.setOrgName(orgName);
                for (Map<String, Object> adminMap : adminList) {
                    if (!partJobOrg.equals(String.valueOf(adminMap.get("departmentId")))) continue;
                    partJob.setInCharge(true);
                    continue block1;
                }
            }
            yzjUser.put(UserJobPropertyEnum.PART_JOB.getKey(), partJobList);
        }
    }

    private Map<String, List<Map<String, Object>>> getYzjOrgAdmin() {
        List<Map<String, Object>> yzjAdminList = this.contextParam.getAdminList();
        HashMap<String, List<Map<String, Object>>> userAdminMap = new HashMap<String, List<Map<String, Object>>>();
        if (Utils.isListNotEmpty(yzjAdminList)) {
            for (Map<String, Object> yzjAdmin : yzjAdminList) {
                Object openIdObj = yzjAdmin.get("openId");
                if (StringUtils.isBlank((Object)openIdObj)) continue;
                String openId = openIdObj.toString();
                ArrayList<Map<String, Object>> adminList = (ArrayList<Map<String, Object>>)userAdminMap.get(openId);
                if (adminList == null) {
                    adminList = new ArrayList<Map<String, Object>>(1);
                }
                adminList.add(yzjAdmin);
                userAdminMap.put(openId, adminList);
            }
        }
        return userAdminMap;
    }

    private Map<String, List<UserDeptPos>> getYzjPartJob(Map<String, List<Map<String, Object>>> userAdminMap) {
        List<Map<String, Object>> yzjPartJobList = this.contextParam.getPartJobList();
        HashMap<String, List<UserDeptPos>> userPartJobMap = new HashMap<String, List<UserDeptPos>>();
        if (Utils.isListNotEmpty(yzjPartJobList)) {
            for (Map<String, Object> partJob : yzjPartJobList) {
                List<Map<String, Object>> adminList;
                Object openIdObj = partJob.get("openId");
                if (StringUtils.isBlank((Object)openIdObj) || StringUtils.isBlank((Object)partJob.get("orgId"))) continue;
                String openId = openIdObj.toString();
                ArrayList<UserDeptPos> partJobList = (ArrayList<UserDeptPos>)userPartJobMap.get(openId);
                if (partJobList == null) {
                    partJobList = new ArrayList<UserDeptPos>(1);
                }
                UserDeptPos pos = new UserDeptPos();
                pos.setPartJob(true);
                String yzjOrgId = String.valueOf(partJob.get("orgId"));
                pos.setYzjOrgId(yzjOrgId);
                pos.setJobTitle(String.valueOf(partJob.get("jobTitle")));
                pos.setOpenId(openId);
                boolean isInCharge = false;
                if (StringUtils.isNotBlank((CharSequence)yzjOrgId) && (adminList = userAdminMap.get(openId)) != null) {
                    for (Map<String, Object> adminMap : adminList) {
                        if (!yzjOrgId.equals(Utils.nullToEmpty((Object)adminMap.get("departmentId").toString()))) continue;
                        isInCharge = true;
                        break;
                    }
                }
                pos.setInCharge(isInCharge);
                partJobList.add(pos);
                userPartJobMap.put(openId, partJobList);
            }
        }
        return userPartJobMap;
    }

    private Map<String, Object> getErpData() {
        GetErpUserDataImpl erp = new GetErpUserDataImpl();
        Map<String, Object> erpData = erp.getBizData();
        List erpUserList = (List)erpData.get("erp_user");
        if (Utils.isListNotEmpty((List)erpUserList)) {
            Map erpUserDeptMap = (Map)erpData.get("erp_user_org");
            Map mainJobMap = (Map)erpUserDeptMap.get(UserJobPropertyEnum.MAIN_JOB.getKey());
            Map partJobMap = (Map)erpUserDeptMap.get(UserJobPropertyEnum.PART_JOB.getKey());
            for (Map userMap : erpUserList) {
                String openId = String.valueOf(userMap.get("openId"));
                userMap.put(UserJobPropertyEnum.MAIN_JOB.getKey(), mainJobMap.get(openId));
                userMap.put(UserJobPropertyEnum.PART_JOB.getKey(), partJobMap.get(openId));
            }
        }
        return erpData;
    }

    private void createReport(Map<String, Object> yzjData, Map<String, Object> erpData, Set<String> erpEnableUser, boolean isCompareAll) {
        log.debug("\u5f00\u59cb\u751f\u6210\u91d1\u8776\u4e91\u548c\u4e91\u4e4b\u5bb6\u7684\u4fe1\u606f\u5dee\u5f02\u62a5\u544a");
        List yzjList = (List)yzjData.get("yzj_user");
        if (Utils.isListEmpty((List)yzjList)) {
            String msg = UserMessage.getMessage((String)"M00047");
            this.createGetDataErrorReport(msg);
            return;
        }
        List erpList = (List)erpData.get("erp_user");
        List<CompareRule> crUsers = UserCompareRuleSingleton.getInstance().getRules();
        HashMap<String, SyncReport> proReportMap = new HashMap<String, SyncReport>();
        Set errorOpenIdAndPhoneSet = (Set)yzjData.get(KEY_ERROR_OPENID_AND_PHONE_SET);
        ArrayList<Map<String, Object>> errorNameList = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> disableList = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> enableList = new ArrayList<Map<String, Object>>();
        ArrayList<String> updateNumberList = new ArrayList<String>();
        HashMap<String, Map<String, Object>> openIdErpMap = new HashMap<String, Map<String, Object>>(erpList.size());
        HashMap<String, Map<String, Object>> phoneErpMap = new HashMap<String, Map<String, Object>>(erpList.size());
        HashMap<String, Map<String, Object>> emailErpMap = new HashMap<String, Map<String, Object>>(erpList.size());
        Iterator erpIter = erpList.iterator();
        while (erpIter.hasNext()) {
            Map erpUser = (Map)erpIter.next();
            if (this.isSuperAdmin(erpUser)) {
                erpIter.remove();
                continue;
            }
            if (this.isErrorUser(erpUser, errorOpenIdAndPhoneSet)) {
                erpIter.remove();
                continue;
            }
            if (!this.isEnable(erpUser)) continue;
            Object erpOpenId = erpUser.get("useropenid");
            Object erpPhone = erpUser.get("phone");
            Object erpEmail = erpUser.get("email");
            if (null != erpOpenId && !StringUtils.isBlank((CharSequence)String.valueOf(erpOpenId))) {
                openIdErpMap.put(String.valueOf(erpOpenId), erpUser);
            }
            if (null != erpPhone && !StringUtils.isBlank((CharSequence)String.valueOf(erpPhone))) {
                phoneErpMap.put(String.valueOf(erpPhone), erpUser);
            }
            if (null == erpEmail || StringUtils.isBlank((CharSequence)String.valueOf(erpEmail))) continue;
            emailErpMap.put(String.valueOf(erpEmail), erpUser);
        }
        String eid = this.yzjConfig.getEid();
        Iterator yzjIter = yzjList.iterator();
        while (yzjIter.hasNext()) {
            Map yzjUser = (Map)yzjIter.next();
            Object name = yzjUser.get("name");
            if (StringUtils.isBlank(name)) {
                errorNameList.add(yzjUser);
                yzjIter.remove();
                continue;
            }
            if ("null".equals(name.toString().toLowerCase().replaceAll("\"", ""))) {
                errorNameList.add(yzjUser);
                yzjIter.remove();
                continue;
            }
            yzjUser.put("eid", eid);
            yzjUser.put("tid", eid);
            String openId = Utils.nullToEmpty(yzjUser.get("openId")).toString();
            if (this.isErrorUser(yzjUser, errorOpenIdAndPhoneSet)) {
                yzjIter.remove();
                continue;
            }
            Map<String, Object> erpUser = this.matchErpUser(yzjUser, openIdErpMap, phoneErpMap, emailErpMap);
            if (CollectionUtils.isEmpty(erpUser)) continue;
            if (isCompareAll) {
                this.isStatusDiff(yzjUser, erpUser, disableList, enableList);
                for (CompareRule cr : crUsers) {
                    if (!"eid".equals(cr.getDestFld()) ? (!"tid".equals(cr.getDestFld()) ? (!"number".equals(cr.getDestFld()) ? !this.isUserDiff(yzjUser, erpUser, cr) : !this.isJobNoDiff(yzjUser, erpUser, updateNumberList)) : eid == null || eid.equals(String.valueOf(erpUser.get("tid")).trim())) : eid == null || eid.equals(String.valueOf(erpUser.get("eid")).trim())) continue;
                    SyncReport report = (SyncReport)proReportMap.get(openId);
                    if (report == null) {
                        report = this.genDiffProReport(yzjUser, erpUser);
                    }
                    this.addDiffProSyncReportEntry(report, yzjUser, erpUser, cr);
                    proReportMap.put(openId, report);
                }
                this.createUserPositionReport(yzjUser, erpUser, proReportMap);
            } else {
                for (CompareRule cr : crUsers) {
                    String erpField = cr.getDestFld();
                    if (!"eid".equals(erpField) && !"useropenid".equals(erpField) && !"fuid".equals(erpField) || !this.isUserDiff(yzjUser, erpUser, cr)) continue;
                    SyncReport report = (SyncReport)proReportMap.get(openId);
                    if (report == null) {
                        report = this.genDiffProReport(yzjUser, erpUser);
                    }
                    this.addDiffProSyncReportEntry(report, yzjUser, erpUser, cr);
                    proReportMap.put(openId, report);
                }
            }
            yzjIter.remove();
            erpList.remove(erpUser);
        }
        if (isCompareAll) {
            this.createInvalidNameReport(errorNameList);
            this.saveAddNewReport(yzjList, errorOpenIdAndPhoneSet);
            disableList.addAll(erpList);
            this.filterEnableErpPhoneAndEmail(disableList, enableList, erpEnableUser);
            this.saveDisableReport(disableList, errorOpenIdAndPhoneSet);
            this.saveEnableReport(enableList, errorOpenIdAndPhoneSet);
        }
        this.saveDiffProReport(proReportMap);
    }

    private Map<String, Object> matchErpUser(Map<String, Object> dtYzj, Map<String, Map<String, Object>> openIdErpMap, Map<String, Map<String, Object>> phoneErpMap, Map<String, Map<String, Object>> emailErpMap) {
        String yzjOpenId = String.valueOf(dtYzj.get("openId"));
        Map<String, Object> dtErp = openIdErpMap.get(yzjOpenId);
        if (!CollectionUtils.isEmpty(dtErp)) {
            return dtErp;
        }
        Object yzjPhone = dtYzj.get("phone");
        if (null != yzjPhone && StringUtils.isNotBlank((CharSequence)String.valueOf(yzjPhone)) && !CollectionUtils.isEmpty(dtErp = phoneErpMap.get(String.valueOf(yzjPhone)))) {
            return dtErp;
        }
        Object yzjEmail = dtYzj.get("email");
        if (null != yzjEmail && StringUtils.isNotBlank((CharSequence)String.valueOf(yzjEmail)) && !CollectionUtils.isEmpty(dtErp = emailErpMap.get(String.valueOf(yzjEmail)))) {
            return dtErp;
        }
        return new HashMap<String, Object>(0);
    }

    private void filterEnableErpPhoneAndEmail(List<Map<String, Object>> disableList, List<Map<String, Object>> enableList, Set<String> erpEnableUserIncludePhoneAndEmail) {
        String email;
        String phone;
        if (CollectionUtils.isEmpty(erpEnableUserIncludePhoneAndEmail)) {
            return;
        }
        for (Map<String, Object> disableObj : disableList) {
            phone = String.valueOf(disableObj.get("phone"));
            email = String.valueOf(disableObj.get("email"));
            if (StringUtils.isNotBlank((CharSequence)phone)) {
                erpEnableUserIncludePhoneAndEmail.remove(phone);
            }
            if (!StringUtils.isNotBlank((CharSequence)email)) continue;
            erpEnableUserIncludePhoneAndEmail.remove(email);
        }
        Iterator<Map<String, Object>> iterator = enableList.iterator();
        while (iterator.hasNext()) {
            Map<String, Object> enableObj = iterator.next();
            phone = String.valueOf(enableObj.get("phone"));
            email = String.valueOf(enableObj.get("email"));
            if (StringUtils.isNotBlank((CharSequence)phone) && erpEnableUserIncludePhoneAndEmail.contains(phone)) {
                iterator.remove();
            }
            if (!StringUtils.isNotBlank((CharSequence)email) || !erpEnableUserIncludePhoneAndEmail.contains(email)) continue;
            iterator.remove();
        }
    }

    private void findYzjCacheUser(Map<String, Object> yzjData, Map<String, Object> erpData, Set<String> erpEnableUser) {
        List yzjList = (List)yzjData.get("yzj_user");
        List erpList = (List)erpData.get("erp_user");
        if (Utils.isListEmpty((List)erpList)) {
            return;
        }
        int erpUserCount = erpList.size();
        HashSet<String> errorOpenIdAndPhoneSet = (HashSet<String>)yzjData.get(KEY_ERROR_OPENID_AND_PHONE_SET);
        if (errorOpenIdAndPhoneSet == null) {
            errorOpenIdAndPhoneSet = new HashSet<String>(erpUserCount);
        }
        yzjData.put(KEY_ERROR_OPENID_AND_PHONE_SET, errorOpenIdAndPhoneSet);
        ArrayList<YzjUserModel> notInYzjList = new ArrayList<YzjUserModel>(erpUserCount);
        ArrayList<Map<String, Object>> duplicatePhoneUserList = new ArrayList<Map<String, Object>>(erpUserCount);
        HashMap<String, Map<String, Object>> phoneMap = new HashMap<String, Map<String, Object>>(erpUserCount);
        ArrayList<Map<String, Object>> duplicateEmailUserList = new ArrayList<Map<String, Object>>(erpUserCount);
        HashMap<String, Map> emailMap = new HashMap<String, Map>(erpUserCount);
        HashSet<String> existsUserSet = new HashSet<String>(yzjList.size() * 2);
        HashSet<String> erpEnableUserSet = new HashSet<String>(erpUserCount * 2);
        for (Map yzjUser2 : yzjList) {
            String openId;
            String phone = String.valueOf(yzjUser2.get("phone"));
            if (StringUtils.isNotBlank((CharSequence)phone)) {
                existsUserSet.add(phone);
            }
            if (!StringUtils.isNotBlank((CharSequence)(openId = String.valueOf(yzjUser2.get("openId"))))) continue;
            existsUserSet.add(openId);
        }
        for (Map erpUser : erpList) {
            String openId = String.valueOf(erpUser.get("useropenid"));
            String phone = "";
            Object phoneObj = erpUser.get("phone");
            if (StringUtils.isNotBlank(phoneObj)) {
                phone = phoneObj.toString();
            }
            Object emailObj = erpUser.get("email");
            boolean enableUser = this.isEnable(erpUser);
            if (enableUser) {
                if (StringUtils.isNotBlank((CharSequence)phone)) {
                    erpEnableUserSet.add(phone);
                }
                if (!StringUtils.isNotBlank(emailMap)) continue;
                erpEnableUserSet.add(emailObj.toString());
                continue;
            }
            if (StringUtils.isNotBlank(emailObj)) {
                String email = emailObj.toString();
                Map emailUser = (Map)emailMap.get(email);
                if (emailUser == null) {
                    emailMap.put(email, erpUser);
                } else {
                    if (duplicateEmailUserList.isEmpty()) {
                        duplicateEmailUserList.add(emailUser);
                    }
                    duplicateEmailUserList.add(erpUser);
                    errorOpenIdAndPhoneSet.add(email);
                    emailMap.put(email, erpUser);
                    if (!StringUtils.isNotBlank((CharSequence)openId) || existsUserSet.contains(openId)) continue;
                    errorOpenIdAndPhoneSet.add(openId);
                    continue;
                }
            }
            if (StringUtils.isBlank((CharSequence)phone)) continue;
            Map phoneUser = (Map)phoneMap.get(phone);
            if (phoneUser != null) {
                if (duplicatePhoneUserList.isEmpty()) {
                    duplicatePhoneUserList.add(phoneUser);
                }
                duplicatePhoneUserList.add(erpUser);
                phoneMap.put(phone, erpUser);
                errorOpenIdAndPhoneSet.add(phone);
                if (!StringUtils.isNotBlank((CharSequence)openId) || existsUserSet.contains(openId)) continue;
                errorOpenIdAndPhoneSet.add(openId);
                continue;
            }
            phoneMap.put(phone, erpUser);
            if (existsUserSet.contains(phone) || existsUserSet.contains(openId)) continue;
            YzjUserModel userModel = new YzjUserModel();
            userModel.setPhone(phone);
            notInYzjList.add(userModel);
            if (notInYzjList.size() <= 1000) continue;
            IYzjUserService userService = YzjServiceFactory.getUserService();
            List<Map<String, Object>> yzjNewUserList = userService.getUsers(0, notInYzjList);
            if (Utils.isListNotEmpty(yzjNewUserList = this.filterYzjNewUser(yzjNewUserList, phoneMap))) {
                yzjList.addAll(yzjNewUserList);
            }
            notInYzjList.clear();
        }
        if (!notInYzjList.isEmpty()) {
            IYzjUserService userService = YzjServiceFactory.getUserService();
            List<Map<String, Object>> yzjNewUserList = userService.getUsers(0, notInYzjList);
            if (Utils.isListNotEmpty(yzjNewUserList = this.filterYzjNewUser(yzjNewUserList, phoneMap))) {
                yzjNewUserList.removeIf(yzjUser -> existsUserSet.contains(String.valueOf(yzjUser.get("phone"))) || existsUserSet.contains(String.valueOf(yzjUser.get("openId"))));
                yzjList.addAll(yzjNewUserList);
            }
        }
        Iterator errOpenIdAndPhone = errorOpenIdAndPhoneSet.iterator();
        while (errOpenIdAndPhone.hasNext()) {
            String err = (String)errOpenIdAndPhone.next();
            if (!erpEnableUserSet.contains(err)) continue;
            errOpenIdAndPhone.remove();
        }
        yzjData.put(KEY_ERROR_OPENID_AND_PHONE_SET, errorOpenIdAndPhoneSet);
        if (!duplicatePhoneUserList.isEmpty()) {
            this.createDuplicatePhoneReport(duplicatePhoneUserList, false);
        }
        if (!duplicateEmailUserList.isEmpty()) {
            this.createDuplicateEmailReport(duplicateEmailUserList, false);
        }
        erpEnableUser.addAll(erpEnableUserSet);
    }

    private List<Map<String, Object>> filterYzjNewUser(List<Map<String, Object>> yzjNewUserList, Map<String, Map<String, Object>> phoneMap) {
        if (Utils.isListEmpty(yzjNewUserList)) {
            return yzjNewUserList;
        }
        ArrayList<Map<String, Object>> removeList = new ArrayList<Map<String, Object>>(yzjNewUserList.size());
        for (Map<String, Object> userMap : yzjNewUserList) {
            if (userMap.get("status") == null || userMap.get("phone") == null) continue;
            String userStatus = (String)userMap.get("status");
            String userPhone = (String)userMap.get("phone");
            if (userStatus.equals("1") || this.isEnable(phoneMap.get(userPhone))) continue;
            removeList.add(userMap);
        }
        if (Utils.isListNotEmpty(removeList)) {
            yzjNewUserList.removeAll(removeList);
        }
        return yzjNewUserList;
    }

    private void createInvalidNameReport(List<Map<String, Object>> yzjDataList) {
        if (Utils.isListEmpty(yzjDataList)) {
            return;
        }
        ArrayList<SyncReport> reportList = new ArrayList<SyncReport>(yzjDataList.size());
        String userId = RequestContext.get().getUserId();
        String curTime = Long.toString(Calendar.getInstance().getTimeInMillis());
        for (Map<String, Object> yzjMap : yzjDataList) {
            SyncReport report = new SyncReport();
            String userName = String.valueOf(yzjMap.get("name"));
            report.setTaskId(this.taskId);
            report.setStatus(3);
            report.setDataType(DifferenceType.USER.getKey());
            report.setSyncObject(userName);
            report.setYzjDataId(String.valueOf(yzjMap.get("openId")));
            report.setModifier(userId);
            report.setModifyTime(curTime);
            List<SyncReportEntry> entryList = report.getEntryList();
            SyncReportEntry reportEntry = new SyncReportEntry();
            reportEntry.setOperation("manual");
            reportEntry.setProperty("name");
            reportEntry.setYzjValue(userName);
            reportEntry.setNote(BaseMessage.getMessage((String)"M00004"));
            entryList.add(reportEntry);
            reportList.add(report);
        }
        YzjSyncReport.add(reportList);
    }

    private boolean isSuperAdmin(Map<String, Object> erpUser) {
        Object id = erpUser.get("id");
        Object name = erpUser.get("name");
        if (StringUtils.isBlank((Object)id) || StringUtils.isBlank((Object)name)) {
            return false;
        }
        long userId = Long.parseLong(id.toString());
        return 1L == userId && "administrator".equals(name.toString());
    }

    private boolean isEnable(Map<String, Object> dataMap) {
        if (dataMap == null) {
            return false;
        }
        Object enableState = dataMap.get("enable");
        return StringUtils.isNotBlank((Object)enableState) && ("1".equals(enableState.toString()) || Boolean.toString(true).equalsIgnoreCase(enableState.toString()));
    }

    private boolean isJobNoDiff(Map<String, Object> yzjUser, Map<String, Object> erpUser, List<String> updateNumberList) {
        boolean isDiff = false;
        Object yzjObj = yzjUser.get("jobNo");
        Object erpObj = erpUser.get("number");
        if (StringUtils.isBlank((Object)yzjObj)) {
            if (StringUtils.isBlank((Object)erpObj)) {
                yzjUser.put("jobNo", 0);
                erpUser.put("number", 0);
                updateNumberList.add(String.valueOf(yzjUser.get("openId")));
            }
        } else if (!yzjObj.toString().trim().equals(Utils.nullToEmpty((Object)erpObj).toString().trim())) {
            isDiff = true;
        }
        return isDiff;
    }

    private boolean isUserDiff(Map<String, Object> yzjUser, Map<String, Object> erpUser, CompareRule cr) {
        boolean isDiff = false;
        Object yzjObj = yzjUser.get(cr.getSrcFld());
        if (yzjObj == null) {
            return isDiff;
        }
        String field = cr.getSrcFld();
        Object erpObj = erpUser.get(cr.getDestFld());
        if ("birthday".equalsIgnoreCase(field)) {
            Date yzjBirthday = null;
            if (StringUtils.isNotBlank((Object)yzjObj) && yzjObj instanceof Date) {
                yzjBirthday = (Date)yzjObj;
            }
            Date erpBirthday = null;
            if (StringUtils.isNotBlank((Object)erpObj)) {
                erpBirthday = erpObj instanceof Date ? (Date)erpObj : Utils.strToDate((String)erpObj.toString(), (String)"yyyy-MM-dd");
            }
            if (yzjBirthday == null && erpBirthday == null) {
                return isDiff;
            }
            if (yzjBirthday != null && erpBirthday == null) {
                isDiff = true;
            } else if (yzjBirthday == null && erpBirthday != null) {
                isDiff = true;
            } else if (yzjBirthday.compareTo(erpBirthday) != 0) {
                isDiff = true;
            }
        } else if ("email".equals(field)) {
            if (StringUtils.isNotBlank((Object)yzjObj) && !yzjObj.toString().trim().equals(Utils.nullToEmpty((Object)erpObj).toString().trim())) {
                isDiff = true;
            }
        } else if ("gender".equals(field)) {
            String erpGender;
            String yzjGender = yzjObj.toString().trim();
            if (!yzjGender.equals(erpGender = Utils.nullToEmpty((Object)erpObj).toString().trim())) {
                if ("0".equals(yzjGender) && StringUtils.isBlank((CharSequence)erpGender)) {
                    return isDiff;
                }
                isDiff = true;
            }
        } else if (!yzjObj.toString().trim().equals(Utils.nullToEmpty((Object)erpObj).toString().trim())) {
            isDiff = true;
        }
        return isDiff;
    }

    private boolean isStatusDiff(Map<String, Object> yzjUser, Map<String, Object> erpUser, List<Map<String, Object>> disableList, List<Map<String, Object>> enableList) {
        boolean isDiff = false;
        Object yzjObj = yzjUser.get("status");
        if (StringUtils.isBlank((Object)yzjObj)) {
            return isDiff;
        }
        Object erpObj = erpUser.get("enable");
        if ("1".equals(yzjObj)) {
            if (!yzjObj.equals(erpObj)) {
                HashMap<String, Object> curDataMap = new HashMap<String, Object>(erpUser);
                curDataMap.put("openId", yzjUser.get("openId"));
                enableList.add(curDataMap);
                isDiff = true;
            }
        } else if (!"0".equals(erpObj)) {
            HashMap<String, Object> curDataMap = new HashMap<String, Object>(erpUser);
            disableList.add(curDataMap);
            isDiff = true;
        }
        return isDiff;
    }

    private void createUserPositionReport(Map<String, Object> yzjUser, Map<String, Object> erpUser, Map<String, SyncReport> proReportMap) {
        List erpPartJobList;
        List yzjPartJobList;
        List erpMainJobList;
        ArrayList<UserDeptPos> yzjJobList = new ArrayList<UserDeptPos>();
        ArrayList<UserDeptPos> erpJobList = new ArrayList<UserDeptPos>();
        List yzjMainJobList = (List)yzjUser.get(UserJobPropertyEnum.MAIN_JOB.getKey());
        if (!CollectionUtils.isEmpty((Collection)yzjMainJobList)) {
            yzjJobList.addAll(yzjMainJobList);
        }
        if (!CollectionUtils.isEmpty((Collection)(erpMainJobList = (List)erpUser.get(UserJobPropertyEnum.MAIN_JOB.getKey())))) {
            erpJobList.addAll(erpMainJobList);
        }
        if (!CollectionUtils.isEmpty((Collection)(yzjPartJobList = (List)yzjUser.get(UserJobPropertyEnum.PART_JOB.getKey())))) {
            yzjJobList.addAll(yzjPartJobList);
        }
        if (!CollectionUtils.isEmpty((Collection)(erpPartJobList = (List)erpUser.get(UserJobPropertyEnum.PART_JOB.getKey())))) {
            erpJobList.addAll(erpPartJobList);
        }
        this.compareSameJob(yzjUser, erpUser, yzjJobList, erpJobList, proReportMap);
        this.compareSameJobOrg(yzjUser, erpUser, yzjJobList, erpJobList, proReportMap);
        this.compareSameJobTitle(yzjUser, erpUser, yzjJobList, erpJobList, proReportMap);
        this.compareNotExistsJob(yzjUser, erpUser, yzjJobList, erpJobList, proReportMap);
    }

    private void compareSameJob(Map<String, Object> yzjUser, Map<String, Object> erpUser, List<UserDeptPos> yzjJobList, List<UserDeptPos> erpJobList, Map<String, SyncReport> proReportMap) {
        Iterator<UserDeptPos> yzjIter = yzjJobList.iterator();
        while (yzjIter.hasNext()) {
            UserDeptPos yzjUdp = yzjIter.next();
            if (!yzjUdp.isPartJob()) {
                this.compareSuperior(yzjUser, erpUser, erpJobList, yzjUdp.getSuperiorList(), proReportMap);
            }
            String yzjOrgId = Utils.nullToEmpty((Object)yzjUdp.getYzjOrgId()).toString().trim();
            String yzjPosition = Utils.nullToEmpty((Object)yzjUdp.getJobTitle()).toString().trim();
            boolean isSame = false;
            Iterator<UserDeptPos> erpIter = erpJobList.iterator();
            while (erpIter.hasNext()) {
                UserDeptPos erpUdp = erpIter.next();
                if (!yzjOrgId.equals(Utils.nullToEmpty((Object)erpUdp.getYzjOrgId()).toString().trim()) || !yzjPosition.equals(Utils.nullToEmpty((Object)erpUdp.getJobTitle()).toString().trim())) continue;
                isSame = true;
                erpIter.remove();
                this.addPartJobReport(yzjUser, erpUser, yzjUdp, erpUdp, proReportMap);
                this.addChargeReport(yzjUser, erpUser, yzjUdp, erpUdp, proReportMap);
                break;
            }
            if (!isSame) continue;
            yzjIter.remove();
        }
    }

    private void compareSuperior(Map<String, Object> yzjUser, Map<String, Object> erpUser, List<UserDeptPos> erpJobList, List<Map<String, String>> yzjSuperiorList, Map<String, SyncReport> proReportMap) {
        if (erpJobList.isEmpty()) {
            return;
        }
        int jobCount = erpJobList.size();
        ArrayList<String> erpSuperiorOpenIds = new ArrayList<String>(jobCount);
        StringBuilder erpSuperiorNames = new StringBuilder();
        for (UserDeptPos dpt : erpJobList) {
            this.genSuperiorCompareInfo(dpt.getSuperiorList(), erpSuperiorOpenIds, erpSuperiorNames);
        }
        ArrayList<String> yzjSuperiorOpenIds = new ArrayList<String>(jobCount);
        StringBuilder yzjSuperiorNames = new StringBuilder();
        this.genSuperiorCompareInfo(yzjSuperiorList, yzjSuperiorOpenIds, yzjSuperiorNames);
        int erpSuperiorCount = erpSuperiorOpenIds.size();
        int yzjSuperiorCount = yzjSuperiorOpenIds.size();
        boolean isSuperiorDifference = false;
        if (erpSuperiorCount == 0) {
            if (yzjSuperiorCount > 0) {
                isSuperiorDifference = true;
            }
        } else {
            erpSuperiorOpenIds.removeAll(yzjSuperiorOpenIds);
            int erpSuperiorDiffCount = erpSuperiorOpenIds.size();
            if (erpSuperiorDiffCount > 0 || yzjSuperiorCount > erpSuperiorCount && jobCount > erpSuperiorCount) {
                isSuperiorDifference = true;
            }
        }
        if (isSuperiorDifference) {
            String yzjValue = StringUtils.substringBeforeLast((String)yzjSuperiorNames.toString(), (String)SPLIT_CHINESE_COMMA);
            String erpValue = StringUtils.substringBeforeLast((String)erpSuperiorNames.toString(), (String)SPLIT_CHINESE_COMMA);
            this.addSuperiorReport(yzjUser, erpUser, yzjValue, erpValue, proReportMap);
        }
    }

    private void genSuperiorCompareInfo(List<Map<String, String>> superiorList, List<String> superiorOpenIds, StringBuilder superiorNames) {
        if (CollectionUtils.isEmpty(superiorList)) {
            return;
        }
        for (Map<String, String> superiorMap : superiorList) {
            for (Map.Entry<String, String> yzjEntry : superiorMap.entrySet()) {
                String openId = yzjEntry.getKey();
                String name = yzjEntry.getValue();
                if (!StringUtils.isNotBlank((CharSequence)openId) || !StringUtils.isNotBlank((CharSequence)name)) continue;
                superiorOpenIds.add(openId);
                superiorNames.append(name);
                superiorNames.append(SPLIT_CHINESE_COMMA);
            }
        }
    }

    private void compareSameJobOrg(Map<String, Object> yzjUser, Map<String, Object> erpUser, List<UserDeptPos> yzjJobList, List<UserDeptPos> erpJobList, Map<String, SyncReport> proReportMap) {
        Iterator<UserDeptPos> yzjIter = yzjJobList.iterator();
        block0: while (yzjIter.hasNext()) {
            UserDeptPos yzjUdp = yzjIter.next();
            String yzjOrgId = Utils.nullToEmpty((Object)yzjUdp.getYzjOrgId()).toString().trim();
            String yzjPosition = Utils.nullToEmpty((Object)yzjUdp.getJobTitle()).toString().trim();
            Iterator<UserDeptPos> erpIter = erpJobList.iterator();
            while (erpIter.hasNext()) {
                UserDeptPos erpUdp = erpIter.next();
                if (!yzjOrgId.equals(Utils.nullToEmpty((Object)erpUdp.getYzjOrgId()).toString().trim())) continue;
                if (!yzjPosition.equals(Utils.nullToEmpty((Object)erpUdp.getJobTitle()).toString().trim())) {
                    yzjUdp.setOperation("edit");
                    yzjUdp.setNote(ResManager.loadKDString((String)"\u53d8\u66f4\u804c\u4f4d\u3002", (String)"UserSyncReport_5", (String)"bos-org-formplugin", (Object[])new Object[0]));
                    if (yzjUdp.isPartJob()) {
                        yzjUdp.setProperty(UserJobPropertyEnum.PART_POSITION.getKey());
                    } else {
                        yzjUdp.setProperty(UserJobPropertyEnum.MAIN_POSITION.getKey());
                    }
                    this.addJobChangeReportEntry(yzjUser, erpUser, proReportMap, yzjUdp, erpUdp);
                }
                this.addChargeReport(yzjUser, erpUser, yzjUdp, erpUdp, proReportMap);
                yzjIter.remove();
                erpIter.remove();
                continue block0;
            }
        }
    }

    private void compareSameJobTitle(Map<String, Object> yzjUser, Map<String, Object> erpUser, List<UserDeptPos> yzjJobList, List<UserDeptPos> erpJobList, Map<String, SyncReport> proReportMap) {
        Iterator<UserDeptPos> yzjIter = yzjJobList.iterator();
        block0: while (yzjIter.hasNext()) {
            UserDeptPos yzjUdp = yzjIter.next();
            String yzjOrgId = Utils.nullToEmpty((Object)yzjUdp.getYzjOrgId()).toString().trim();
            String yzjPosition = Utils.nullToEmpty((Object)yzjUdp.getJobTitle()).toString().trim();
            Iterator<UserDeptPos> erpIter = erpJobList.iterator();
            while (erpIter.hasNext()) {
                boolean isSame = true;
                UserDeptPos erpUdp = erpIter.next();
                if (StringUtils.isNotBlank((CharSequence)yzjPosition) && !yzjPosition.equals(Utils.nullToEmpty((Object)erpUdp.getJobTitle()).toString().trim())) {
                    isSame = false;
                }
                if (!isSame) continue;
                if (!yzjOrgId.equals(Utils.nullToEmpty((Object)erpUdp.getYzjOrgId()).toString().trim())) {
                    yzjUdp.setOperation("edit");
                    yzjUdp.setNote(ResManager.loadKDString((String)"\u53d8\u66f4\u4efb\u804c\u90e8\u95e8\u3002", (String)"UserSyncReport_6", (String)"bos-org-formplugin", (Object[])new Object[0]));
                    if (yzjUdp.isPartJob()) {
                        yzjUdp.setProperty(UserJobPropertyEnum.PART_ORG.getKey());
                    } else {
                        yzjUdp.setProperty(UserJobPropertyEnum.MAIN_ORG.getKey());
                    }
                    this.addJobChangeReportEntry(yzjUser, erpUser, proReportMap, yzjUdp, erpUdp);
                }
                this.addChargeReport(yzjUser, erpUser, yzjUdp, erpUdp, proReportMap);
                yzjIter.remove();
                erpIter.remove();
                continue block0;
            }
        }
    }

    private void compareNotExistsJob(Map<String, Object> yzjUser, Map<String, Object> erpUser, List<UserDeptPos> yzjJobList, List<UserDeptPos> erpJobList, Map<String, SyncReport> proReportMap) {
        for (UserDeptPos pos : yzjJobList) {
            if (StringUtils.isBlank((CharSequence)pos.getYzjOrgId())) continue;
            if (StringUtils.isBlank((CharSequence)pos.getOrgName())) {
                this.addJobOrgNotExistsReportEntry(yzjUser, erpUser, proReportMap, pos);
                continue;
            }
            if (pos.isPartJob()) {
                pos.setProperty(UserJobPropertyEnum.PART_JOB.getKey());
            } else {
                pos.setProperty(UserJobPropertyEnum.MAIN_JOB.getKey());
            }
            this.addJobNotExistsReportEntry(yzjUser, erpUser, proReportMap, pos, true);
        }
        for (UserDeptPos pos : erpJobList) {
            if (pos.isPartJob()) {
                pos.setProperty(UserJobPropertyEnum.PART_JOB.getKey());
            } else {
                pos.setProperty(UserJobPropertyEnum.MAIN_JOB.getKey());
            }
            this.addJobNotExistsReportEntry(yzjUser, erpUser, proReportMap, pos, false);
        }
    }

    private void addJobOrgNotExistsReportEntry(Map<String, Object> yzjUser, Map<String, Object> erpUser, Map<String, SyncReport> proReportMap, UserDeptPos pos) {
        String openId = Utils.nullToEmpty((Object)yzjUser.get("openId")).toString().trim();
        SyncReport report = proReportMap.get(openId);
        if (report == null) {
            report = this.genDiffProReport(yzjUser, erpUser);
            proReportMap.put(openId, report);
        }
        report.setStatus(3);
        List<SyncReportEntry> entryList = report.getEntryList();
        SyncReportEntry reportEntry = new SyncReportEntry();
        reportEntry.setOperation("manual");
        if (pos.isPartJob()) {
            reportEntry.setProperty(UserJobPropertyEnum.PART_JOB.getKey());
        } else {
            reportEntry.setProperty(UserJobPropertyEnum.MAIN_JOB.getKey());
        }
        reportEntry.setYzjValue(this.genJobInfo(pos));
        reportEntry.setNote(UserMessage.getMessage((String)"M00048"));
        entryList.add(reportEntry);
    }

    private String genJobInfo(UserDeptPos pos) {
        String isIncharge = pos.isInCharge() ? ResManager.loadKDString((String)"\u8d1f\u8d23\u4eba", (String)"UserSyncReport_7", (String)"bos-org-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u975e\u8d1f\u8d23\u4eba", (String)"UserSyncReport_8", (String)"bos-org-formplugin", (Object[])new Object[0]);
        String jobTitle = pos.getJobTitle();
        if (StringUtils.isBlank((CharSequence)jobTitle)) {
            jobTitle = null;
        }
        String jobInfo = pos.getOrgName() + "\\" + jobTitle + "\\" + isIncharge;
        return jobInfo;
    }

    private void addSuperiorReport(Map<String, Object> yzjUser, Map<String, Object> erpUser, String yzjValue, String erpValue, Map<String, SyncReport> proReportMap) {
        String openId = Utils.nullToEmpty((Object)yzjUser.get("openId")).toString().trim();
        SyncReport report = proReportMap.get(openId);
        if (report == null) {
            report = this.genDiffProReport(yzjUser, erpUser);
            proReportMap.put(openId, report);
        }
        List<SyncReportEntry> entryList = report.getEntryList();
        SyncReportEntry reportEntry = new SyncReportEntry();
        reportEntry.setOperation("edit");
        reportEntry.setProperty(UserJobPropertyEnum.MAIN_SUPERIOR.getKey());
        reportEntry.setNote("");
        reportEntry.setYzjValue(yzjValue);
        reportEntry.setErpValue(erpValue);
        entryList.add(reportEntry);
    }

    private void addPartJobReport(Map<String, Object> yzjUser, Map<String, Object> erpUser, UserDeptPos yzjUdp, UserDeptPos erpUdp, Map<String, SyncReport> proReportMap) {
        if (yzjUdp.isPartJob() != erpUdp.isPartJob()) {
            yzjUdp.setOperation("edit");
            yzjUdp.setNote(ResManager.loadKDString((String)"\u53d8\u66f4\u4efb\u804c\u90e8\u95e8\u3002", (String)"UserSyncReport_6", (String)"bos-org-formplugin", (Object[])new Object[0]));
            if (yzjUdp.isPartJob()) {
                yzjUdp.setProperty(UserJobPropertyEnum.PART_JOB.getKey());
            } else {
                yzjUdp.setProperty(UserJobPropertyEnum.MAIN_JOB.getKey());
            }
            this.addJobChangeReportEntry(yzjUser, erpUser, proReportMap, yzjUdp, erpUdp);
        }
    }

    private void addChargeReport(Map<String, Object> yzjUser, Map<String, Object> erpUser, UserDeptPos yzjUdp, UserDeptPos erpUdp, Map<String, SyncReport> proReportMap) {
        if (yzjUdp.isInCharge() != erpUdp.isInCharge()) {
            yzjUdp.setOperation("edit");
            yzjUdp.setNote(yzjUdp.isInCharge() ? ResManager.loadKDString((String)"\u8bbe\u7f6e\u8d1f\u8d23\u4eba", (String)"UserSyncReport_9", (String)"bos-org-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u53d6\u6d88\u8d1f\u8d23\u4eba", (String)"UserSyncReport_10", (String)"bos-org-formplugin", (Object[])new Object[0]));
            if (yzjUdp.isPartJob()) {
                yzjUdp.setProperty(UserJobPropertyEnum.PART_ADMIN.getKey());
            } else {
                yzjUdp.setProperty(UserJobPropertyEnum.MAIN_ADMIN.getKey());
            }
            this.addJobChangeReportEntry(yzjUser, erpUser, proReportMap, yzjUdp, erpUdp);
        }
    }

    private void addJobChangeReportEntry(Map<String, Object> yzjUser, Map<String, Object> erpUser, Map<String, SyncReport> proReportMap, UserDeptPos yzjPos, UserDeptPos erpPos) {
        String openId = Utils.nullToEmpty((Object)yzjUser.get("openId")).toString().trim();
        SyncReport report = proReportMap.get(openId);
        if (report == null) {
            report = this.genDiffProReport(yzjUser, erpUser);
            proReportMap.put(openId, report);
        }
        List<SyncReportEntry> entryList = report.getEntryList();
        SyncReportEntry reportEntry = new SyncReportEntry();
        reportEntry.setOperation(yzjPos.getOperation());
        reportEntry.setProperty(yzjPos.getProperty());
        reportEntry.setNote(yzjPos.getNote());
        reportEntry.setYzjValue(this.genJobInfo(yzjPos));
        reportEntry.setErpValue(this.genJobInfo(erpPos));
        entryList.add(reportEntry);
    }

    private void addJobNotExistsReportEntry(Map<String, Object> yzjUser, Map<String, Object> erpUser, Map<String, SyncReport> proReportMap, UserDeptPos pos, boolean isAddNew) {
        String openId = Utils.nullToEmpty((Object)yzjUser.get("openId")).toString().trim();
        SyncReport report = proReportMap.get(openId);
        if (report == null) {
            report = this.genDiffProReport(yzjUser, erpUser);
            proReportMap.put(openId, report);
        }
        report.setStatus(0);
        List<SyncReportEntry> entryList = report.getEntryList();
        SyncReportEntry reportEntry = new SyncReportEntry();
        reportEntry.setProperty(pos.getProperty());
        String jobInfo = this.genJobInfo(pos);
        if (isAddNew) {
            reportEntry.setOperation("add");
            reportEntry.setYzjValue(jobInfo);
        } else {
            reportEntry.setOperation("delete");
            reportEntry.setErpValue(jobInfo);
        }
        reportEntry.setNote(pos.getNote());
        entryList.add(reportEntry);
    }

    private void saveAddNewReport(List<Map<String, Object>> notInErpList, Set<String> errorOpenIdAndPhoneSet) {
        ArrayList<SyncReport> reportList = new ArrayList<SyncReport>(notInErpList.size());
        for (Map<String, Object> yzjMap : notInErpList) {
            String phone = String.valueOf(yzjMap.get("phone"));
            String email = String.valueOf(yzjMap.get("email"));
            String openId = yzjMap.get("openId").toString();
            SyncReport report = new SyncReport();
            String userName = yzjMap.get("name").toString();
            report.setTaskId(this.taskId);
            report.setDataType(DifferenceType.USER.getKey());
            report.setSyncObject(userName);
            report.setYzjDataId(openId);
            List<SyncReportEntry> entryList = report.getEntryList();
            SyncReportEntry reportEntry = new SyncReportEntry();
            entryList.add(reportEntry);
            reportEntry.setOperation("add");
            reportEntry.setYzjValue(phone);
            if (errorOpenIdAndPhoneSet.contains(phone)) {
                report.setStatus(3);
                reportEntry.setNote(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u8be5\u624b\u673a\u53f7\u7684\u4eba\u5458\u5b58\u5728\u5f02\u5e38\u4fe1\u606f\uff0c\u4e0d\u5141\u8bb8\u540c\u6b65\u66f4\u65b0\u3002", (String)"UserSyncReport_11", (String)"bos-org-formplugin", (Object[])new Object[0]), phone));
            } else if (errorOpenIdAndPhoneSet.contains(email)) {
                report.setStatus(3);
                reportEntry.setNote(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u8be5\u90ae\u7bb1\u7684\u4eba\u5458\u5b58\u5728\u5f02\u5e38\u4fe1\u606f\uff0c\u4e0d\u5141\u8bb8\u540c\u6b65\u66f4\u65b0\u3002", (String)"UserSyncReport_12", (String)"bos-org-formplugin", (Object[])new Object[0]), email));
            } else if (errorOpenIdAndPhoneSet.contains(openId)) {
                report.setStatus(3);
                reportEntry.setNote(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u8be5openId\u7684\u4eba\u5458\u5b58\u5728\u5f02\u5e38\u4fe1\u606f\uff0c\u4e0d\u5141\u8bb8\u540c\u6b65\u66f4\u65b0\u3002", (String)"UserSyncReport_13", (String)"bos-org-formplugin", (Object[])new Object[0]), openId));
            } else {
                report.setStatus(0);
            }
            reportList.add(report);
        }
        YzjSyncReport.add(reportList);
    }

    private void saveDisableReport(List<Map<String, Object>> erpList, Set<String> errorOpenIdAndPhoneSet) {
        if (Utils.isListEmpty(erpList)) {
            return;
        }
        int count = erpList.size();
        ArrayList<SyncReport> reportList = new ArrayList<SyncReport>(count);
        int newDisableCount = 0;
        Calendar cal = Calendar.getInstance();
        cal.set(11, cal.get(11) - 1);
        Date currentDate = cal.getTime();
        for (Map<String, Object> erpMap : erpList) {
            Object enable = erpMap.get("enable");
            if (enable != null && "0".equals(enable.toString()) || this.isErrorUser(erpMap, errorOpenIdAndPhoneSet)) continue;
            String phone = String.valueOf(erpMap.get("phone"));
            Object createTime = erpMap.get("createtime");
            if (StringUtils.isBlank((CharSequence)phone) && createTime != null && currentDate.before((Date)createTime)) continue;
            ++newDisableCount;
            reportList.add(this.genEnableReport(erpMap, "disable"));
        }
        if (newDisableCount >= this.yzjConfig.getUserDisableLimit()) {
            this.yzjConfig.setAutoSync(false);
        }
        YzjSyncReport.add(reportList);
    }

    private void saveEnableReport(List<Map<String, Object>> erpList, Set<String> errorOpenIdAndPhoneSet) {
        if (Utils.isListEmpty(erpList)) {
            return;
        }
        ArrayList<SyncReport> reportList = new ArrayList<SyncReport>(erpList.size());
        for (Map<String, Object> erpMap : erpList) {
            Object enable = erpMap.get("enable");
            if (enable != null && "1".equals(enable.toString()) || this.isErrorUser(erpMap, errorOpenIdAndPhoneSet)) continue;
            reportList.add(this.genEnableReport(erpMap, "enable"));
        }
        YzjSyncReport.add(reportList);
    }

    private boolean isErrorUser(Map<String, Object> dataMap, Set<String> errorKeySet) {
        String openId = String.valueOf(dataMap.get("openId"));
        String phone = String.valueOf(dataMap.get("phone"));
        String email = String.valueOf(dataMap.get("email"));
        return errorKeySet.contains(openId) || errorKeySet.contains(phone) || errorKeySet.contains(email);
    }

    private SyncReport genEnableReport(Map<String, Object> erpMap, String operation) {
        SyncReport report = new SyncReport();
        List<SyncReportEntry> entryList = report.getEntryList();
        SyncReportEntry reportEntry = new SyncReportEntry();
        report.setDataType(DifferenceType.USER.getKey());
        report.setSyncObject(String.valueOf(erpMap.get("name")));
        if ("disable".equals(operation) && StringUtils.isBlank((Object)erpMap.get("openId"))) {
            report.setStatus(3);
            reportEntry.setNote(UserMessage.getMessage((String)"M00049"));
        } else {
            report.setStatus(0);
            report.setYzjDataId(String.valueOf(erpMap.get("openId")));
        }
        report.setErpDataId(String.valueOf(erpMap.get("id")));
        report.setTaskId(this.taskId);
        reportEntry.setOperation(operation);
        if ("enable".equals(operation)) {
            reportEntry.setYzjValue(String.valueOf(erpMap.get("phone")));
        } else {
            reportEntry.setErpValue(String.valueOf(erpMap.get("phone")));
        }
        entryList.add(reportEntry);
        return report;
    }

    private SyncReport genDiffProReport(Map<String, Object> dtYzj, Map<String, Object> dtErp) {
        SyncReport report = new SyncReport();
        report.setDataType(DifferenceType.USER.getKey());
        report.setSyncObject(String.valueOf(dtYzj.get("name")));
        report.setYzjDataId(String.valueOf(dtYzj.get("openId")));
        String userId = String.valueOf(dtErp.get("id"));
        report.setErpDataId(userId);
        report.setTaskId(this.taskId);
        report.setStatus(0);
        return report;
    }

    private void saveDiffProReport(Map<String, SyncReport> proReportMap) {
        ArrayList<SyncReport> reportList = new ArrayList<SyncReport>(proReportMap.size());
        for (Map.Entry<String, SyncReport> reportSet : proReportMap.entrySet()) {
            reportList.add(reportSet.getValue());
        }
        YzjSyncReport.add(reportList);
    }

    private void addDiffProSyncReportEntry(SyncReport report, Map<String, Object> dtYzj, Map<String, Object> dtErp, CompareRule cr) {
        String srcField = cr.getSrcFld();
        String destField = cr.getDestFld();
        Object yzjValue = dtYzj.get(srcField);
        List<SyncReportEntry> entryList = report.getEntryList();
        SyncReportEntry reportEntry = new SyncReportEntry();
        reportEntry.setOperation("edit");
        reportEntry.setProperty(destField);
        String yzjShowValue = UserSyncUtils.getDiffProShowValue(srcField, yzjValue);
        reportEntry.setYzjValue(yzjShowValue);
        Object erpValue = dtErp.get(destField);
        if (StringUtils.isNotBlank((Object)erpValue)) {
            reportEntry.setErpValue(UserSyncUtils.getDiffProShowValue(srcField, erpValue));
        }
        entryList.add(reportEntry);
    }

    private void createSuperadminNameReport(List<Map<String, Object>> userList) {
        this.createErrorUserReport(userList, "name", UserMessage.getMessage((String)"M00050", (Object[])new Object[]{ResManager.loadKDString((String)"\u59d3\u540d", (String)"UserSyncReport_14", (String)"bos-org-formplugin", (Object[])new Object[0])}));
    }

    private void createDiscardReport(List<Map<String, Object>> discardList) {
        this.createErrorUserReport(discardList, "phone", UserMessage.getMessage((String)"M00051"));
    }

    private void createDuplicatePhoneReport(List<Map<String, Object>> duplicatePhoneList, boolean isYzj) {
        String errorMsg = "";
        errorMsg = isYzj ? UserMessage.getMessage((String)"M00053") : UserMessage.getMessage((String)"M00052");
        this.createErrorUserReport(duplicatePhoneList, "phone", errorMsg);
    }

    private void createDuplicateEmailReport(List<Map<String, Object>> duplicateEmailList, boolean isYzj) {
        String errorMsg = "";
        errorMsg = isYzj ? UserMessage.getMessage((String)"M00055") : UserMessage.getMessage((String)"M00054");
        this.createErrorUserReport(duplicateEmailList, "email", errorMsg);
    }

    private void createErrorUserReport(List<Map<String, Object>> userList, String yzjPropertyName, String errorMsg) {
        if (userList.isEmpty()) {
            return;
        }
        ArrayList<SyncReport> reportList = new ArrayList<SyncReport>(userList.size());
        String userId = RequestContext.get().getUserId();
        String curTime = Long.toString(Calendar.getInstance().getTimeInMillis());
        for (Map<String, Object> yzjMap : userList) {
            String propertyValue = String.valueOf(yzjMap.get(yzjPropertyName));
            SyncReport report = new SyncReport();
            String userName = String.valueOf(yzjMap.get("name"));
            report.setTaskId(this.taskId);
            report.setStatus(3);
            report.setDataType(DifferenceType.USER.getKey());
            report.setSyncObject(userName);
            report.setYzjDataId(String.valueOf(yzjMap.get("openId")));
            Object erpId = yzjMap.get("id");
            if (StringUtils.isNotBlank((Object)erpId)) {
                report.setErpDataId(erpId.toString());
            }
            report.setModifier(userId);
            report.setModifyTime(curTime);
            List<SyncReportEntry> entryList = report.getEntryList();
            SyncReportEntry reportEntry = new SyncReportEntry();
            reportEntry.setOperation("manual");
            reportEntry.setProperty(yzjPropertyName);
            reportEntry.setYzjValue(propertyValue);
            reportEntry.setNote(errorMsg);
            entryList.add(reportEntry);
            reportList.add(report);
        }
        YzjSyncReport.add(reportList);
    }
}

