/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.yunzhijia.diff.impl.utils;

import java.util.HashMap;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.CacheKeyUtil;

public class YzjSyncCache {
    private static final DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("YzjSyncTask", new DistributeCacheHAPolicy(true, true));
    private static final int EXPIRE_SECOND = 3600;

    public static boolean isTaskRunning() {
        String statusCache = (String)cache.get(YzjSyncCache.getTaskStatusKey());
        return "1".equals(statusCache);
    }

    public static void updateTaskRunningStatus() {
        String key = YzjSyncCache.getTaskStatusKey();
        cache.put(key, (Object)"1");
        cache.expireAfter(key, 3600);
    }

    public static void removeTaskStatus() {
        cache.remove(YzjSyncCache.getTaskStatusKey());
    }

    public static void removeTaskProgress() {
        cache.remove(YzjSyncCache.getTaskProgressKey());
    }

    public static String getTaskStatusKey() {
        String acctId = CacheKeyUtil.getAcctId();
        return acctId + "taskStatus";
    }

    public static String getTaskProgressKey() {
        String acctId = CacheKeyUtil.getAcctId();
        return acctId + "taskProgress";
    }

    public static void updateTaskProgress(String detail) {
        YzjSyncCache.updateTaskProgress(detail, 1);
    }

    public static void updateTaskFailProgress(String detail) {
        YzjSyncCache.updateTaskProgress(String.format(ResManager.loadKDString((String)"\u6267\u884c\u5931\u8d25\uff1a%1$s", (String)"YzjSyncCache_2", (String)"bos-org-formplugin", (Object[])new Object[0]), detail), 3);
    }

    private static void updateTaskProgress(String detail, int status) {
        String key = YzjSyncCache.getTaskProgressKey();
        Map<String, Object> taskProgressInfo = YzjSyncCache.getTaskProgressInfo(key);
        Object progress = taskProgressInfo.get("progress");
        int addProgress = (int)(Math.random() * 10.0 + 1.0);
        if (StringUtils.isBlank((Object)progress)) {
            progress = addProgress;
        } else {
            addProgress = (Integer)progress + addProgress;
            if (addProgress < 100) {
                progress = addProgress;
            }
        }
        YzjSyncCache.updateTaskProgress((Integer)progress, detail, status, key, taskProgressInfo);
    }

    private static void updateTaskProgress(int progress, String detail, int status) {
        String key = YzjSyncCache.getTaskProgressKey();
        Map<String, Object> taskProgressInfo = YzjSyncCache.getTaskProgressInfo(key);
        YzjSyncCache.updateTaskProgress(progress, detail, status, key, taskProgressInfo);
    }

    private static void updateTaskProgress(int progress, String detail, int status, String key, Map<String, Object> taskProgressInfo) {
        taskProgressInfo.put("progress", progress);
        taskProgressInfo.put("detail", detail);
        taskProgressInfo.put("status", status);
        cache.put(key, (Object)SerializationUtils.toJsonString(taskProgressInfo));
    }

    public static void startTaskProgress() {
        int addProgress = (int)(Math.random() * 5.0 + 1.0);
        YzjSyncCache.updateTaskProgress(addProgress, ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c\u4e91\u4e4b\u5bb6\u5dee\u5f02\u5bf9\u6bd4\uff0c\u8bf7\u7a0d\u7b49\u3002", (String)"YzjSyncCache_0", (String)"bos-org-formplugin", (Object[])new Object[0]), 1);
    }

    public static void finishTaskProgress() {
        YzjSyncCache.updateTaskProgress(100, ResManager.loadKDString((String)"\u4e91\u4e4b\u5bb6\u5dee\u5f02\u5bf9\u6bd4\u6267\u884c\u6210\u529f\u3002", (String)"YzjSyncCache_1", (String)"bos-org-formplugin", (Object[])new Object[0]), 2);
    }

    public static Map<String, Object> getTaskProgressInfo() {
        return YzjSyncCache.getTaskProgressInfo(YzjSyncCache.getTaskProgressKey());
    }

    public static Map<String, Object> getTaskProgressInfo(String taskProgressKey) {
        String progress = (String)cache.get(taskProgressKey);
        if (StringUtils.isBlank((CharSequence)progress)) {
            return new HashMap<String, Object>();
        }
        return (Map)SerializationUtils.fromJsonString((String)progress, Map.class);
    }
}

