/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.yunzhijia.diff.impl.utils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.base.utils.msg.BaseMessage;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.utils.Utils;
import kd.bos.org.yunzhijia.diff.impl.utils.YzjSyncCache;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.util.OpenPageUtils;
import kd.bos.servicehelper.QueryServiceHelper;

public class YzjSyncImplUtils {
    private static final Log log = LogFactory.getLog(YzjSyncImplUtils.class);
    private static final String SYSTEM_TYPE = "bos-org-formplugin";
    public static final String BOS_YZJ_SYNCPROGRESS = "bos_yzj_syncprogress";

    public static Map<String, Long> getOrgIdMap() {
        String selectFields = "id,fyzjorgid";
        DynamicObjectCollection orgCol = QueryServiceHelper.query((String)"bos_org", (String)selectFields, null);
        if (Utils.isListEmpty((List)orgCol)) {
            return new HashMap<String, Long>(0);
        }
        HashMap<String, Long> orgIdMap = new HashMap<String, Long>(orgCol.size());
        for (DynamicObject org : orgCol) {
            orgIdMap.put(org.getString("fyzjorgid"), org.getLong("id"));
        }
        return orgIdMap;
    }

    public static Map<String, Long> getBackupOrgIdMap(long taskId, String syncBackupType) {
        return YzjSyncImplUtils.getBackupOrgIdMap(taskId, syncBackupType, "fyzjorgid");
    }

    public static Map<String, Long> getBackupOrgNumberIdMap(long taskId, String syncBackupType) {
        return YzjSyncImplUtils.getBackupOrgIdMap(taskId, syncBackupType, "number");
    }

    public static Map<String, Long> getBackupOrgIdMap(long taskId, String syncBackupType, String keyProName) {
        String selectFields = "id," + keyProName;
        QFilter taskFilter = new QFilter("task", "=", (Object)taskId);
        QFilter typeFilter = new QFilter("backuptype", "=", (Object)syncBackupType);
        QFilter[] filters = new QFilter[]{taskFilter, typeFilter};
        DynamicObjectCollection orgCol = QueryServiceHelper.query((String)"bos_yzj_org", (String)selectFields, (QFilter[])filters);
        if (Utils.isListEmpty((List)orgCol)) {
            return new HashMap<String, Long>(0);
        }
        HashMap<String, Long> orgIdMap = new HashMap<String, Long>(orgCol.size());
        for (DynamicObject org : orgCol) {
            orgIdMap.put(org.getString(keyProName), org.getLong("id"));
        }
        return orgIdMap;
    }

    public static void openSysParameterPage(IFormView view, boolean isCloseView) {
        String appId = "cts";
        String menuItemId = "1646402983019152384";
        AppInfo app = AppMetadataCache.getAppInfo((String)appId);
        if (app == null) {
            view.showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u67e5\u627e\u57fa\u7840\u670d\u52a1\u5e94\u7528\u5931\u8d25\u3002", (String)"YzjSyncImplUtils_0", (String)SYSTEM_TYPE, (Object[])new Object[0]), appId));
            return;
        }
        AppMenuInfo menu = AppMetadataCache.getAppMenuInfo((String)appId, (String)menuItemId);
        if (menu == null) {
            view.showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u67e5\u627e\u7cfb\u7edf\u53c2\u6570\u83dc\u5355\u5931\u8d25\u3002", (String)"YzjSyncImplUtils_1", (String)SYSTEM_TYPE, (Object[])new Object[0]), menuItemId));
            return;
        }
        String appHomeNum = app.getHomeNum();
        String menuFormId = menu.getFormId();
        if (StringUtils.isBlank((CharSequence)appHomeNum) || StringUtils.isBlank((CharSequence)menuFormId)) {
            view.showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u7cfb\u7edf\u53c2\u6570\u6ca1\u6709\u914d\u7f6e\u83dc\u5355\u3002", (String)"YzjSyncImplUtils_2", (String)SYSTEM_TYPE, (Object[])new Object[0]), menuItemId));
            return;
        }
        if (isCloseView) {
            view.close();
        }
        String appName = app.getName().getLocaleValue();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("view", view);
        map.put("appname", appName);
        map.put("appmainnumber", appHomeNum);
        map.put("formnumber", menuFormId);
        map.put("parametertype", menu.getParamType());
        map.put("parameter", menu.getParams());
        map.put("menuname", menu.getName().getLocaleValue());
        OpenPageUtils.openApp((String)app.getNumber(), (String)menuItemId, map, (IFormView)view);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String checkTaskRunning() {
        String resultMsg = "";
        DLock dl = DLock.create((String)"bas/yunzhijia/sync/YzjSyncTaskAction");
        String cacheKey = YzjSyncCache.getTaskStatusKey();
        try {
            dl.lock();
            boolean isTaskRunning = YzjSyncCache.isTaskRunning();
            log.info(cacheKey + "\uff1a\u83b7\u53d6\u4e91\u4e4b\u5bb6\u5dee\u5f02\u5bf9\u6bd4\u4efb\u52a1\u9501\u3002\u662f\u5426\u6709\u4efb\u52a1\u6b63\u5728\u6267\u884c\uff1a" + isTaskRunning);
            if (isTaskRunning) {
                String string = resultMsg = BaseMessage.getMessage((String)"M00034");
                return string;
            }
            YzjSyncCache.updateTaskRunningStatus();
        }
        finally {
            dl.unlock();
            dl.close();
            log.info(cacheKey + "\uff1a\u91ca\u653e\u4e91\u4e4b\u5bb6\u5dee\u5f02\u5bf9\u6bd4\u4efb\u52a1\u9501\u3002\u662f\u5426\u6709\u4efb\u52a1\u6b63\u5728\u6267\u884c\uff1a" + YzjSyncCache.isTaskRunning());
        }
        return resultMsg;
    }

    public static void showProgressForm(IFormView view, IFormPlugin plugin) {
        if (view == null) {
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(BOS_YZJ_SYNCPROGRESS);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack(plugin, BOS_YZJ_SYNCPROGRESS));
        view.showForm(parameter);
    }
}

