/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.yunzhijia.diff.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.base.utils.msg.BaseMessage;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.org.utils.OrgViewUtils;
import kd.bos.org.utils.Utils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;

public class YzjSearchPlugin
extends AbstractFormPlugin
implements SearchEnterListener,
RowClickEventListener,
HyperLinkClickListener {
    private static final String SEARCH_FIELD_NAME = "fieldName";
    private static final String SEARCH_FILED_VALUE = "value";
    private static final String PERCENT_LABEL = "%";

    public void initialize() {
        EntryGrid entry;
        super.initialize();
        Search search = (Search)this.getView().getControl("searchap");
        if (search != null) {
            search.addEnterListener((SearchEnterListener)this);
        }
        if ((entry = (EntryGrid)this.getControl("entryentity")) != null) {
            entry.addRowClickListener((RowClickEventListener)this);
            entry.addHyperClickListener((HyperLinkClickListener)this);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        this.showCompareForm(evt.getRowIndex());
    }

    public void entryRowDoubleClick(RowClickEvent evt) {
        this.showCompareForm(evt.getRow());
    }

    private void showCompareForm(int rowIndex) {
        DynamicObject rowObj = this.getModel().getEntryRowEntity("entryentity", rowIndex);
        Object dataType = this.getModel().getValue("datatype");
        if (StringUtils.isBlank((Object)dataType)) {
            this.getView().showErrorNotification(String.format(BaseMessage.getMessage((String)"M00042", (Object[])new Object[]{ResManager.loadKDString((String)"\u6570\u636e\u7c7b\u578b", (String)"YzjSearchPlugin_0", (String)"bos-org-formplugin", (Object[])new Object[0])}), new Object[0]));
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("bos_yzj_data");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("datatype", dataType);
        formShowParameter.setCustomParam("id", (Object)rowObj.getLong("id"));
        this.getView().showForm(formShowParameter);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if ("datatype".equals(e.getProperty().getName())) {
            this.clearSearchResult();
        }
    }

    private void clearSearchResult() {
        IDataModel model = this.getModel();
        int rowCount = model.getEntryRowCount("entryentity");
        for (int i = rowCount - 1; i >= 0; --i) {
            model.deleteEntryRow("entryentity", i);
        }
    }

    public void search(SearchEnterEvent arg0) {
        IDataModel model = this.getModel();
        Object dataType = model.getValue("datatype");
        if (StringUtils.isBlank((Object)dataType)) {
            this.getView().showErrorNotification(String.format(BaseMessage.getMessage((String)"M00042", (Object[])new Object[]{ResManager.loadKDString((String)"\u6570\u636e\u7c7b\u578b", (String)"YzjSearchPlugin_0", (String)"bos-org-formplugin", (Object[])new Object[0])}), new Object[0]));
            return;
        }
        this.clearSearchResult();
        QFilter searchFilters = this.getSearchFilter(arg0);
        if (searchFilters == null) {
            return;
        }
        int type = Integer.parseInt(dataType.toString());
        switch (type) {
            case 1: {
                this.queryOrg(searchFilters);
                break;
            }
            case 2: {
                this.queryUser(searchFilters);
                break;
            }
        }
    }

    private void queryOrg(QFilter searchFilters) {
        String selectFields = "id";
        QFilter[] filters = new QFilter[]{searchFilters};
        DynamicObjectCollection dataObjCol = QueryServiceHelper.query((String)"bos_org", (String)selectFields, (QFilter[])filters);
        if (Utils.isListEmpty((List)dataObjCol)) {
            return;
        }
        ArrayList<Long> orgIds = new ArrayList<Long>(dataObjCol.size());
        for (DynamicObject org : dataObjCol) {
            orgIds.add(org.getLong("id"));
        }
        selectFields = "id,org.number number,fullname name,yzjorgid openid";
        QFilter orgFilter = new QFilter("org", "in", orgIds);
        QFilter viewFilter = OrgViewUtils.getOrgViewFilter((String)"01");
        filters = new QFilter[]{viewFilter, orgFilter};
        dataObjCol = QueryServiceHelper.query((String)"bos_org_structure", (String)selectFields, (QFilter[])filters);
        this.genResult(dataObjCol);
    }

    private void queryUser(QFilter searchFilters) {
        String selectFields = "id,number,name,useropenid openid";
        QFilter[] filters = new QFilter[]{searchFilters};
        DynamicObjectCollection dataObjCol = QueryServiceHelper.query((String)"bos_user", (String)selectFields, (QFilter[])filters);
        this.genResult(dataObjCol);
    }

    private void genResult(DynamicObjectCollection dataObjCol) {
        if (Utils.isListEmpty((List)dataObjCol)) {
            return;
        }
        int index = 0;
        IDataModel model = this.getModel();
        for (DynamicObject dataObj : dataObjCol) {
            model.createNewEntryRow("entryentity");
            model.setValue("id", dataObj.get("id"), index);
            model.setValue("openid", dataObj.get("openid"), index);
            model.setValue("number", dataObj.get("number"), index);
            model.setValue("name", dataObj.get("name"), index);
            ++index;
        }
    }

    private QFilter getSearchFilter(SearchEnterEvent arg0) {
        List paramList = arg0.getSearchFields();
        if (CollectionUtils.isEmpty((Collection)paramList)) {
            return null;
        }
        QFilter searchFilters = null;
        for (Map param : paramList) {
            List files = (List)param.get(SEARCH_FIELD_NAME);
            if (CollectionUtils.isEmpty((Collection)files)) continue;
            for (String field : files) {
                List values = (List)param.get(SEARCH_FILED_VALUE);
                searchFilters = this.filterOr(searchFilters, field, values);
            }
        }
        return searchFilters;
    }

    private QFilter filterOr(QFilter searchFilters, String field, List<String> values) {
        if (CollectionUtils.isEmpty(values)) {
            return searchFilters;
        }
        for (String value : values) {
            if (StringUtils.isBlank((CharSequence)value)) continue;
            if (searchFilters == null) {
                searchFilters = new QFilter(field, "like", (Object)(PERCENT_LABEL + value + PERCENT_LABEL));
                continue;
            }
            searchFilters = searchFilters.or(new QFilter(field, "like", (Object)(PERCENT_LABEL + value + PERCENT_LABEL)));
        }
        return searchFilters;
    }
}

