/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.yunzhijia.diff.plugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.org.utils.OrgViewUtils;
import kd.bos.org.utils.Utils;
import kd.bos.org.yunzhijia.diff.impl.user.UserSyncUtils;
import kd.bos.org.yunzhijia.model.CompareRule;
import kd.bos.org.yunzhijia.model.OrgCompareRuleSingleton;
import kd.bos.org.yunzhijia.model.UserCompareRuleSingleton;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class YzjSyncDataComparePlugin
extends AbstractFormPlugin {
    public static final String SPLIT_COLOR = "#E2E7EF";
    public static final String BACK_COLOR = "#FFB5B5";
    private static final String SYSTEM_TYPE = "bos-org-formplugin";

    public void afterCreateNewData(EventObject e) {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>(1);
        map.put("heightLimit", Boolean.FALSE);
        this.getView().updateControlMetadata("cloud-hub", map);
        this.getView().updateControlMetadata("before", map);
        this.getView().updateControlMetadata("after", map);
        this.getView().updateControlMetadata("current", map);
        long reportId = (Long)this.getView().getFormShowParameter().getCustomParam("id");
        String selectFields = "id,task,datatype,yzjdataid,erpdataid,entryentity.operation operation,entryentity.property property,entryentity.yzjvalue yzjvalue,status";
        QFilter idFilter = new QFilter("id", "=", (Object)reportId);
        QFilter[] filters = new QFilter[]{idFilter};
        DynamicObjectCollection reportCol = QueryServiceHelper.query((String)"bos_yzj_syncreport", (String)selectFields, (QFilter[])filters);
        if (Utils.isListEmpty((List)reportCol)) {
            return;
        }
        ArrayList<String> propertyList = new ArrayList<String>(reportCol.size());
        DynamicObject reportObj = null;
        boolean isAutomatic = false;
        for (DynamicObject entityObj : reportCol) {
            isAutomatic = entityObj.getBoolean("status");
            reportObj = entityObj;
            propertyList.add(entityObj.getString("property"));
        }
        if (reportObj != null) {
            String dataType = reportObj.getString("datatype");
            if ("org".equals(dataType)) {
                this.showOrg(reportObj, propertyList, isAutomatic);
            } else if ("user".equals(dataType)) {
                this.showUser(reportObj, propertyList, isAutomatic);
            }
        }
    }

    private void showOrg(DynamicObject reportObj, List<String> propertyList, boolean isAutomatic) {
        String yzjOrgId = reportObj.getString("yzjdataid");
        Long orgId = 0L;
        String erpDataId = reportObj.getString("erpdataid");
        if (StringUtils.isNotBlank((CharSequence)erpDataId)) {
            orgId = Long.valueOf(erpDataId);
        }
        ArrayList<CompareRule> proList = new ArrayList<CompareRule>();
        CompareRule id = new CompareRule("id", "id", ResManager.loadKDString((String)"\u6570\u636e\u5185\u7801", (String)"YzjSyncDataComparePlugin_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        proList.add(id);
        CompareRule erporgid = new CompareRule("erporgid", "erporgid", ResManager.loadKDString((String)"\u7ec4\u7ec7\u5185\u7801", (String)"YzjSyncDataComparePlugin_1", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        proList.add(erporgid);
        proList.addAll(OrgCompareRuleSingleton.getInstance().refreshRules());
        CompareRule enable = new CompareRule("status", "enable", ResManager.loadKDString((String)"\u4f7f\u7528\u72b6\u6001", (String)"YzjSyncDataComparePlugin_2", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        proList.add(enable);
        String selectFields = YzjSyncDataComparePlugin.getOrgFields(proList);
        QFilter idFilter = null;
        QFilter curIdFilter = null;
        String operation = reportObj.getString("operation");
        if (StringUtils.isBlank((CharSequence)yzjOrgId)) {
            idFilter = "freeze".equals(operation) ? (orgId == 0L ? new QFilter("org.org.id", "in", (Object)Collections.EMPTY_LIST) : new QFilter("org.org.id", "=", (Object)orgId)) : (orgId == 0L ? new QFilter("org", "in", (Object)Collections.EMPTY_LIST) : new QFilter("org", "=", (Object)orgId));
            curIdFilter = orgId == 0L ? new QFilter("org", "in", (Object)Collections.EMPTY_LIST) : new QFilter("org", "=", (Object)orgId);
        } else {
            idFilter = new QFilter("yzjorgid", "=", (Object)yzjOrgId);
            curIdFilter = new QFilter("yzjorgid", "=", (Object)yzjOrgId);
        }
        String fullnameFilter = "";
        long taskId = reportObj.getLong("task");
        if ("unfreeze".equals(operation)) {
            String fullname = reportObj.getString("yzjvalue");
            idFilter = idFilter.or(new QFilter("fullname", "=", (Object)fullname));
            curIdFilter = curIdFilter.or(new QFilter("fullname", "=", (Object)fullname));
        } else if ("edit".equals(operation)) {
            if (propertyList.contains("yzjorgid")) {
                fullnameFilter = this.getOrgFullname(taskId, yzjOrgId);
                idFilter = idFilter.or(new QFilter("fullname", "=", (Object)fullnameFilter));
                curIdFilter = curIdFilter.or(new QFilter("fullname", "=", (Object)fullnameFilter));
            }
        } else if ("move".equals(operation)) {
            propertyList.add("fullname");
        }
        HashMap<Integer, String> yzjDataMap = new HashMap<Integer, String>();
        ArrayList<Integer> markList = new ArrayList<Integer>();
        this.showBackupOrg(taskId, selectFields, idFilter, proList, markList, isAutomatic, yzjDataMap);
        this.showCurrentOrg(selectFields, curIdFilter, proList, markList, yzjDataMap);
        this.updateEntryGridBackColor("cloud-hub", markList, BACK_COLOR);
        this.updateEntryGridBackColor("before", markList, BACK_COLOR);
        this.updateEntryGridBackColor("after", markList, BACK_COLOR);
        this.updateEntryGridBackColor("current", markList, BACK_COLOR);
    }

    private String getOrgFullname(long taskId, String yzjOrgId) {
        QFilter taskFilter = new QFilter("org.task", "=", (Object)taskId);
        QFilter backuptypeFilter = new QFilter("org.backuptype", "=", (Object)"cloud-hub");
        QFilter idFilter = new QFilter("yzjorgid", "=", (Object)yzjOrgId);
        QFilter[] filters = new QFilter[]{taskFilter, idFilter, backuptypeFilter};
        DynamicObjectCollection orgCol = QueryServiceHelper.query((String)"bos_yzj_orgstructure", (String)"fullname", (QFilter[])filters);
        if (Utils.isListEmpty((List)orgCol)) {
            return "";
        }
        return ((DynamicObject)orgCol.get(0)).getString("fullname");
    }

    private void showBackupOrg(long taskId, String selectFields, QFilter idFilter, List<CompareRule> proList, List<Integer> markList, boolean isAutomatic, Map<Integer, String> yzjDataMap) {
        selectFields = selectFields + ",org,org.backuptype backuptype,org.id orgId,org.org.id erporgid";
        QFilter taskFilter = new QFilter("org.task", "=", (Object)taskId);
        QFilter[] filters = new QFilter[]{idFilter, taskFilter};
        DynamicObjectCollection orgCol = QueryServiceHelper.query((String)"bos_yzj_orgstructure", (String)selectFields, (QFilter[])filters);
        HashMap<String, DynamicObject> typeMap = new HashMap<String, DynamicObject>(3);
        if (Utils.isListNotEmpty((List)orgCol)) {
            for (DynamicObject org : orgCol) {
                String dataType = org.getString("backuptype");
                typeMap.put(dataType, org);
            }
        }
        this.updataOrgClientData(typeMap, proList, markList, isAutomatic, yzjDataMap);
    }

    private void showCurrentOrg(String selectFields, QFilter idFilter, List<CompareRule> proList, List<Integer> markList, Map<Integer, String> yzjDataMap) {
        selectFields = selectFields + ",org.id orgId,org.id erporgid";
        QFilter viewFilter = OrgViewUtils.getOrgViewFilter((String)"01");
        QFilter[] filters = new QFilter[]{idFilter, viewFilter};
        DynamicObjectCollection orgCol = QueryServiceHelper.query((String)"bos_org_structure", (String)selectFields, (QFilter[])filters);
        if (Utils.isListEmpty((List)orgCol)) {
            return;
        }
        DynamicObject org = (DynamicObject)orgCol.get(0);
        this.updataOrgClientData("current", org, proList, markList, yzjDataMap);
    }

    private static String getOrgFields(List<CompareRule> proList) {
        StringBuilder selectFields = new StringBuilder();
        for (CompareRule rule : proList) {
            String fieldName = rule.getDestFld();
            if ("erporgid".equals(fieldName)) continue;
            if ("name".equals(fieldName)) {
                fieldName = "org.name name";
            } else if ("enable".equals(fieldName)) {
                fieldName = "org.enable enable";
            }
            selectFields.append(fieldName);
            selectFields.append(",");
        }
        selectFields.append("status");
        return selectFields.toString();
    }

    private void updataOrgClientData(Map<String, DynamicObject> typeMap, List<CompareRule> proList, List<Integer> markList, boolean isAutomatic, Map<Integer, String> yzjDataMap) {
        this.updataOrgClientData("cloud-hub", typeMap.get("cloud-hub"), proList, markList, yzjDataMap);
        this.updataOrgClientData("before", typeMap.get("before"), proList, markList, yzjDataMap);
        if (isAutomatic) {
            this.updataOrgClientData("after", typeMap.get("after"), proList, markList, yzjDataMap);
        } else {
            String proNameField = "name_after";
            String proValueField = "value_after";
            int index = 0;
            IDataModel model = this.getModel();
            model.createNewEntryRow("after");
            model.setValue(proNameField, (Object)this.getTipTitle(), index);
            model.setValue(proValueField, (Object)ResManager.loadKDString((String)"\u672a\u6267\u884c\u540c\u6b65\uff0c\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u6570\u636e", (String)"YzjSyncDataComparePlugin_3", (String)SYSTEM_TYPE, (Object[])new Object[0]), index);
        }
    }

    private void updataOrgClientData(String dataType, DynamicObject obj, List<CompareRule> proList, List<Integer> markList, Map<Integer, String> yzjDataMap) {
        String proNameField = "name_" + dataType;
        String proValueField = "value_" + dataType;
        int index = 0;
        IDataModel model = this.getModel();
        if (obj == null) {
            model.createNewEntryRow(dataType);
            model.setValue(proNameField, (Object)this.getTipTitle(), index);
            model.setValue(proValueField, (Object)ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u6570\u636e", (String)"YzjSyncDataComparePlugin_4", (String)SYSTEM_TYPE, (Object[])new Object[0]), index);
            return;
        }
        for (CompareRule pro : proList) {
            String destFld = pro.getDestFld();
            if (index <= model.getEntryRowCount(dataType)) {
                model.createNewEntryRow(dataType);
            }
            model.setValue(proNameField, (Object)pro.getDesc(), index);
            String value = "";
            boolean isMarkSkip = false;
            if ("id".equals(destFld)) {
                value = UserSyncUtils.getDiffProShowValue(destFld, obj.get("orgId"));
                isMarkSkip = true;
            } else {
                value = UserSyncUtils.getDiffProShowValue(destFld, obj.get(destFld));
                if ("erporgid".equals(destFld)) {
                    isMarkSkip = true;
                    if ("0".equals(value)) {
                        value = "";
                    }
                }
            }
            model.setValue(proValueField, (Object)value, index);
            if (!isMarkSkip) {
                this.addMarkItemIndex(dataType, index, value, yzjDataMap, markList);
            }
            ++index;
        }
    }

    private void showUser(DynamicObject reportObj, List<String> propertyList, boolean isAutomatic) {
        QFilter otherKeyFilter;
        QFilter curFilter;
        QFilter idFilter;
        String openId = reportObj.getString("yzjdataid");
        Long userId = 0L;
        String erpDataId = reportObj.getString("erpdataid");
        if (StringUtils.isNotBlank((CharSequence)erpDataId)) {
            userId = Long.valueOf(erpDataId);
        }
        ArrayList<CompareRule> proList = new ArrayList<CompareRule>();
        CompareRule idRule = new CompareRule("id", "id", ResManager.loadKDString((String)"\u6570\u636e\u5185\u7801", (String)"YzjSyncDataComparePlugin_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        proList.add(idRule);
        CompareRule userIdRule = new CompareRule("userid", "userid", ResManager.loadKDString((String)"\u4eba\u5458\u5185\u7801", (String)"YzjSyncDataComparePlugin_5", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        proList.add(userIdRule);
        proList.addAll(UserCompareRuleSingleton.getInstance().refreshRules());
        CompareRule enable = new CompareRule("status", "enable", ResManager.loadKDString((String)"\u4f7f\u7528\u72b6\u6001", (String)"YzjSyncDataComparePlugin_2", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        proList.add(enable);
        String selectFields = YzjSyncDataComparePlugin.getUserFields(proList);
        if (StringUtils.isBlank((CharSequence)openId)) {
            if (userId == 0L) {
                idFilter = new QFilter("user", "in", (Object)Collections.EMPTY_LIST);
                curFilter = new QFilter("id", "in", (Object)Collections.EMPTY_LIST);
            } else {
                idFilter = new QFilter("user", "=", (Object)userId);
                curFilter = new QFilter("id", "=", (Object)userId);
                String propertyName = reportObj.getString("property");
                if ("phone".equals(propertyName) || "email".equals(propertyName)) {
                    idFilter = idFilter.or(new QFilter(propertyName, "=", reportObj.get("yzjvalue")));
                }
            }
        } else {
            idFilter = new QFilter("useropenid", "=", (Object)openId);
            if (userId == 0L) {
                curFilter = new QFilter("useropenid", "=", (Object)openId);
            } else {
                idFilter = idFilter.or(new QFilter("user", "=", (Object)userId));
                curFilter = new QFilter("id", "=", (Object)userId);
            }
        }
        String operation = reportObj.getString("operation");
        boolean isIdChanged = false;
        if ("edit".equals(operation)) {
            if (propertyList.contains("useropenid")) {
                isIdChanged = true;
            }
        } else if ("enable".equals(operation)) {
            propertyList.add("enable");
        }
        long taskId = reportObj.getLong("task");
        if (isIdChanged && (otherKeyFilter = this.getUserPhoneOrEmailFilter(taskId, openId)) != null) {
            idFilter = idFilter.or(otherKeyFilter);
        }
        HashMap<Integer, String> yzjDataMap = new HashMap<Integer, String>();
        ArrayList<Integer> markList = new ArrayList<Integer>();
        this.showBackupUser(taskId, idFilter, selectFields, proList, markList, isAutomatic, yzjDataMap);
        this.showCurrentUser(curFilter, selectFields, proList, markList, yzjDataMap);
        this.updateEntryGridBackColor("cloud-hub", markList, BACK_COLOR);
        this.updateEntryGridBackColor("before", markList, BACK_COLOR);
        this.updateEntryGridBackColor("after", markList, BACK_COLOR);
        this.updateEntryGridBackColor("current", markList, BACK_COLOR);
    }

    private QFilter getUserPhoneOrEmailFilter(long taskId, String openId) {
        String selectFields = "phone,email";
        QFilter taskFilter = new QFilter("task", "=", (Object)taskId);
        QFilter backuptypeFilter = new QFilter("backuptype", "=", (Object)"cloud-hub");
        QFilter idFilter = new QFilter("useropenid", "=", (Object)openId);
        QFilter[] filters = new QFilter[]{taskFilter, idFilter, backuptypeFilter};
        DynamicObject userObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_yzj_user", (String)selectFields, (QFilter[])filters);
        if (userObj != null) {
            String phone = userObj.getString("phone");
            if (StringUtils.isNotBlank((CharSequence)phone)) {
                return new QFilter("phone", "=", (Object)phone);
            }
            String email = userObj.getString("email");
            if (StringUtils.isNotBlank((CharSequence)email)) {
                return new QFilter("email", "=", (Object)email);
            }
        }
        return null;
    }

    private void showBackupUser(long taskId, QFilter idFilter, String selectFields, List<CompareRule> proList, List<Integer> markList, boolean isAutomatic, Map<Integer, String> yzjDataMap) {
        selectFields = selectFields + ",user,backuptype, user.id userid";
        QFilter taskFilter = new QFilter("task", "=", (Object)taskId);
        QFilter[] filters = new QFilter[]{idFilter, taskFilter};
        DynamicObjectCollection userCol = QueryServiceHelper.query((String)"bos_yzj_user", (String)selectFields, (QFilter[])filters, (String)"entryentity.ispartjob,entryentity.dpt.org");
        HashMap<String, List<DynamicObject>> typeMap = new HashMap<String, List<DynamicObject>>(3);
        if (Utils.isListNotEmpty((List)userCol)) {
            for (DynamicObject user : userCol) {
                String dataType = user.getString("backuptype");
                ArrayList<DynamicObject> userList = (ArrayList<DynamicObject>)typeMap.get(dataType);
                if (userList == null) {
                    userList = new ArrayList<DynamicObject>();
                }
                userList.add(user);
                typeMap.put(dataType, userList);
            }
        }
        this.updataUserClientData(typeMap, proList, markList, isAutomatic, yzjDataMap);
    }

    private void showCurrentUser(QFilter idFilter, String selectFields, List<CompareRule> proList, List<Integer> markList, Map<Integer, String> yzjDataMap) {
        selectFields = selectFields + ",id userid";
        QFilter numberFilter = new QFilter("number", "!=", (Object)"administrator");
        QFilter[] filters = new QFilter[]{idFilter, numberFilter};
        DynamicObjectCollection userCol = QueryServiceHelper.query((String)"bos_user", (String)selectFields, (QFilter[])filters, (String)"entryentity.ispartjob,entryentity.dpt");
        this.updataUserClientData("current", (List<DynamicObject>)userCol, proList, markList, yzjDataMap);
    }

    private static String getUserFields(List<CompareRule> proList) {
        StringBuilder selectFields = new StringBuilder();
        for (CompareRule rule : proList) {
            String fieldName = rule.getDestFld();
            if ("userid".equals(fieldName)) continue;
            selectFields.append(fieldName);
            selectFields.append(",");
        }
        selectFields.append("entryentity.id entryid,entryentity.dpt.name dpt");
        selectFields.append(",entryentity.seq,entryentity.position position");
        selectFields.append(",entryentity.isincharge isincharge,entryentity.ispartjob ispartjob");
        selectFields.append(",entryentity.superior.name superior");
        return selectFields.toString();
    }

    private void updataUserClientData(Map<String, List<DynamicObject>> typeMap, List<CompareRule> proList, List<Integer> markList, boolean isAutomatic, Map<Integer, String> yzjDataMap) {
        this.updataUserClientData("cloud-hub", typeMap.get("cloud-hub"), proList, markList, yzjDataMap);
        this.updataUserClientData("before", typeMap.get("before"), proList, markList, yzjDataMap);
        if (isAutomatic) {
            this.updataUserClientData("after", typeMap.get("after"), proList, markList, yzjDataMap);
        } else {
            String proNameField = "name_after";
            String proValueField = "value_after";
            int index = 0;
            IDataModel model = this.getModel();
            model.createNewEntryRow("after");
            model.setValue(proNameField, (Object)this.getTipTitle(), index);
            model.setValue(proValueField, (Object)ResManager.loadKDString((String)"\u672a\u6267\u884c\u540c\u6b65\uff0c\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u6570\u636e", (String)"YzjSyncDataComparePlugin_3", (String)SYSTEM_TYPE, (Object[])new Object[0]), index);
        }
    }

    private void updataUserClientData(String dataType, List<DynamicObject> objList, List<CompareRule> userProList, List<Integer> markList, Map<Integer, String> yzjDataMap) {
        String proNameField = "name_" + dataType;
        String proValueField = "value_" + dataType;
        int index = 0;
        IDataModel model = this.getModel();
        if (Utils.isListEmpty(objList)) {
            model.createNewEntryRow(dataType);
            model.setValue(proNameField, (Object)this.getTipTitle(), index);
            model.setValue(proValueField, (Object)ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u6570\u636e\u3002", (String)"YzjSyncDataComparePlugin_6", (String)SYSTEM_TYPE, (Object[])new Object[0]), index);
            return;
        }
        ArrayList<Integer> splitList = new ArrayList<Integer>(userProList.size());
        for (CompareRule pro : userProList) {
            String destFld = pro.getDestFld();
            ArrayList<String> openIds = new ArrayList<String>(objList.size());
            for (DynamicObject obj : objList) {
                String openId = obj.getString("useropenid");
                if (openIds.contains(openId)) continue;
                if (index <= model.getEntryRowCount(dataType)) {
                    model.createNewEntryRow(dataType);
                }
                openIds.add(openId);
                model.setValue(proNameField, (Object)pro.getDesc(), index);
                String value = UserSyncUtils.getDiffProShowValue(destFld, obj.get(destFld));
                boolean isMarkSkip = false;
                if ("id".equals(destFld)) {
                    isMarkSkip = true;
                } else if ("userid".equals(destFld)) {
                    isMarkSkip = true;
                    if ("0".equals(value)) {
                        value = "";
                    }
                }
                model.setValue(proValueField, (Object)value, index);
                if (!isMarkSkip) {
                    this.addMarkItemIndex(dataType, index, value, yzjDataMap, markList);
                }
                ++index;
            }
        }
        StringBuilder superiorSb = new StringBuilder();
        boolean isCloudHub = "cloud-hub".equals(dataType);
        for (DynamicObject obj : objList) {
            if (obj.getLong("entryid") == 0L) continue;
            String superior = obj.getString("superior");
            if (StringUtils.isNotBlank((CharSequence)superior)) {
                superiorSb.append(superior);
                superiorSb.append(",");
            }
            if (isCloudHub && obj.get("dpt") == null && StringUtils.isBlank((CharSequence)obj.getString("position"))) continue;
            model.createNewEntryRow(dataType);
            boolean isPartJob = obj.getBoolean("ispartjob");
            String value = "";
            value = isPartJob ? ResManager.loadKDString((String)"\u517c\u804c", (String)"YzjSyncDataComparePlugin_7", (String)SYSTEM_TYPE, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4e3b\u804c", (String)"YzjSyncDataComparePlugin_8", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            model.setValue(proValueField, (Object)value, index);
            splitList.add(index);
            model.createNewEntryRow(dataType);
            model.setValue(proNameField, (Object)ResManager.loadKDString((String)"\u90e8\u95e8", (String)"YzjSyncDataComparePlugin_9", (String)SYSTEM_TYPE, (Object[])new Object[0]), ++index);
            value = obj.getString("dpt");
            model.setValue(proValueField, (Object)value, index);
            this.addMarkItemIndex(dataType, index, value, yzjDataMap, markList);
            model.createNewEntryRow(dataType);
            model.setValue(proNameField, (Object)ResManager.loadKDString((String)"\u804c\u4f4d", (String)"YzjSyncDataComparePlugin_10", (String)SYSTEM_TYPE, (Object[])new Object[0]), ++index);
            value = obj.getString("position");
            model.setValue(proValueField, (Object)value, index);
            this.addMarkItemIndex(dataType, index, value, yzjDataMap, markList);
            model.createNewEntryRow(dataType);
            model.setValue(proNameField, (Object)ResManager.loadKDString((String)"\u8d1f\u8d23\u4eba", (String)"YzjSyncDataComparePlugin_11", (String)SYSTEM_TYPE, (Object[])new Object[0]), ++index);
            value = obj.getBoolean("isincharge") ? ResManager.loadKDString((String)"\u662f", (String)"YzjSyncDataComparePlugin_12", (String)SYSTEM_TYPE, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"YzjSyncDataComparePlugin_13", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            model.setValue(proValueField, (Object)value, index);
            this.addMarkItemIndex(dataType, index, value, yzjDataMap, markList);
            model.createNewEntryRow(dataType);
            model.setValue(proNameField, (Object)ResManager.loadKDString((String)"\u76f4\u63a5\u4e0a\u7ea7", (String)"YzjSyncDataComparePlugin_14", (String)SYSTEM_TYPE, (Object[])new Object[0]), ++index);
            if (isCloudHub) {
                model.setValue(proValueField, (Object)"", index);
            } else {
                model.setValue(proValueField, (Object)superior, index);
            }
            ++index;
        }
        model.createNewEntryRow(dataType);
        model.setValue(proValueField, (Object)ResManager.loadKDString((String)"\u76f4\u63a5\u4e0a\u7ea7", (String)"YzjSyncDataComparePlugin_14", (String)SYSTEM_TYPE, (Object[])new Object[0]), index);
        splitList.add(index);
        model.createNewEntryRow(dataType);
        model.setValue(proNameField, (Object)ResManager.loadKDString((String)"\u59d3\u540d", (String)"YzjSyncDataComparePlugin_15", (String)SYSTEM_TYPE, (Object[])new Object[0]), ++index);
        String superior = "";
        if (StringUtils.isNotBlank((CharSequence)superiorSb)) {
            superior = StringUtils.substringBeforeLast((String)superiorSb.toString(), (String)",");
        }
        model.setValue(proValueField, (Object)superior, index);
        this.addMarkItemIndex(dataType, index, superior, yzjDataMap, markList);
        ++index;
        this.updateEntryGridBackColor(dataType, splitList, SPLIT_COLOR);
    }

    private boolean addMarkItemIndex(String dataType, int index, String value, Map<Integer, String> yzjDataMap, List<Integer> markList) {
        if (markList.contains(index)) {
            return true;
        }
        boolean isMark = false;
        if (value == null) {
            value = "";
        }
        if ("cloud-hub".equals(dataType)) {
            yzjDataMap.put(index, value);
        } else if (!yzjDataMap.isEmpty() && !value.equals(yzjDataMap.get(index))) {
            markList.add(index);
            isMark = true;
        }
        return isMark;
    }

    private void updateEntryGridBackColor(String dataType, List<Integer> rowList, String color) {
        if (Utils.isListEmpty(rowList)) {
            return;
        }
        int index = 0;
        int[] indexArr = new int[rowList.size()];
        for (int rowIndex : rowList) {
            indexArr[index++] = rowIndex;
        }
        EntryGrid grid = (EntryGrid)this.getControl(dataType);
        grid.setRowBackcolor(color, indexArr);
    }

    private String getTipTitle() {
        return ResManager.loadKDString((String)"\u63d0\u793a", (String)"YzjSyncDataComparePlugin_16", (String)SYSTEM_TYPE, (Object[])new Object[0]);
    }
}

