/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.yunzhijia.diff.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.utils.OrgTreeUtils;
import kd.bos.org.utils.Utils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class YzjSyncOrgReferPlugin
extends StandardTreeListPlugin {
    private static final Log log = LogFactory.getLog(YzjSyncOrgReferPlugin.class);
    private static final String NO_ORG = "noOrg";
    private static final String OUT_ORG = "outOrg";
    private static final String PROP_ENTRY_ENTITY_DPT = "entryentity.dpt";
    private static final String SYSTEM_TYPE = "bos-org-formplugin";
    private final String NODE_NAME_UNKNOWN = ResManager.loadKDString((String)"\u672a\u5206\u914d\u90e8\u95e8", (String)"YzjSyncOrgReferPlugin_0", (String)"bos-org-formplugin", (Object[])new Object[0]);
    private final String NODE_NAME_PARTNER = ResManager.loadKDString((String)"\u5408\u4f5c\u4f19\u4f34", (String)"YzjSyncOrgReferPlugin_1", (String)"bos-org-formplugin", (Object[])new Object[0]);

    public void initializeTree(EventObject e) {
        this.initRootNode("cloud-hub");
    }

    private void initRootNode(String backupType) {
        TreeNode root;
        boolean isChangeBackuptype = false;
        if (this.getTreeModel().getRoot() != null) {
            isChangeBackuptype = true;
        }
        if ((root = this.queryRootNode(backupType)) != null) {
            this.getTreeModel().setRoot(root);
            String rootId = root.getId();
            this.getTreeModel().setCurrentNodeId((Object)rootId);
            if (isChangeBackuptype) {
                this.treeListView.getTreeView().deleteAllNodes();
                this.treeListView.getTreeView().addNode(root);
                this.getView().invokeOperation("refresh");
            }
            log.debug("\u884c\u653f\u7ec4\u7ec7\u6811\u6839\u8282\u70b9ID\u4e3a\uff1a" + rootId);
        }
    }

    public void refreshNode(RefreshNodeEvent e) {
        QFilter freezeFilter;
        String nodeId = e.getNodeId().toString();
        if (NO_ORG.equalsIgnoreCase(nodeId) || OUT_ORG.equalsIgnoreCase(nodeId)) {
            return;
        }
        QFilter otherFilter = freezeFilter = new QFilter("isfreeze", "=", (Object)Boolean.FALSE);
        String backupType = this.getModel().getValue("backuptype").toString();
        List<TreeNode> treeNodes = this.queryChildNodes(nodeId, otherFilter, backupType);
        if (nodeId.equals(this.getTreeModel().getRoot().getId())) {
            TreeNode noOrgNode = new TreeNode(nodeId, NO_ORG, this.NODE_NAME_UNKNOWN, false);
            TreeNode outOrgNode = new TreeNode(nodeId, OUT_ORG, this.NODE_NAME_PARTNER, false);
            treeNodes.add(noOrgNode);
            treeNodes.add(outOrgNode);
        }
        e.setChildNodes(treeNodes);
    }

    public void expendTreeNode(TreeNodeEvent e) {
        String nodeId = (String)e.getNodeId();
        if (this.getNode(nodeId) == null) {
            return;
        }
        TreeNode node = this.getTreeListView().getTreeModel().refreshNode((Object)nodeId);
        node.setIsOpened(true);
        e.setExpandedNode(node);
    }

    private TreeNode getNode(Object nodeId) {
        return OrgTreeUtils.getNode((Object)nodeId, (ITreeModel)this.getTreeModel());
    }

    public void treeNodeClick(TreeNodeEvent e) {
        String nodeId = e.getNodeId().toString();
        if (this.getNode(nodeId) == null) {
            return;
        }
        this.treeListView.getTreeView().queryTreeNodeChildren(e.getParentNodeId().toString(), nodeId);
        this.refreshBillList();
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        e.setCancel(true);
        e.addQFilter(this.genRefreshFilter(e.getNodeId().toString()));
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        BillList billList = (BillList)this.getControl("billlistap");
        long taskId = (Long)this.getView().getFormShowParameter().getCustomParam("task");
        String backupType = this.getModel().getValue("backuptype").toString();
        QFilter taskFilter = new QFilter("task", "=", (Object)taskId);
        QFilter backupTypeFilter = new QFilter("backuptype", "=", (Object)backupType);
        taskFilter = taskFilter.and(backupTypeFilter);
        billList.setFilter(taskFilter);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String proName = e.getProperty().getName();
        if ("chkincludechild".equals(proName)) {
            Object currentNodeId = this.getTreeModel().getCurrentNodeId();
            if (StringUtils.isNotBlank((Object)currentNodeId)) {
                TreeView treeView = this.getTreeListView().getTreeView();
                treeView.treeNodeClick("", currentNodeId.toString());
            }
        } else if ("backuptype".equals(proName)) {
            String backupType = this.getModel().getValue("backuptype").toString();
            this.initRootNode(backupType);
        }
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
        evt.setCancel(true);
    }

    private TreeNode queryRootNode(String backupType) {
        TreeNode root = null;
        List<TreeNode> rootNodeList = this.queryChildNodes("", null, backupType);
        if (Utils.isListNotEmpty(rootNodeList)) {
            root = rootNodeList.get(0);
            root.setParentid("");
            root.setIsOpened(true);
        } else {
            LocaleString text = new LocaleString(ResManager.loadKDString((String)"\u5168\u90e8", (String)"YzjSyncOrgReferPlugin_2", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            root = new TreeNode("", "-1", text.getLocaleValue());
        }
        return root;
    }

    private List<TreeNode> queryChildNodes(String parentId, QFilter otherFilter, String backupType) {
        ArrayList<TreeNode> childNodes = new ArrayList<TreeNode>();
        long parentOrgId = 0L;
        if (StringUtils.isNotBlank((CharSequence)parentId)) {
            parentOrgId = Long.parseLong(parentId);
        }
        String selectFields = "id,org.id org,org.name name,parent.id parent,longNumber,isleaf,isfreeze";
        long taskId = (Long)this.getView().getFormShowParameter().getCustomParam("task");
        QFilter taskFilter = new QFilter("org.task", "=", (Object)taskId);
        QFilter backupTypeFilter = new QFilter("org.backuptype", "=", (Object)backupType);
        QFilter parentFilter = new QFilter("parent", "=", (Object)parentOrgId);
        QFilter[] filters = new QFilter[]{taskFilter, backupTypeFilter, parentFilter, otherFilter};
        DynamicObjectCollection subOrgCol = QueryServiceHelper.query((String)"bos_yzj_orgstructure", (String)selectFields, (QFilter[])filters, (String)"sortcode");
        if (Utils.isListEmpty((List)subOrgCol)) {
            return childNodes;
        }
        for (DynamicObject orgObj : subOrgCol) {
            childNodes.add(this.genTreeNode(orgObj));
        }
        return childNodes;
    }

    private TreeNode genTreeNode(DynamicObject orgObj) {
        TreeNode node = new TreeNode();
        node.setId(orgObj.getString("org"));
        String name = orgObj.getString("name");
        if (orgObj.getBoolean("isfreeze")) {
            name = String.format(ResManager.loadKDString((String)"%1$s(\u5c01\u5b58)", (String)"YzjSyncOrgReferPlugin_3", (String)SYSTEM_TYPE, (Object[])new Object[0]), name);
        }
        node.setText(name);
        String parentId = orgObj.getString("parent");
        if ("0".equals(parentId)) {
            parentId = "";
        }
        node.setParentid(parentId);
        node.setLongNumber(orgObj.getString("longnumber"));
        if (!orgObj.getBoolean("isleaf")) {
            node.setChildren(new ArrayList());
        }
        return node;
    }

    private void refreshBillList() {
        BillList billList = (BillList)this.getControl("billlistap");
        billList.getEntryState().setCurrentPageIndex(Integer.valueOf(0));
        billList.refresh();
    }

    private QFilter genRefreshFilter(String nodeId) {
        if (StringUtils.isBlank((CharSequence)nodeId)) {
            return null;
        }
        QFilter qFilter = null;
        long taskId = (Long)this.getView().getFormShowParameter().getCustomParam("task");
        QFilter taskFilter = new QFilter("task", "=", (Object)taskId);
        String backupType = this.getModel().getValue("backuptype").toString();
        QFilter backupTypeFilter = new QFilter("backuptype", "=", (Object)backupType);
        if (NO_ORG.equals(nodeId)) {
            qFilter = new QFilter("usertype", "=", (Object)"1");
            QFilter dptFilter = QFilter.isNull((String)PROP_ENTRY_ENTITY_DPT);
            QFilter[] qFilterDp = new QFilter[]{dptFilter, qFilter, backupTypeFilter, taskFilter};
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bos_yzj_user", (String)"id", (QFilter[])qFilterDp, null);
            ArrayList<Long> userIds = null;
            if (Utils.isListEmpty((List)dynamicObjects)) {
                userIds = new ArrayList<Long>(0);
            } else {
                userIds = new ArrayList(dynamicObjects.size());
                for (DynamicObject dynamicObject : dynamicObjects) {
                    userIds.add(dynamicObject.getLong("id"));
                }
            }
            QFilter idFilter = new QFilter("id", "in", userIds);
            qFilter = qFilter.and(idFilter);
        } else if (OUT_ORG.equals(nodeId)) {
            qFilter = new QFilter("usertype", "!=", (Object)"1");
        } else {
            qFilter = new QFilter("usertype", "=", (Object)"1");
            long orgId = Long.parseLong(nodeId);
            QFilter orgFilter = null;
            if (Boolean.parseBoolean(this.getModel().getValue("chkincludechild").toString())) {
                List<Long> subOrgIds = this.getSubOrgId(orgId);
                orgFilter = new QFilter(PROP_ENTRY_ENTITY_DPT, "in", subOrgIds);
            } else {
                orgFilter = new QFilter(PROP_ENTRY_ENTITY_DPT, "=", (Object)orgId);
            }
            qFilter = qFilter.and(orgFilter);
        }
        if (qFilter == null) {
            return taskFilter;
        }
        qFilter = qFilter.and(taskFilter);
        return qFilter;
    }

    public void setFilter(SetFilterEvent e) {
        List filters = e.getQFilters();
        QFilter usertypeFilter = new QFilter("usertype", "=", (Object)"1");
        filters.add(usertypeFilter);
        String backupType = this.getModel().getValue("backuptype").toString();
        QFilter backupTypeFilter = new QFilter("backuptype", "=", (Object)backupType);
        filters.add(backupTypeFilter);
    }

    private List<Long> getSubOrgId(long orgId) {
        long taskId = (Long)this.getView().getFormShowParameter().getCustomParam("task");
        String selectFields = "id,org,longnumber";
        String backupType = this.getModel().getValue("backuptype").toString();
        QFilter taskFilter = new QFilter("org.task", "=", (Object)taskId);
        QFilter backupTypeFilter = new QFilter("org.backuptype", "=", (Object)backupType);
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter[] filters = new QFilter[]{taskFilter, backupTypeFilter, orgFilter};
        DynamicObjectCollection orgCol = QueryServiceHelper.query((String)"bos_yzj_orgstructure", (String)selectFields, (QFilter[])filters, (String)"sortcode");
        ArrayList<Long> orgIds = new ArrayList<Long>();
        orgIds.add(orgId);
        if (Utils.isListEmpty((List)orgCol)) {
            return orgIds;
        }
        String longnumber = ((DynamicObject)orgCol.get(0)).getString("longnumber");
        QFilter longnumberFilter = new QFilter("longnumber", "like", (Object)(longnumber + "!" + "%"));
        filters = new QFilter[]{taskFilter, backupTypeFilter, longnumberFilter};
        orgCol = QueryServiceHelper.query((String)"bos_yzj_orgstructure", (String)selectFields, (QFilter[])filters, (String)"sortcode");
        if (Utils.isListEmpty((List)orgCol)) {
            return orgIds;
        }
        for (DynamicObject org : orgCol) {
            orgIds.add(org.getLong("org"));
        }
        return orgIds;
    }
}

