/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.yunzhijia.diff.plugin;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.EventObject;
import java.util.List;
import kd.bos.base.utils.msg.BaseMessage;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.org.utils.Utils;
import kd.bos.org.yunzhijia.diff.impl.YzjSyncTaskAction;
import kd.bos.org.yunzhijia.diff.impl.utils.YzjSyncCache;
import kd.bos.org.yunzhijia.diff.impl.utils.YzjSyncImplUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.yzj.config.YzjConfigServiceHelper;
import kd.bos.yzj.model.YzjConfig;

public class YzjSyncReportListPlugin
extends AbstractListPlugin {
    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"toolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object paramTaskId = formShowParameter.getCustomParam("task");
        if (StringUtils.isBlank((Object)paramTaskId)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btn_sync", "btn_all", "btn_org"});
        } else {
            String name;
            Boolean isLatest = (Boolean)formShowParameter.getCustomParam("islatest");
            if (isLatest == null || !isLatest.booleanValue()) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"btn_sync", "btn_all"});
            }
            if (StringUtils.isNotBlank((CharSequence)(name = (String)formShowParameter.getCustomParam("name"))) && name.startsWith("Account-")) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"btn_org"});
            }
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        IListColumn taskColumn;
        super.beforeCreateListColumns(args);
        Object paramTaskId = this.getView().getFormShowParameter().getCustomParam("task");
        if (StringUtils.isNotBlank((Object)paramTaskId) && (taskColumn = args.getListColumn("task.name")) != null) {
            taskColumn.setVisible(0);
        }
    }

    public void setFilter(SetFilterEvent e) {
        Object paramTaskId;
        List filters = e.getQFilters();
        if (filters != null && StringUtils.isNotBlank((Object)(paramTaskId = this.getView().getFormShowParameter().getCustomParam("task")))) {
            QFilter taskFilter = new QFilter("task.id", "=", paramTaskId);
            filters.add(taskFilter);
        }
        super.setFilter(e);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("btn_sync".equals(itemKey)) {
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            if (Utils.isListEmpty((List)selectedRows)) {
                this.getView().showTipNotification(BaseMessage.getMessage((String)"M00020"));
                evt.setCancel(true);
            } else {
                ArrayList<Object> reportIds = new ArrayList<Object>(selectedRows.size());
                for (ListSelectedRow row : selectedRows) {
                    reportIds.add(row.getPrimaryKeyValue());
                }
                QFilter statusFilter = new QFilter("status", "=", (Object)Integer.toString(0));
                QFilter idFilter = new QFilter("id", "in", reportIds);
                QFilter[] filters = new QFilter[]{statusFilter, idFilter};
                if (!QueryServiceHelper.exists((String)"bos_yzj_syncreport", (QFilter[])filters)) {
                    this.getView().showTipNotification(BaseMessage.getMessage((String)"M00063"));
                    evt.setCancel(true);
                }
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        boolean checkTaskRunning;
        String itemKey = evt.getItemKey();
        boolean bl = checkTaskRunning = "btn_sync".equals(itemKey) || "btn_all".equals(itemKey);
        if (checkTaskRunning && YzjSyncCache.isTaskRunning()) {
            YzjSyncImplUtils.showProgressForm(this.getView(), (IFormPlugin)this);
            return;
        }
        if ("btn_sync".equals(itemKey)) {
            String confirmMsg = BaseMessage.getMessage((String)"M00043");
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("btn_sync", (IFormPlugin)this);
            this.getView().showConfirm(confirmMsg, MessageBoxOptions.YesNo, confirmCallBacks);
        } else if ("btn_all".equals(itemKey)) {
            String selectFields = "id,islatest,starttime";
            long taskId = (Long)this.getView().getFormShowParameter().getCustomParam("task");
            QFilter idFilter = new QFilter("id", "=", (Object)taskId);
            QFilter[] qFilters = new QFilter[]{idFilter};
            DynamicObjectCollection taskCol = QueryServiceHelper.query((String)"bos_yzj_synctask", (String)selectFields, (QFilter[])qFilters);
            if (Utils.isListEmpty((List)taskCol)) {
                this.getView().showTipNotification(BaseMessage.getMessage((String)"M00045"));
                return;
            }
            DynamicObject taskObj = (DynamicObject)taskCol.get(0);
            if (!taskObj.getBoolean("islatest")) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"btn_sync", "btn_all"});
                this.getView().showTipNotification(BaseMessage.getMessage((String)"M00046"));
                return;
            }
            Calendar cal = Calendar.getInstance();
            cal.add(11, -1);
            if (cal.getTime().after(taskObj.getDate("starttime"))) {
                String confirmMsg = BaseMessage.getMessage((String)"M00047");
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("btn_all", (IFormPlugin)this);
                this.getView().showConfirm(confirmMsg, MessageBoxOptions.YesNo, confirmCallBacks);
            } else if (!this.isAutoSyncCountOverLimit(taskId)) {
                String confirmMsg = BaseMessage.getMessage((String)"M00044");
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("btn_all", (IFormPlugin)this);
                this.getView().showConfirm(confirmMsg, MessageBoxOptions.YesNo, confirmCallBacks);
            }
        } else if ("btn_org".equals(itemKey)) {
            ListShowParameter formShowParameter = new ListShowParameter();
            formShowParameter.setFormId("bos_yzj_orgrefer");
            formShowParameter.setBillFormId("bos_yzj_user");
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            Object taskId = this.getView().getFormShowParameter().getCustomParam("task");
            formShowParameter.setCustomParam("task", taskId);
            QFilter taskFilter = new QFilter("task", "=", taskId);
            formShowParameter.getListFilterParameter().getQFilters().add(taskFilter);
            this.getView().showForm((FormShowParameter)formShowParameter);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        if (event.getResult() != MessageBoxResult.Yes) {
            return;
        }
        final String callBackId = event.getCallBackId();
        if (!"btn_sync".equals(callBackId) && !"btn_all".equals(callBackId)) {
            return;
        }
        final long taskId = (Long)this.getView().getFormShowParameter().getCustomParam("task");
        try {
            YzjSyncCache.startTaskProgress();
            YzjSyncImplUtils.showProgressForm(this.getView(), (IFormPlugin)this);
            ThreadPools.executeOnceIncludeRequestContext((String)("YzjSyncTask_Manual_Update_" + callBackId), (Runnable)new Runnable(){

                @Override
                public void run() {
                    YzjSyncReportListPlugin.this.runSyncTask(taskId, callBackId);
                    YzjSyncCache.finishTaskProgress();
                    YzjSyncCache.removeTaskStatus();
                }
            });
        }
        catch (Exception e) {
            YzjSyncCache.removeTaskStatus();
            String errorMsg = e.getMessage();
            YzjSyncCache.updateTaskFailProgress(errorMsg);
            throw new KDBizException(errorMsg);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        if ("bos_yzj_syncprogress".equals(evt.getActionId())) {
            this.refreshBillList();
        }
    }

    private void refreshBillList() {
        BillList billList = (BillList)this.getControl("billlistap");
        billList.refresh();
    }

    private void runSyncTask(long taskId, String callBackId) {
        if ("btn_sync".equals(callBackId)) {
            this.syncSelected(taskId);
        } else if ("btn_all".equals(callBackId)) {
            this.syncAll(taskId);
        }
    }

    private boolean isAutoSyncCountOverLimit(long taskId) {
        YzjConfig yzjConfig = YzjConfigServiceHelper.getParameterConfig();
        QFilter taskFilter = new QFilter("task", "=", (Object)taskId);
        QFilter typeFilter = new QFilter("datatype", "=", (Object)"org");
        QFilter statusFilter = new QFilter("status", "=", (Object)Integer.toString(0));
        QFilter operFilter = new QFilter("entryentity.operation", "=", (Object)"freeze");
        QFilter[] filters = new QFilter[]{taskFilter, typeFilter, statusFilter, operFilter};
        String selectFields = "count(1) synccount";
        DynamicObject countObj = QueryServiceHelper.queryOne((String)"bos_yzj_syncreport", (String)selectFields, (QFilter[])filters);
        boolean isOrgOverLimit = false;
        if (countObj != null && yzjConfig.getOrgDisableLimit() <= countObj.getInt("synccount")) {
            isOrgOverLimit = true;
        }
        typeFilter = new QFilter("datatype", "=", (Object)"user");
        operFilter = new QFilter("entryentity.operation", "=", (Object)"disable");
        filters = new QFilter[]{taskFilter, typeFilter, statusFilter, operFilter};
        countObj = QueryServiceHelper.queryOne((String)"bos_yzj_syncreport", (String)selectFields, (QFilter[])filters);
        boolean isUserOverLimit = false;
        if (countObj != null && yzjConfig.getUserDisableLimit() <= countObj.getInt("synccount")) {
            isUserOverLimit = true;
        }
        if (isOrgOverLimit && isUserOverLimit) {
            String confirmMsg = BaseMessage.getMessage((String)"M00049");
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("btn_all", (IFormPlugin)this);
            this.getView().showConfirm(confirmMsg, MessageBoxOptions.YesNo, confirmCallBacks);
            return true;
        }
        if (isOrgOverLimit) {
            String confirmMsg = BaseMessage.getMessage((String)"M00050");
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("btn_all", (IFormPlugin)this);
            this.getView().showConfirm(confirmMsg, MessageBoxOptions.YesNo, confirmCallBacks);
            return true;
        }
        if (isUserOverLimit) {
            String confirmMsg = BaseMessage.getMessage((String)"M00051");
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("btn_all", (IFormPlugin)this);
            this.getView().showConfirm(confirmMsg, MessageBoxOptions.YesNo, confirmCallBacks);
            return true;
        }
        return false;
    }

    private void syncAll(long taskId) {
        BillList billList = (BillList)this.getControl("billlistap");
        YzjSyncTaskAction.syncAll(taskId);
        this.getView().showSuccessNotification(BaseMessage.getMessage((String)"M00052"));
        billList.refresh();
    }

    private void syncSelected(long taskId) {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection rows = billList.getSelectedRows();
        ArrayList<Long> reportIds = new ArrayList<Long>(rows.size());
        for (ListSelectedRow row : rows) {
            reportIds.add(Long.valueOf(row.getPrimaryKeyValue().toString()));
        }
        if (this.isIncludeException(reportIds)) {
            this.getView().showTipNotification(BaseMessage.getMessage((String)"M00054"));
            return;
        }
        YzjSyncTaskAction.syncByReportId(taskId, reportIds);
        this.getView().showSuccessNotification(BaseMessage.getMessage((String)"M00052"));
        billList.refresh();
    }

    private boolean isIncludeException(List<Long> reportIds) {
        QFilter idFilter = new QFilter("id", "in", reportIds);
        QFilter typeFilter = new QFilter("datatype", "=", (Object)"user");
        QFilter statusFilter = new QFilter("status", "=", (Object)Integer.toString(3));
        QFilter[] filters = new QFilter[]{idFilter, typeFilter, statusFilter};
        return QueryServiceHelper.exists((String)"bos_yzj_syncreport", (QFilter[])filters);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs evt) {
        evt.setCancel(true);
        this.showForm(evt.getHyperLinkClickEvent().getRowIndex());
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
        evt.setCancel(true);
        this.showForm(evt.getRow());
    }

    private void showForm(int rowIndex) {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection col = billList.getSelectedRows();
        if (Utils.isListEmpty((List)col)) {
            return;
        }
        for (ListSelectedRow listRow : col) {
            if (rowIndex != listRow.getRowKey()) continue;
            String reportId = listRow.getPrimaryKeyValue().toString();
            String pageId = this.getView().getPageId();
            String newPageId = pageId + "|" + reportId;
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("bos_yzj_datacompare");
            formShowParameter.setPageId(newPageId);
            IFormView iformView = this.getView().getView(newPageId);
            if (iformView != null) {
                iformView.activate();
                this.getView().sendFormAction(iformView);
                return;
            }
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            formShowParameter.setCustomParam("id", listRow.getPrimaryKeyValue());
            this.getView().showForm(formShowParameter);
            break;
        }
    }
}

