/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.yunzhijia.diff.plugin;

import java.util.HashMap;
import kd.bos.base.utils.msg.BaseMessage;
import kd.bos.base.utils.msg.OrgMessage;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.org.yunzhijia.diff.impl.YzjSyncTaskAction;
import kd.bos.org.yunzhijia.diff.impl.utils.YzjSyncCache;
import kd.bos.org.yunzhijia.diff.impl.utils.YzjSyncImplUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.yzj.config.YzjConfigServiceHelper;
import kd.bos.yzj.model.YzjConfig;

public class YzjSyncTaskListPlugin
extends AbstractListPlugin
implements ListRowClickListener {
    private static final String BTN_CHECKOPENID = "btn_checkopenid";
    private static final String CHECKOPENID = "checkopenid";
    private static final String CHECK = "check";
    private static final String CHECKANDSYNC = "checkandsync";
    private static final String REMOVERUNNINGCACHE = "removerunningcache";
    private static final String BTN_INITCONFIG = "btn_initconfig";
    private static final String SYSTEM_TYPE = "bos-org-formplugin";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"toolbarap"});
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (("btn_report".equals(itemKey) || "btn_sync".equals(itemKey) || BTN_CHECKOPENID.equals(itemKey)) && 2 != YzjConfigServiceHelper.getParameterConfig().getSyncMode()) {
            evt.setCancel(true);
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("btn_config_edit", (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"YzjSyncTaskListPlugin_0", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u53bb\u4fee\u6539\u53c2\u6570", (String)"YzjSyncTaskListPlugin_1", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            this.getView().showConfirm(BaseMessage.getMessage((String)"M00055"), "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
        }
    }

    public void itemClick(ItemClickEvent evt) {
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        boolean checkTaskRunning;
        String operateKey = args.getOperateKey();
        boolean bl = checkTaskRunning = CHECK.equals(operateKey) || CHECKANDSYNC.equals(operateKey) || CHECKOPENID.equals(operateKey);
        if (checkTaskRunning && YzjSyncCache.isTaskRunning()) {
            YzjSyncImplUtils.showProgressForm(this.getView(), (IFormPlugin)this);
            return;
        }
        if (REMOVERUNNINGCACHE.equals(operateKey)) {
            YzjSyncCache.removeTaskStatus();
            YzjSyncCache.removeTaskProgress();
            this.getView().showSuccessNotification(BaseMessage.getMessage((String)"M00052"));
        } else if (CHECKOPENID.equals(operateKey)) {
            String confirmMsg = OrgMessage.getMessage((String)"M00234");
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(BTN_CHECKOPENID, (IFormPlugin)this);
            this.getView().showConfirm(confirmMsg, MessageBoxOptions.YesNo, confirmCallBacks);
        } else if (CHECK.equals(operateKey)) {
            String confirmMsg = BaseMessage.getMessage((String)"M00056");
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("btn_report", (IFormPlugin)this);
            this.getView().showConfirm(confirmMsg, MessageBoxOptions.YesNo, confirmCallBacks);
        } else if (CHECKANDSYNC.equals(operateKey)) {
            String confirmMsg = BaseMessage.getMessage((String)"M00057");
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("btn_sync", (IFormPlugin)this);
            this.getView().showConfirm(confirmMsg, MessageBoxOptions.YesNo, confirmCallBacks);
        } else if ("btn_search".equals(operateKey)) {
            this.showSearchForm();
        } else if (BTN_INITCONFIG.equals(operateKey)) {
            this.showConfigForm();
        }
    }

    private void showConfigForm() {
        YzjSyncImplUtils.openSysParameterPage(this.getView(), false);
    }

    private void showSearchForm() {
        ListShowParameter para = new ListShowParameter();
        String formId = "bos_yzj_syncreport";
        String key = formId + "|" + "btn_search";
        if (this.isOpenedTab(para, key)) {
            return;
        }
        para.setBillFormId(formId);
        para.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        FormConfig formConfig = FormMetadataCache.getListFormConfig((String)formId);
        para.setFormId(formConfig.getListFormId());
        para.setShowTitle(false);
        para.setHasRight(true);
        para.setCaption(ResManager.loadKDString((String)"\u4e91\u4e4b\u5bb6\u5dee\u5f02\u5bf9\u6bd4\u5386\u53f2\u62a5\u544a", (String)"YzjSyncTaskListPlugin_2", (String)SYSTEM_TYPE, (Object[])new Object[0]));
        this.getView().showForm((FormShowParameter)para);
    }

    private boolean isOpenedTab(ListShowParameter para, Object key) {
        String pageId = this.getView().getPageId();
        String newPageId = pageId + "|" + key;
        para.setPageId(newPageId);
        IFormView iformView = this.getView().getView(newPageId);
        if (iformView != null) {
            iformView.activate();
            this.getView().sendFormAction(iformView);
            return true;
        }
        return false;
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        if (event.getResult() != MessageBoxResult.Yes) {
            return;
        }
        final String callBackId = event.getCallBackId();
        if ("btn_config_edit".equals(callBackId)) {
            YzjSyncImplUtils.openSysParameterPage(this.getView(), false);
            return;
        }
        YzjSyncCache.startTaskProgress();
        YzjSyncImplUtils.showProgressForm(this.getView(), (IFormPlugin)this);
        ThreadPools.executeOnceIncludeRequestContext((String)("YzjSyncTask_Manual_Compare_" + callBackId), (Runnable)new Runnable(){

            @Override
            public void run() {
                YzjSyncTaskListPlugin.this.runSyncTask(callBackId);
                YzjSyncTaskListPlugin.this.refreshBillList();
            }
        });
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        if ("bos_yzj_syncprogress".equals(evt.getActionId())) {
            this.refreshBillList();
        }
    }

    private void refreshBillList() {
        BillList billList = (BillList)this.getControl("billlistap");
        billList.refresh();
    }

    private void runSyncTask(String callBackId) {
        String result = "";
        YzjConfig yzjConfig = YzjConfigServiceHelper.getConfig();
        if ("btn_report".equals(callBackId)) {
            yzjConfig.setStartModel(1);
            yzjConfig.setAutoSync(false);
            result = YzjSyncTaskAction.start(yzjConfig);
        } else if ("btn_sync".equals(callBackId)) {
            yzjConfig.setStartModel(1);
            yzjConfig.setAutoSync(true);
            result = YzjSyncTaskAction.start(yzjConfig);
        } else if (BTN_CHECKOPENID.equals(callBackId)) {
            yzjConfig.setStartModel(2);
            yzjConfig.setAutoSync(false);
            result = YzjSyncTaskAction.start(yzjConfig);
        }
        if (StringUtils.isNotBlank((CharSequence)result)) {
            this.getView().showErrorNotification(result);
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs evt) {
        evt.setCancel(true);
        this.showReportForm();
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
        evt.setCancel(true);
        this.showReportForm();
    }

    private void showReportForm() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRow currentSelectedRow = billList.getCurrentSelectedRowInfo();
        if (currentSelectedRow == null) {
            return;
        }
        ListShowParameter formShowParameter = new ListShowParameter();
        Object pk = currentSelectedRow.getPrimaryKeyValue();
        if (this.isOpenedTab(formShowParameter, pk.toString())) {
            return;
        }
        String selectFields = "id,name,islatest,unsynccount";
        DynamicObject taskObj = BusinessDataServiceHelper.loadSingleFromCache((Object)pk, (String)"bos_yzj_synctask", (String)selectFields);
        if (taskObj != null) {
            boolean isLatest = taskObj.getBoolean("islatest");
            if (isLatest) {
                if (YzjSyncCache.isTaskRunning()) {
                    YzjSyncImplUtils.showProgressForm(this.getView(), (IFormPlugin)this);
                    return;
                }
            } else {
                formShowParameter.setCaption(ResManager.loadKDString((String)"\u4e91\u4e4b\u5bb6\u5dee\u5f02\u5bf9\u6bd4\u5386\u53f2\u62a5\u544a", (String)"YzjSyncTaskListPlugin_2", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            }
            int unSyncCount = taskObj.getInt("unsynccount");
            String name = taskObj.getString("name");
            formShowParameter.setCustomParam("task", pk);
            formShowParameter.setCustomParam("islatest", (Object)isLatest);
            formShowParameter.setCustomParam("unsynccount", (Object)unSyncCount);
            formShowParameter.setCustomParam("name", (Object)name);
        }
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setBillFormId("bos_yzj_syncreport");
        this.getView().showForm((FormShowParameter)formShowParameter);
    }
}

