/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.yunzhijia.diff.plugin;

import java.util.EventObject;
import java.util.Map;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.org.yunzhijia.diff.impl.utils.YzjSyncCache;
import kd.bos.orm.util.CollectionUtils;

public class YzjSyncTaskProgressPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final String KEY_PROGRESSBAR = "progressbarap";
    private static final String KEY_PROGRESS_DETAIL = "progressdetail";
    private static final String KEY_PROGRESS_PERCENT = "progresspercent";
    private static final String IMG_RUNNING = "running";
    private static final String IMG_FAIL = "fail";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar progressBar = (ProgressBar)this.getControl(KEY_PROGRESSBAR);
        if (progressBar != null) {
            progressBar.addProgressListener((ProgresssListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        ProgressBar bar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
        bar.setPercent(this.updateProgress());
        bar.start();
    }

    public void onProgress(ProgressEvent evt) {
        evt.setProgress(this.updateProgress());
    }

    private int updateProgress() {
        Map<String, Object> progressMap = YzjSyncCache.getTaskProgressInfo();
        int progress = 0;
        String detail = "";
        int status = 0;
        if (!CollectionUtils.isEmpty(progressMap)) {
            progress = (Integer)progressMap.get("progress");
            detail = (String)progressMap.get("detail");
            status = (Integer)progressMap.get("status");
        }
        Label detailLabel = (Label)this.getControl(KEY_PROGRESS_DETAIL);
        detailLabel.setText(detail);
        Label percentLabel = (Label)this.getControl(KEY_PROGRESS_PERCENT);
        percentLabel.setText(progress + "%");
        this.updateStatus(progress, status);
        return progress;
    }

    private void updateStatus(int progress, int status) {
        boolean end = false;
        if (1 == status) {
            this.getView().setVisible(Boolean.TRUE, new String[]{IMG_RUNNING});
            this.getView().setVisible(Boolean.FALSE, new String[]{"success", IMG_FAIL});
        } else if (2 == status) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"success"});
            this.getView().setVisible(Boolean.FALSE, new String[]{IMG_FAIL, IMG_RUNNING});
            end = true;
        } else if (3 == status) {
            this.getView().setVisible(Boolean.TRUE, new String[]{IMG_FAIL});
            this.getView().setVisible(Boolean.FALSE, new String[]{"success", IMG_RUNNING});
            end = true;
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{IMG_RUNNING, "success", IMG_FAIL});
            end = true;
        }
        if (end || progress >= 100) {
            ProgressBar bar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
            bar.stop();
        }
    }
}

