/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orgview;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.utils.msg.BaseMessage;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.org.utils.OrgViewUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.yzj.interfaces.IYzjOrgService;
import kd.bos.yzj.model.org.YzjOrgParam;
import kd.bos.yzj.service.YzjServiceFactory;

public class AdminOrgSortPlugin
extends AbstractFormPlugin {
    private static final String IMG_IS_FREEZE = "/icons/pc/state/already_processed.png";
    private static final String CACHE_KEY_FREEZE = "freeze_org";

    public void initialize() {
        this.addClickListeners(new String[]{"btnsave"});
        this.addItemClickListeners(new String[]{"toolbar"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map paramMap = this.getView().getFormShowParameter().getCustomParams();
        if (paramMap != null) {
            this.initOrgEntryEntity(paramMap);
        }
    }

    private void initOrgEntryEntity(Map<String, Object> paramMap) {
        QFilter[] filters = this.getOrgFilters(paramMap);
        String selectFields = "id,org.id org,level,isfreeze,sortcode";
        String orderBys = "level,sortcode,longnumber";
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"kd.bos.orgview.AdminOrgSortPlugin.initOrgEntryEntity", (String)"bos_org_structure", (String)selectFields, (QFilter[])filters, (String)orderBys);){
            IDataModel model = this.getModel();
            int rowIndex = 0;
            HashMap<String, String> sortcodeMap = new HashMap<String, String>();
            HashMap<String, Boolean> freezeMap = new HashMap<String, Boolean>(16);
            for (Row orgObj : ds) {
                model.createNewEntryRow("entryentity");
                String orgId = orgObj.getString("org");
                model.setValue("id", (Object)orgId, rowIndex);
                model.setValue("org", (Object)orgId, rowIndex);
                model.setValue("level", (Object)orgObj.getInteger("level"), rowIndex);
                Boolean isFreeze = orgObj.getBoolean("isfreeze");
                if (isFreeze.booleanValue()) {
                    model.setValue("isfreeze", (Object)IMG_IS_FREEZE, rowIndex);
                }
                sortcodeMap.put(orgId, orgObj.getString("sortcode"));
                freezeMap.put(orgId, isFreeze);
                ++rowIndex;
            }
            this.getPageCache().put("sortcode", SerializationUtils.toJsonString(sortcodeMap));
            this.getPageCache().put(CACHE_KEY_FREEZE, SerializationUtils.toJsonString(freezeMap));
        }
    }

    private QFilter[] getOrgFilters(Map<String, Object> paramMap) {
        Long parentId = 0L;
        Object parentIdParam = paramMap.get("parent");
        if (StringUtils.isNotBlank((Object)parentIdParam)) {
            parentId = Long.valueOf(parentIdParam.toString());
        }
        QFilter viewFilter = OrgViewUtils.getOrgViewFilter((String)"01");
        QFilter orgFilter = new QFilter("parent", "=", (Object)parentId);
        Object value = this.getModel().getValue("isshowdisabled");
        if (!Boolean.parseBoolean(value.toString())) {
            QFilter freezeFilter = new QFilter("isfreeze", "=", (Object)Boolean.FALSE);
            return new QFilter[]{viewFilter, orgFilter, freezeFilter};
        }
        return new QFilter[]{viewFilter, orgFilter};
    }

    public void click(EventObject evt) {
        String itemkey;
        Control c = (Control)evt.getSource();
        switch (itemkey = c.getKey().toLowerCase()) {
            case "btnsave": {
                this.save();
                break;
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String isChangedCache = this.getPageCache().get("ischanged");
        if (StringUtils.isBlank((CharSequence)isChangedCache)) {
            this.getView().returnDataToParent(null);
        } else {
            HashMap<String, Boolean> returnData = new HashMap<String, Boolean>(1);
            returnData.put("ischanged", Boolean.TRUE);
            this.getView().returnDataToParent(returnData);
        }
    }

    private void save() {
        HashMap<String, String> oldSortcodeMap = new HashMap();
        String oldSortcodeMapCache = this.getPageCache().get("sortcode");
        if (StringUtils.isNotBlank((CharSequence)oldSortcodeMapCache)) {
            oldSortcodeMap = (Map)SerializationUtils.fromJsonString((String)oldSortcodeMapCache, Map.class);
        }
        ArrayList<Long> resortOrgList = new ArrayList<Long>();
        this.findChangedRecord(oldSortcodeMap, resortOrgList);
        if (resortOrgList.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6392\u5e8f\u672a\u53d1\u751f\u6539\u53d8\uff0c\u4e0d\u9700\u8981\u6267\u884c\u4fdd\u5b58\u3002", (String)"AdminOrgSortPlugin_0", (String)"bos-org-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getPageCache().put("ischanged", "true");
        this.getPageCache().put("sortcode", SerializationUtils.toJsonString(oldSortcodeMap));
        List<YzjOrgParam> orgModelList = this.save(oldSortcodeMap, resortOrgList);
        this.updateYunzhijiaOrgWeight(orgModelList);
        this.getModel().setDataChanged(false);
        this.getView().close();
    }

    private List<YzjOrgParam> save(Map<String, String> oldSortcodeMap, List<Long> resortOrgList) {
        QFilter orgFilter;
        String selectProperties = "id,org,parent,yzjorgid,level,isleaf,isfreeze,sortcode";
        QFilter viewFilter = OrgViewUtils.getOrgViewFilter((String)"01");
        QFilter[] filters = new QFilter[]{viewFilter, orgFilter = new QFilter("org", "in", resortOrgList)};
        DynamicObject[] orgArr = BusinessDataServiceHelper.load((String)"bos_org_structure", (String)selectProperties, (QFilter[])filters);
        if (orgArr == null || orgArr.length == 0) {
            return new ArrayList<YzjOrgParam>();
        }
        ArrayList<YzjOrgParam> orgModelList = new ArrayList<YzjOrgParam>(orgArr.length);
        String parentOrgName = "";
        for (DynamicObject orgStructure : orgArr) {
            DynamicObject org = orgStructure.getDynamicObject("org");
            if (org == null) continue;
            DynamicObject parent = orgStructure.getDynamicObject("parent");
            if (parent != null) {
                parentOrgName = parent.getString("name");
            }
            String newSortCode = oldSortcodeMap.get(org.getString("id"));
            orgStructure.set("sortcode", (Object)newSortCode);
            if (orgStructure.getBoolean("isfreeze")) continue;
            YzjOrgParam yzjOrg = new YzjOrgParam();
            yzjOrg.setYzjOrgId(orgStructure.getString("yzjorgid"));
            yzjOrg.setSortCode(newSortCode);
            orgModelList.add(yzjOrg);
        }
        SaveServiceHelper.save((DynamicObject[])orgArr);
        LogServiceHelper.addLog((IFormView)this.getView(), (String)ResManager.loadKDString((String)"\u6392\u5e8f", (String)"AdminOrgSortPlugin_1", (String)"bos-org-formplugin", (Object[])new Object[0]), (String)String.format(ResManager.loadKDString((String)"\u5bf9[%s]\u4e0b\u7ea7\u884c\u653f\u7ec4\u7ec7\u8fdb\u884c\u91cd\u65b0\u6392\u5e8f", (String)"AdminOrgSortPlugin_2", (String)"bos-org-formplugin", (Object[])new Object[0]), parentOrgName));
        return orgModelList;
    }

    private void findChangedRecord(Map<String, String> oldSortcodeMap, List<Long> resortOrgList) {
        int sortCode = 1;
        DynamicObjectCollection orgCol = this.getModel().getEntryEntity("entryentity");
        for (DynamicObject orgField : orgCol) {
            String oldSortCode;
            DynamicObject orgObj = orgField.getDynamicObject("org");
            if (orgObj == null) continue;
            String orgId = orgObj.getString("id");
            int level = orgField.getInt("level");
            String newSortCode = Integer.toString(OrgViewUtils.getOrgSortCode((int)level, (int)sortCode++));
            if (newSortCode.equals(oldSortCode = oldSortcodeMap.get(orgId))) continue;
            resortOrgList.add(orgObj.getLong("id"));
            oldSortcodeMap.put(orgId, newSortCode);
        }
    }

    private void updateYunzhijiaOrgWeight(List<YzjOrgParam> orgModelList) {
        IYzjOrgService orgService = YzjServiceFactory.getOrgService();
        orgService.updateWeightById(orgModelList);
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] selectRows = entryGrid.getEntryState().getSelectedRows();
        if (selectRows == null || selectRows.length == 0) {
            this.getView().showTipNotification(BaseMessage.getMessage((String)"M00020"));
            return;
        }
        this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5728\u5904\u7406\uff0c\u8bf7\u7a0d\u7b49\u3002", (String)"AdminOrgSortPlugin_3", (String)"bos-org-formplugin", (Object[])new Object[0])));
        int rowCount = this.getModel().getEntryEntity("entryentity").size();
        switch (itemKey = evt.getItemKey().toLowerCase()) {
            case "tbl_top": {
                int startIndex = 0;
                this.sort(entryGrid, selectRows, startIndex);
                break;
            }
            case "tbl_up": {
                int startIndex = selectRows[0] == 0 ? 0 : selectRows[0] - 1;
                this.sort(entryGrid, selectRows, startIndex);
                break;
            }
            case "tbl_down": {
                int startIndex = selectRows[0] + 1;
                if (startIndex + selectRows.length >= rowCount) {
                    startIndex = rowCount - selectRows.length;
                }
                this.sort(entryGrid, selectRows, startIndex);
                break;
            }
            case "tbl_bottom": {
                int startIndex = rowCount - selectRows.length;
                this.sort(entryGrid, selectRows, startIndex);
                break;
            }
        }
        this.getView().hideLoading();
    }

    private void sort(EntryGrid entryGrid, int[] selectRows, int startIndex) {
        ArrayList tempOrgList = new ArrayList(this.getModel().getEntryEntity("entryentity"));
        int tempOrgCount = tempOrgList.size();
        IDataModel model = this.getModel();
        model.deleteEntryData("entryentity");
        ArrayList selectList = new ArrayList(selectRows.length);
        HashMap<Integer, Integer> selectIndexMap = new HashMap<Integer, Integer>(selectRows.length);
        int endIndex = startIndex + selectRows.length;
        for (int index : selectRows) {
            selectList.add(tempOrgList.get(index));
            selectIndexMap.put(index, index);
        }
        Map<String, Boolean> freezeOrgMap = this.getFreezeOrgMapFromPageCache();
        int tempIndex = 0;
        int[] newSelectArr = new int[selectRows.length];
        int selectIndex = 0;
        for (int index = 0; index < tempOrgCount; ++index) {
            model.createNewEntryRow("entryentity");
            DynamicObject org = null;
            if (index >= startIndex && index < endIndex) {
                org = (DynamicObject)selectList.get(selectIndex);
                newSelectArr[selectIndex++] = index;
            } else {
                tempIndex = this.findNextRow(selectIndexMap, tempIndex);
                org = (DynamicObject)tempOrgList.get(tempIndex);
                ++tempIndex;
            }
            Long orgId = org.getLong("id");
            model.setValue("id", (Object)orgId, index);
            model.setValue("org", (Object)org.getLong("id"), index);
            model.setValue("level", (Object)org.getInt("level"), index);
            Boolean isFreeze = freezeOrgMap.get(orgId.toString());
            if (!isFreeze.booleanValue()) continue;
            model.setValue("isfreeze", (Object)IMG_IS_FREEZE, index);
        }
        entryGrid.selectRows(newSelectArr, newSelectArr[0]);
    }

    private Map<String, Boolean> getFreezeOrgMapFromPageCache() {
        String freezeOrganizations = this.getPageCache().get(CACHE_KEY_FREEZE);
        if (StringUtils.isBlank((CharSequence)freezeOrganizations)) {
            return Collections.emptyMap();
        }
        return (Map)SerializationUtils.fromJsonString((String)freezeOrganizations, Map.class);
    }

    private int findNextRow(Map<Integer, Integer> selectIndexMap, int index) {
        if (selectIndexMap.containsKey(index)) {
            selectIndexMap.remove(index);
            return this.findNextRow(selectIndexMap, ++index);
        }
        return index;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if (!"isshowdisabled".equals(propertyName)) {
            return;
        }
        Map paramMap = this.getView().getFormShowParameter().getCustomParams();
        if (paramMap != null) {
            IDataModel model = this.getModel();
            model.deleteEntryData("entryentity");
            this.initOrgEntryEntity(paramMap);
        }
    }
}

