/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orgview;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.BaseShowParameter;
import kd.bos.base.BasedataHelper;
import kd.bos.base.IBasedataController;
import kd.bos.base.utils.msg.BaseMessage;
import kd.bos.base.utils.msg.BaseMessageUtils;
import kd.bos.base.utils.msg.OrgMessage;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.AfterQueryOfExportEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeQueryOfExportEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BaseDataCustomControllerEvent;
import kd.bos.form.field.events.BasedataControllerSourceEnum;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.mvc.list.TreeListModel;
import kd.bos.org.controller.filter.OrgFilterCacheKey;
import kd.bos.org.model.OrgTreeParam;
import kd.bos.org.model.OrgTreeSearchParam;
import kd.bos.org.opplugin.common.OrgFieldLengthValidator;
import kd.bos.org.utils.OrgBillListCommon;
import kd.bos.org.utils.OrgTreeBuilder;
import kd.bos.org.utils.OrgTreeUtils;
import kd.bos.org.utils.OrgUtils;
import kd.bos.org.utils.Utils;
import kd.bos.org.yunzhijia.diff.impl.utils.YzjSyncImplUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class OrgViewTreeListPlugin
extends StandardTreeListPlugin {
    public static final Log logger = LogFactory.getLog(OrgViewTreeListPlugin.class);
    public static final String ORG_FUNC_ID = "orgFuncId";
    public static final String ORG_VIEW_SCHEME_NUMBER = "orgViewSchemeNumber";
    public static final String KEY_ORGF7_TITLE = ".orgF7Title";
    protected static final String KEY_ORG_VIEW_PROPERTY_NAME = ".orgViewPropertyName";
    private boolean isSearchClick = false;
    private static final int F7_STYLE_DEFAULT = 0;
    private static final int F7_STYLE_CONTROLLED = 3;
    private static final String TABLE_T_ORG_STRUCTURE = "t_org_structure";
    private List<QFilter> controllerFilters = null;
    private DistributeSessionlessCache cache;
    private String orgViewType;
    private String orgViewSchemeNumber;
    private static final String HEALTH_CHECK = "healthcheck";
    private boolean isShowDisableChanged;

    public void initialize() {
        ((TreeListModel)this.getTreeModel()).setGobackToRoot(false);
        super.initialize();
    }

    public void initializeTree(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        logger.info("\u3010\u7ec4\u7ec7\u67e5\u8be2\u3011\u521d\u59cb\u5316\u53c2\u6570\uff1a" + formShowParameter.getCustomParams());
        logger.info("\u3010\u7ec4\u7ec7\u67e5\u8be2\u3011\u4e1a\u52a1\u8bbe\u7f6e\u7684\u521d\u59cb\u5316\u8fc7\u6ee4\u6761\u4ef6\uff1a" + ((ListShowParameter)formShowParameter).getListFilterParameter().getQFilters());
        this.beforeInitializeOrgView();
        this.initializeOrgView();
        this.cacheLockDutyCombo();
        Object initOrgId = formShowParameter.getCustomParam("initOrgId");
        if (StringUtils.isNotBlank((Object)initOrgId) && !initOrgId.equals(formShowParameter.getCustomParam("initRootOrgId"))) {
            this.getPageCache().put("initOrgId", initOrgId.toString());
        }
        this.initRootNode();
    }

    public void initializeOrgView() {
        if (StringUtils.isNotBlank((CharSequence)this.getOrgViewType()) && StringUtils.isNotBlank((CharSequence)this.getOrgViewNumber())) {
            return;
        }
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map initializeOrgView = OrgBillListCommon.getInitializeOrgView((FormShowParameter)formShowParameter, (String)this.getDefaultViewType());
        this.setOrgViewType((String)initializeOrgView.get(ORG_FUNC_ID));
        this.setOrgViewNumber((String)initializeOrgView.get(ORG_VIEW_SCHEME_NUMBER));
        logger.info("\u7ec4\u7ec7\u6811\u89c6\u56fe\u65b9\u6848\u53c2\u6570\u521d\u59cb\u5316\u540e\u8868\u5355\u53c2\u6570\uff1a" + formShowParameter.getCustomParams());
    }

    protected void beforeInitializeOrgView() {
        logger.debug("\u4f7f\u7528\u9ed8\u8ba4\u89c6\u56fe\u65b9\u6848\u52a0\u8f7d\u65b9\u5f0f\u3002");
    }

    private void cacheLockDutyCombo() {
        Boolean isLockDutyCombo = (Boolean)this.getView().getFormShowParameter().getCustomParam("islockfunc");
        if (isLockDutyCombo == null) {
            isLockDutyCombo = Boolean.FALSE;
        }
        this.getPageCache().put("islockfunc", Boolean.toString(isLockDutyCombo));
    }

    protected String getDefaultViewType() {
        return "15";
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (LicenseServiceHelper.isSingleOrgManageMode()) {
            this.getModel().setValue("chkincludechild", (Object)Boolean.TRUE);
        }
        this.showDisabledOrg((ListShowParameter)this.getView().getFormShowParameter(), this.getOrgViewType());
        TreeNode root = this.getTreeModel().getRoot();
        if (root != null) {
            this.getTreeListView().getTreeView().focusNode(root);
        }
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        e.setCancel(true);
        if (this.isSearchClick) {
            return;
        }
        QFilter subOrgFilter = this.getBuildTreeListFilter(e.getNodeId().toString());
        if (subOrgFilter != null) {
            e.addQFilter(subOrgFilter);
        }
    }

    public void refreshNode(RefreshNodeEvent e) {
        if (this.isShowDisableChanged) {
            return;
        }
        String nodeId = e.getNodeId().toString();
        OrgTreeParam param = this.getOrgTreeParam(Long.parseLong(nodeId));
        e.setChildNodes(OrgUnitServiceHelper.getTreeChildren((OrgTreeParam)param));
    }

    private QFilter getBuildTreeListFilter(String nodeId) {
        QFilter subOrgFilter;
        String longNumberFilterPro;
        String parentFilterPro;
        String orgFilterPro;
        if (StringUtils.isBlank((CharSequence)nodeId) || "0".equals(nodeId)) {
            return null;
        }
        if ("id".equals(this.getListPKPropertyName())) {
            orgFilterPro = "structure.vieworg";
            parentFilterPro = "structure.viewparent";
            longNumberFilterPro = "structure.longnumber";
        } else {
            orgFilterPro = "org";
            parentFilterPro = "parent";
            longNumberFilterPro = "longnumber";
        }
        long orgId = Long.parseLong(nodeId);
        if (this.isIncludeGrand()) {
            QFilter orgFilter;
            String orgViewNumber = this.getOrgViewNumber();
            QFilter viewFilter = new QFilter("view.number", "=", (Object)orgViewNumber);
            QFilter[] filters = new QFilter[]{viewFilter, orgFilter = new QFilter("org", "=", (Object)orgId)};
            DynamicObject structObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org_structure", (String)"longnumber", (QFilter[])filters);
            if (structObj == null) {
                return null;
            }
            String longNumberFilter = structObj.getString("longnumber") + "!" + "%";
            subOrgFilter = QFilter.like((String)longNumberFilterPro, (String)longNumberFilter);
        } else {
            subOrgFilter = new QFilter(parentFilterPro, "=", (Object)orgId);
        }
        QFilter currentOrgFilter = new QFilter(orgFilterPro, "=", (Object)orgId);
        currentOrgFilter = currentOrgFilter.or(subOrgFilter);
        return currentOrgFilter;
    }

    public void showDisabledOrg(ListShowParameter listShowParameter, String orgFuncId) {
        FieldEdit showDisableEdit = (FieldEdit)this.getControl("isshowdisabled");
        if (showDisableEdit == null) {
            return;
        }
        if (!listShowParameter.isLookUp()) {
            if ("01".equals(orgFuncId)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"isshowdisabled"});
            }
            return;
        }
        if (!listShowParameter.isF7ClickByFilter()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"isshowdisabled"});
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"isshowdisabled"});
        if ("01".equals(orgFuncId)) {
            showDisableEdit.setCaption(new LocaleString(ResManager.loadKDString((String)"\u663e\u793a\u5c01\u5b58", (String)"OrgViewTreeListPlugin_7", (String)"bos-org-formplugin", (Object[])new Object[0])));
        } else {
            showDisableEdit.setCaption(new LocaleString(ResManager.loadKDString((String)"\u663e\u793a\u7981\u7528", (String)"OrgViewTreeListPlugin_8", (String)"bos-org-formplugin", (Object[])new Object[0])));
        }
    }

    public void buildBaseDataControllerTreeFilter(List<QFilter> qFilters) {
        this.buildBaseDataControllerFilter(qFilters, false);
    }

    public void buildBaseDataControllerListFilter(List<QFilter> qFilters) {
        this.buildBaseDataControllerFilter(qFilters, true);
    }

    public void buildBaseDataControllerFilter(List<QFilter> qFilters, boolean isAddListFilter) {
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        EntityType dataEntityType = ((IListView)this.getView()).getListModel().getDataEntityType();
        if (this.controllerFilters == null || TABLE_T_ORG_STRUCTURE.equalsIgnoreCase(dataEntityType.getAlias())) {
            String orgViewType = this.getOrgViewType();
            listShowParameter.setCustomParam(ORG_FUNC_ID, (Object)orgViewType);
            listShowParameter.setCustomParam(ORG_VIEW_SCHEME_NUMBER, (Object)this.getOrgViewNumber());
            BaseDataCustomControllerEvent event = new BaseDataCustomControllerEvent((Object)this, listShowParameter, BasedataControllerSourceEnum.F7);
            BasedataEntityType entityType = this.getBillListEntityType(orgViewType, isAddListFilter, dataEntityType);
            List controllers = BasedataHelper.createPlugin((List)entityType.getBasedataControllersProp());
            for (IBasedataController controller : controllers) {
                controller.buildBaseDataCoreFilter(event);
            }
            this.controllerFilters = event.getQfilters();
        }
        if (!CollectionUtils.isEmpty(this.controllerFilters)) {
            qFilters.addAll(this.controllerFilters);
        }
    }

    private BasedataEntityType getBillListEntityType(String orgViewType, boolean isAddListFilter, EntityType dataEntityType) {
        BasedataEntityType entityType = null;
        if (isAddListFilter && !this.isOrgF7()) {
            entityType = (BasedataEntityType)dataEntityType;
        }
        if (entityType == null) {
            entityType = "01".equals(orgViewType) ? (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)"bos_adminorg") : (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)"bos_org");
        }
        return entityType;
    }

    public TreeNode initRootNode() {
        logger.info(String.format("\u7ec4\u7ec7\u804c\u80fd\u67e5\u8be2\u7684\u53c2\u6570\uff1a[\u804c\u80fd\u7c7b\u578b]%s[\u89c6\u56fe\u65b9\u6848]%s", this.getOrgViewType(), this.getOrgViewNumber()));
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object rootId = formShowParameter.getCustomParam("rootId");
        long orgId = 0L;
        boolean isHideShowAllOrgCheckbox = true;
        if (StringUtils.isNotBlank((Object)rootId)) {
            orgId = Long.parseLong(rootId.toString());
        } else {
            Object paramInitRootOrgId = formShowParameter.getCustomParam("initRootOrgId");
            if (StringUtils.isNotBlank((Object)paramInitRootOrgId)) {
                orgId = Long.parseLong(paramInitRootOrgId.toString());
                isHideShowAllOrgCheckbox = orgId <= 0L;
            }
        }
        OrgTreeParam param = this.getOrgTreeParam(orgId);
        TreeNode root = OrgUnitServiceHelper.getTreeRootNodeById((OrgTreeParam)param);
        if (root == null) {
            if (orgId == 0L) {
                if (param.isBuildRootNodeInRange()) {
                    param.setId(0L);
                    param.setBuildRootNodeInRange(false);
                    root = OrgUnitServiceHelper.getTreeRootNodeById((OrgTreeParam)param);
                }
            } else {
                isHideShowAllOrgCheckbox = true;
                param.setId(0L);
                root = OrgUnitServiceHelper.getTreeRootNodeById((OrgTreeParam)param);
            }
            if (root == null) {
                root = new TreeNode("", "0", ResManager.loadKDString((String)"\u5168\u90e8", (String)"OrgViewTreeListPlugin_0", (String)"bos-org-formplugin", (Object[])new Object[0]));
            }
        } else if (!isHideShowAllOrgCheckbox && StringUtils.isNotBlank((CharSequence)root.getLongNumber()) && root.getLongNumber().indexOf("!") == -1) {
            isHideShowAllOrgCheckbox = true;
        }
        rootId = root.getId();
        if (StringUtils.isBlank((CharSequence)this.getPageCache().get("initOrgId"))) {
            long rootOrgId = Long.parseLong(rootId.toString());
            List children = null;
            if (rootOrgId != 0L) {
                param = this.getOrgTreeParam(rootOrgId);
                children = OrgUnitServiceHelper.getTreeChildren((OrgTreeParam)param);
                children = CollectionUtils.isEmpty((Collection)children) ? null : children;
            }
            root.setChildren(children);
        } else {
            root.setChildren(new ArrayList());
        }
        this.treeListView.getTreeView().deleteAllNodes();
        this.getTreeModel().setRoot(root);
        this.getTreeModel().setCurrentNodeId(rootId);
        if (isHideShowAllOrgCheckbox) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"showallorg"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"showallorg"});
        }
        return root;
    }

    private OrgTreeParam getOrgTreeParam(long orgId) {
        boolean buildRootNodeInRange;
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        OrgTreeParam param = new OrgTreeParam();
        param.setId(orgId);
        String orgViewNumber = this.getOrgViewNumber();
        param.setOrgViewNumber(orgViewNumber);
        param.setMarkFreeze(true);
        param.setIncludeFreeze(true);
        boolean includeDisable = OrgBillListCommon.isIncludeFreeze((IDataModel)this.getModel());
        param.setIncludeDisable(includeDisable);
        this.buildBaseDataControllerTreeFilter(param.getCustomFilterList());
        QFilter otherFilter = this.addTreeNodeFilter();
        if (otherFilter != null) {
            param.getCustomFilterList().add(otherFilter);
        }
        boolean bl = buildRootNodeInRange = !listShowParameter.isLookUp() || 0 == listShowParameter.getF7Style() || 3 == listShowParameter.getF7Style();
        if (buildRootNodeInRange) {
            param.getCustomFilterList().addAll(listShowParameter.getListFilterParameter().getQFilters());
        }
        param.setBuildRootNodeInRange(buildRootNodeInRange);
        return param;
    }

    public List<Long> getAdminChargeOrgs() {
        return OrgBillListCommon.getPermOrgs((IFormView)this.getView(), (String)this.getOrgViewNumber(), (Map)this.getView().getFormShowParameter().getCustomParams(), (boolean)this.isOrgF7());
    }

    public void expendTreeNode(TreeNodeEvent e) {
        if (this.isShowDisableChanged) {
            return;
        }
        TreeNode rootNode = this.getTreeModel().getRoot();
        if (rootNode == null) {
            return;
        }
        String nodeId = (String)e.getNodeId();
        TreeNode curNode = OrgTreeUtils.getNode((TreeNode)rootNode, (Object)nodeId);
        if (curNode == null) {
            return;
        }
        if (!curNode.getIsOpened()) {
            curNode.setIsOpened(true);
            this.getTreeModel().setRoot(rootNode);
            e.setExpandedNode(curNode);
        }
        if (nodeId.equals(rootNode.getId())) {
            OrgTreeUtils.focusInitOrgTreeNode((ListView)((ListView)this.getView()), (String)this.getOrgViewNumber());
        }
    }

    public void treeNodeClick(TreeNodeEvent e) {
        if (this.isShowDisableChanged) {
            return;
        }
        OrgTreeUtils.removeSearchTreeNodeCache((IPageCache)this.getPageCache(), (String)"_parentIdCacheKey");
        this.treeListView.getTreeView().queryTreeNodeChildren(String.valueOf(e.getParentNodeId()), String.valueOf(e.getNodeId()));
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        if (!CollectionUtils.isEmpty((Collection)args.getFastQFilters())) {
            this.isSearchClick = true;
        }
        OrgTreeUtils.removeListRowClickCache((IPageCache)this.getPageCache());
    }

    public TreeNode getNode(Object nodeId) {
        return OrgTreeUtils.getNode((Object)nodeId, (ITreeModel)this.getTreeModel());
    }

    private boolean isIncludeGrand() {
        boolean isIncludeGrand = true;
        Object includeChild = this.getModel().getValue("chkincludechild");
        if (includeChild != null) {
            isIncludeGrand = Boolean.parseBoolean(includeChild.toString());
        }
        return isIncludeGrand;
    }

    public void beforePropertyChanged(PropertyChangedArgs e) {
        if ("isshowdisabled".equals(e.getProperty().getName())) {
            this.isShowDisableChanged = true;
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String proName = e.getProperty().getName();
        BaseMessageUtils.showLoading((IFormView)this.getView(), () -> {
            if ("chkincludechild".equals(proName)) {
                this.clickFocusNode();
            } else if ("isshowdisabled".equals(proName)) {
                this.isShowDisableChanged = false;
                TreeView treeView = this.getTreeListView().getTreeView();
                String focusNodeId = treeView.getTreeState().getFocusNodeId();
                this.getPageCache().put("initOrgId", focusNodeId);
                TreeNode rootNode = this.initRootNode();
                treeView.addNode(rootNode);
                treeView.treeNodeClick(rootNode.getParentid(), rootNode.getId());
                this.getPageCache().remove("orgTreeTriggerBySearch");
            } else if ("showallorg".equals(proName)) {
                this.showAllOrg();
            }
        });
    }

    private void clickFocusNode() {
        Map focusNode = this.getTreeListView().getTreeView().getTreeState().getFocusNode();
        TreeNode node = focusNode == null ? this.getTreeModel().getRoot() : new TreeNode(String.valueOf(focusNode.get("parentid")), String.valueOf(focusNode.get("id")), String.valueOf(focusNode.get("text")));
        this.treeListView.getTreeView().treeNodeClick(node.getParentid(), node.getId());
    }

    private void showAllOrg() {
        Object paramInitRootOrgId = this.getView().getFormShowParameter().getCustomParam("initRootOrgId");
        if (paramInitRootOrgId == null) {
            return;
        }
        long rootOrgId = 0L;
        if (!((Boolean)this.getModel().getValue("showallorg")).booleanValue()) {
            rootOrgId = Long.parseLong(paramInitRootOrgId.toString());
        }
        OrgTreeParam param = this.getOrgTreeParam(rootOrgId);
        OrgTreeUtils.fireClickShowAllOrgCheckBox((ListView)((ListView)this.getView()), (OrgTreeParam)param);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        if (this.isUseDefaultClickEvent()) {
            super.billListHyperLinkClick(args);
        } else {
            args.setCancel(true);
            this.clickRow(args.getHyperLinkClickEvent().getRowIndex());
        }
    }

    public void listRowClick(ListRowClickEvent evt) {
        String focusNodeId;
        evt.setCancel(true);
        if (!OrgTreeUtils.focusTreeNodeAfterListRowClick((ListRowClickEvent)evt, (IPageCache)this.getPageCache())) {
            return;
        }
        ListSelectedRow row = evt.getCurrentListSelectedRow();
        String rowPkId = row.getPrimaryKeyValue().toString();
        String orgId = this.getCurrentListSelectedOrg(rowPkId);
        if (orgId.equals(focusNodeId = this.treeListView.getTreeView().getTreeState().getFocusNodeId())) {
            ArrayList loopController = new ArrayList();
            OrgTreeUtils.expandParentNode((TreeView)this.treeListView.getTreeView(), (ITreeModel)this.treeListView.getTreeModel(), (String)orgId, loopController);
        } else {
            OrgTreeSearchParam searchParam = new OrgTreeSearchParam(orgId, (ListView)this.getView(), this.getOrgViewNumber());
            searchParam.setSearchById(true);
            OrgTreeUtils.searchFromLazyOrgTree((OrgTreeSearchParam)searchParam);
        }
        String currentFocusNodeId = this.treeListView.getTreeView().getTreeState().getFocusNodeId();
        boolean isFocusRootNode = false;
        TreeNode rootNode = this.getTreeModel().getRoot();
        if (StringUtils.isBlank((Object)currentFocusNodeId)) {
            isFocusRootNode = true;
        } else {
            TreeNode currentNode = OrgTreeUtils.getNode((TreeNode)rootNode, (Object)currentFocusNodeId);
            if (currentNode == null) {
                isFocusRootNode = true;
            }
        }
        if (isFocusRootNode) {
            this.treeListView.getTreeView().focusNode(rootNode);
        }
    }

    public String getCurrentListSelectedOrg(String rowPkId) {
        return rowPkId;
    }

    public boolean isUseDefaultClickEvent() {
        return false;
    }

    private void clickRow(int rowIndex) {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection col = billList.getSelectedRows();
        if (Utils.isListEmpty((List)col)) {
            return;
        }
        for (ListSelectedRow listRow : col) {
            if (rowIndex != listRow.getRowKey()) continue;
            this.showOrgEditForm(listRow.getPrimaryKeyValue());
            break;
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        ListSelectedRowCollection selectedRows;
        super.beforeItemClick(evt);
        if ("tblorgchange".equals(evt.getItemKey())) {
            this.showOrgChange();
            evt.setCancel(true);
        } else if ("tblhealthcheck".equals(evt.getItemKey()) && CollectionUtils.isEmpty((Collection)(selectedRows = ((ListView)this.getView()).getSelectedRows()))) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(HEALTH_CHECK, (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u672a\u9009\u62e9\u6570\u636e\u65f6\uff0c\u5c06\u6267\u884c\u5168\u90e8\u7ec4\u7ec7\u7684\u5065\u5eb7\u68c0\u67e5\u3002\u786e\u8ba4\u6267\u884c\u5417\uff1f", (String)"OrgViewTreeListPlugin_1", (String)"bos-org-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBacks);
            evt.setCancel(true);
        }
        OrgFilterCacheKey keyObj = new OrgFilterCacheKey(this.getOrgViewNumber());
        this.getPageCache().remove(keyObj.getKey());
    }

    private void showOrgChange() {
        if (!PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)this.getView().getFormShowParameter().getAppId(), (String)"bos_org_changerecord", (String)"47150e89000000ac")) {
            String caption = FormMetadataCache.getFormConfig((String)"bos_org_changerecord").getCaption().getLocaleValue();
            this.getView().showErrorNotification(BaseMessage.getMessage((String)"M00065", (Object[])new Object[]{caption, BaseMessage.getMessage((String)"M00075")}));
            return;
        }
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"bos_org_changerecord", (boolean)true, (int)0, (boolean)false);
        listShowParameter.setPageId(this.getView().getPageId() + listShowParameter.getBillFormId());
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Donothing) {
            Donothing operation = (Donothing)args.getSource();
            String operateKey = operation.getOperateKey();
            if ("sort".equals(operateKey)) {
                if (this.isSortAble()) {
                    args.setCancel(true);
                } else {
                    this.showOrgSortForm();
                }
            } else if (HEALTH_CHECK.equals(operateKey)) {
                this.healthCheck(operation);
            }
        }
    }

    private void healthCheck(Donothing healthCheckOp) {
        ListSelectedRowCollection listSelectedData = healthCheckOp.getListSelectedData();
        if (listSelectedData == null) {
            return;
        }
        if (!CollectionUtils.isEmpty((Collection)listSelectedData)) {
            return;
        }
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (CollectionUtils.isEmpty((Collection)selectedRows)) {
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"OrgViewTreeListPlugin.healthCheck", (String)"bos_org", (String)"id,number,name", null, (String)"");){
                for (Row row : dataSet) {
                    ListSelectedRow selectedRow = new ListSelectedRow(row.get("id"));
                    selectedRow.setNumber(row.getString("number"));
                    selectedRow.setName(row.getString("name"));
                    listSelectedData.add((Object)selectedRow);
                }
            }
        } else {
            listSelectedData.addAll((Collection)selectedRows);
        }
        logger.info("\u3010\u7ec4\u7ec7\u3011\u6267\u884c\u5065\u5eb7\u68c0\u67e5", (Object)listSelectedData.size());
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult operationResult = args.getOperationResult();
        if (operationResult == null) {
            return;
        }
        if (HEALTH_CHECK.equals(args.getOperateKey())) {
            operationResult.getAllErrorInfo().clear();
            OrgFieldLengthValidator validator = new OrgFieldLengthValidator();
            String message = validator.validateStructureField();
            if (StringUtils.isNotBlank((CharSequence)message)) {
                this.getView().showMessage(message);
            }
        }
    }

    protected Long getSortViewId() {
        return null;
    }

    protected void operationPreCheck(BeforeItemClickEvent evt, String btnKey) {
    }

    private boolean isSortAble() {
        String orgSortSchema = OrgUnitServiceHelper.getOrgSortSchema();
        if (!"sortcode".equals(orgSortSchema) && !"sortnumber".equals(orgSortSchema)) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("tblsort", (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"OrgViewTreeListPlugin_2", (String)"bos-org-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u53bb\u4fee\u6539\u53c2\u6570", (String)"OrgViewTreeListPlugin_3", (String)"bos-org-formplugin", (Object[])new Object[0]));
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            this.getView().showConfirm(OrgMessage.getMessage((String)"M00047"), "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
            return true;
        }
        boolean isAble = false;
        Map focMap = this.treeListView.getTreeView().getTreeState().getFocusNode();
        if (focMap == null) {
            isAble = true;
            this.getView().showTipNotification(OrgMessage.getMessage((String)"M00048"));
        } else {
            Object isParent = focMap.get("isParent");
            if (isParent != null && !((Boolean)isParent).booleanValue()) {
                isAble = true;
                this.getView().showTipNotification(OrgMessage.getMessage((String)"M00048"));
            }
        }
        return isAble;
    }

    private void showOrgSortForm() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("bos_org_sort");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        String parentNodeId = this.treeListView.getTreeView().getTreeState().getFocusNodeId();
        String parentOrgId = this.getParentOrgId(formShowParameter, parentNodeId);
        if (StringUtils.isBlank((CharSequence)parentOrgId)) {
            this.getView().showTipNotification(OrgMessage.getMessage((String)"M00049"));
            return;
        }
        Long sortViewId = this.getSortViewId();
        formShowParameter.setCustomParam("view", (Object)sortViewId);
        if (sortViewId != null && sortViewId == 1L) {
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u6392\u5e8f", (String)"OrgViewTreeListPlugin_5", (String)"bos-org-formplugin", (Object[])new Object[0]));
        } else {
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u5143\u6392\u5e8f", (String)"OrgViewTreeListPlugin_6", (String)"bos-org-formplugin", (Object[])new Object[0]));
        }
        formShowParameter.setCustomParam("parent", (Object)parentNodeId);
        formShowParameter.setCloseCallBack(this.genClosedCallBack((IFormPlugin)this, "bos_org_sort"));
        this.getView().showForm(formShowParameter);
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        if (event.getResult() == MessageBoxResult.Yes) {
            String callBackId = event.getCallBackId();
            if ("tblsort".equals(callBackId)) {
                YzjSyncImplUtils.openSysParameterPage(this.getView(), false);
                return;
            }
            if (HEALTH_CHECK.equals(callBackId)) {
                this.getView().invokeOperation(HEALTH_CHECK);
            }
        }
    }

    private String getParentOrgId(FormShowParameter formShowParameter, String parentNodeId) {
        if (StringUtils.isBlank((CharSequence)parentNodeId)) {
            return "";
        }
        List<Long> chargeOrgList = this.getAdminChargeOrgs();
        if (chargeOrgList == null) {
            formShowParameter.setCustomParam("parent", (Object)parentNodeId);
            return parentNodeId;
        }
        String parentOrgId = "";
        int max = chargeOrgList.size();
        for (int i = 0; i < max; ++i) {
            Long orgId = chargeOrgList.get(i);
            if (!parentNodeId.equals(((Object)orgId).toString())) continue;
            parentOrgId = parentNodeId;
            break;
        }
        return parentOrgId;
    }

    public void beforeShowBill(BeforeShowBillFormEvent arg0) {
        super.beforeShowBill(arg0);
        BillShowParameter formShowParameter = arg0.getParameter();
        Object curNodeId = this.treeListView.getTreeModel().getCurrentNodeId();
        if (this.addDefaultParent(curNodeId)) {
            formShowParameter.setCustomParam("parent", curNodeId);
        }
        formShowParameter.setCloseCallBack(this.genClosedCallBack((IFormPlugin)this, OperationStatus.ADDNEW.name()));
        OrgFilterCacheKey keyObj = new OrgFilterCacheKey(this.getOrgViewNumber());
        this.getPageCache().remove(keyObj.getKey());
    }

    private boolean addDefaultParent(Object curNodeId) {
        if (StringUtils.isBlank((Object)curNodeId)) {
            return false;
        }
        List<Long> chargeOrgList = this.getAdminChargeOrgs();
        if (chargeOrgList == null) {
            return true;
        }
        boolean isAddAble = false;
        int max = chargeOrgList.size();
        for (int i = 0; i < max; ++i) {
            Long orgId = chargeOrgList.get(i);
            if (!curNodeId.equals(((Object)orgId).toString())) continue;
            isAddAble = true;
            break;
        }
        return isAddAble;
    }

    public void showOrgEditForm(Object rowPkId) {
        String orgViewNumber = this.getOrgViewNumber();
        OrgFilterCacheKey keyObj = new OrgFilterCacheKey(orgViewNumber);
        this.getPageCache().remove(keyObj.getKey());
        BaseShowParameter formShowParameter = null;
        formShowParameter = rowPkId == null ? this.getAddNewShowFormParameter() : this.getEditShowFormParameter(rowPkId);
        this.addEditShowFormParameter(formShowParameter);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    private BaseShowParameter getAddNewShowFormParameter() {
        BaseShowParameter formShowParameter = new BaseShowParameter();
        formShowParameter.setBillStatus(BillOperationStatus.ADDNEW);
        formShowParameter.setCloseCallBack(this.genClosedCallBack((IFormPlugin)this, OperationStatus.ADDNEW.name()));
        String parentId = this.treeListView.getTreeView().getTreeState().getFocusNodeId();
        if (StringUtils.isBlank((CharSequence)parentId)) {
            return formShowParameter;
        }
        List<Long> chargeOrgList = this.getAdminChargeOrgs();
        if (chargeOrgList == null) {
            formShowParameter.setCustomParam("parent", (Object)parentId);
            return formShowParameter;
        }
        int max = chargeOrgList.size();
        for (int i = 0; i < max; ++i) {
            Long orgId = chargeOrgList.get(i);
            if (!parentId.equals(((Object)orgId).toString())) continue;
            formShowParameter.setCustomParam("parent", (Object)parentId);
            break;
        }
        return formShowParameter;
    }

    private BaseShowParameter getEditShowFormParameter(Object rowPkId) {
        BaseShowParameter formShowParameter = new BaseShowParameter();
        formShowParameter.setBillStatus(BillOperationStatus.EDIT);
        formShowParameter.setCloseCallBack(this.genClosedCallBack((IFormPlugin)this, OperationStatus.EDIT.name()));
        QFilter filter = null;
        EntityType dataEntityType = ((IListView)this.getView()).getListModel().getDataEntityType();
        if (dataEntityType != null && TABLE_T_ORG_STRUCTURE.equalsIgnoreCase(dataEntityType.getAlias())) {
            filter = new QFilter("id", "=", rowPkId);
        } else {
            filter = new QFilter("org", "=", rowPkId);
            QFilter viewFilter = new QFilter("view.number", "=", (Object)this.getOrgViewNumber());
            filter = filter.and(viewFilter);
        }
        QFilter[] filters = new QFilter[]{filter};
        DynamicObject adminOrg = QueryServiceHelper.queryOne((String)"bos_org_structure", (String)"id,org,parent,isleaf,isfreeze", (QFilter[])filters);
        if (adminOrg != null) {
            formShowParameter.setCustomParam("parent", adminOrg.get("parent"));
            formShowParameter.setCustomParam("isleaf", adminOrg.get("isleaf"));
            formShowParameter.setCustomParam("isfreeze", adminOrg.get("isfreeze"));
            formShowParameter.setPkId(adminOrg.get("org"));
        }
        return formShowParameter;
    }

    public void addEditShowFormParameter(BaseShowParameter parameter) {
        if (parameter == null) {
            throw new KDBizException(BaseMessage.getMessage((String)"M00014"));
        }
    }

    public CloseCallBack genClosedCallBack(IFormPlugin plugin, String actionId) {
        CloseCallBack closeCallBack = new CloseCallBack(plugin, actionId);
        return closeCallBack;
    }

    public void closedCallBack(ClosedCallBackEvent arg0) {
        String actionId = arg0.getActionId();
        Object returnData = arg0.getReturnData();
        if ("bos_org_sort".equals(actionId)) {
            if ("save".equals(returnData)) {
                TreeView treeView = this.treeListView.getTreeView();
                treeView.treeNodeClick("", treeView.getTreeState().getFocusNodeId());
            }
            return;
        }
        if (!(returnData instanceof Map)) {
            return;
        }
        Map returnDataMap = (Map)returnData;
        Object operation = returnDataMap.get("operation");
        if ("tblclose".equals(operation) || "bos_org_viewschema_ou".equals(returnDataMap.get("view"))) {
            return;
        }
        this.refreshTreeNodeAndView(returnDataMap);
    }

    private void refreshTreeNodeAndView(Map<String, Object> returnDataMap) {
        TreeView treeView = this.getTreeListView().getTreeView();
        TreeNode rootNode = this.getTreeModel().getRoot();
        TreeNode treeNode = (TreeNode)returnDataMap.get("TreeNode");
        if (treeNode == null) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)treeNode.getParentid())) {
            this.updateRootNodeAfterEdit(treeNode);
            return;
        }
        Map focusNodeMap = treeView.getTreeState().getFocusNode();
        if (focusNodeMap != null) {
            String focusNodeId = focusNodeMap.get("id").toString();
            String focusParentId = focusNodeMap.get("parentid").toString();
            if (treeNode.getId().equals(focusNodeId) && (StringUtils.isEmpty((CharSequence)focusParentId) || treeNode.getParentid().equals(focusParentId))) {
                TreeNode oldTreeNode = OrgTreeUtils.getNode((TreeNode)rootNode, (Object)treeNode.getId());
                if (oldTreeNode != null) {
                    oldTreeNode.setText(treeNode.getText());
                    treeView.updateNode(oldTreeNode);
                    TreeNode focusNode = new TreeNode(focusParentId, focusNodeId, focusNodeMap.get("text").toString());
                    treeView.focusNode(focusNode);
                    this.getTreeModel().setRoot(rootNode);
                }
                this.refreshBillList();
                return;
            }
        }
        treeView.deleteNode(treeNode.getId());
        this.getTreeListView().getTreeModel().getRoot().deleteChildNode(treeNode.getId());
        OrgTreeUtils.removeSearchTreeNodeCache((IPageCache)this.getPageCache(), (String)"_oldSearchText");
        OrgTreeSearchParam searchParam = new OrgTreeSearchParam(treeNode.getId(), (ListView)this.getView(), this.getOrgViewNumber());
        searchParam.setSearchById(true);
        searchParam.setClickNode(true);
        OrgTreeUtils.searchFromLazyOrgTree((OrgTreeSearchParam)searchParam);
    }

    private void updateRootNodeAfterEdit(TreeNode treeNode) {
        TreeView treeView = this.getTreeListView().getTreeView();
        TreeNode rootNode = this.getTreeModel().getRoot();
        rootNode.setText(treeNode.getText());
        treeView.updateNode(rootNode);
        treeView.focusNode(rootNode);
        this.getTreeModel().setRoot(rootNode);
        this.refreshBillList();
    }

    public void refreshListView() {
        ((IListView)this.getView()).refresh();
    }

    public void refreshBillList() {
        BillList billList = (BillList)this.getControl("billlistap");
        billList.refresh();
    }

    public List<Long> getOrgIdsOfSelectedRows() {
        List<Long> ids = this.getSelectedPks();
        return this.getOrgIdsOfSelectedRows(ids);
    }

    public List<Long> getSelectedPks() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection listSelect = billList.getSelectedRows();
        if (Utils.isListEmpty((List)listSelect)) {
            return new ArrayList<Long>(0);
        }
        ArrayList<Long> ids = new ArrayList<Long>(listSelect.size());
        for (ListSelectedRow row : listSelect) {
            ids.add(Long.valueOf(String.valueOf(row.getPrimaryKeyValue())));
        }
        return ids;
    }

    public List<Long> getOrgIdsOfSelectedRows(List<Long> ids) {
        QFilter[] filters;
        String selectProperties;
        Map structureObjMap;
        if (ids.isEmpty()) {
            return new ArrayList<Long>();
        }
        QFilter viewFilter = new QFilter("view.number", "=", (Object)this.getOrgViewNumber());
        if (Utils.isListNotEmpty(ids)) {
            viewFilter = viewFilter.and(new QFilter("id", "in", ids));
        }
        if (CollectionUtils.isEmpty((Map)(structureObjMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org_structure", (String)(selectProperties = "org"), (QFilter[])(filters = new QFilter[]{viewFilter}))))) {
            return new ArrayList<Long>();
        }
        ArrayList<Long> orgIds = new ArrayList<Long>(structureObjMap.size());
        for (DynamicObject org : structureObjMap.values()) {
            DynamicObject orgEntity = org.getDynamicObject("org");
            if (orgEntity == null) continue;
            orgIds.add(orgEntity.getLong("id"));
        }
        return orgIds;
    }

    public Map<Long, Long> getSelectedRowsMap(List<Long> ids) {
        QFilter[] filters;
        String selectProperties;
        Map structureObjMap;
        if (ids.isEmpty()) {
            return new HashMap<Long, Long>();
        }
        QFilter viewFilter = new QFilter("view.number", "=", (Object)this.getOrgViewNumber());
        if (Utils.isListNotEmpty(ids)) {
            viewFilter = viewFilter.and(new QFilter("id", "in", ids));
        }
        if (CollectionUtils.isEmpty((Map)(structureObjMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org_structure", (String)(selectProperties = "id,org"), (QFilter[])(filters = new QFilter[]{viewFilter}))))) {
            return new HashMap<Long, Long>();
        }
        HashMap<Long, Long> pkMap = new HashMap<Long, Long>(structureObjMap.size());
        for (DynamicObject structObj : structureObjMap.values()) {
            DynamicObject orgEntity = structObj.getDynamicObject("org");
            if (orgEntity == null) continue;
            pkMap.put(orgEntity.getLong("id"), structObj.getLong("id"));
        }
        return pkMap;
    }

    public boolean isSelectedRow(boolean isOnlyOne) {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection listSelect = billList.getSelectedRows();
        if (Utils.isListEmpty((List)listSelect)) {
            this.getView().showTipNotification(BaseMessage.getMessage((String)"M00020"));
            return false;
        }
        if (isOnlyOne && listSelect.size() > 1) {
            this.getView().showTipNotification(BaseMessage.getMessage((String)"M00026"));
            return false;
        }
        return true;
    }

    public void search(SearchEnterEvent evt) {
        if (StringUtils.isBlank((CharSequence)evt.getText())) {
            return;
        }
        OrgTreeParam orgTreeParam = this.getOrgTreeParam(0L);
        if (!CollectionUtils.isEmpty((Collection)orgTreeParam.getOrgRangeList())) {
            QFilter idFilter = new QFilter("id", "in", (Object)orgTreeParam.getOrgRangeList());
            orgTreeParam.getCustomFilterList().add(idFilter);
        }
        OrgTreeSearchParam searchParam = new OrgTreeSearchParam(evt.getText(), (ListView)this.getView(), this.getOrgViewNumber());
        searchParam.getOrgFilterList().addAll(orgTreeParam.getCustomFilterList());
        searchParam.setClickNode(true);
        OrgTreeUtils.searchFromLazyOrgTree((OrgTreeSearchParam)searchParam);
    }

    public void beforeQueryOfExport(BeforeQueryOfExportEvent e) {
        super.beforeQueryOfExport(e);
        e.setOrderBys(OrgUtils.getOrgSortFields());
    }

    public void afterQueryOfExport(AfterQueryOfExportEvent e) {
        super.afterQueryOfExport(e);
        this.rebuildAfterQueryOfExport(e);
    }

    private void rebuildAfterQueryOfExport(AfterQueryOfExportEvent e) {
        DynamicObject[] queryValues = e.getQueryValues();
        if (queryValues == null || queryValues.length == 0) {
            return;
        }
        DynamicObject queryValue = queryValues[0];
        if (queryValue.getDynamicObjectType().getProperties().get((Object)"structure") == null) {
            return;
        }
        DynamicObjectCollection structureObjCol = queryValue.getDynamicObjectCollection("structure");
        if (CollectionUtils.isEmpty((Collection)structureObjCol)) {
            return;
        }
        if (structureObjCol.getDynamicObjectType().getProperties().get((Object)"view") == null) {
            return;
        }
        this.rebuildAfterQueryOfExport(queryValues);
    }

    protected void rebuildAfterQueryOfExport(DynamicObject[] queryValues) {
    }

    protected DistributeSessionlessCache getDistributeCache() {
        if (this.cache == null) {
            this.cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("OrgUnitTreeListPlugin", new DistributeCacheHAPolicy(true, true));
        }
        return this.cache;
    }

    protected void refreshTreeAfterDoOperation(List<Object> orgIds, boolean deleteNode, String operationKey) {
        if (orgIds.isEmpty()) {
            return;
        }
        TreeView tv = (TreeView)this.getControl("treeview");
        TreeNode rootNode = this.getTreeModel().getRoot();
        ArrayList<TreeNode> allChildren = new ArrayList<TreeNode>();
        TreeNode focusNode = this.getRefreshTreeFocusNode(orgIds, allChildren, operationKey);
        if (focusNode == null) {
            String focusNodeId = tv.getTreeState().getFocusNodeId();
            if (StringUtils.isBlank((CharSequence)focusNodeId)) {
                tv.treeNodeClick("", rootNode.getId());
            } else {
                tv.treeNodeClick("", focusNodeId);
            }
            return;
        }
        boolean isIncludeDisable = false;
        if (this.getModel().getProperty("isshowdisabled") != null) {
            isIncludeDisable = Boolean.parseBoolean(this.getModel().getValue("isshowdisabled").toString());
        }
        boolean isDeleteFrozenTreeNode = deleteNode && !isIncludeDisable;
        this.deleteNodeForRefreshTree(allChildren, isDeleteFrozenTreeNode);
        this.getTreeModel().setRoot(rootNode);
        if (isDeleteFrozenTreeNode) {
            tv.treeNodeClick("", focusNode.getParentid());
        } else {
            tv.updateNodes(allChildren);
            tv.focusNode(focusNode);
            this.refreshList();
        }
        OrgFilterCacheKey keyObj = new OrgFilterCacheKey("01");
        this.getPageCache().remove(keyObj.getKey());
    }

    private void deleteNodeForRefreshTree(List<TreeNode> allChildren, boolean isDeleteFrozenTreeNode) {
        TreeView tv = (TreeView)this.getControl("treeview");
        TreeNode rootNode = this.getTreeModel().getRoot();
        for (TreeNode treeNode : allChildren) {
            String nodeId = treeNode.getId();
            if (!isDeleteFrozenTreeNode) continue;
            rootNode.deleteChildNode(nodeId);
            tv.deleteNode(nodeId);
        }
    }

    private void refreshList() {
        BillList billList = (BillList)this.getControl("billlistap");
        billList.clearSelection();
        this.refreshListView();
    }

    private TreeNode getRefreshTreeFocusNode(List<Object> orgIds, List<TreeNode> allChildren, String operationKey) {
        TreeNode focusNode = null;
        TreeNode rootNode = this.getTreeModel().getRoot();
        HashMap<String, Boolean> labelDataMap = new HashMap<String, Boolean>(1);
        if ("disable".endsWith(operationKey)) {
            labelDataMap.put("enable", Boolean.FALSE);
        } else if ("freeze".endsWith(operationKey)) {
            labelDataMap.put("structure.isfreeze", Boolean.TRUE);
        }
        for (Object orgId : orgIds) {
            TreeNode treeNode = OrgTreeUtils.getNode((TreeNode)rootNode, (Object)orgId);
            if (treeNode == null) continue;
            if (focusNode == null) {
                focusNode = treeNode;
            }
            OrgTreeBuilder.updateNodeLabel((TreeNode)treeNode, labelDataMap, null);
            allChildren.add(treeNode);
        }
        return focusNode;
    }

    protected String getOrgViewType() {
        if (this.orgViewType != null) {
            return this.orgViewType;
        }
        return this.getPageCache().get(ORG_FUNC_ID);
    }

    protected void setOrgViewType(String orgViewType) {
        this.orgViewType = orgViewType;
        this.getView().getFormShowParameter().setCustomParam(ORG_FUNC_ID, (Object)orgViewType);
        this.getPageCache().put(ORG_FUNC_ID, orgViewType);
    }

    protected String getOrgViewNumber() {
        if (this.orgViewSchemeNumber != null) {
            return this.orgViewSchemeNumber;
        }
        return this.getPageCache().get(ORG_VIEW_SCHEME_NUMBER);
    }

    protected void setOrgViewNumber(String orgViewNumber) {
        this.orgViewSchemeNumber = orgViewNumber;
        this.getView().getFormShowParameter().setCustomParam(ORG_VIEW_SCHEME_NUMBER, (Object)orgViewNumber);
        this.getPageCache().put(ORG_VIEW_SCHEME_NUMBER, orgViewNumber);
    }

    private boolean isOrgF7() {
        return ((ListShowParameter)this.getView().getFormShowParameter()).isLookUp();
    }

    public QFilter addTreeNodeFilter() {
        return null;
    }

    public QFilter addBillListFilters() {
        return null;
    }

    public String getListPKPropertyName() {
        return "id";
    }
}

