/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orgview.importdata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.base.utils.msg.OrgMessage;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.IImportPlugin;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.org.model.OrgParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class OrgImportPlugin
implements IImportPlugin {
    private String languageTag = "";

    public List<Object> importData(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        Object importtype = option.get("importtype");
        if (!"new".equals(importtype)) {
            ImportLogger.ImportLog importLog = new ImportLogger.ImportLog(OrgMessage.getMessage((String)"M00045"));
            importlogs.add(importLog);
            return new ArrayList<Object>(0);
        }
        Locale locale = RequestContext.get().getLang().getLocale();
        this.languageTag = RequestContext.get().getLang().getLocale().toLanguageTag();
        this.languageTag = this.languageTag == null ? "" : this.languageTag.replaceAll("-", "_");
        String errorMsg = "";
        OrgParam orgParam = new OrgParam();
        this.setOrgProperties(data, orgParam);
        errorMsg = this.setOrgFullname(data, orgParam);
        if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
            ImportLogger.ImportLog importLog = new ImportLogger.ImportLog(errorMsg);
            importlogs.add(importLog);
            return new ArrayList<Object>(0);
        }
        this.setOrgPattern(data, orgParam);
        this.setDescription(data, orgParam);
        ArrayList<OrgParam> paramList = new ArrayList<OrgParam>(1);
        paramList.add(orgParam);
        OrgUnitServiceHelper.addByFullname(paramList);
        ArrayList<Object> idList = new ArrayList<Object>(1);
        if (orgParam.isSuccess()) {
            idList.add(orgParam.getId());
        } else if (importlogs != null) {
            ImportLogger.ImportLog importLog = new ImportLogger.ImportLog(orgParam.getMsg());
            importlogs.add(importLog);
        }
        return idList;
    }

    private String setOrgProperties(Map<String, Object> data, OrgParam orgParam) {
        Object org = data.get("org");
        if (StringUtils.isBlank((Object)org)) {
            return "";
        }
        Map orgMap = (Map)org;
        HashMap propertyMap = orgParam.getPropertyMap();
        for (Map.Entry orgEntry : orgMap.entrySet()) {
            String orgProName = (String)orgEntry.getKey();
            Object orgProValue = orgEntry.getValue();
            if ("importprop".equals(orgProName)) continue;
            if ("number".contains(orgProName)) {
                orgParam.setNumber(orgProValue == null ? "" : orgProValue.toString());
                continue;
            }
            if ("name".equals(orgProName)) {
                orgParam.setName(orgProValue == null ? "" : orgProValue.toString());
                continue;
            }
            if (propertyMap == null) {
                propertyMap = new HashMap(orgMap.size());
                orgParam.setPropertyMap(propertyMap);
            }
            propertyMap.put(orgProName, orgProValue);
        }
        orgMap.put("id", "0");
        return "";
    }

    private String setOrgFullname(Map<String, Object> data, OrgParam orgParam) {
        Object fullname = data.get("fullname");
        if (StringUtils.isBlank((Object)fullname)) {
            return "";
        }
        String localeFullname = "";
        if (fullname instanceof String) {
            localeFullname = fullname.toString();
        } else if (fullname instanceof Map) {
            Map fullnameMap = (Map)fullname;
            Object importFullname = fullnameMap.get(this.languageTag);
            if (StringUtils.isBlank(importFullname)) {
                return OrgMessage.getMessage((String)"M00046", (Object[])new Object[]{this.languageTag});
            }
            localeFullname = importFullname.toString();
        }
        orgParam.setFullname(localeFullname);
        return "";
    }

    private String setOrgPattern(Map<String, Object> data, OrgParam orgParam) {
        QFilter nameFilter;
        QFilter[] filters;
        DynamicObject patternObj;
        Object orgPatternNumber = data.get("orgpattern");
        if (StringUtils.isBlank((Object)orgPatternNumber)) {
            return "";
        }
        if (orgPatternNumber instanceof String) {
            orgParam.setOrgPatternNumber(String.valueOf(orgPatternNumber));
            return "";
        }
        if (!(orgPatternNumber instanceof Map)) {
            return "";
        }
        Map orgPatternMap = (Map)orgPatternNumber;
        Object patternImportprop = orgPatternMap.get("importprop");
        if ("number".equals(patternImportprop)) {
            Object patternNumber = orgPatternMap.get("number");
            orgParam.setOrgPatternNumber(patternNumber == null ? "" : patternNumber.toString());
        } else if ("name".equals(patternImportprop) && (patternObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org_pattern", (QFilter[])(filters = new QFilter[]{nameFilter = new QFilter("name", "=", orgPatternMap.get("name"))}))) != null) {
            orgParam.setOrgPatternId(patternObj.getLong("id"));
        }
        return "";
    }

    private String setDescription(Map<String, Object> data, OrgParam orgParam) {
        Map descMap;
        Object importDesc;
        Object description = data.get("comment");
        if (StringUtils.isBlank((Object)description)) {
            return "";
        }
        if (description instanceof String) {
            orgParam.setDescription(description.toString());
        } else if (description instanceof Map && StringUtils.isNotBlank(importDesc = (descMap = (Map)description).get(this.languageTag))) {
            orgParam.setDescription(importDesc.toString());
        }
        return "";
    }
}

