/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orgview.orgf7treelist;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.base.utils.msg.BaseMessageUtils;
import kd.bos.base.utils.msg.OrgMessage;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.control.TreeView;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.list.ListCache;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.cache.PageCache;
import kd.bos.org.utils.Utils;
import kd.bos.orgview.OrgViewTreeListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class OrgF7ViewListFormPlugin
extends OrgViewTreeListPlugin {
    public static final String ORGVIEW_COMLISTID = "cmborgtypelst";
    public static final String KEY_FUN_PARENTPAGECACHE = "orgF7SelViewTreeType";
    public static final String PARAM_SHOW_ADMIN_ORG_VIEW_TYPE = "showAdminOrgViewType";
    public static final String PARAM_IS_INCLUDE_ALL_SUB = "isIncludeAllSub";
    private static final String FILTER_CONTAINER_AP = "filtercontainerap";
    private Boolean isLockDutyCombo;

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        Map customParams = listShowParameter.getCustomParams();
        this.enableIncludeSubOrgButton(customParams);
        if (this.getModel().getValue(ORGVIEW_COMLISTID) == null) {
            this.setOrgBizComboEdit(this.getOrgBizList(customParams));
            this.setComDefaultValue();
        }
        if (this.isLockDutyCombo().booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{ORGVIEW_COMLISTID});
        }
        this.updateOrgViewAndTitle();
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.setFieldProperty(FILTER_CONTAINER_AP, "tips", null);
    }

    private Boolean isLockDutyCombo() {
        if (this.isLockDutyCombo != null) {
            return this.isLockDutyCombo;
        }
        String isLockFuncObj = this.getPageCache().get("islockfunc");
        if (isLockFuncObj == null) {
            this.isLockDutyCombo = Boolean.FALSE;
        }
        this.isLockDutyCombo = Boolean.valueOf(isLockFuncObj);
        return this.isLockDutyCombo;
    }

    private void enableIncludeSubOrgButton(Map<String, Object> customParams) {
        Object isIncludeAllSub = customParams.get(PARAM_IS_INCLUDE_ALL_SUB);
        if (isIncludeAllSub != null && Boolean.parseBoolean(isIncludeAllSub.toString())) {
            this.getView().getModel().setValue("chkincludechild", (Object)Boolean.TRUE);
            this.getView().updateView("chkincludechild");
        }
        if (LicenseServiceHelper.isSingleOrgManageMode()) {
            this.getView().getModel().setValue("chkincludechild", (Object)Boolean.TRUE);
        }
    }

    @Override
    public boolean isUseDefaultClickEvent() {
        return true;
    }

    private List<Map<String, String>> getOrgBizList(Map<String, Object> customParams) {
        QFilter[] filters;
        Map bizMap;
        QFilter baseFilter = new QFilter("isbasetype", "=", (Object)Boolean.TRUE);
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter visiableFilter = new QFilter("visiable", "=", (Object)Boolean.TRUE);
        QFilter categoryFilter = new QFilter("category", "=", (Object)"1");
        boolean showAdminOrgViewType = true;
        Object showAdminOrgViewTypeParam = customParams.get(PARAM_SHOW_ADMIN_ORG_VIEW_TYPE);
        if (StringUtils.isNotBlank((Object)showAdminOrgViewTypeParam)) {
            showAdminOrgViewType = Boolean.parseBoolean(showAdminOrgViewTypeParam.toString());
        }
        if (showAdminOrgViewType) {
            QFilter adminFilter = new QFilter("id", "=", (Object)1L);
            categoryFilter = categoryFilter.or(adminFilter);
        }
        if ((bizMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org_biz", (String)"id,fnumber,fname", (QFilter[])(filters = new QFilter[]{baseFilter, enableFilter, visiableFilter, categoryFilter}), (String)"fnumber")) == null || bizMap.isEmpty()) {
            return new ArrayList<Map<String, String>>(0);
        }
        ArrayList<Map<String, String>> bizList = new ArrayList<Map<String, String>>(bizMap.size());
        HashMap<String, String> map = null;
        for (Map.Entry entry : bizMap.entrySet()) {
            DynamicObject bizObj = (DynamicObject)entry.getValue();
            map = new HashMap<String, String>(2);
            map.put("number", bizObj.getString("fnumber"));
            map.put("name", bizObj.getString("fname"));
            bizList.add(map);
        }
        return bizList;
    }

    private void setOrgBizComboEdit(List<Map<String, String>> bizList) {
        if (Utils.isListEmpty(bizList)) {
            return;
        }
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl(ORGVIEW_COMLISTID);
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(bizList.size());
        for (Map<String, String> map : bizList) {
            ComboItem item = new ComboItem();
            item.setValue(map.get("number"));
            item.setCaption(new LocaleString(map.get("name")));
            comboItems.add(item);
        }
        comboEdit.setComboItems(comboItems);
    }

    private void setComDefaultValue() {
        String orgFuncId = this.getOrgViewType();
        if ("15".equals(orgFuncId)) {
            return;
        }
        this.getView().getModel().setValue(ORGVIEW_COMLISTID, (Object)orgFuncId);
        this.getView().updateView(ORGVIEW_COMLISTID);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if (ORGVIEW_COMLISTID.equals(propertyName)) {
            BaseMessageUtils.showLoading((IFormView)this.getView(), (String)OrgMessage.getMessage((String)"M00140"), () -> this.changeViewType());
        }
    }

    private void changeViewType() {
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        String orgFuncId = "15";
        Object orgFuncObj = this.getView().getModel().getValue(ORGVIEW_COMLISTID);
        if (StringUtils.isNotBlank((Object)orgFuncObj)) {
            orgFuncId = orgFuncObj.toString();
        }
        String oldOrgFuncId = this.getOrgViewType();
        this.setOrgViewType(orgFuncId);
        if ("01".equals(orgFuncId) || "01".equals(oldOrgFuncId)) {
            this.showDisabledOrg(listShowParameter, orgFuncId);
        }
        this.updateOrgViewAndTitle();
        TreeNode rootNode = this.initRootNode();
        if (rootNode == null) {
            this.treeListView.refreshTreeView();
        } else {
            this.treeListView.getTreeView().deleteAllNodes();
            TreeView treeView = (TreeView)this.getControl("treeview");
            treeView.addNode(rootNode);
            treeView.treeNodeClick("", rootNode.getId());
        }
    }

    private void updateOrgViewAndTitle() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String title = this.updateOrgViewAndGetTitle(formShowParameter);
        Boolean isOrgF7TitleCustomized = formShowParameter.getCustomParams().getOrDefault("isOrgF7TitleCustomized", Boolean.FALSE);
        if (!Boolean.parseBoolean(((Object)isOrgF7TitleCustomized).toString()) && StringUtils.isNotBlank((CharSequence)title)) {
            ListCache listCache = new ListCache(this.getPageCache(), FILTER_CONTAINER_AP);
            listCache.setFilterContainerTitle(new LocaleString(title));
            this.getView().updateView(FILTER_CONTAINER_AP);
        }
    }

    private String updateOrgViewAndGetTitle(FormShowParameter formShowParameter) {
        QFilter defaultFilter;
        QFilter numberFilter;
        QFilter[] filters;
        DynamicObject viewObj;
        String orgFuncId = this.getOrgViewType();
        if (formShowParameter.getParentPageId() != null) {
            PageCache parentPageCache = new PageCache(formShowParameter.getParentPageId());
            parentPageCache.put(KEY_FUN_PARENTPAGECACHE, orgFuncId);
        }
        String name = ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u5143", (String)"OrgF7ViewListFormPlugin_0", (String)"bos-org-formplugin", (Object[])new Object[0]);
        if (StringUtils.isNotBlank((CharSequence)orgFuncId) && (viewObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org_viewschema", (String)"id,number,treetypeid", (QFilter[])(filters = new QFilter[]{numberFilter = new QFilter("treetype", "=", (Object)orgFuncId), defaultFilter = new QFilter("isdefault", "=", (Object)Boolean.TRUE)}))) != null) {
            DynamicObject bizObj;
            if (!this.isLockDutyCombo().booleanValue()) {
                this.setOrgViewNumber(viewObj.getString("number"));
            }
            if ((bizObj = viewObj.getDynamicObject("treetypeid")) != null) {
                name = bizObj.getString("fname");
                if (StringUtils.isNotBlank((CharSequence)bizObj.getString("userdefinename"))) {
                    name = bizObj.getString("userdefinename");
                }
                this.getPageCache().put(this.getView().getPageId() + ".orgViewPropertyName", bizObj.getString("propertyname"));
            }
        }
        boolean isChangeTitle = true;
        String cacheTitleChangeView = this.getPageCache().get("titleChangeView");
        if (StringUtils.isBlank((CharSequence)cacheTitleChangeView)) {
            if ("15".equals(orgFuncId)) {
                isChangeTitle = false;
            }
        } else if (cacheTitleChangeView.equals(orgFuncId)) {
            isChangeTitle = false;
        }
        this.getPageCache().put("titleChangeView", orgFuncId);
        return isChangeTitle ? name : "";
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        this.addInitRootOrgFilter(e);
    }

    private void addInitRootOrgFilter(SetFilterEvent e) {
        if (((Boolean)this.getModel().getValue("showallorg")).booleanValue()) {
            return;
        }
        Object paramInitRootOrgId = this.getView().getFormShowParameter().getCustomParam("initRootOrgId");
        if (StringUtils.isBlank((Object)paramInitRootOrgId)) {
            return;
        }
        TreeNode rootNode = this.getTreeModel().getRoot();
        if (Objects.isNull(rootNode)) {
            return;
        }
        QFilter orgFilter = null;
        String longNumber = rootNode.getLongNumber();
        if (StringUtils.isBlank((CharSequence)longNumber)) {
            ArrayList<Long> orgIds = new ArrayList<Long>(1);
            orgIds.add(Long.valueOf(paramInitRootOrgId.toString()));
            orgFilter = new QFilter("id", "in", (Object)OrgUnitServiceHelper.getAllSubordinateOrgs((String)this.getOrgViewNumber(), orgIds, (boolean)true));
        } else if (longNumber.indexOf("!") != -1) {
            orgFilter = new QFilter("structure.vieworg", "=", (Object)Long.valueOf(paramInitRootOrgId.toString()));
            String longNumberFilter = rootNode.getLongNumber() + "!" + "%";
            orgFilter = orgFilter.or(QFilter.like((String)"structure.longnumber", (String)longNumberFilter));
        }
        if (orgFilter != null) {
            e.getQFilters().add(orgFilter);
        }
    }
}

