/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orgview.orgunit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ListVisible;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.list.IListColumn;
import kd.bos.org.OrgListPlugin;
import kd.bos.org.utils.OrgUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class OrgUnitListPlugin
extends OrgListPlugin {
    private static final String BIZ_CATEGORY_OT = "2";

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        List listColumns = args.getListColumns();
        if (CollectionUtils.isEmpty((Collection)listColumns)) {
            return;
        }
        this.modifyDutyColumn(listColumns);
    }

    private void modifyDutyColumn(List<IListColumn> listColumns) {
        List bizObjList = OrgUtils.getAllOrgBizNameList();
        if (CollectionUtils.isEmpty((Collection)bizObjList)) {
            return;
        }
        int bizCount = bizObjList.size();
        ArrayList<String> orgBizProAllList = new ArrayList<String>(bizCount);
        HashMap<String, DynamicObject> baseBizObjMap = new HashMap<String, DynamicObject>(bizCount);
        for (DynamicObject dutyObj : bizObjList) {
            String fieldKey = dutyObj.getString("propertyname");
            orgBizProAllList.add(fieldKey);
            baseBizObjMap.put(fieldKey, dutyObj);
        }
        this.addPresetBiz(orgBizProAllList);
        if ("01".equals(this.getCurrentOrgFunctionId())) {
            this.removeAllDutyColumn(listColumns, orgBizProAllList);
        } else {
            this.addOtherDutyColumn(listColumns, orgBizProAllList, baseBizObjMap);
        }
    }

    private String getCurrentOrgFunctionId() {
        String orgFuncId = this.getPageCache().get("orgFuncId");
        if (StringUtils.isBlank((CharSequence)orgFuncId)) {
            orgFuncId = (String)this.getView().getFormShowParameter().getCustomParam("orgFuncId");
        }
        return orgFuncId;
    }

    private void removeAllDutyColumn(List<IListColumn> listColumns, List<String> orgBizProAllList) {
        Iterator<IListColumn> iterator = listColumns.iterator();
        while (iterator.hasNext()) {
            IListColumn listColumn = iterator.next();
            if (!orgBizProAllList.contains(listColumn.getListFieldKey())) continue;
            iterator.remove();
        }
    }

    private void addOtherDutyColumn(List<IListColumn> listColumns, List<String> orgBizProAllList, Map<String, DynamicObject> baseBizObjMap) {
        Iterator<IListColumn> columnIterator = listColumns.iterator();
        while (columnIterator.hasNext()) {
            boolean visible;
            IListColumn listColumn = columnIterator.next();
            String fieldKey = listColumn.getListFieldKey();
            if (!orgBizProAllList.contains(fieldKey)) continue;
            DynamicObject bizObj = baseBizObjMap.get(fieldKey);
            boolean bl = visible = bizObj != null && bizObj.getBoolean("enable") && bizObj.getBoolean("visiable") && !BIZ_CATEGORY_OT.equals(bizObj.getString("category"));
            if (visible) {
                listColumn.setCaption(new LocaleString(bizObj.getString("fname")));
                if (bizObj.getBoolean("basemaintain")) continue;
                listColumn.setVisible(ListVisible.NOT.getVisible());
                continue;
            }
            columnIterator.remove();
        }
    }

    private void addPresetBiz(List<String> orgBizProAllList) {
        for (int i = 1; i <= 10; ++i) {
            orgBizProAllList.add("fispresetbiz" + i);
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.updateOrgViewAndTitle(this.getCurrentOrgFunctionId());
    }

    private void updateOrgViewAndTitle(String orgFuncId) {
        if (StringUtils.isBlank((CharSequence)orgFuncId)) {
            return;
        }
        QFilter filter1 = new QFilter("fnumber", "=", (Object)orgFuncId);
        QFilter[] filters = new QFilter[]{filter1};
        DynamicObject bizObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org_biz", (String)"id,fname ", (QFilter[])filters);
        if (bizObj != null) {
            String name = bizObj.getString("fname");
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            formShowParameter.setCaption(name);
            formShowParameter.getFormConfig().setCaption(new LocaleString(name));
        }
    }
}

