/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orgview.orgunit;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.org.utils.OrgUtils;
import kd.bos.orgview.OrgViewTreeListPlugin;

public class OrgUnitTreeListPlugin
extends OrgViewTreeListPlugin {
    private static final String BAR_ORGUNIT = "bar_orgunit";

    @Override
    public void initializeOrgView() {
        this.setOrgViewType("15");
        this.setOrgViewNumber("15");
        this.getView().getFormShowParameter().setCustomParam("isOrgBaseAdmin", (Object)Boolean.TRUE);
    }

    @Override
    public void beforeItemClick(BeforeItemClickEvent evt) {
        if ("tblclose".equalsIgnoreCase(evt.getItemKey().toLowerCase())) {
            return;
        }
        super.beforeItemClick(evt);
        switch (evt.getItemKey().toLowerCase()) {
            case "bar_orgunit": {
                this.showOrgUnitEdit();
                evt.setCancel(true);
                break;
            }
            case "tblmaintain": {
                this.maintainOrgView();
                evt.setCancel(true);
                break;
            }
        }
    }

    @Override
    public void addEditShowFormParameter(BaseShowParameter parameter) {
        if (parameter != null) {
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
            parameter.setFormId(listShowParameter.getBillFormId());
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent arg0) {
        super.closedCallBack(arg0);
        String actionId = arg0.getActionId();
        if (BAR_ORGUNIT.equals(actionId)) {
            Object returnData = arg0.getReturnData();
            if (returnData == null) {
                return;
            }
            Map returnDataMap = (Map)returnData;
            if (!returnDataMap.containsKey("ischanged")) {
                return;
            }
            TreeView treeView = this.getTreeListView().getTreeView();
            String focusNodeId = treeView.getTreeState().getFocusNodeId();
            if (StringUtils.isBlank((CharSequence)focusNodeId)) {
                focusNodeId = this.getTreeModel().getRoot().getId();
            }
            treeView.treeNodeClick("", focusNodeId);
        }
    }

    private void showOrgUnitEdit() {
        BillShowParameter formShowParameter = new BillShowParameter();
        formShowParameter.setFormId("bos_org_viewschema_ou");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u5feb\u901f\u65b0\u589e", (String)"OrgUnitTreeListPlugin_0", (String)"bos-org-formplugin", (Object[])new Object[0]));
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BAR_ORGUNIT));
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    private void maintainOrgView() {
        BillShowParameter formShowParameter = new BillShowParameter();
        formShowParameter.setFormId("bos_org_viewschema_biz");
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult operationResult = args.getOperationResult();
        if (operationResult == null) {
            return;
        }
        List successPkIds = operationResult.getSuccessPkIds();
        if ("enable".equals(args.getOperateKey())) {
            this.refreshTreeAfterDoOperation(successPkIds, false, "enable");
        } else if ("disable".equals(args.getOperateKey())) {
            this.refreshTreeAfterDoOperation(successPkIds, true, "disable");
        }
    }

    @Override
    public boolean isUseDefaultClickEvent() {
        return true;
    }

    @Override
    protected void rebuildAfterQueryOfExport(DynamicObject[] queryValues) {
        Map notBaseMaintainViewNumberMap = OrgUtils.getNotBaseMaintainViewMap();
        TreeMap<String, DynamicObject> structureMap = new TreeMap<String, DynamicObject>();
        for (DynamicObject orgObj : queryValues) {
            DynamicObjectCollection structureCol = orgObj.getDynamicObjectCollection("structure");
            Iterator iterator = structureCol.iterator();
            while (iterator.hasNext()) {
                DynamicObject structureObj = (DynamicObject)iterator.next();
                DynamicObject viewObj = structureObj.getDynamicObject("view");
                if (viewObj == null) continue;
                boolean remove = false;
                if (viewObj.getLong("id") == 1L) {
                    remove = true;
                } else if (notBaseMaintainViewNumberMap != null && notBaseMaintainViewNumberMap.containsKey(viewObj.getString("number"))) {
                    remove = true;
                }
                if (!remove) {
                    structureMap.put(viewObj.getString("number"), structureObj);
                }
                iterator.remove();
            }
            DynamicObject structureObj = (DynamicObject)structureMap.remove("15");
            if (structureObj != null) {
                structureCol.add(0, structureObj);
            }
            structureCol.addAll(structureMap.values());
            structureMap.clear();
        }
    }
}

