/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.event;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.event.AbstractOrgEventServicePlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.PermissionService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class OrgPermEventServicePlugin
extends AbstractOrgEventServicePlugin {
    private static Log logger = LogFactory.getLog(OrgPermEventServicePlugin.class);

    public Object handleEvent(KDBizEvent evt) {
        try {
            logger.debug("\u3010\u4e8b\u4ef6\u8ba2\u9605-\u7ec4\u7ec7\u4fdd\u5b58\u3011\u6267\u884c\u66f4\u65b0\u7ec4\u7ec7\u6743\u9650\u7684\u5904\u7406start");
            PermissionServiceHelper.clearAllCache();
            JSONObject params = this.getBecEventOperationParams(evt);
            if (params == null) {
                List<Long> ids = this.getIds(evt);
                Map<String, Map<Long, Set<Long>>> viewParentOrgMap = this.getOrg(ids);
                this.updateAdminChargeOrgs(viewParentOrgMap);
            } else {
                HashMap<String, Map<Long, Set<Long>>> viewParentOrgMap = new HashMap<String, Map<Long, Set<Long>>>(2);
                this.getViewParentOrgMap(viewParentOrgMap, params, "add");
                this.getViewParentOrgMap(viewParentOrgMap, params, "update");
                this.updateAdminChargeOrgs(viewParentOrgMap);
            }
            logger.debug("\u3010\u4e8b\u4ef6\u8ba2\u9605-\u7ec4\u7ec7\u4fdd\u5b58\u3011\u6267\u884c\u66f4\u65b0\u7ec4\u7ec7\u6743\u9650\u7684\u5904\u7406end");
        }
        catch (Exception e) {
            logger.debug("\u3010\u4e8b\u4ef6\u8ba2\u9605-\u7ec4\u7ec7\u4fdd\u5b58\u3011\u6267\u884c\u66f4\u65b0\u7ec4\u7ec7\u6743\u9650\u7684\u5904\u7406exception", (Object)e);
        }
        return null;
    }

    private void updateAdminChargeOrgs(Map<String, Map<Long, Set<Long>>> viewParentOrgMap) {
        if (viewParentOrgMap.isEmpty()) {
            return;
        }
        PermissionService permService = (PermissionService)ServiceFactory.getService(PermissionService.class);
        for (Map.Entry<String, Map<Long, Set<Long>>> viewEntry : viewParentOrgMap.entrySet()) {
            for (Map.Entry<Long, Set<Long>> orgEntry : viewEntry.getValue().entrySet()) {
                Set<Long> value;
                Long key = orgEntry.getKey();
                boolean success = permService.updateAdminChargeOrgs(key, new ArrayList<Long>(value = orgEntry.getValue()), viewEntry.getKey(), true);
                if (success) continue;
                logger.info("\u3010\u4e8b\u4ef6\u8ba2\u9605-\u7ec4\u7ec7\u4fdd\u5b58\u3011\u6267\u884c\u7ec4\u7ec7\u6743\u9650\u66f4\u65b0{}\uff0ckey\uff1a{}\uff0cvalue\uff1a{}\uff0c viewEntry.getKey()\uff1a{}", new Object[]{success ? "\u6210\u529f\uff1a" : "\u5931\u8d25\uff1a", key, null == value || value.isEmpty() ? "" : JSON.toJSONString(value), viewEntry.getKey()});
            }
        }
    }

    private void getViewParentOrgMap(Map<String, Map<Long, Set<Long>>> viewParentOrgMap, JSONObject params, String operation) {
        JSONObject opJson = params.getJSONObject(operation);
        if (opJson == null) {
            return;
        }
        Set entries = opJson.entrySet();
        for (Map.Entry entry : entries) {
            JSONObject viewJson;
            JSONObject idJson = (JSONObject)entry.getValue();
            JSONObject entityJson = idJson.getJSONObject("structure");
            if (entityJson == null) continue;
            JSONObject proJson1 = entityJson.getJSONObject("property");
            JSONObject proJson2 = entityJson.getJSONObject("add");
            if (null == proJson1 && null == proJson2) continue;
            long id = Long.parseLong((String)entry.getKey());
            if (null != proJson1) {
                viewJson = proJson1.getJSONObject(Long.toString(1L));
                this.getViewParentOrgMap(id, viewParentOrgMap, viewJson, "01", operation, false);
                viewJson = proJson1.getJSONObject(Long.toString(15L));
                this.getViewParentOrgMap(id, viewParentOrgMap, viewJson, "15", operation, false);
            }
            if (null == proJson2) continue;
            viewJson = proJson2.getJSONObject(Long.toString(1L));
            this.getViewParentOrgMap(id, viewParentOrgMap, viewJson, "01", operation, true);
            viewJson = proJson2.getJSONObject(Long.toString(15L));
            this.getViewParentOrgMap(id, viewParentOrgMap, viewJson, "15", operation, true);
        }
    }

    private void getViewParentOrgMap(long id, Map<String, Map<Long, Set<Long>>> viewParentOrgMap, JSONObject changeProJson, String viewNumber, String operation, boolean innerAdd) {
        Object oldValue;
        if (changeProJson == null) {
            return;
        }
        JSONObject parentJson = changeProJson.getJSONObject("viewparent");
        if (parentJson == null) {
            return;
        }
        Object newValue = parentJson.get((Object)"newValue");
        if (StringUtils.isBlank((Object)newValue)) {
            return;
        }
        if (!innerAdd && Objects.equals("update", operation) && Objects.equals(newValue, oldValue = parentJson.get((Object)"oldValue"))) {
            return;
        }
        Map parentOrgMap = viewParentOrgMap.computeIfAbsent(viewNumber, v -> new HashMap(64));
        parentOrgMap.computeIfAbsent(Long.valueOf(newValue.toString()), v -> new HashSet(64)).add(id);
    }

    private Map<String, Map<Long, Set<Long>>> getOrg(List<Long> ids) {
        HashMap<String, Map<Long, Set<Long>>> viewParentOrgMap = new HashMap<String, Map<Long, Set<Long>>>(2);
        String selectFields = "id,view.number view,org,parent";
        QFilter viewFilter = new QFilter("view", "in", (Object)new Long[]{1L, 15L});
        QFilter orgFilter = new QFilter("org", "in", ids);
        QFilter[] filters = new QFilter[]{viewFilter, orgFilter};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"OrgPermEventServicePlugin.handleEvent", (String)"bos_org_structure", (String)selectFields, (QFilter[])filters, (String)"");){
            for (Row row : dataSet) {
                Map parentOrgMap = viewParentOrgMap.computeIfAbsent(row.getString("view"), v -> new HashMap(64));
                parentOrgMap.computeIfAbsent(row.getLong("parent"), v -> new HashSet(64)).add(row.getLong("org"));
            }
        }
        return viewParentOrgMap;
    }
}

