/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.org.event.AbstractOrgEventServicePlugin;
import kd.bos.org.utils.OrgViewUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class OrgRelationEventServicePlugin
extends AbstractOrgEventServicePlugin {
    public Object handleEvent(KDBizEvent evt) {
        List<Long> ids = this.getIds(evt);
        if (!ids.isEmpty()) {
            this.saveAdminOrgRelationInGalaxy(ids);
        }
        return null;
    }

    private void saveAdminOrgRelationInGalaxy(List<Long> ids) {
        if (OrgUnitServiceHelper.getOrgmanageMode() != 1) {
            return;
        }
        logger.info("\u3010\u4e8b\u4ef6\u8ba2\u9605-\u7ec4\u7ec7\u4fdd\u5b58\u3011\u6267\u884c\u4fdd\u5b58\u884c\u653f\u7ec4\u7ec7\u5230\u4e1a\u52a1\u5355\u5143\u5206\u914d\u90e8\u95e8\uff1a" + ids);
        List<Long> adminOrgIds = this.getAdminOrgIds(ids);
        if (adminOrgIds.isEmpty()) {
            return;
        }
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                this.saveRelation(new ArrayList<Long>(adminOrgIds));
                this.saveDuty(new ArrayList<Long>(adminOrgIds));
            }
            catch (Exception e) {
                logger.info("\u3010\u4e8b\u4ef6\u8ba2\u9605-\u7ec4\u7ec7\u4fdd\u5b58\u3011\u201c\u5355\u7ec4\u7ec7\u4f01\u4e1a\u7ba1\u7406\u6a21\u5f0f\u201d\u65f6\uff0c\u4fdd\u5b58\u884c\u653f\u7ec4\u7ec7\u5230\u4e1a\u52a1\u5355\u5143\u5206\u914d\u90e8\u95e8\u5931\u8d25\uff1a" + e.getMessage());
                txHandle.markRollback();
            }
        }
        logger.info("\u3010\u4e8b\u4ef6\u8ba2\u9605-\u7ec4\u7ec7\u4fdd\u5b58\u3011\u6267\u884c\u4fdd\u5b58\u884c\u653f\u7ec4\u7ec7\u5230\u4e1a\u52a1\u5355\u5143\u5206\u914d\u90e8\u95e8\uff1a" + adminOrgIds);
    }

    private List<Long> getAdminOrgIds(List<Long> ids) {
        QFilter bizOrgFilter = new QFilter("isbizorg", "=", (Object)Boolean.FALSE);
        QFilter idFilter = new QFilter("id", "in", ids);
        QFilter[] filters = new QFilter[]{bizOrgFilter, idFilter};
        Map orgObjMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"id", (QFilter[])filters);
        if (CollectionUtils.isEmpty((Map)orgObjMap)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Long> adminOrgIds = new ArrayList<Long>(orgObjMap.size());
        for (Map.Entry entry : orgObjMap.entrySet()) {
            adminOrgIds.add((Long)entry.getKey());
        }
        return adminOrgIds;
    }

    private void saveRelation(List<Long> ids) {
        this.removeExistsRelationOrg(ids);
        if (ids.isEmpty()) {
            return;
        }
        int index = 0;
        DynamicObject[] orgRelationObjArr = new DynamicObject[ids.size()];
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"bos_org_orgrelation_dept");
        long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
        for (Long id : ids) {
            DynamicObject orgRelationObj = new DynamicObject((DynamicObjectType)type);
            orgRelationObj.set("typerelation", (Object)585511977942548480L);
            orgRelationObj.set("fromorg", (Object)rootOrgId);
            orgRelationObj.set("toorg", (Object)id);
            orgRelationObjArr[index++] = orgRelationObj;
        }
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"bos_org_orgrelation_dept", (DynamicObject[])orgRelationObjArr, null);
        if (!operationResult.isSuccess()) {
            logger.info("\u3010\u4e8b\u4ef6\u8ba2\u9605-\u7ec4\u7ec7\u4fdd\u5b58\u3011\u6267\u884c\u4e1a\u52a1\u5355\u5143\u5206\u914d\u90e8\u95e8\u4fdd\u5b58\u64cd\u4f5c\u5931\u8d25\u3002");
        }
    }

    private void removeExistsRelationOrg(List<Long> ids) {
        ArrayList<Long> existsIds = new ArrayList<Long>(ids.size());
        QFilter typerelationFilter = new QFilter("typerelation", "=", (Object)585511977942548480L);
        QFilter fromorgFilter = new QFilter("fromorg", "=", (Object)OrgUnitServiceHelper.getRootOrgId());
        QFilter toorgFilter = new QFilter("toorg", "in", ids);
        QFilter[] filters = new QFilter[]{typerelationFilter, fromorgFilter, toorgFilter};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"OrgRelationEventServicePlugin.removeExistsRelationOrg", (String)"bos_org_orgrelation", (String)"toorg", (QFilter[])filters, (String)"");){
            for (Row row : dataSet) {
                existsIds.add(row.getLong("toorg"));
            }
        }
        ids.removeAll(existsIds);
    }

    private void saveDuty(List<Long> ids) {
        this.removeExistsDutyOrg(ids);
        if (ids.isEmpty()) {
            return;
        }
        int index = 0;
        DynamicObject[] dutyObjArr = new DynamicObject[ids.size()];
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"bos_org_dutyrelation");
        for (Long id : ids) {
            DynamicObject dutyObj = new DynamicObject((DynamicObjectType)type);
            dutyObj.set("org", (Object)id);
            dutyObj.set("orgduty", (Object)1L);
            OrgViewUtils.genCommonField((DynamicObject)dutyObj, (boolean)true);
            dutyObjArr[index++] = dutyObj;
        }
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"bos_org_dutyrelation", (DynamicObject[])dutyObjArr, null);
        if (!operationResult.isSuccess()) {
            logger.info("\u3010\u4e8b\u4ef6\u8ba2\u9605-\u7ec4\u7ec7\u4fdd\u5b58\u3011\u6267\u884c\u90e8\u95e8\u5c5e\u6027\u7ba1\u7406\u4fdd\u5b58\u64cd\u4f5c\u5931\u8d25\u3002");
        }
    }

    private void removeExistsDutyOrg(List<Long> ids) {
        ArrayList<Long> existsIds = new ArrayList<Long>(ids.size());
        QFilter orgFilter = new QFilter("org", "in", ids);
        QFilter[] filters = new QFilter[]{orgFilter};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"OrgRelationEventServicePlugin.removeExistsDutyOrg", (String)"bos_org_dutyrelation", (String)"org", (QFilter[])filters, (String)"");){
            for (Row row : dataSet) {
                existsIds.add(row.getLong("org"));
            }
        }
        ids.removeAll(existsIds);
    }
}

