/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.base.utils.msg.OrgMessage;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.org.api.IOrgBizChecker;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class OrgRelationDutyChecker
implements IOrgBizChecker {
    private Map<String, String> viewtypeNameMap = null;

    public String batchCheckBizClear(long orgId, List<String> viewNumberList) {
        List<String> treetypeList = this.getTreetypeList(viewNumberList);
        if (treetypeList.isEmpty()) {
            return "";
        }
        String selectFields = "typerelation.name,typerelation.fromtype,typerelation.totype, ";
        QFilter fromOrgFilter = new QFilter("fromorg", "=", (Object)orgId);
        QFilter fromTypeFilter = new QFilter("typerelation.fromtype", "in", treetypeList);
        fromOrgFilter = fromOrgFilter.and(fromTypeFilter);
        QFilter toOrgFilter = new QFilter("toorg", "=", (Object)orgId);
        QFilter toTypeFilter = new QFilter("typerelation.totype", "in", treetypeList);
        toOrgFilter = toOrgFilter.and(toTypeFilter);
        QFilter filter = fromOrgFilter.or(toOrgFilter);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObject relationObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org_orgrelation", (String)selectFields, (QFilter[])filters);
        if (relationObj == null) {
            return "";
        }
        String fromtype = relationObj.getString("typerelation.fromtype");
        String totype = relationObj.getString("typerelation.totype");
        String existsViewName = "";
        if (treetypeList.contains(fromtype)) {
            existsViewName = this.viewtypeNameMap.get(fromtype);
        } else if (treetypeList.contains(totype)) {
            existsViewName = this.viewtypeNameMap.get(totype);
        }
        return OrgMessage.getMessage((String)"M00111", (Object[])new Object[]{existsViewName, relationObj.get("typerelation.name")});
    }

    private List<String> getTreetypeList(List<String> viewNumberList) {
        QFilter defaultFilter = new QFilter("isdefault", "=", (Object)Boolean.TRUE);
        QFilter numberFilter = new QFilter("number", "in", viewNumberList);
        String selectFields = "name,treetype,treetypeid";
        QFilter[] filters = new QFilter[]{defaultFilter, numberFilter};
        Map viewObjMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org_viewschema", (String)selectFields, (QFilter[])filters);
        if (CollectionUtils.isEmpty((Map)viewObjMap)) {
            return new ArrayList<String>(0);
        }
        int count = viewObjMap.size();
        ArrayList<String> treetypeList = new ArrayList<String>(count);
        this.viewtypeNameMap = new HashMap<String, String>(count);
        for (Map.Entry viewEntry : viewObjMap.entrySet()) {
            DynamicObject viewObj = (DynamicObject)viewEntry.getValue();
            DynamicObject bizObj = viewObj.getDynamicObject("treetypeid");
            String treetype = "";
            String name = "";
            if (bizObj == null) {
                treetype = viewObj.getString("treetype");
                name = viewObj.getString("name");
            } else {
                treetype = bizObj.getString("fnumber");
                name = bizObj.getString("fname");
            }
            treetypeList.add(treetype);
            this.viewtypeNameMap.put(treetype, name);
        }
        return treetypeList;
    }
}

