/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.base.utils.msg.BaseMessage;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OrgRelationParam;
import kd.bos.org.utils.Utils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class OrgRelationService {
    private static final Log logger = LogFactory.getLog(OrgRelationService.class);
    private static final String FROM_ORG_ORDER = "isdefaultfromorg desc,fromorg.number";
    private static final String TO_ORG_ORDER = "isdefaulttoorg desc,toorg.number";
    private static final String IS_DEFAULT = "isDefault";

    public List<Long> getAdminOrgRelation(List<Long> orgIds, boolean isReturnAdminOrg) {
        Map<Long, Set<Long>> adminOrgRelationMap = this.getAdminOrgRelationMap(orgIds, isReturnAdminOrg);
        if (CollectionUtils.isEmpty(adminOrgRelationMap)) {
            return new ArrayList<Long>(0);
        }
        ArrayList<Long> relationOrgList = new ArrayList<Long>(adminOrgRelationMap.size());
        for (Map.Entry<Long, Set<Long>> entry : adminOrgRelationMap.entrySet()) {
            relationOrgList.addAll((Collection<Long>)entry.getValue());
        }
        return relationOrgList;
    }

    public Map<Long, Set<Long>> getAdminOrgRelationMap(List<Long> orgIds, boolean isReturnAdminOrg) {
        String orderBy;
        String toKey;
        String fromKey;
        if (Utils.isListEmpty(orgIds)) {
            logger.info("[getAdminOrgRelationMap]\u6839\u636e\u884c\u653f\u7ec4\u7ec7\u534f\u4f5c\u5173\u7cfb\u67e5\u8be2\u7ec4\u7ec7\u65f6\uff0c\u53c2\u6570\u4e3a\u7a7a\u3002");
            return new HashMap<Long, Set<Long>>(0);
        }
        HashMap<Long, Set<Long>> relationMap = new HashMap<Long, Set<Long>>(orgIds.size());
        if (isReturnAdminOrg) {
            fromKey = "fromorg";
            toKey = "toorg";
            orderBy = TO_ORG_ORDER;
        } else {
            fromKey = "toorg";
            toKey = "fromorg";
            orderBy = FROM_ORG_ORDER;
        }
        QFilter typeFilter = new QFilter("typerelation", "=", (Object)585511977942548480L);
        QFilter orgFilter = new QFilter(fromKey, "in", orgIds);
        QFilter[] filters = new QFilter[]{typeFilter, orgFilter};
        Map relationObjMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org_orgrelation", (String)(fromKey + "," + toKey), (QFilter[])filters, (String)orderBy);
        if (!CollectionUtils.isEmpty((Map)relationObjMap)) {
            for (DynamicObject relationObj : relationObjMap.values()) {
                DynamicObject fromOrgObj = relationObj.getDynamicObject(fromKey);
                DynamicObject toOrgObj = relationObj.getDynamicObject(toKey);
                if (fromOrgObj == null || toOrgObj == null) continue;
                relationMap.computeIfAbsent(fromOrgObj.getLong("id"), v -> new LinkedHashSet(relationObjMap.size())).add(toOrgObj.getLong("id"));
            }
        }
        logger.info("\u83b7\u53d6\u4e1a\u52a1\u5355\u5143\u5206\u914d\u90e8\u95e8\u7684\u7ed3\u679c\u662f\uff1a" + relationMap);
        return relationMap;
    }

    public List<Long> getFromOrgs(String toOrgType, Long toOrgId, String fromOrgType, boolean isIncludeToOrgSelf) {
        OrgRelationParam param = new OrgRelationParam();
        param.setToViewType(toOrgType);
        param.setFromViewType(fromOrgType);
        param.setOrgId(toOrgId.longValue());
        param.setDirectViewType("fromorg");
        param.setIncludeSelf(isIncludeToOrgSelf);
        return this.getBizRelationOrgIds(param);
    }

    public Long getToOrg(String fromOrgType, String toOrgType, Long fromOrgId, boolean isIncludeFromOrgSelf) {
        OrgRelationParam param = new OrgRelationParam();
        param.setToViewType(toOrgType);
        param.setFromViewType(fromOrgType);
        param.setOrgId(fromOrgId.longValue());
        param.setDirectViewType("toorg");
        param.setIncludeSelf(isIncludeFromOrgSelf);
        List<Long> toOrgIds = this.getBizRelationOrgIds(param);
        return CollectionUtils.isEmpty(toOrgIds) ? Long.valueOf(0L) : toOrgIds.get(0);
    }

    public List<Long> getAllToOrg(String fromOrgType, String toOrgType, Long fromOrgId, boolean isIncludeFromOrgSelf) {
        OrgRelationParam param = new OrgRelationParam();
        param.setToViewType(toOrgType);
        param.setFromViewType(fromOrgType);
        param.setOrgId(fromOrgId.longValue());
        param.setDirectViewType("toorg");
        param.setIncludeSelf(isIncludeFromOrgSelf);
        return this.getBizRelationOrgIds(param);
    }

    public long getDefaultOrgRelation(OrgRelationParam param) {
        return this.getDefaultOrgRelation(param, false);
    }

    public long getOrgForFormDefValue(OrgRelationParam param) {
        return this.getDefaultOrgRelation(param, true);
    }

    private long getDefaultOrgRelation(OrgRelationParam param, boolean forFormDefValue) {
        Object id;
        Map orgMap;
        boolean isConfiguredRelation;
        Map<String, Object> orgRelation = this.getOrgRelation(param, 2);
        List data = (List)orgRelation.get("data");
        boolean bl = isConfiguredRelation = !CollectionUtils.isEmpty((Collection)data);
        if (isConfiguredRelation) {
            for (Map relationMap : data) {
                Boolean isDefault = (Boolean)relationMap.get(IS_DEFAULT);
                if (isDefault != null && isDefault.booleanValue()) {
                    long orgId = (Long)relationMap.get("orgId");
                    logger.info("\u9ed8\u8ba4\u7ec4\u7ec7\u8fd4\u56de\u4e1a\u52a1\u5355\u5143\u95f4\u534f\u4f5c\u914d\u7f6e\u7684\u9ed8\u8ba4\u503c\uff1a" + orgId);
                    return orgId;
                }
                if (forFormDefValue) continue;
                long orgId = (Long)relationMap.get("orgId");
                logger.info("\u9ed8\u8ba4\u7ec4\u7ec7\u8fd4\u56de\u4e1a\u52a1\u5355\u5143\u95f4\u534f\u4f5c\u914d\u7f6e\u7684\u7f16\u7801\u6700\u5c0f\u7684\u7ec4\u7ec7\uff1a" + orgId);
                return orgId;
            }
        }
        long orgId = param.getOrgId();
        if (this.hasTargetViewType(param)) {
            logger.info("\u9ed8\u8ba4\u7ec4\u7ec7\u8fd4\u56de\u5177\u6709\u5f53\u524d\u804c\u80fd\u7c7b\u578b\u7684\u53c2\u6570\u8bbe\u7f6e\u7684\u7ec4\u7ec7\uff1a" + orgId);
            return orgId;
        }
        if (forFormDefValue && !isConfiguredRelation && "10".equals(param.getToViewType()) && !CollectionUtils.isEmpty((Map)(orgMap = OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)false, (Boolean)true))) && StringUtils.isNotBlank(id = orgMap.get("id"))) {
            logger.info("\u9ed8\u8ba4\u7ec4\u7ec7\u8fd4\u56de\u5176\u5bf9\u5e94\u7684\u6838\u7b97\u4e3b\u4f53\uff1a" + id);
            return Long.parseLong(id.toString());
        }
        logger.info("\u9ed8\u8ba4\u7ec4\u7ec7\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\uff0c\u672a\u67e5\u8be2\u5230\u9ed8\u8ba4\u7ec4\u7ec7\u3002");
        return 0L;
    }

    public Map<String, Object> getOrgRelation(OrgRelationParam param) {
        return this.getOrgRelation(param, -1);
    }

    public Map<Long, Map<Long, Map<String, Object>>> getMultiOrgRelation(OrgRelationParam param) {
        if (param == null) {
            String errorMsg = BaseMessage.getMessage((String)"M00014");
            throw new KDBizException(errorMsg);
        }
        List sourceOrgIds = param.getOrgIds();
        if (CollectionUtils.isEmpty((Collection)sourceOrgIds)) {
            logger.warn("\u7ec4\u7ec7ID\u4e3a\u7a7a\u3002");
            return new HashMap<Long, Map<Long, Map<String, Object>>>(0);
        }
        return this.getMultiOrgRelation(param, sourceOrgIds, -1);
    }

    public List<Long> getBizRelationOrgIds(OrgRelationParam param) {
        List<Long> orgIds = this.getAllRelationOrgIds(param);
        this.addOrgSelf(param, orgIds);
        logger.info("[getBizRelationOrgIds]\u83b7\u53d6\u4e1a\u52a1\u4e1a\u52a1\u5355\u5143\u95f4\u534f\u4f5c\u7ec4\u7ec7\u7ed3\u679cID\uff1a" + orgIds);
        return orgIds;
    }

    private void addOrgSelf(OrgRelationParam param, List<Long> orgIds) {
        if (param == null || orgIds == null) {
            return;
        }
        if (param.isIncludeSelf() && !orgIds.contains(param.getOrgId()) && this.hasTargetViewType(param)) {
            orgIds.add(param.getOrgId());
        }
    }

    private List<Long> getAllRelationOrgIds(OrgRelationParam param) {
        Map<String, Object> orgRelation = this.getOrgRelation(param, -1);
        return (List)orgRelation.get("orgId");
    }

    private Map<String, Object> getOrgRelation(OrgRelationParam param, int top) {
        if (param == null) {
            String errorMsg = BaseMessage.getMessage((String)"M00014");
            throw new KDBizException(errorMsg);
        }
        logger.info("[getOrgRelation]\u83b7\u53d6\u4e1a\u52a1\u4e1a\u52a1\u5355\u5143\u95f4\u534f\u4f5c\u7ec4\u7ec7\u53c2\u6570\uff1a" + param);
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        ArrayList<Long> orgIds = new ArrayList<Long>(32);
        result.put("orgId", orgIds);
        ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>(32);
        result.put("data", data);
        long orgId = param.getOrgId();
        if (orgId == 0L) {
            logger.warn("\u7ec4\u7ec7ID\u4e3a\u7a7a\u3002");
            return result;
        }
        ArrayList<Long> sourceOrgIds = new ArrayList<Long>(1);
        sourceOrgIds.add(orgId);
        Map<Long, Map<Long, Map<String, Object>>> results = this.getMultiOrgRelation(param, sourceOrgIds, top);
        Map<Long, Map<String, Object>> relationOrgMap = results.get(orgId);
        if (CollectionUtils.isEmpty(relationOrgMap)) {
            return result;
        }
        for (Map.Entry<Long, Map<String, Object>> entry : relationOrgMap.entrySet()) {
            orgIds.add(entry.getKey());
            Map<String, Object> detail = entry.getValue();
            detail.put("orgId", entry.getKey());
            data.add(detail);
        }
        return result;
    }

    private Map<Long, Map<Long, Map<String, Object>>> getMultiOrgRelation(OrgRelationParam param, List<Long> sourceOrgIds, int top) {
        String orderBy;
        QFilter orgFilter;
        String selectFields;
        logger.info("[getMultiOrgRelation]\u6279\u91cf\u83b7\u53d6\u4e1a\u52a1\u4e1a\u52a1\u5355\u5143\u95f4\u534f\u4f5c\u7ec4\u7ec7\u53c2\u6570\uff1a" + param);
        HashMap<Long, Map<Long, Map<String, Object>>> result = new HashMap<Long, Map<Long, Map<String, Object>>>(sourceOrgIds.size());
        QFilter filter = this.getOrgRelationQFilter(param);
        if (filter == null) {
            return result;
        }
        if ("toorg".equalsIgnoreCase(param.getDirectViewType())) {
            selectFields = "toorg,isdefaulttoorg,fromorg";
            orgFilter = new QFilter("fromorg", "in", sourceOrgIds);
            filter = filter.and(orgFilter);
            orderBy = TO_ORG_ORDER;
        } else {
            selectFields = "fromorg,isdefaultfromorg,toorg";
            orgFilter = new QFilter("toorg", "in", sourceOrgIds);
            filter = filter.and(orgFilter);
            orderBy = FROM_ORG_ORDER;
        }
        Map relationObjMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org_orgrelation", (String)selectFields, (QFilter[])new QFilter[]{filter}, (String)orderBy);
        if (CollectionUtils.isEmpty((Map)relationObjMap)) {
            return result;
        }
        int rowIndex = 1;
        String[] fields = selectFields.split(",");
        for (Map.Entry relationEntry : relationObjMap.entrySet()) {
            DynamicObject relationObj = (DynamicObject)relationEntry.getValue();
            DynamicObject orgObj = relationObj.getDynamicObject(fields[0]);
            DynamicObject sourceOrgObj = relationObj.getDynamicObject(fields[2]);
            if (orgObj == null || sourceOrgObj == null) continue;
            long relationOrgId = orgObj.getLong("id");
            long sourceOrgId = sourceOrgObj.getLong("id");
            Map relationOrgMap = result.computeIfAbsent(sourceOrgId, k -> new LinkedHashMap(4));
            Map detail = relationOrgMap.computeIfAbsent(relationOrgId, k -> new HashMap(1));
            detail.put(IS_DEFAULT, relationObj.getBoolean(fields[1]));
            relationOrgMap.put(relationOrgId, detail);
            result.put(sourceOrgId, relationOrgMap);
            if (top > 0 && top <= rowIndex) break;
            ++rowIndex;
        }
        logger.info("[getMultiOrgRelation]\u6279\u91cf\u83b7\u53d6\u4e1a\u52a1\u4e1a\u52a1\u5355\u5143\u95f4\u534f\u4f5c\u7ec4\u7ec7\u7ed3\u679c\uff1a" + result);
        return result;
    }

    private QFilter getOrgRelationQFilter(OrgRelationParam param) {
        QFilter filter;
        if (param.getId() > 0L) {
            DynamicObject obj;
            QFilter relationFilter = new QFilter("typerelation", "=", (Object)param.getId());
            if (StringUtils.isBlank((CharSequence)param.getToViewType()) && (obj = BusinessDataServiceHelper.loadSingleFromCache((Object)param.getId(), (String)"bos_org_typerelation")) != null) {
                param.setNumber(obj.getString("number"));
                param.setToViewType(obj.getString("totype"));
                param.setFromViewType(obj.getString("fromtype"));
            }
            return relationFilter;
        }
        if (StringUtils.isBlank((CharSequence)param.getNumber())) {
            QFilter fromTypeFilter;
            String toViewType = param.getToViewType();
            if (StringUtils.isBlank((CharSequence)toViewType)) {
                logger.warn("\u53d7\u6258\u7ec4\u7ec7\u7684\u804c\u80fd\u7c7b\u578b\u4e3a\u7a7a\u3002");
                return null;
            }
            filter = new QFilter("totype", "=", (Object)param.getToViewType());
            String fromViewType = param.getFromViewType();
            if (StringUtils.isBlank((CharSequence)fromViewType)) {
                fromTypeFilter = new QFilter("fromtype", "=", (Object)" ");
                filter = filter.and(fromTypeFilter);
            } else {
                fromTypeFilter = new QFilter("fromtype", "=", (Object)fromViewType);
                filter = filter.and(fromTypeFilter);
            }
        } else {
            filter = new QFilter("number", "=", (Object)param.getNumber());
        }
        if (filter == null) {
            logger.warn("\u751f\u6210\u7684\u534f\u4f5c\u7c7b\u578b\u8fc7\u6ee4\u6761\u4ef6\u4e3a\u7a7a\u3002");
            return null;
        }
        QFilter[] filters = new QFilter[]{filter};
        Map objMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org_typerelation", (String)"id", (QFilter[])filters, (String)"ispreset desc");
        if (CollectionUtils.isEmpty((Map)objMap)) {
            logger.warn("\u67e5\u8be2\u4e0d\u5230\u534f\u4f5c\u7c7b\u578b\uff1a" + filter);
            return null;
        }
        Long id = (Long)objMap.entrySet().iterator().next().getKey();
        param.setId(id.longValue());
        QFilter relationFilter = new QFilter("typerelation", "=", (Object)id);
        return relationFilter;
    }

    private boolean hasTargetViewType(OrgRelationParam param) {
        String targetViewType = "fromorg".equalsIgnoreCase(param.getDirectViewType()) ? param.getFromViewType() : param.getToViewType();
        return StringUtils.isBlank((CharSequence)targetViewType) || OrgUnitServiceHelper.checkOrgFunction((Long)param.getOrgId(), (String)targetViewType);
    }
}

