/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.service;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.utils.msg.BaseMessage;
import kd.bos.base.utils.msg.OrgMessage;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.IFormView;
import kd.bos.form.control.TreeView;
import kd.bos.form.operate.webapi.AbstractOperateWebApi;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.org.api.IOrgService;
import kd.bos.org.history.OrgHistoryUtils;
import kd.bos.org.manager.CacheManager;
import kd.bos.org.manager.OrgLeafUtils;
import kd.bos.org.model.BizViewQueryParam;
import kd.bos.org.model.OrgApiResult;
import kd.bos.org.model.OrgChangeCheckDetail;
import kd.bos.org.model.OrgChangeCheckReport;
import kd.bos.org.model.OrgDutyView;
import kd.bos.org.model.OrgParam;
import kd.bos.org.model.OrgQueryType;
import kd.bos.org.model.OrgRelationParam;
import kd.bos.org.model.OrgSeparation;
import kd.bos.org.model.OrgTreeParam;
import kd.bos.org.model.OrgTreeSearchParam;
import kd.bos.org.model.ViewSchemaParam;
import kd.bos.org.service.OrgRelationService;
import kd.bos.org.service.OrgServiceHRImpl;
import kd.bos.org.service.OrgServiceOperationImpl;
import kd.bos.org.service.OrgServiceQueryImpl;
import kd.bos.org.service.common.OrgManagerUtils;
import kd.bos.org.service.common.OrgMsgManager;
import kd.bos.org.service.common.OrgParamValidator;
import kd.bos.org.utils.OrgTreeBuilder;
import kd.bos.org.utils.OrgTreeUtils;
import kd.bos.org.utils.OrgUtils;
import kd.bos.org.utils.OrgViewUtils;
import kd.bos.org.utils.Utils;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.permission.api.PermissionService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.devportal.BizCloudServiceHelp;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.workflow.engine.msg.info.MessageInfo;

public class OrgService
implements IOrgService {
    private static final Log logger = LogFactory.getLog(OrgService.class);
    public static final String org_entityID = "bos_org";
    public static final String entityID_org_structure = "bos_org_structure";
    public static final String orgBiz_entityID = "bos_org_biz";
    private String fullNameSeq;

    public List<DynamicObject> getAllData(String orgViewType, Long currentUserID, Long currentOrgID, QFilter[] filters) {
        return new OrgServiceQueryImpl().getAllData(orgViewType, currentUserID, currentOrgID, filters);
    }

    public DynamicObject getTreeRootData(String orgViewType, Long currentUserID, Long currentOrgID, QFilter[] filters) {
        return new OrgServiceQueryImpl().getTreeRootData(orgViewType, currentUserID, currentOrgID, filters);
    }

    public List<DynamicObject> getChildrenData(String orgViewType, Long currentUserID, Long currentOrgID, QFilter[] filters, Long parentID) {
        return new OrgServiceQueryImpl().getChildrenData(orgViewType, currentUserID, currentOrgID, filters, parentID);
    }

    public List<Long> getAuthorizedBizOrgIds(Long userID, String orgFunction, String entityID, String permissionItem, String appId, QFilter otherFilter, String orderBy, int top) {
        return new OrgServiceQueryImpl().getAuthorizedBizOrgIds(userID, orgFunction, entityID, permissionItem, appId, otherFilter, orderBy, top);
    }

    public List<Long> getAuthorizedBizOrgIds(Long userID, String orgFunction, String entityID, String permissionItem, String appId, QFilter otherFilter, String orderBy, int from, int length) {
        return new OrgServiceQueryImpl().getAuthorizedBizOrgIds(userID, orgFunction, entityID, permissionItem, appId, otherFilter, orderBy, from, length);
    }

    public DynamicObjectCollection getAuthorizedBizOrgs(Long userID, String orgFunction, String entityID, String permissionItem, String appId, QFilter otherFilter, String selectProperties, String orderBy, int top) {
        return new OrgServiceQueryImpl().getAuthorizedBizOrgs(userID, orgFunction, entityID, permissionItem, appId, otherFilter, selectProperties, orderBy, top);
    }

    public DynamicObjectCollection getAuthorizedBizOrgs(Long userID, String orgFunction, String entityID, String permissionItem, String appId, QFilter otherFilter, String selectProperties, String orderBy, int from, int length) {
        return new OrgServiceQueryImpl().getAuthorizedBizOrgs(userID, orgFunction, entityID, permissionItem, appId, otherFilter, selectProperties, orderBy, from, length);
    }

    public DynamicObject getBizOrg(Long orgID, String orgFunction) {
        return new OrgServiceQueryImpl().getBizOrg(orgID, orgFunction);
    }

    public String getBizOrgPropertyName(String orgFunction) {
        return new OrgServiceQueryImpl().getBizOrgPropertyName(orgFunction);
    }

    public QFilter getBizOrgFilter(String orgFunction) {
        return new OrgServiceQueryImpl().getBizOrgFilter(orgFunction);
    }

    public List<Long> getBizOrgIds(String orgFunction) {
        return this.getBizOrgIds(orgFunction, null, "", -1);
    }

    public List<Long> getBizOrgIds(String orgFunction, QFilter otherFilter, String orderBy, int top) {
        return new OrgServiceQueryImpl().getBizOrgIds(orgFunction, otherFilter, orderBy, top);
    }

    public List<Long> getBizOrgIds(String orgFunction, QFilter otherFilter, String orderBy, int from, int length) {
        return new OrgServiceQueryImpl().getBizOrgIds(orgFunction, otherFilter, orderBy, from, length);
    }

    public DynamicObjectCollection getBizOrgs(String orgFunction, QFilter otherFilter, String selectProperties, String orderBy, int top) {
        return new OrgServiceQueryImpl().getBizOrgs(orgFunction, otherFilter, selectProperties, orderBy, top);
    }

    public DynamicObjectCollection getBizOrgs(String orgFunction, QFilter otherFilter, String selectProperties, String orderBy, int from, int length) {
        return new OrgServiceQueryImpl().getBizOrgs(orgFunction, otherFilter, selectProperties, orderBy, from, length);
    }

    public void add(List<OrgParam> paramList) {
        this.addOrUpdate(paramList);
    }

    public void add(OrgParam orgParam) {
        OrgServiceOperationImpl saveService = new OrgServiceOperationImpl(orgParam);
        saveService.save();
    }

    public boolean updateOrgPermission(long parentId, long orgId, String orgViewType, boolean isAdd) {
        logger.info(orgId + "\uff1a\u66f4\u65b0\u7ec4\u7ec7\u6743\u9650\uff0c\u804c\u80fd\u7c7b\u578b\uff1a" + orgViewType);
        PermissionService permService = (PermissionService)ServiceFactory.getService(PermissionService.class);
        ArrayList<Long> orgIds = new ArrayList<Long>(1);
        orgIds.add(orgId);
        boolean success = permService.updateAdminChargeOrgs(Long.valueOf(parentId), orgIds, orgViewType, isAdd);
        logger.info(orgId + "\uff1a\u66f4\u65b0\u7ec4\u7ec7\u6743\u9650\uff0c\u804c\u80fd\u7c7b\u578b\uff1a" + orgViewType);
        return success;
    }

    @Deprecated
    public void addByFullname(List<OrgParam> paramList) {
        TreeMap<Integer, List<OrgParam>> levelMap;
        if (OrgParamValidator.isOrgParamEmpty(paramList)) {
            return;
        }
        ArrayList<String> parentFullnameList = new ArrayList<String>(paramList.size());
        if (!this.isAddByFullnameParamValid(paramList, parentFullnameList, levelMap = new TreeMap<Integer, List<OrgParam>>())) {
            return;
        }
        HashMap<String, Long> idMap = new HashMap<String, Long>();
        this.getOrgFullnameIdMap(idMap, parentFullnameList, "01");
        for (Map.Entry levelEntry : levelMap.entrySet()) {
            for (OrgParam orgParam : (List)levelEntry.getValue()) {
                String fullname = orgParam.getFullname();
                String parentFullname = StringUtils.substringBeforeLast((String)fullname, (String)this.getFullNameSep());
                Long parentId = (Long)idMap.get(parentFullname);
                if (parentId == null) {
                    this.getOrgFullnameIdMap(idMap, Collections.singletonList(parentFullname), "01");
                    parentId = (Long)idMap.get(parentFullname);
                }
                if (parentId == null) {
                    if (fullname.indexOf(this.getFullNameSep()) != -1) {
                        OrgMsgManager.generateFailMsg(orgParam, OrgMessage.getMessage((String)"M00116", (Object[])new Object[]{parentFullname}));
                        continue;
                    }
                    parentId = 0L;
                }
                orgParam.setParentId(parentId.longValue());
            }
        }
        this.addOrUpdate(paramList);
    }

    @Deprecated
    public boolean isAddByFullnameParamValid(List<OrgParam> paramList, List<String> parentFullnameList, Map<Integer, List<OrgParam>> levelMap) {
        String rootFullname = OrgViewUtils.getRootOrgFullName();
        boolean isNoRootOrg = StringUtils.isBlank((CharSequence)rootFullname);
        boolean isSuccess = false;
        int count = paramList.size();
        ArrayList<String> fullnameList = new ArrayList<String>(count);
        ArrayList<String> numberList = new ArrayList<String>(count);
        for (OrgParam orgParam : paramList) {
            String orgNewPath;
            int level;
            List<OrgParam> levelList;
            String orgName;
            String parentFullname;
            String fullname = orgParam.getFullname();
            if (StringUtils.isBlank((CharSequence)fullname)) {
                orgParam.setSuccess(false);
                orgParam.setMsg(OrgMessage.getMessage((String)"M00005"));
                continue;
            }
            if (!isNoRootOrg && fullname.indexOf(this.getFullNameSep()) == -1) {
                if (rootFullname.equals(fullname)) {
                    orgParam.setSuccess(false);
                    orgParam.setMsg(OrgMessage.getMessage((String)"M00021"));
                    continue;
                }
                orgParam.setSuccess(false);
                orgParam.setMsg(fullname + "\uff1a" + OrgMessage.getMessage((String)"M00007"));
                continue;
            }
            if (fullnameList.contains(fullname)) {
                orgParam.setSuccess(false);
                orgParam.setMsg(OrgMessage.getMessage((String)"M00006"));
                continue;
            }
            fullnameList.add(fullname);
            String number = orgParam.getNumber();
            if (StringUtils.isNotBlank((CharSequence)number)) {
                if (numberList.contains(number)) {
                    orgParam.setSuccess(false);
                    orgParam.setMsg(BaseMessage.getMessage((String)"M00006"));
                    continue;
                }
                numberList.add(number);
            }
            if (!parentFullnameList.contains(parentFullname = StringUtils.substringBeforeLast((String)fullname, (String)this.getFullNameSep()))) {
                parentFullnameList.add(parentFullname);
            }
            if (StringUtils.isBlank((CharSequence)(orgName = StringUtils.substringAfterLast((String)fullname, (String)this.getFullNameSep())))) {
                orgParam.setSuccess(false);
                orgParam.setMsg(fullname + "\uff1a" + OrgMessage.getMessage((String)"M00007"));
                continue;
            }
            orgParam.setName(orgName);
            orgParam.setDuty("01");
            if (StringUtils.isBlank((CharSequence)rootFullname)) {
                rootFullname = StringUtils.substringBefore((String)fullname, (String)this.getFullNameSep());
            }
            if ((levelList = levelMap.get(level = Utils.countInnerStr((String)(orgNewPath = StringUtils.substringAfter((String)fullname, (String)(rootFullname + this.getFullNameSep()))), (String)this.getFullNameSep()) + 2)) == null) {
                levelList = new ArrayList<OrgParam>();
                levelMap.put(level, levelList);
            }
            levelList.add(orgParam);
            orgParam.setSuccess(true);
            isSuccess = true;
        }
        if (isSuccess && isNoRootOrg) {
            OrgParam rootOrgParam = new OrgParam();
            rootOrgParam.setName(rootFullname);
            this.addRoot(rootOrgParam);
            if (!rootOrgParam.isSuccess()) {
                for (OrgParam orgParam : paramList) {
                    if (!orgParam.isSuccess()) continue;
                    orgParam.setSuccess(false);
                    orgParam.setMsg(rootOrgParam.getMsg());
                }
                isSuccess = false;
            }
        }
        return isSuccess;
    }

    public Map<String, Long> getOrgFullnameIdMap(Map<String, Long> idMap, List<String> parentFullnameList, String orgViewType) {
        if (Utils.isListEmpty(parentFullnameList)) {
            return idMap;
        }
        String selectFields = "id,org,fullname";
        QFilter viewFilter = OrgViewUtils.getOrgViewFilter((String)orgViewType);
        QFilter fullnameFilter = new QFilter("fullname", "in", parentFullnameList);
        QFilter[] filters = new QFilter[]{viewFilter, fullnameFilter};
        DynamicObjectCollection orgCol = QueryServiceHelper.query((String)entityID_org_structure, (String)selectFields, (QFilter[])filters);
        if (Utils.isListEmpty((List)orgCol)) {
            return idMap;
        }
        for (DynamicObject orgObj : orgCol) {
            idMap.put(orgObj.getString("fullname"), orgObj.getLong("org"));
        }
        return idMap;
    }

    public void addRoot(OrgParam orgParam) {
        if (OrgParamValidator.isOrgParamEmpty(orgParam)) {
            return;
        }
        long rootOrgId = this.getRootOrgId();
        if (this.isHasRoot(rootOrgId)) {
            long orgId = orgParam.getId();
            if (orgId == 0L || rootOrgId == orgId) {
                orgParam.setId(rootOrgId);
                TreeMap<String, OrgDutyView> multiViewMap = orgParam.getMultiViewMap();
                if (multiViewMap == null || multiViewMap.isEmpty()) {
                    multiViewMap = new TreeMap<String, OrgDutyView>();
                    multiViewMap.put("15", new OrgDutyView());
                    orgParam.setMultiViewMap(multiViewMap);
                }
                ArrayList<OrgParam> paramList = new ArrayList<OrgParam>(1);
                paramList.add(orgParam);
                this.addOrUpdate(paramList);
            } else {
                orgParam.setSuccess(false);
                orgParam.setMsg(OrgMessage.getMessage((String)"M00021"));
            }
        } else {
            if (StringUtils.isBlank((CharSequence)orgParam.getName())) {
                orgParam.setSuccess(false);
                orgParam.setMsg(BaseMessage.getMessage((String)"M00004"));
                return;
            }
            orgParam.setFullname(orgParam.getName());
            OrgServiceOperationImpl saveService = new OrgServiceOperationImpl(orgParam);
            saveService.save();
        }
    }

    private boolean isHasRoot(long rootOrgId) {
        QFilter parentFilter = new QFilter("id", "=", (Object)rootOrgId);
        QFilter[] qFilters = new QFilter[]{parentFilter};
        return QueryServiceHelper.exists((String)org_entityID, (QFilter[])qFilters);
    }

    public void addDutyRoot(OrgParam orgParam) {
        if (OrgParamValidator.isOrgParamEmpty(orgParam)) {
            return;
        }
        long orgId = orgParam.getId();
        if (orgId == 0L) {
            orgParam.setId(this.getRootOrgId());
        }
        OrgServiceOperationImpl saveService = new OrgServiceOperationImpl(orgParam);
        saveService.save();
    }

    public void update(List<OrgParam> paramList) {
        this.addOrUpdate(paramList);
    }

    public void update(OrgParam orgParam) {
        OrgServiceOperationImpl saveService = new OrgServiceOperationImpl(orgParam);
        saveService.save();
    }

    public void delete(List<OrgParam> paramList) {
        if (OrgParamValidator.isOrgParamEmpty(paramList)) {
            return;
        }
        ArrayList<Long> orgIds = new ArrayList<Long>(paramList.size());
        for (OrgParam orgParam : paramList) {
            if (!OrgParamValidator.isDeleteParamValid(orgParam)) continue;
            orgIds.add(orgParam.getId());
        }
        if (orgIds.isEmpty()) {
            return;
        }
        try (TXHandle h = TX.required();){
            try {
                Map parentViewMap = OrgLeafUtils.getParentViewMapByOrgId(orgIds);
                DynamicObject type = BusinessDataServiceHelper.newDynamicObject((String)org_entityID);
                DeleteServiceHelper.delete((IDataEntityType)type.getDataEntityType(), (Object[])orgIds.toArray(new Object[orgIds.size()]));
                QFilter orgFilter = new QFilter("org", "in", orgIds);
                QFilter[] filters = new QFilter[]{orgFilter};
                DeleteServiceHelper.delete((String)entityID_org_structure, (QFilter[])filters);
                OrgLeafUtils.updateParentOrgLeaf((Map)parentViewMap);
                OrgManagerUtils.saveHistory(orgIds);
            }
            catch (Exception e) {
                OrgMsgManager.generateExceptionMsg((Throwable)e, paramList);
                h.markRollback();
            }
        }
        logger.info("\u5220\u9664\u7ec4\u7ec7\uff1a" + paramList.size());
    }

    public void disable(List<OrgParam> paramList) {
        if (OrgParamValidator.isOrgParamEmpty(paramList)) {
            return;
        }
        OrgServiceOperationImpl service = new OrgServiceOperationImpl(paramList);
        service.disable();
        logger.info("\u6279\u91cf\u7981\u7528\u7ec4\u7ec7\uff1a" + paramList.size());
    }

    public void enable(List<OrgParam> paramList) {
        if (OrgParamValidator.isOrgParamEmpty(paramList)) {
            return;
        }
        OrgServiceOperationImpl service = new OrgServiceOperationImpl(paramList);
        service.enable();
        logger.info("\u6279\u91cf\u542f\u7528\u7ec4\u7ec7\uff1a" + paramList.size());
    }

    public void freeze(List<OrgParam> paramList) {
        this.freeze(paramList, true);
    }

    public void unFreeze(List<OrgParam> paramList) {
        this.freeze(paramList, false);
    }

    private void freeze(List<OrgParam> paramList, boolean freeze) {
        OrgServiceOperationImpl orgServiceOperation;
        if (OrgParamValidator.isOrgParamEmpty(paramList)) {
            return;
        }
        int count = paramList.size();
        ArrayList<OrgParam> orgUnitList = new ArrayList<OrgParam>(count);
        ArrayList<OrgParam> adminOrgList = new ArrayList<OrgParam>(count);
        HashMap<OrgParam, OrgDutyView> adminOrgDutyViewMap = new HashMap<OrgParam, OrgDutyView>(count);
        for (OrgParam orgParam : paramList) {
            OrgDutyView orgDutyView;
            if (StringUtils.isBlank((CharSequence)orgParam.getDuty()) && CollectionUtils.isEmpty((Map)orgParam.getMultiViewMap())) {
                orgParam.setDuty("01");
            }
            if (!OrgParamValidator.parseMultiViewMap(orgParam)) continue;
            TreeMap multiViewMap = orgParam.getMultiViewMap();
            boolean hasOrgUnitBiz = false;
            for (Map.Entry entry : multiViewMap.entrySet()) {
                if ("01".equals(entry.getKey())) {
                    adminOrgList.add(orgParam);
                    continue;
                }
                hasOrgUnitBiz = true;
                orgUnitList.add(orgParam);
            }
            if (!hasOrgUnitBiz || (orgDutyView = (OrgDutyView)multiViewMap.remove("01")) == null) continue;
            adminOrgDutyViewMap.put(orgParam, orgDutyView);
        }
        if (!orgUnitList.isEmpty()) {
            orgServiceOperation = new OrgServiceOperationImpl(orgUnitList);
            if (freeze) {
                orgServiceOperation.bizFreeze();
            } else {
                orgServiceOperation.bizUnfreeze();
            }
            for (Map.Entry entry : adminOrgDutyViewMap.entrySet()) {
                ((OrgParam)entry.getKey()).getMultiViewMap().put("01", entry.getValue());
            }
        }
        if (!adminOrgList.isEmpty()) {
            orgServiceOperation = new OrgServiceOperationImpl(adminOrgList);
            if (freeze) {
                orgServiceOperation.freeze();
            } else {
                orgServiceOperation.unFreeze();
            }
        }
    }

    @Deprecated
    public void addOrgUnitStructure(OrgParam orgParam) {
        logger.error("\u8c03\u7528\u4e86\u5e9f\u5f03\u7684\u63a5\u53e3\uff08addOrgUnitStructure\uff09\u3002");
        if (orgParam != null) {
            orgParam.setSuccess(false);
        }
    }

    public void addDuty(List<OrgParam> paramList) {
        OrgServiceOperationImpl saveService = new OrgServiceOperationImpl(paramList);
        saveService.addView();
    }

    public void deleteDuty(List<OrgParam> paramList) {
        OrgServiceOperationImpl saveService = new OrgServiceOperationImpl(paramList);
        saveService.deleteView();
    }

    public long getOrgViewIdByFormId(String orgViewType, String formNumber) {
        QFilter objectFilter;
        QFilter[] objectfilters;
        String selectedObject;
        DynamicObject[] bizObjectTypes;
        if (StringUtils.isBlank((CharSequence)orgViewType)) {
            orgViewType = "01";
        }
        if ((bizObjectTypes = BusinessDataServiceHelper.load((String)"bos_formmeta", (String)(selectedObject = "id"), (QFilter[])(objectfilters = new QFilter[]{objectFilter = new QFilter("number", "=", (Object)formNumber)}), (String)"id")) == null || bizObjectTypes.length == 0) {
            return 1L;
        }
        String formID = bizObjectTypes[0].getString("id");
        DynamicObject bizApp = BizAppServiceHelp.getBizAppByFormID((String)formID);
        String bizAppID = "";
        if (bizApp != null) {
            bizAppID = bizApp.getString("id");
        }
        QFilter filterTreeType = new QFilter("orgfunc", "=", (Object)orgViewType);
        long viewId = 1L;
        DynamicObject bizCloud = BizCloudServiceHelp.getBizCloudByFormID((String)formID);
        String cloudId = "";
        if (bizCloud != null) {
            cloudId = bizCloud.getString("id");
        }
        if (!"".equals(bizAppID)) {
            String selectCloudSet = "id,view";
            QFilter filterCloudSet = new QFilter("bizcloud", "=", (Object)cloudId);
            QFilter[] filterCloudSets = new QFilter[]{filterCloudSet, filterTreeType};
            DynamicObject[] bizSetS = BusinessDataServiceHelper.load((String)"bos_devportal_bizapp", (String)selectCloudSet, (QFilter[])filterCloudSets, (String)"id");
            if (bizSetS == null || bizSetS.length == 0) {
                return viewId;
            }
            viewId = bizSetS[0].getLong("view_id");
        }
        return viewId;
    }

    public void enableHR(List<OrgParam> paramList) {
        this.enableHR(paramList, true);
    }

    public void disableHR(List<OrgParam> paramList) {
        this.enableHR(paramList, false);
    }

    private void enableHR(List<OrgParam> paramList, boolean enable) {
        if (OrgParamValidator.isOrgParamEmpty(paramList)) {
            return;
        }
        logger.info("\u542f\u7528\u7981\u7528\u7ec4\u7ec7HR\uff1a" + enable);
        ArrayList<Long> orgIds = new ArrayList<Long>(paramList.size());
        for (OrgParam orgParam : paramList) {
            orgIds.add(orgParam.getId());
        }
        String selectProperties = "id,org,ishr";
        QFilter orgFilter = new QFilter("org", "in", orgIds);
        QFilter viewFilter = OrgViewUtils.getOrgViewFilter((String)"01");
        QFilter[] filters = new QFilter[]{orgFilter, viewFilter};
        DynamicObject[] orgStruArr = BusinessDataServiceHelper.load((String)entityID_org_structure, (String)selectProperties, (QFilter[])filters);
        if (orgStruArr == null || orgStruArr.length == 0) {
            return;
        }
        ArrayList<Long> enableOrgIds = new ArrayList<Long>(orgStruArr.length);
        for (DynamicObject orgStru : orgStruArr) {
            orgStru.set("ishr", (Object)enable);
            enableOrgIds.add(orgStru.getDynamicObject("org").getLong("id"));
        }
        try (TXHandle h = TX.required();){
            try {
                SaveServiceHelper.save((DynamicObject[])orgStruArr);
                OrgHistoryUtils.saveOrgStructureHistory(enableOrgIds);
                CacheManager.removeCache((String)entityID_org_structure);
                for (OrgParam orgParam : paramList) {
                    if (enableOrgIds.contains(orgParam.getId())) {
                        orgParam.setSuccess(true);
                        continue;
                    }
                    orgParam.setSuccess(false);
                    orgParam.setMsg(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7%1$s", (String)"OrgService_6", (String)"bos-mservice-org", (Object[])new Object[0]), BaseMessage.getMessage((String)"M00062")));
                }
            }
            catch (Exception e) {
                OrgMsgManager.generateExceptionMsg((Throwable)e, paramList);
                h.markRollback();
            }
        }
    }

    public long getRootOrgId() {
        return new OrgServiceQueryImpl().getRootOrgId();
    }

    public Map<Long, Long> getRootOrgId(List<Long> viewIds) {
        return new OrgServiceQueryImpl().getRootOrgId(viewIds);
    }

    public String getOrg(long orgId, long userId, OrgQueryType queryType, List<Long> resultList) {
        return new OrgServiceQueryImpl().getOrg(orgId, userId, queryType, resultList);
    }

    public void addOrUpdate(List<OrgParam> paramList) {
        OrgServiceOperationImpl saveService = new OrgServiceOperationImpl(paramList);
        saveService.save();
    }

    public Map<String, Object> getTreeRootNodeMapById(OrgTreeParam param) {
        if (param == null) {
            return null;
        }
        OrgTreeBuilder orgTreeBuilder = new OrgTreeBuilder(param);
        if (param.isReturnTreeNodeOrMap()) {
            HashMap<String, Object> dataMap = new HashMap<String, Object>(1);
            dataMap.put("data", orgTreeBuilder.buildRootTreeNode());
            return dataMap;
        }
        return orgTreeBuilder.buildRootNode();
    }

    public List<Map<String, Object>> getTreeChildrenMap(OrgTreeParam param) {
        if (param == null) {
            return new ArrayList<Map<String, Object>>(0);
        }
        OrgTreeBuilder orgTreeBuilder = new OrgTreeBuilder(param);
        if (param.isReturnTreeNodeOrMap()) {
            ArrayList<Map<String, Object>> dataMapList = new ArrayList<Map<String, Object>>(1);
            HashMap<String, List> dataMap = new HashMap<String, List>(1);
            dataMapList.add(dataMap);
            dataMap.put("data", orgTreeBuilder.buildTreeNodes());
            return dataMapList;
        }
        return orgTreeBuilder.build();
    }

    public List<Long> getAdminOrgRelation(List<Long> orgIds, boolean isReturnAdminOrg) {
        return new OrgRelationService().getAdminOrgRelation(orgIds, isReturnAdminOrg);
    }

    public List<Long> getAuthorizedAdminOrg() {
        QFilter typeFilter = new QFilter("typerelation", "=", (Object)585511977942548480L);
        QFilter[] filters = new QFilter[]{typeFilter};
        try (DataSet ds = ORM.create().queryDataSet("kd.bos.org.service.OrgService.getAdminOrgByAuthorizedOrgUnit", "bos_org_orgrelation", "fromorg,toorg", filters);){
            if (ds.hasNext()) {
                HasPermOrgResult permOrg = PermissionServiceHelper.getUserHasPermOrgs((long)Long.parseLong(RequestContext.get().getUserId()));
                if (permOrg.hasAllOrgPerm()) {
                    List<Long> list = null;
                    return list;
                }
                List chargeOrgList = permOrg.getHasPermOrgs();
                if (Utils.isListEmpty((List)chargeOrgList)) {
                    ArrayList<Long> arrayList = new ArrayList<Long>(0);
                    return arrayList;
                }
                ArrayList<Long> relationOrgList = new ArrayList<Long>();
                for (Row row : ds) {
                    long orgUintId = row.getLong("fromorg");
                    long adminOrgId = row.getLong("toorg");
                    if (!chargeOrgList.contains(orgUintId)) continue;
                    relationOrgList.add(adminOrgId);
                }
                ArrayList<Long> arrayList = relationOrgList;
                return arrayList;
            }
            List<Long> list = null;
            return list;
        }
    }

    public List<DynamicObject> getAuthorizedBizOrgUnits(Long arg0, String arg1, String arg2, String arg3) {
        return null;
    }

    public List<DynamicObject> getAuthorizedBizOrgUnits(Long arg0, String arg1, String arg2, String arg3, String arg4) {
        return null;
    }

    public List<DynamicObject> getAuthorizedBizOrgUnits(Long arg0, String arg1, String arg2, String arg3, boolean arg4) {
        return null;
    }

    public long getDefaultOrgRelation(OrgRelationParam param) {
        return new OrgRelationService().getDefaultOrgRelation(param);
    }

    public long getOrgForFormDefValue(OrgRelationParam param) {
        return new OrgRelationService().getOrgForFormDefValue(param);
    }

    public Map<String, Object> getOrgRelation(OrgRelationParam param) {
        return new OrgRelationService().getOrgRelation(param);
    }

    public Map<Long, Map<Long, Map<String, Object>>> getMultiOrgRelation(OrgRelationParam param) {
        return new OrgRelationService().getMultiOrgRelation(param);
    }

    public List<Long> getBizRelationOrgIds(OrgRelationParam param) {
        return new OrgRelationService().getBizRelationOrgIds(param);
    }

    public void move(long viewId, long orgId, long oldParentId, long newParentId) {
        if (viewId == 0L) {
            throw new KDBizException(OrgMessage.getMessage((String)"M00002"));
        }
        if (oldParentId == newParentId) {
            return;
        }
        QFilter idFilter = new QFilter("id", "=", (Object)viewId);
        QFilter[] filters = new QFilter[]{idFilter};
        DynamicObject viewObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org_viewschema", (String)"number", (QFilter[])filters);
        if (viewObj == null) {
            throw new KDBizException(OrgMessage.getMessage((String)"M00016"));
        }
        OrgParam orgParam = new OrgParam();
        orgParam.setId(orgId);
        orgParam.setParentId(newParentId);
        orgParam.setDuty(viewObj.getString("number"));
        this.update(orgParam);
    }

    public List<Long> getAllOrg(String viewSchemaNumber) {
        return new OrgServiceQueryImpl().getAllOrg(viewSchemaNumber);
    }

    public boolean isDistributedDepartment() {
        QFilter typeFilter = new QFilter("typerelation", "=", (Object)585511977942548480L);
        QFilter[] filters = new QFilter[]{typeFilter};
        return QueryServiceHelper.exists((String)"bos_org_orgrelation", (QFilter[])filters);
    }

    public boolean checkOrgFunction(Long orgID, String orgFunction) {
        ArrayList<Long> orgIds = new ArrayList<Long>(1);
        orgIds.add(orgID);
        List<Long> result = this.filterOrgDuty(orgIds, orgFunction);
        return result.contains(orgID);
    }

    public List<Long> filterOrgDuty(List<Long> orgIds, String orgViewNumber) {
        return new OrgServiceQueryImpl().filterOrgDuty(orgIds, orgViewNumber, null, null, -1);
    }

    public List<Long> filterOrg(List<Long> orgIds, long viewId, boolean isFilterDisable, boolean isFilterFreeze) {
        return new OrgServiceQueryImpl().filterOrg(orgIds, viewId, isFilterDisable, isFilterFreeze);
    }

    public List<Long> getOrgByLevel(String orgViewNumber, int level, boolean includeDisable, boolean includeFreeze) {
        return new OrgServiceQueryImpl().getOrgByLevel(orgViewNumber, level, includeDisable, includeFreeze);
    }

    public OrgApiResult saveOrgViewSchema(ViewSchemaParam param) {
        String viewType;
        String name;
        String number;
        OrgApiResult result = OrgParamValidator.checkSaveViewSchemaParam(param);
        if (!result.isSuccess()) {
            return result;
        }
        DynamicObject viewSchemaObj = null;
        long id = param.getId();
        String userId = RequestContext.get().getUserId();
        Date currentDate = new Date();
        Date startDate = param.getStartDate();
        Date endDate = param.getEndDate();
        if (id == 0L) {
            viewSchemaObj = BusinessDataServiceHelper.newDynamicObject((String)"bos_org_viewschema");
            viewSchemaObj.set("id", (Object)param.getCustomId());
            viewSchemaObj.set("status", (Object)"C");
            viewSchemaObj.set("enable", (Object)Character.valueOf('1'));
            viewSchemaObj.set("creator", (Object)userId);
            viewSchemaObj.set("createtime", (Object)currentDate);
            viewSchemaObj.set("modifier", (Object)userId);
            viewSchemaObj.set("modifytime", (Object)currentDate);
            if (startDate == null) {
                startDate = Utils.getDate((int)0);
            }
            if (endDate == null) {
                endDate = Utils.getEndDate();
            }
        } else {
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)"bos_org_viewschema");
            DynamicObject[] viewSchemaObjArr = BusinessDataServiceHelper.load((Object[])new Long[]{id}, (DynamicObjectType)type);
            if (viewSchemaObjArr == null || viewSchemaObjArr.length == 0) {
                OrgParamValidator.genErrorMsg(result, BaseMessage.getMessage((String)"M00062"));
                return result;
            }
            viewSchemaObj = viewSchemaObjArr[0];
            viewSchemaObj.set("modifier", (Object)userId);
            viewSchemaObj.set("modifytime", (Object)currentDate);
        }
        if (StringUtils.isNotBlank((CharSequence)(number = param.getNumber()))) {
            viewSchemaObj.set("number", (Object)number);
        }
        if (StringUtils.isNotBlank((CharSequence)(name = param.getName()))) {
            viewSchemaObj.set("name", (Object)name);
        }
        if (StringUtils.isNotBlank((CharSequence)(viewType = param.getViewType()))) {
            viewSchemaObj.set("treetype", (Object)viewType);
        }
        if (startDate != null) {
            viewSchemaObj.set("startdate", (Object)startDate);
        }
        if (endDate != null) {
            viewSchemaObj.set("enddate", (Object)endDate);
        }
        OperationResult opResult = OperationServiceHelper.executeOperate((String)"save", (String)"bos_org_viewschema", (DynamicObject[])new DynamicObject[]{viewSchemaObj}, null);
        OrgParamValidator.genOperationResult(opResult, result);
        if (result.isSuccess()) {
            result.setNumber(viewSchemaObj.getString("number"));
            result.setName(viewSchemaObj.getString("name"));
        }
        return result;
    }

    public OrgApiResult deleteOrgViewSchema(List<Long> idList) {
        return this.execute("bos_org_viewschema", idList, "delete");
    }

    public OrgApiResult enableOrgViewSchema(List<Long> idList, boolean enable) {
        return this.execute("bos_org_viewschema", idList, enable ? "enable" : "disable");
    }

    private OrgApiResult execute(String entityNumber, List<Long> idList, String operation) {
        OrgApiResult result = new OrgApiResult(true);
        if (idList == null || idList.isEmpty()) {
            OrgParamValidator.genErrorMsg(result, BaseMessage.getMessage((String)"M00014"));
            return result;
        }
        JSONObject dataPack = new JSONObject();
        dataPack.put("ids", idList);
        AbstractOperateWebApi webApi = FormMetadataCache.getFormOperationApi((String)FormMetadataCache.getFormConfig((String)entityNumber).getEntityTypeId(), (String)operation);
        webApi.initialize(entityNumber, (Map)dataPack);
        try {
            ApiResult executeResult = webApi.execute();
            OrgParamValidator.genApiResult(executeResult, result);
        }
        catch (Exception e) {
            String errorMsg = BaseMessage.getMessage((String)"M00061", (Object[])new Object[]{e.getMessage()});
            logger.info(errorMsg);
            OrgParamValidator.genErrorMsg(result, errorMsg);
        }
        return result;
    }

    public List<Long> getAllSuperiorOrgs(String orgFunction, long orgId) {
        return new OrgServiceQueryImpl().getAllSuperiorOrgs(orgFunction, orgId);
    }

    public Map<Long, List<Long>> getAllSuperiorOrgs(String viewNumber, List<Long> orgIds) {
        return new OrgServiceQueryImpl().getAllSuperiorOrgs(viewNumber, orgIds);
    }

    public boolean isParentOrg(String viewNumber, long parentId, long orgId) {
        QFilter viewFilter = new QFilter("view.number", "=", (Object)viewNumber);
        QFilter parentFilter = new QFilter("org", "=", (Object)parentId);
        QFilter[] filters = new QFilter[]{viewFilter, parentFilter};
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)" kd.bos.org.OrgOperationServicePlugIn.isParent", (String)entityID_org_structure, (String)"longnumber", (QFilter[])filters, (String)"", (int)1);){
            if (ds.hasNext()) {
                QFilter parentLongnumberFilter = new QFilter("longnumber", "like", (Object)(ds.next().getString("longnumber") + "!" + "%"));
                QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
                QFilter[] qFilters = new QFilter[]{viewFilter, parentLongnumberFilter, orgFilter};
                boolean bl = QueryServiceHelper.exists((String)entityID_org_structure, (QFilter[])qFilters);
                return bl;
            }
        }
        return false;
    }

    public String getOrgSortSchema() {
        return OrgUtils.getOrgSortSchema();
    }

    public String getOrgSortFields() {
        return OrgUtils.getOrgSortFields();
    }

    public String getOrgStructureSortFields() {
        return OrgUtils.getOrgStructureSortFields();
    }

    public List<Long> getAllOrgByViewId(long viewId, boolean isIncludeDisable) {
        return new OrgServiceQueryImpl().getAllOrgByViewId(viewId, isIncludeDisable);
    }

    public List<Long> getAllSubordinateOrgs(Long viewId, List<Long> orgIds, boolean isIncludeCurOrg) {
        return new OrgServiceQueryImpl().getAllSubordinateOrgs(viewId, orgIds, isIncludeCurOrg);
    }

    public List<Long> getAllSubordinateOrgs(Long viewId, List<Long> orgIds, boolean bIncludeCurOrg, boolean isIncludeDisable) {
        return new OrgServiceQueryImpl().getAllSubordinateOrgs(viewId, orgIds, bIncludeCurOrg, isIncludeDisable);
    }

    public List<Long> getAllOrgByViewNumber(String viewSchemaNumber, boolean isIncludeDisable) {
        return new OrgServiceQueryImpl().getAllOrgByViewNumber(viewSchemaNumber, isIncludeDisable);
    }

    public List<Long> getAllSubordinateOrgs(String viewSchemaNumber, List<Long> orgIds, boolean isIncludeCurOrg) {
        return new OrgServiceQueryImpl().getAllSubordinateOrgs(viewSchemaNumber, orgIds, isIncludeCurOrg);
    }

    public List<Long> getAllSubordinateOrgs(String viewSchemaNumber, List<Long> orgIds, boolean isIncludeCurOrg, boolean isIncludeDisable) {
        return new OrgServiceQueryImpl().getAllSubordinateOrgs(viewSchemaNumber, orgIds, isIncludeCurOrg, isIncludeDisable);
    }

    public List<Long> getFromOrgs(String toOrgType, Long toOrgId, String fromOrgType, boolean isIncludeToOrgSelf) {
        return new OrgRelationService().getFromOrgs(toOrgType, toOrgId, fromOrgType, isIncludeToOrgSelf);
    }

    public List<Long> getAllToOrg(String fromOrgType, String toOrgType, Long fromOrgId, boolean isIncludeFromOrgSelf) {
        return new OrgRelationService().getAllToOrg(fromOrgType, toOrgType, fromOrgId, isIncludeFromOrgSelf);
    }

    public Long getToOrg(String fromOrgType, String toOrgType, Long fromOrgId, boolean isIncludeFromOrgSelf) {
        return new OrgRelationService().getToOrg(fromOrgType, toOrgType, fromOrgId, isIncludeFromOrgSelf);
    }

    public Map<Long, Long> getDirectSuperiorOrg(String viewSchemaNumber, List<Long> orgIds) {
        return new OrgServiceQueryImpl().getDirectSuperiorOrg(viewSchemaNumber, orgIds);
    }

    public OrgApiResult disableDuty(List<OrgParam> orgParamList) {
        OrgApiResult result = this.doEnableStructure(orgParamList, false);
        return result;
    }

    public OrgApiResult enableDuty(List<OrgParam> orgParamList) {
        OrgApiResult result = this.doEnableStructure(orgParamList, true);
        return result;
    }

    private OrgApiResult doEnableStructure(List<OrgParam> orgParamList, boolean enable) {
        OrgApiResult result = new OrgApiResult(true);
        if (OrgParamValidator.isOrgParamEmpty(orgParamList)) {
            result.setSuccess(false);
            result.setErrorMsg(BaseMessage.getMessage((String)"M00014"));
            return result;
        }
        int count = orgParamList.size();
        ArrayList<Long> orgIds = new ArrayList<Long>(count);
        HashSet<String> dutyList = new HashSet<String>(count);
        HashMap<String, OrgParam> orgParamMap = new HashMap<String, OrgParam>(count);
        ArrayList<OrgApiResult> resultList = new ArrayList<OrgApiResult>(count);
        result.setResultList(resultList);
        for (OrgParam orgParam : orgParamList) {
            long orgId = orgParam.getId();
            String duty = orgParam.getDuty();
            if (orgId == 0L) {
                OrgMsgManager.generateFailMsg(resultList, orgParam, BaseMessage.getMessage((String)"M00015", (Object[])new Object[]{ResManager.loadKDString((String)"\u7ec4\u7ec7\u5185\u7801", (String)"OrgService_9", (String)"bos-mservice-org", (Object[])new Object[0])}));
                continue;
            }
            if (StringUtils.isBlank((CharSequence)duty)) {
                OrgMsgManager.generateFailMsg(resultList, orgParam, BaseMessage.getMessage((String)"M00015", (Object[])new Object[]{ResManager.loadKDString((String)"\u804c\u80fd\u7c7b\u578b", (String)"OrgService_14", (String)"bos-mservice-org", (Object[])new Object[0])}));
                continue;
            }
            orgIds.add(orgId);
            dutyList.add(duty);
            orgParamMap.put(orgId + "," + duty, orgParam);
        }
        String selectFields = "id,org,view,enable";
        QFilter viewFilter = new QFilter("view.number", "in", dutyList);
        QFilter orgFilter = new QFilter("org", "in", orgIds);
        QFilter[] filters = new QFilter[]{viewFilter, orgFilter};
        DynamicObject[] structureObjArr = BusinessDataServiceHelper.load((String)entityID_org_structure, (String)selectFields, (QFilter[])filters);
        if (structureObjArr != null && structureObjArr.length > 0) {
            ArrayList<Long> structureIds = new ArrayList<Long>(count);
            HashMap<Long, OrgParam> operationObjMap = new HashMap<Long, OrgParam>(count);
            for (DynamicObject structureObj : structureObjArr) {
                DynamicObject orgObj = structureObj.getDynamicObject("org");
                long orgId = orgObj.getLong("id");
                DynamicObject viewObj = structureObj.getDynamicObject("view");
                String duty = viewObj.getString("number");
                String key = orgId + "," + duty;
                OrgParam orgParam = (OrgParam)orgParamMap.get(key);
                if (orgParam == null) continue;
                orgParamMap.remove(key);
                orgParam.setNumber(orgObj.getString("number"));
                orgParam.setName(orgObj.getString("name"));
                if (enable == structureObj.getBoolean("enable")) {
                    String statusName = enable ? ResManager.loadKDString((String)"\u542f\u7528", (String)"OrgService_15", (String)"bos-mservice-org", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7981\u7528", (String)"OrgService_16", (String)"bos-mservice-org", (Object[])new Object[0]);
                    OrgMsgManager.generateFailMsg(resultList, orgParam, String.format(ResManager.loadKDString((String)"%1$s\uff1a\u6570\u636e\u5df2\u4e3a%2$s\u72b6\u6001\u3002", (String)"OrgService_17", (String)"bos-mservice-org", (Object[])new Object[0]), orgObj.getString("number"), statusName));
                    continue;
                }
                long structureId = structureObj.getLong("id");
                structureIds.add(structureId);
                operationObjMap.put(structureId, orgParam);
            }
            if (!structureIds.isEmpty()) {
                OperationResult operationResult = OperationServiceHelper.executeOperate((String)(enable ? "enable" : "disable"), (String)entityID_org_structure, (Object[])structureIds.toArray(), null);
                ValidateResultCollection validateResultCollection = operationResult.getValidateResult();
                List validateErrors = validateResultCollection.getValidateErrors();
                for (ValidateResult validateResult : validateErrors) {
                    List allErrorInfo = validateResult.getAllErrorInfo();
                    for (OperateErrorInfo errorInfo : allErrorInfo) {
                        Object pk = errorInfo.getPkValue();
                        OrgParam orgParam = (OrgParam)operationObjMap.get(pk);
                        if (orgParam == null) continue;
                        OrgMsgManager.generateFailMsg(resultList, orgParam, orgParam.getNumber() + "\uff1a" + errorInfo.getMessage());
                        operationObjMap.remove(pk);
                    }
                }
            }
            for (OrgParam orgParam : operationObjMap.values()) {
                OrgMsgManager.generateSuccessMsg(resultList, orgParam);
            }
        }
        for (OrgParam orgParam : orgParamMap.values()) {
            OrgMsgManager.generateFailMsg(resultList, orgParam, OrgMessage.getMessage((String)"M00016"));
        }
        return result;
    }

    public OrgApiResult batchSyncHRViewSchemaAndOrg(ViewSchemaParam viewSchemaParam, List<OrgParam> orgParamList) {
        return new OrgServiceHRImpl().batchSyncHRViewSchemaAndOrg(viewSchemaParam, orgParamList);
    }

    public OrgApiResult batchSyncHROrg(List<OrgParam> orgParamList) {
        return new OrgServiceHRImpl().batchSyncHROrg(orgParamList);
    }

    public long getParentIdBySelfOrOrgUnitView(long srcParentId, long viewId) {
        return new OrgServiceQueryImpl().getParentIdBySelfOrOrgUnitView(srcParentId, viewId);
    }

    public long getParentIdBySelfOrOrgUnitView(long srcParentId, String viewNumber) {
        return new OrgServiceQueryImpl().getParentIdBySelfOrOrgUnitView(srcParentId, viewNumber);
    }

    public String getOrgTreeNodeFormat() {
        return OrgTreeUtils.getOrgTreeNodeFormat();
    }

    public String formatOrgTreeNodeName(String number, String name) {
        return OrgTreeUtils.formatOrgTreeNodeName((String)number, (String)name, (String)this.getOrgTreeNodeFormat());
    }

    public String formatOrgTreeNodeName(String number, String name, String format) {
        return OrgTreeUtils.formatOrgTreeNodeName((String)number, (String)name, (String)format);
    }

    public List<Map<String, Object>> getCorporateOrg(boolean includeDisable) {
        return new OrgServiceQueryImpl().getCorporateOrg(includeDisable);
    }

    public void listViewLazyLoadTreeSearch(Map<String, Object> param) {
        this.lazyLoadTreeSearch(param);
    }

    public void formViewLazyLoadTreeSearch(Map<String, Object> param) {
        this.lazyLoadTreeSearch(param);
    }

    private void lazyLoadTreeSearch(Map<String, Object> param) {
        Object rootNodeCacheKeyParam;
        Object treeViewParam;
        Object searchByIdParam;
        Object clickNodeParam;
        Object viewNumberParam;
        if (param == null) {
            return;
        }
        Object viewParam = param.get("view");
        OrgTreeSearchParam searchParam = viewParam instanceof ListView ? new OrgTreeSearchParam(null, (ListView)viewParam, null) : new OrgTreeSearchParam(null, (IFormView)viewParam, null, null, null);
        Object searchTextParam = param.get("searchText");
        if (searchTextParam != null) {
            searchParam.setSearchText(searchTextParam.toString());
        }
        if ((viewNumberParam = param.get("viewNumber")) != null) {
            searchParam.setOrgViewNumber(viewNumberParam.toString());
        }
        if ((clickNodeParam = param.get("clickNode")) != null) {
            searchParam.setClickNode(((Boolean)clickNodeParam).booleanValue());
        }
        if ((searchByIdParam = param.get("searchById")) != null) {
            searchParam.setSearchById(((Boolean)searchByIdParam).booleanValue());
        }
        if ((treeViewParam = param.get("treeView")) instanceof TreeView) {
            searchParam.setTreeView((TreeView)treeViewParam);
        }
        if ((rootNodeCacheKeyParam = param.get("rootNodeCacheKey")) != null) {
            searchParam.setRootNodeCacheKey(rootNodeCacheKeyParam.toString());
        }
        OrgTreeUtils.searchFromLazyOrgTree((OrgTreeSearchParam)searchParam);
    }

    public Map<Long, List<Long>> getAllSubordinateOrgMap(String viewSchemaNumber, List<Long> orgIds, boolean isIncludeCurOrg) {
        return new OrgServiceQueryImpl().getAllSubordinateOrgMap(viewSchemaNumber, orgIds, isIncludeCurOrg);
    }

    public Map<Long, List<Long>> getAllSubordinateOrgMap(long viewId, List<Long> orgIds, boolean isIncludeCurOrg) {
        return new OrgServiceQueryImpl().getAllSubordinateOrgMap(viewId, orgIds, isIncludeCurOrg);
    }

    public int getCorporateLimitCountOfGalaxy() {
        return 20;
    }

    public Map<Long, Map<String, Object>> getCompanyOfOrg(Object viewIDOrNumber, Collection orgIds) {
        return this.getOrgByPattern(viewIDOrNumber, orgIds, true, Arrays.asList("1", "2"));
    }

    public Map<Long, Map<String, Object>> getOrgByPattern(Object viewIDOrNumber, Collection orgIds, boolean isByPatternType, List<Object> patternOrPatternTypes) {
        return new OrgServiceQueryImpl().getOrgByPattern(viewIDOrNumber, orgIds, isByPatternType, patternOrPatternTypes);
    }

    public OrgSeparation getOrgSeparation() {
        OrgSeparation orgSeparation = new OrgSeparation();
        DynamicObject orgConfig = BusinessDataServiceHelper.loadSingleFromCache((Object)1L, (String)"bos_org_config");
        if (orgConfig != null) {
            orgSeparation.setFullNameSep(orgConfig.getString("fullnamesep"));
        }
        return orgSeparation;
    }

    private String getFullNameSep() {
        if (this.fullNameSeq == null) {
            this.fullNameSeq = this.getOrgSeparation().getFullNameSep();
        }
        return this.fullNameSeq;
    }

    public Map<Long, Set<Long>> getAdminOrgRelationMap(List<Long> orgIds, boolean isReturnAdminOrg) {
        return new OrgRelationService().getAdminOrgRelationMap(orgIds, isReturnAdminOrg);
    }

    public Map<Long, Map<String, Object>> getAccountingBizUnit(long viewId, List<Long> orgIds, boolean isBizUnit, boolean isSearchUpward) {
        return new OrgServiceQueryImpl().getAccountingBizUnit(viewId, orgIds, isBizUnit, isSearchUpward);
    }

    public Map<Long, Long> getHandoverOrgIds(long bizId, List<Long> orgIds) {
        return new OrgServiceQueryImpl().getHandoverOrgIds(bizId, orgIds);
    }

    public Map<Long, Long> getHandoverOrgIds(String bizNumber, List<Long> orgIds) {
        if (StringUtils.isBlank((CharSequence)bizNumber)) {
            return new HashMap<Long, Long>(0);
        }
        DynamicObject bizObj = BusinessDataServiceHelper.loadSingleFromCache((String)orgBiz_entityID, (String)"id", (QFilter[])new QFilter[]{new QFilter("fnumber", "=", (Object)bizNumber)});
        if (bizObj == null) {
            logger.info("\u6839\u636e\u804c\u80fd\u7c7b\u578b\u7f16\u7801\u83b7\u53d6\u4ea4\u63a5\u7ec4\u7ec7\u5931\u8d25\uff1a\u804c\u80fd\u7c7b\u578b\u4e0d\u5b58\u5728\uff1a" + bizNumber);
            return new HashMap<Long, Long>(0);
        }
        return this.getHandoverOrgIds(bizObj.getLong("id"), orgIds);
    }

    public Map<Object, DynamicObject> getBiz(BizViewQueryParam bizViewQueryParam) {
        if (bizViewQueryParam == null) {
            bizViewQueryParam = new BizViewQueryParam();
        }
        QFilter filter = this.getBizViewFilter(bizViewQueryParam);
        if (bizViewQueryParam.isOnlyVisible()) {
            filter = filter.and(new QFilter("visiable", "=", (Object)Boolean.TRUE));
        }
        if (bizViewQueryParam.isOnlyDefault()) {
            filter = filter.and(new QFilter("fuserdefine", "=", (Object)Boolean.FALSE));
        }
        if (bizViewQueryParam.isOnlyBaseType()) {
            filter = filter.and(new QFilter("isbasetype", "=", (Object)Boolean.TRUE));
        }
        if (StringUtils.isNotBlank((CharSequence)bizViewQueryParam.getCategory())) {
            filter = filter.and(new QFilter("category", "=", (Object)bizViewQueryParam.getCategory()));
        }
        Map bizObjMap = BusinessDataServiceHelper.loadFromCache((String)orgBiz_entityID, (QFilter[])new QFilter[]{filter});
        return this.orderByString(bizObjMap, "fnumber");
    }

    public Map<Object, DynamicObject> getView(BizViewQueryParam bizViewQueryParam) {
        if (bizViewQueryParam == null) {
            bizViewQueryParam = new BizViewQueryParam();
        }
        QFilter filter = this.getBizViewFilter(bizViewQueryParam);
        if (bizViewQueryParam.isOnlyDefault()) {
            filter = filter.and(new QFilter("isdefault", "=", (Object)Boolean.TRUE));
        }
        Map viewObjMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org_viewschema", (QFilter[])new QFilter[]{filter});
        return this.orderByString(viewObjMap, "number");
    }

    private QFilter getBizViewFilter(BizViewQueryParam bizViewQueryParam) {
        QFilter filter = new QFilter("status", "=", (Object)"C");
        if (bizViewQueryParam.getCustomFilter() != null) {
            filter = filter.and(bizViewQueryParam.getCustomFilter());
        }
        if (bizViewQueryParam.isOnlyEnable()) {
            filter = filter.and(new QFilter("enable", "=", (Object)Boolean.TRUE));
        }
        if (bizViewQueryParam.isOnlyBaseMaintain()) {
            filter = filter.and(new QFilter("basemaintain", "=", (Object)Boolean.TRUE));
        }
        return filter;
    }

    private Map<Object, DynamicObject> orderByString(Map<Object, DynamicObject> objMap, String orderBy) {
        Stream<Map.Entry> sortedEntryStream = objMap.entrySet().stream().sorted(Comparator.comparing(o -> ((DynamicObject)o.getValue()).getString(orderBy)));
        return sortedEntryStream.collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (u, v) -> u, LinkedHashMap::new));
    }

    public OrgApiResult saveOrgChangeCheckReport(OrgChangeCheckReport orgChangeCheckReport) {
        OrgApiResult orgApiResult = new OrgApiResult(true);
        this.checkOrgChangeCheckReport(orgApiResult, orgChangeCheckReport);
        if (!orgApiResult.isSuccess()) {
            return orgApiResult;
        }
        Long changeRecordId = orgChangeCheckReport.getChangeRecordId();
        DynamicObject orgChangeRecordObj = BusinessDataServiceHelper.loadSingle((Object)changeRecordId, (String)"bos_org_changerecord");
        DynamicObjectCollection checkRptDoc = orgChangeRecordObj.getDynamicObjectCollection("checkrptentry");
        int handleEventCount = 0;
        for (DynamicObject currEntryObj : checkRptDoc) {
            DynamicObject eventObj = currEntryObj.getDynamicObject("event");
            if (eventObj != null && eventObj.getPkValue().equals(orgChangeCheckReport.getEventId())) {
                currEntryObj.set("event", (Object)orgChangeCheckReport.getEventId());
                currEntryObj.set("checkstatus", (Object)orgChangeCheckReport.getCheckStatus());
                currEntryObj.set("checkresult", (Object)orgChangeCheckReport.getCheckResult());
                List details = orgChangeCheckReport.getDetails();
                if (details != null && details.size() > 0) {
                    DynamicObjectCollection subDoc = currEntryObj.getDynamicObjectCollection("checkdetailentry");
                    DynamicObjectType subEntryType = subDoc.getDynamicObjectType();
                    subDoc.clear();
                    int index = 0;
                    for (OrgChangeCheckDetail detail : details) {
                        DynamicObject subEntryObj = new DynamicObject(subEntryType);
                        subEntryObj.set("seq", (Object)index++);
                        subEntryObj.set("entity", (Object)detail.getEntity());
                        subEntryObj.set("bdnumber", (Object)detail.getBdNumber());
                        subEntryObj.set("reason", (Object)detail.getReason());
                        subEntryObj.set("solution", (Object)detail.getSolution());
                        subDoc.add((Object)subEntryObj);
                    }
                }
                ++handleEventCount;
                continue;
            }
            if (StringUtils.isBlank((CharSequence)currEntryObj.getString("checkstatus"))) continue;
            ++handleEventCount;
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{orgChangeRecordObj});
        logger.info("OrgService#saveOrgChangeCheckReport save success");
        if (handleEventCount >= checkRptDoc.size()) {
            this.sendMessage(orgChangeRecordObj);
            logger.info("OrgService#saveOrgChangeCheckReport sendMessage success");
        }
        return orgApiResult;
    }

    private void checkOrgChangeCheckReport(OrgApiResult orgApiResult, OrgChangeCheckReport orgChangeCheckReport) {
        if (orgChangeCheckReport == null) {
            orgApiResult.setSuccess(false);
            String msg = "OrgChangeCheckReport is null";
            orgApiResult.setErrorMsg(msg);
            logger.error(msg);
            return;
        }
        if (orgChangeCheckReport.getChangeRecordId() == null || orgChangeCheckReport.getEventId() == null) {
            String msg = "ChangeRecordId is null or EventId is null";
            orgApiResult.setSuccess(false);
            orgApiResult.setErrorMsg(msg);
            logger.error(msg);
            return;
        }
        if (!QueryServiceHelper.exists((String)"bos_org_changerecord", (Object)orgChangeCheckReport.getChangeRecordId())) {
            String msg = "ChangeRecord is not exist";
            orgApiResult.setSuccess(false);
            orgApiResult.setErrorMsg(msg);
            logger.error(msg);
            return;
        }
    }

    private void sendMessage(DynamicObject orgChangeRecordObj) {
        MessageInfo messageInfo = this.buildMessageInfo(orgChangeRecordObj);
        MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo);
    }

    private MessageInfo buildMessageInfo(DynamicObject orgChangeRecordObj) {
        Object changeRecordId = orgChangeRecordObj.getPkValue();
        DynamicObjectCollection checkRptEntry = orgChangeRecordObj.getDynamicObjectCollection("checkrptentry");
        MessageInfo messageInfo = new MessageInfo();
        String title = ResManager.loadKDString((String)"\u91cd\u7f6e\u6839\u7ec4\u7ec7\u5904\u7406", (String)"OrgService_18", (String)"bos-mservice-org", (Object[])new Object[0]);
        messageInfo.setTitle(title);
        int subscriptionEventCount = checkRptEntry.size();
        long warn = checkRptEntry.stream().filter(obj -> "W".equals(obj.getString("checkstatus"))).count();
        String content = String.format(ResManager.loadKDString((String)"\u91cd\u7f6e\u6839\u7ec4\u7ec7\u5df2\u7ecf\u751f\u6548\uff0c\u6570\u636e\u68c0\u67e5\u4f9b\u5171\u6709%1$s\u4e2a\u5185\u5bb9\uff0c\u5176\u4e2d%2$s\u4e2a\u8b66\u544a\uff0c\u53ef\u4ee5\u70b9\u51fb\u4e0b\u65b9\u6570\u636e\u68c0\u67e5\u62a5\u544a\u67e5\u770b\u8be6\u60c5\u3002", (String)"OrgService_19", (String)"bos-mservice-org", (Object[])new Object[0]), subscriptionEventCount, warn);
        messageInfo.setContent(content);
        ArrayList<Long> userIds = new ArrayList<Long>();
        userIds.add(orgChangeRecordObj.getLong("creator_id"));
        messageInfo.setUserIds(userIds);
        messageInfo.setType("message");
        messageInfo.setTag(title);
        messageInfo.setOperation("view");
        messageInfo.setEntityNumber("bos_org_changeresetroot");
        messageInfo.setSource("base");
        String clientUrl = UrlService.getDomainContextUrl();
        String contentUrl = clientUrl + String.format("/index.html?formId=%s&type=base&pkId=%s&caption=%s&status=%s&openStyle=modal", "bos_org_changeresetroot", changeRecordId, title, "view");
        messageInfo.setContentUrl(contentUrl);
        return messageInfo;
    }

    public int getYzjConfigSyncMode() {
        return new OrgServiceQueryImpl().getYzjConfigSyncMode();
    }
}

