/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.service;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OperationType;
import kd.bos.org.model.OrgApiResult;
import kd.bos.org.model.OrgParam;
import kd.bos.org.model.ViewSchemaParam;
import kd.bos.org.service.OrgService;

public class OrgServiceHRImpl {
    private static final Log logger = LogFactory.getLog(OrgServiceHRImpl.class);

    /*
     * Loose catch block
     */
    public OrgApiResult batchSyncHRViewSchemaAndOrg(ViewSchemaParam viewSchemaParam, List<OrgParam> orgParamList) {
        OrgApiResult orgApiResult;
        block26: {
            Throwable throwable;
            TXHandle txHandle;
            block23: {
                OrgApiResult orgApiResult2;
                block24: {
                    block25: {
                        block20: {
                            OrgApiResult orgApiResult3;
                            block21: {
                                block22: {
                                    orgApiResult = new OrgApiResult(true);
                                    if (viewSchemaParam == null || orgParamList == null || orgParamList.size() == 0) {
                                        return orgApiResult;
                                    }
                                    txHandle = TX.requiresNew();
                                    throwable = null;
                                    orgApiResult = new OrgService().saveOrgViewSchema(viewSchemaParam);
                                    if (orgApiResult.isSuccess()) break block20;
                                    orgApiResult3 = orgApiResult;
                                    if (txHandle == null) break block21;
                                    if (throwable == null) break block22;
                                    try {
                                        txHandle.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    break block21;
                                }
                                txHandle.close();
                            }
                            return orgApiResult3;
                        }
                        if (this.batchSyncHRViewOrg(orgParamList, orgApiResult)) break block23;
                        txHandle.markRollback();
                        orgApiResult2 = orgApiResult;
                        if (txHandle == null) break block24;
                        if (throwable == null) break block25;
                        try {
                            txHandle.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        break block24;
                    }
                    txHandle.close();
                }
                return orgApiResult2;
            }
            try {
                break block26;
                catch (Exception e) {
                    logger.info("\u6279\u91cf\u540c\u6b65\u7ec4\u7ec7\u89c6\u56fe\u65b9\u6848\u548c\u7ec4\u7ec7\u89c6\u56fe\u6811\u5931\u8d25\uff1a" + e.getMessage());
                    orgApiResult.setErrorMsg(String.format(ResManager.loadKDString((String)"\u6279\u91cf\u540c\u6b65\u7ec4\u7ec7\u89c6\u56fe\u65b9\u6848\u548c\u7ec4\u7ec7\u89c6\u56fe\u6811\u5931\u8d25\uff1a%1$s\u3002", (String)"OrgServiceHRImpl_0", (String)"bos-mservice-org", (Object[])new Object[0]), e.getMessage()));
                    orgApiResult.setSuccess(false);
                    txHandle.markRollback();
                }
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            catch (Throwable throwable5) {
                throw throwable5;
            }
            finally {
                if (txHandle != null) {
                    if (throwable != null) {
                        try {
                            txHandle.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                    } else {
                        txHandle.close();
                    }
                }
            }
        }
        logger.info("\u6279\u91cf\u540c\u6b65HR\u7ec4\u7ec7\u89c6\u56fe\u65b9\u6848\u548c\u7ec4\u7ec7\u89c6\u56fe\u6811", (Object)orgParamList.size());
        return orgApiResult;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OrgApiResult batchSyncHROrg(List<OrgParam> orgParamList) {
        OrgApiResult orgApiResult;
        block14: {
            OrgApiResult orgApiResult2;
            TXHandle txHandle;
            block15: {
                orgApiResult = new OrgApiResult(true);
                if (orgParamList == null) return orgApiResult;
                if (orgParamList.size() == 0) {
                    return orgApiResult;
                }
                txHandle = TX.requiresNew();
                Throwable throwable = null;
                try {
                    if (this.batchSyncHRViewOrg(orgParamList, orgApiResult)) break block14;
                    txHandle.markRollback();
                    orgApiResult2 = orgApiResult;
                    if (txHandle == null) return orgApiResult2;
                    if (throwable == null) break block15;
                }
                catch (Exception e) {
                    logger.info("\u6279\u91cf\u540c\u6b65\u7ec4\u7ec7\u5931\u8d25\uff1a" + e.getMessage());
                    orgApiResult.setErrorMsg(String.format(ResManager.loadKDString((String)"\u6279\u91cf\u540c\u6b65\u7ec4\u7ec7\u5931\u8d25\uff1a%1$s", (String)"OrgServiceHRImpl_1", (String)"bos-mservice-org", (Object[])new Object[0]), e.getMessage()));
                    orgApiResult.setSuccess(false);
                    txHandle.markRollback();
                    break block14;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    throw throwable4;
                }
                try {
                    txHandle.close();
                    return orgApiResult2;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                    return orgApiResult2;
                }
            }
            txHandle.close();
            return orgApiResult2;
        }
        logger.info("\u6279\u91cf\u540c\u6b65HR\u7ec4\u7ec7\uff1a" + orgParamList.size());
        return orgApiResult;
    }

    private boolean batchSyncHRViewOrg(List<OrgParam> orgParamList, OrgApiResult orgApiResult) {
        if (orgParamList == null || orgParamList.size() == 0) {
            return true;
        }
        OrgService orgService = new OrgService();
        OrgHROperationParam operationParam = new OrgHROperationParam();
        this.filterOperationParam(orgParamList, operationParam);
        return this.add(operationParam.getAddOrgParamList(), orgService, orgApiResult) & this.addDuty(operationParam.getAddDutyOrgParamList(), orgService, orgApiResult) & this.update(operationParam.getUpdateDutyOrgParamList(), orgService, orgApiResult) & this.deleteDuty(operationParam.getDeleteDutyOrgParamList(), orgService, orgApiResult) & this.disableDuty(operationParam.getDisableDutyOrgParamList(), orgService, orgApiResult) & this.enableDuty(operationParam.getEnableDutyOrgParamList(), orgService, orgApiResult) & this.freeze(operationParam.getFreezeOrgParamList(), orgService, orgApiResult) & this.unfreeze(operationParam.getUnfreezeOrgParamList(), orgService, orgApiResult);
    }

    private void filterOperationParam(List<OrgParam> orgParamList, OrgHROperationParam operationParam) {
        List<OrgParam> addOrgParamList = operationParam.getAddOrgParamList();
        List<OrgParam> addDutyOrgParamList = operationParam.getAddDutyOrgParamList();
        List<OrgParam> updateDutyOrgParamList = operationParam.getUpdateDutyOrgParamList();
        List<OrgParam> deleteDutyOrgParamList = operationParam.getDeleteDutyOrgParamList();
        List<OrgParam> disableDutyOrgParamList = operationParam.getDisableDutyOrgParamList();
        List<OrgParam> enableDutyOrgParamList = operationParam.getEnableDutyOrgParamList();
        List<OrgParam> freezeOrgParamList = operationParam.getFreezeOrgParamList();
        List<OrgParam> unfreezeOrgParamList = operationParam.getUnfreezeOrgParamList();
        orgParamList.forEach(orgParam -> {
            if (OperationType.addDuty.equals((Object)orgParam.getOperationType())) {
                addDutyOrgParamList.add((OrgParam)orgParam);
            } else if (OperationType.update.equals((Object)orgParam.getOperationType())) {
                updateDutyOrgParamList.add((OrgParam)orgParam);
            } else if (OperationType.deleteDuty.equals((Object)orgParam.getOperationType())) {
                deleteDutyOrgParamList.add((OrgParam)orgParam);
            } else if (OperationType.disableDuty.equals((Object)orgParam.getOperationType())) {
                disableDutyOrgParamList.add((OrgParam)orgParam);
            } else if (OperationType.enableDuty.equals((Object)orgParam.getOperationType())) {
                enableDutyOrgParamList.add((OrgParam)orgParam);
            } else if (OperationType.add.equals((Object)orgParam.getOperationType())) {
                addOrgParamList.add((OrgParam)orgParam);
            } else if (OperationType.freeze.equals((Object)orgParam.getOperationType())) {
                freezeOrgParamList.add((OrgParam)orgParam);
            } else if (OperationType.unfreeze.equals((Object)orgParam.getOperationType())) {
                unfreezeOrgParamList.add((OrgParam)orgParam);
            }
        });
    }

    private boolean add(List<OrgParam> orgParamList, OrgService orgService, OrgApiResult orgApiResult) {
        if (orgParamList.size() > 0) {
            orgService.add(orgParamList);
            return this.validateOrgParam(orgApiResult, orgParamList);
        }
        return true;
    }

    private boolean update(List<OrgParam> orgParamList, OrgService orgService, OrgApiResult orgApiResult) {
        if (orgParamList.size() > 0) {
            orgService.update(orgParamList);
            return this.validateOrgParam(orgApiResult, orgParamList);
        }
        return true;
    }

    private boolean addDuty(List<OrgParam> orgParamList, OrgService orgService, OrgApiResult orgApiResult) {
        if (orgParamList.size() > 0) {
            orgService.addDuty(orgParamList);
            return this.validateOrgParam(orgApiResult, orgParamList);
        }
        return true;
    }

    private boolean deleteDuty(List<OrgParam> orgParamList, OrgService orgService, OrgApiResult orgApiResult) {
        if (orgParamList.size() > 0) {
            orgService.deleteDuty(orgParamList);
            return this.validateOrgParam(orgApiResult, orgParamList);
        }
        return true;
    }

    private boolean disableDuty(List<OrgParam> orgParamList, OrgService orgService, OrgApiResult orgApiResult) {
        if (orgParamList.size() > 0) {
            orgService.disableDuty(orgParamList);
            return this.validateOrgParam(orgApiResult, orgParamList);
        }
        return true;
    }

    private boolean enableDuty(List<OrgParam> orgParamList, OrgService orgService, OrgApiResult orgApiResult) {
        if (orgParamList.size() > 0) {
            orgService.enableDuty(orgParamList);
            return this.validateOrgParam(orgApiResult, orgParamList);
        }
        return true;
    }

    private boolean freeze(List<OrgParam> orgParamList, OrgService orgService, OrgApiResult orgApiResult) {
        if (orgParamList.size() > 0) {
            orgService.freeze(orgParamList);
            return this.validateOrgParam(orgApiResult, orgParamList);
        }
        return true;
    }

    private boolean unfreeze(List<OrgParam> orgParamList, OrgService orgService, OrgApiResult orgApiResult) {
        if (orgParamList.size() > 0) {
            orgService.unFreeze(orgParamList);
            return this.validateOrgParam(orgApiResult, orgParamList);
        }
        return true;
    }

    private boolean validateOrgParam(OrgApiResult orgApiResult, List<OrgParam> orgParamList) {
        boolean currSuccess = true;
        List resultList = orgApiResult.getResultList();
        for (OrgParam orgParam : orgParamList) {
            if (orgParam.isSuccess()) continue;
            OrgApiResult result = new OrgApiResult(false, orgParam.getMsg());
            result.setId(orgParam.getId() > 0L ? orgParam.getId() : orgParam.getCustomOrgId());
            result.setNumber(orgParam.getNumber());
            resultList.add(result);
            currSuccess = false;
        }
        orgApiResult.setSuccess(orgApiResult.isSuccess() && currSuccess);
        return currSuccess;
    }

    private static class OrgHROperationParam {
        List<OrgParam> addOrgParamList = new ArrayList<OrgParam>();
        List<OrgParam> addDutyOrgParamList = new ArrayList<OrgParam>();
        List<OrgParam> updateDutyOrgParamList = new ArrayList<OrgParam>();
        List<OrgParam> deleteDutyOrgParamList = new ArrayList<OrgParam>();
        List<OrgParam> disableDutyOrgParamList = new ArrayList<OrgParam>();
        List<OrgParam> enableDutyOrgParamList = new ArrayList<OrgParam>();
        List<OrgParam> freezeOrgParamList = new ArrayList<OrgParam>();
        List<OrgParam> unfreezeOrgParamList = new ArrayList<OrgParam>();

        private OrgHROperationParam() {
        }

        public List<OrgParam> getAddOrgParamList() {
            return this.addOrgParamList;
        }

        public List<OrgParam> getAddDutyOrgParamList() {
            return this.addDutyOrgParamList;
        }

        public List<OrgParam> getUpdateDutyOrgParamList() {
            return this.updateDutyOrgParamList;
        }

        public List<OrgParam> getDeleteDutyOrgParamList() {
            return this.deleteDutyOrgParamList;
        }

        public List<OrgParam> getDisableDutyOrgParamList() {
            return this.disableDutyOrgParamList;
        }

        public List<OrgParam> getEnableDutyOrgParamList() {
            return this.enableDutyOrgParamList;
        }

        public List<OrgParam> getFreezeOrgParamList() {
            return this.freezeOrgParamList;
        }

        public List<OrgParam> getUnfreezeOrgParamList() {
            return this.unfreezeOrgParamList;
        }
    }
}

