/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.utils.BaseBatchHandler;
import kd.bos.base.utils.IBaseBatchHandler;
import kd.bos.base.utils.msg.BaseMessage;
import kd.bos.base.utils.msg.OrgMessage;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OrgDutyView;
import kd.bos.org.model.OrgParam;
import kd.bos.org.opplugin.common.OrgComparator;
import kd.bos.org.opplugin.model.OrgOpContext;
import kd.bos.org.service.common.OrgMsgManager;
import kd.bos.org.service.common.OrgOperationObjectLoader;
import kd.bos.org.service.common.OrgParamValidator;
import kd.bos.org.utils.DynamicObjectUtils;
import kd.bos.org.utils.OrgUtils;
import kd.bos.org.utils.Utils;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;

public class OrgServiceOperationImpl {
    private static final Log logger = LogFactory.getLog(OrgServiceOperationImpl.class);
    private List<OrgParam> orgParamList;
    private OrgOperationObjectLoader orgLoader;
    private Map<String, DynamicObject> viewNumberObjMap;
    private Map<Object, DynamicObject> patternObjMap;
    private Map<String, DynamicObjectType> dynamicObjectTypeMap;

    public OrgServiceOperationImpl(OrgParam orgParam) {
        if (orgParam != null) {
            this.orgParamList = new ArrayList<OrgParam>(1);
            this.orgParamList.add(orgParam);
        }
    }

    public OrgServiceOperationImpl(List<OrgParam> orgParamList) {
        this.orgParamList = orgParamList;
    }

    public void save() {
        this.batchHandle(batchOrgParamList -> this.save(batchOrgParamList));
    }

    private void save(List<OrgParam> batchOrgParamList) {
        if (CollectionUtils.isEmpty(batchOrgParamList)) {
            return;
        }
        int count = batchOrgParamList.size();
        ArrayList<OrgParam> addParamList = new ArrayList<OrgParam>(count);
        HashMap<Object, OrgParam> updateParamMap = new HashMap<Object, OrgParam>(count);
        HashMap<Long, OrgParam> orgCustomIdMap = new HashMap<Long, OrgParam>(count);
        this.orgLoader = new OrgOperationObjectLoader(batchOrgParamList);
        this.orgLoader.load(params -> {
            OrgParam orgParam = (OrgParam)params[0];
            if (orgParam.getId() == 0L) {
                addParamList.add(orgParam);
                long customOrgId = orgParam.getCustomOrgId();
                if (customOrgId > 0L) {
                    if (orgCustomIdMap.containsKey(customOrgId)) {
                        OrgMsgManager.generateFailMsg(orgParam, customOrgId + "M00067" + BaseMessage.getMessage((String)"M00018"));
                        return null;
                    }
                    orgCustomIdMap.put(customOrgId, orgParam);
                }
            } else {
                updateParamMap.put(orgParam.getId(), orgParam);
            }
            return null;
        });
        this.validateCustomId(orgCustomIdMap);
        Map<Integer, DynamicObject> addOrgObjMap = this.getNewOrgDynamicObject(addParamList);
        Map<Object, DynamicObject> dataBaseOrgObjMap = this.getOrgDynamicObject(updateParamMap);
        ArrayList<DynamicObject> saveObjList = new ArrayList<DynamicObject>(count);
        HashMap<Object, OrgParam> orgParamMap = new HashMap<Object, OrgParam>(count);
        for (OrgParam orgParam : batchOrgParamList) {
            if (!orgParam.isSuccess()) continue;
            DynamicObject orgObj = orgParam.getId() == 0L ? addOrgObjMap.get(orgParam.hashCode()) : dataBaseOrgObjMap.get(orgParam.getId());
            if (orgObj == null) {
                OrgMsgManager.generateFailMsg(orgParam, BaseMessage.getMessage((String)"M00020"));
                continue;
            }
            this.convertOrgDynamicObject(orgObj, orgParam);
            if (!orgParam.isSuccess()) continue;
            saveObjList.add(orgObj);
            orgParamMap.put(orgObj.get("id"), orgParam);
        }
        this.save(saveObjList, orgParamMap, Boolean.FALSE);
    }

    public void addView() {
        this.batchHandle(batchOrgParamList -> this.modifyView(batchOrgParamList, true));
    }

    public void deleteView() {
        this.batchHandle(batchOrgParamList -> this.modifyView(batchOrgParamList, false));
    }

    private void modifyView(List<OrgParam> batchOrgParamList, boolean addView) {
        if (CollectionUtils.isEmpty(batchOrgParamList)) {
            return;
        }
        int count = batchOrgParamList.size();
        HashMap<Object, OrgParam> updateParamMap = new HashMap<Object, OrgParam>(count);
        this.orgLoader = new OrgOperationObjectLoader(batchOrgParamList);
        this.orgLoader.load(params -> {
            OrgParam orgParam = (OrgParam)params[0];
            if (orgParam.getId() > 0L) {
                TreeMap multiViewMap = orgParam.getMultiViewMap();
                if (CollectionUtils.isEmpty((Map)multiViewMap)) {
                    OrgMsgManager.generateFailMsg(orgParam, OrgMessage.getMessage((String)"M00002"));
                    return null;
                }
                updateParamMap.put(orgParam.getId(), orgParam);
            } else {
                OrgMsgManager.generateFailMsg(orgParam, BaseMessage.getMessage((String)"M00002"));
            }
            return null;
        });
        Map<Object, DynamicObject> orgObjMap = this.getOrgDynamicObject(updateParamMap);
        if (CollectionUtils.isEmpty(orgObjMap)) {
            return;
        }
        this.modifyView(batchOrgParamList, addView, orgObjMap);
    }

    private void modifyView(List<OrgParam> batchOrgParamList, boolean addView, Map<Object, DynamicObject> orgObjMap) {
        int count = batchOrgParamList.size();
        ArrayList<DynamicObject> saveObjList = new ArrayList<DynamicObject>(count);
        HashMap<Object, OrgParam> orgParamMap = new HashMap<Object, OrgParam>(count);
        for (OrgParam orgParam : batchOrgParamList) {
            if (orgParam == null || !orgParam.isSuccess()) continue;
            long id = orgParam.getId();
            DynamicObject orgObj = orgObjMap.get(id);
            if (orgObj == null) {
                OrgMsgManager.generateFailMsg(orgParam, BaseMessage.getMessage((String)"M00058", (Object[])new Object[]{id}));
                continue;
            }
            if (addView) {
                this.addView(orgParam, orgObj);
            } else {
                this.deleteView(orgParam, orgObj);
            }
            if (!orgParam.isSuccess()) continue;
            saveObjList.add(orgObj);
            orgParamMap.put(orgObj.get("id"), orgParam);
        }
        this.save(saveObjList, orgParamMap, Boolean.TRUE);
    }

    private void addView(OrgParam orgParam, DynamicObject orgObj) {
        DynamicObjectCollection structureObjCol = orgObj.getDynamicObjectCollection("structure");
        TreeMap multiViewMap = orgParam.getMultiViewMap();
        for (Map.Entry viewEntry : multiViewMap.entrySet()) {
            DynamicObject structureObj = structureObjCol.addNew();
            this.convertStructureDynamicObject(orgParam, orgObj, structureObj, (String)viewEntry.getKey(), (OrgDutyView)viewEntry.getValue(), false);
        }
    }

    private void deleteView(OrgParam orgParam, DynamicObject orgObj) {
        TreeMap multiViewMap = orgParam.getMultiViewMap();
        DynamicObjectCollection structureObjCol = orgObj.getDynamicObjectCollection("structure");
        Iterator iterator = structureObjCol.iterator();
        while (iterator.hasNext()) {
            DynamicObject structureObj = (DynamicObject)iterator.next();
            DynamicObject viewObj = structureObj.getDynamicObject("view");
            if (viewObj == null || !multiViewMap.containsKey(viewObj.getString("number"))) continue;
            iterator.remove();
        }
    }

    private void save(List<DynamicObject> saveObjList, Map<Object, OrgParam> orgParamMap, Boolean isOrgApiBuildView) {
        if (saveObjList.isEmpty()) {
            return;
        }
        logger.info("\u3010\u7ec4\u7ec7\u64cd\u4f5c\u670d\u52a1\u63a5\u53e3\u5b9e\u73b0\u7c7b\u3011\u6bd4\u8f83\u7ec4\u7ec7\u53d8\u66f4\u5185\u5bb9");
        OrgOpContext orgOpContext = new OrgOpContext();
        OrgComparator orgComparator = new OrgComparator(orgOpContext, this.orgLoader.getSourceOrgMap(), saveObjList);
        orgComparator.compare();
        OperateOption operateOption = this.getOperateOption();
        operateOption.setVariableValue("orgApiChangeData", SerializationUtils.toJsonString((Object)orgOpContext.getChangeDataProvider().convertToOperationParam()));
        operateOption.setVariableValue("isOrgApiBuildView", isOrgApiBuildView.toString());
        OperationResult opResult = OperationServiceHelper.executeOperate((String)"save", (String)"bos_org", (DynamicObject[])saveObjList.toArray(new DynamicObject[saveObjList.size()]), (OperateOption)operateOption);
        this.parseOperationResult(opResult, orgParamMap);
    }

    private OperateOption getOperateOption() {
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", Boolean.TRUE.toString());
        option.setVariableValue("skipCheckDataPermission", Boolean.TRUE.toString());
        option.setVariableValue("skipCheckSpecialDataPermission", Boolean.TRUE.toString());
        return option;
    }

    private Map<Object, DynamicObject> getOrgDynamicObject(Map<Object, OrgParam> updateParamMap) {
        HashSet<Object> dataBaseOrgIds = new HashSet<Object>(updateParamMap.keySet());
        dataBaseOrgIds.addAll(this.orgLoader.getParentOrgParamMap().keySet());
        HashMap<Object, DynamicObject> dataBaseOrgObjMap = new HashMap<Object, DynamicObject>(this.orgLoader.getTargetObjMap().size());
        for (Map.Entry<Object, DynamicObject> entry : this.orgLoader.getTargetObjMap().entrySet()) {
            DynamicObject orgObj = entry.getValue();
            if (!orgObj.getDataEntityState().getFromDatabase()) continue;
            dataBaseOrgObjMap.put(entry.getKey(), orgObj);
        }
        dataBaseOrgIds.removeAll(dataBaseOrgObjMap.keySet());
        for (Map.Entry<Object, Object> entry : dataBaseOrgIds) {
            List<OrgParam> batchOrgParamList;
            OrgParam orgParam = updateParamMap.get(entry);
            if (orgParam != null) {
                OrgMsgManager.generateFailMsg(orgParam, BaseMessage.getMessage((String)"M00058", (Object[])new Object[]{entry}));
            }
            if (this.orgLoader.getTargetObjMap().containsKey(entry) || (batchOrgParamList = this.orgLoader.getParentOrgParamMap().get(entry)) == null) continue;
            for (OrgParam errorParentParam : batchOrgParamList) {
                OrgMsgManager.generateFailMsg(errorParentParam, BaseMessage.getMessage((String)"M00058", (Object[])new Object[]{entry}));
            }
        }
        return dataBaseOrgObjMap;
    }

    private Map<Integer, DynamicObject> getNewOrgDynamicObject(List<OrgParam> addParamList) {
        HashMap<Integer, DynamicObject> addOrgObjMap = new HashMap<Integer, DynamicObject>(addParamList.size());
        if (addParamList.isEmpty()) {
            return addOrgObjMap;
        }
        long[] ids = ORM.create().genLongIds("bos_org", addParamList.size());
        int idIndex = 0;
        for (OrgParam orgParam : addParamList) {
            if (!orgParam.isSuccess()) continue;
            long id = orgParam.getCustomOrgId();
            if (id <= 0L) {
                id = ids[idIndex++];
            }
            DynamicObject orgObj = BusinessDataServiceHelper.newDynamicObject((String)"bos_org");
            orgObj.set("id", (Object)id);
            orgObj.set("masterid", (Object)id);
            addOrgObjMap.put(orgParam.hashCode(), orgObj);
            this.orgLoader.getTargetObjMap().put(id, orgObj);
        }
        return addOrgObjMap;
    }

    private void validateCustomId(Map<Long, OrgParam> orgCustomIdMap) {
        if (orgCustomIdMap.isEmpty()) {
            return;
        }
        QFilter idFilter = new QFilter("id", "in", orgCustomIdMap.keySet());
        QFilter[] filters = new QFilter[]{idFilter};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"OrgServiceOperationImpl.validateCustomId", (String)"bos_org", (String)"id", (QFilter[])filters, (String)"");){
            for (Row row : dataSet) {
                Long id = row.getLong("id");
                OrgMsgManager.generateFailMsg(orgCustomIdMap.get(id), id + "M00067" + BaseMessage.getMessage((String)"M00018"));
            }
        }
    }

    private void convertOrgDynamicObject(DynamicObject orgObj, OrgParam orgParam) {
        boolean fromDatabase = orgObj.getDataEntityState().getFromDatabase();
        TreeMap multiViewMap = orgParam.getMultiViewMap();
        if (!fromDatabase && CollectionUtils.isEmpty((Map)multiViewMap)) {
            OrgMsgManager.generateFailMsg(orgParam, OrgMessage.getMessage((String)"M00002"));
            return;
        }
        DynamicObject pattern = this.getPattern(orgObj, orgParam, orgParam.getOrgPatternId());
        if (!orgParam.isSuccess()) {
            return;
        }
        this.setOtherProperty(orgObj, orgParam.getPropertyMap());
        if (pattern != null) {
            orgObj.set("orgpattern", (Object)pattern);
        }
        if (StringUtils.isNotBlank((CharSequence)orgParam.getNumber())) {
            orgObj.set("number", (Object)orgParam.getNumber());
        }
        if (StringUtils.isNotBlank((CharSequence)orgParam.getName())) {
            orgObj.set("name", (Object)orgParam.getName());
        }
        if (StringUtils.isNotBlank((CharSequence)orgParam.getYzjOrgId())) {
            orgObj.set("fyzjorgid", (Object)orgParam.getYzjOrgId());
            orgObj.set("fyzjimorted", (Object)"1");
        }
        DynamicObjectCollection structureObjCol = orgObj.getDynamicObjectCollection("structure");
        HashMap<String, DynamicObject> existsViewStructureMap = new HashMap<String, DynamicObject>(structureObjCol.size());
        boolean isBizOrg = false;
        for (DynamicObject structureObj : structureObjCol) {
            DynamicObject viewObj = structureObj.getDynamicObject("view");
            if (viewObj == null) continue;
            existsViewStructureMap.put(viewObj.getString("number"), structureObj);
            if (isBizOrg) continue;
            isBizOrg = this.isBizOrg(structureObj);
        }
        DynamicObject firstStructureObj = null;
        DynamicObject orgUnitStructureObj = null;
        for (Map.Entry entry : multiViewMap.entrySet()) {
            String viewNumber = (String)entry.getKey();
            DynamicObject structureObj = (DynamicObject)existsViewStructureMap.get(viewNumber);
            if (structureObj == null) {
                structureObj = this.addNewStructure(structureObjCol);
            }
            this.convertStructureDynamicObject(orgParam, orgObj, structureObj, viewNumber, (OrgDutyView)entry.getValue(), true);
            if (!orgParam.isSuccess()) {
                return;
            }
            if (firstStructureObj == null) {
                firstStructureObj = structureObj;
            }
            if (!isBizOrg) {
                isBizOrg = this.isBizOrg(structureObj);
            }
            if (orgUnitStructureObj != null || !"15".equals(viewNumber)) continue;
            orgUnitStructureObj = structureObj;
        }
        if (orgParam.isSuccess() && !fromDatabase && isBizOrg && firstStructureObj != null) {
            if (orgUnitStructureObj == null) {
                orgUnitStructureObj = this.addNewStructure(structureObjCol);
                this.copyStructure(orgObj, orgParam, "15", firstStructureObj, orgUnitStructureObj);
            }
            if (!multiViewMap.containsKey("16")) {
                DynamicObject bdControlStructureObj = this.addNewStructure(structureObjCol);
                this.copyStructure(orgObj, orgParam, "16", orgUnitStructureObj, bdControlStructureObj);
            }
        }
    }

    private DynamicObject addNewStructure(DynamicObjectCollection structureObjCol) {
        DynamicObject structureObj = structureObjCol.addNew();
        return structureObj;
    }

    private void convertStructureDynamicObject(OrgParam orgParam, DynamicObject orgObj, DynamicObject structureObj, String viewNumber, OrgDutyView dutyView, boolean convertOtherProperty) {
        DynamicObject viewObj = this.getView(orgObj, orgParam, viewNumber);
        if (viewObj == null) {
            return;
        }
        if (convertOtherProperty) {
            this.setOtherProperty(structureObj, dutyView.getPropertyMap());
        }
        if (orgParam.isHandleFrozenOrg()) {
            structureObj.set("isfreeze", (Object)"1");
            structureObj.set("sealuptime", (Object)new Date());
        }
        if (orgParam.isControlUnit()) {
            structureObj.set("isctrlunit", (Object)"1");
        }
        structureObj.set("view", (Object)viewObj);
        DynamicObject viewOrgObj = new DynamicObject(this.getDynamicObjectType(orgObj).get("org"));
        DynamicObjectUtils.copy((DynamicObject)orgObj, (DynamicObject)viewOrgObj);
        this.copyPkValue(orgObj, viewOrgObj);
        structureObj.set("vieworg", (Object)viewOrgObj);
        long parentId = dutyView.getParentId();
        DynamicObject parentObj = null;
        if (parentId > 0L && (parentObj = this.orgLoader.getTargetObjMap().get(parentId)) == null) {
            OrgMsgManager.generateFailMsg(orgParam, OrgMessage.getMessage((String)"M00014", (Object[])new Object[]{viewObj.getString("name")}));
        }
        if (parentObj == null) {
            if (parentId == 0L) {
                structureObj.set("viewparent", null);
            }
        } else {
            DynamicObject viewParentObj = new DynamicObject(this.getDynamicObjectType(orgObj).get("parent"));
            DynamicObjectUtils.copy((DynamicObject)parentObj, (DynamicObject)viewParentObj);
            this.copyPkValue(parentObj, viewParentObj);
            structureObj.set("viewparent", (Object)viewParentObj);
        }
    }

    private void copyStructure(DynamicObject orgObj, OrgParam orgParam, String viewNumber, DynamicObject from, DynamicObject to) {
        this.copyPkValue(from, to);
        to.set("view", (Object)this.getView(orgObj, orgParam, viewNumber));
        to.set("vieworg", from.get("vieworg"));
        to.set("viewparent", from.get("viewparent"));
    }

    private void copyPkValue(DynamicObject from, DynamicObject to) {
        to.set("id", from.get("id"));
    }

    private boolean isBizOrg(DynamicObject structureObj) {
        DynamicObject viewObj = structureObj.getDynamicObject("view");
        if (viewObj == null) {
            return false;
        }
        return 1L != viewObj.getLong("id");
    }

    private void setOtherProperty(DynamicObject obj, Map<String, Object> orgPropertyMap) {
        if (CollectionUtils.isEmpty(orgPropertyMap)) {
            return;
        }
        HashSet<String> propertiesNameSet = new HashSet<String>(orgPropertyMap.keySet());
        propertiesNameSet.remove("id");
        propertiesNameSet.remove("masterid");
        propertiesNameSet.remove("number");
        propertiesNameSet.remove("name");
        propertiesNameSet.remove("orgpattern");
        propertiesNameSet.remove("customOrgId");
        if (propertiesNameSet.isEmpty()) {
            return;
        }
        DataEntityPropertyCollection orgProperties = obj.getDataEntityType().getProperties();
        for (IDataEntityProperty orgPro : orgProperties) {
            String propertyKey = orgPro.getName();
            if (propertiesNameSet.remove(propertyKey)) {
                obj.set(propertyKey, orgPropertyMap.get(propertyKey));
            }
            if (!propertiesNameSet.isEmpty()) continue;
            break;
        }
    }

    private DynamicObject getPattern(DynamicObject orgObj, OrgParam orgParam, long id) {
        DynamicObject patternObj;
        if (id <= 0L) {
            return null;
        }
        if (this.patternObjMap == null) {
            DynamicObjectType patternType = this.getDynamicObjectType(orgObj).get("orgpattern");
            this.patternObjMap = BusinessDataServiceHelper.loadFromCache((DynamicObjectType)patternType, null);
            if (this.patternObjMap == null) {
                this.patternObjMap = new HashMap<Object, DynamicObject>(0);
            }
        }
        if ((patternObj = this.patternObjMap.get(id)) == null) {
            OrgMsgManager.generateFailMsg(orgParam, OrgMessage.getMessage((String)"M00019"));
            return null;
        }
        return patternObj;
    }

    private DynamicObject getView(DynamicObject orgObj, OrgParam orgParam, String number) {
        DynamicObject viewObj;
        if (StringUtils.isBlank((CharSequence)number)) {
            return null;
        }
        if (this.viewNumberObjMap == null) {
            Map viewObjMap = BusinessDataServiceHelper.loadFromCache((DynamicObjectType)this.getDynamicObjectType(orgObj).get("view"), null);
            if (CollectionUtils.isEmpty((Map)viewObjMap)) {
                this.viewNumberObjMap = new HashMap<String, DynamicObject>(0);
                OrgMsgManager.generateFailMsg(orgParam, OrgMessage.getMessage((String)"M00015"));
            } else {
                this.viewNumberObjMap = new HashMap<String, DynamicObject>(viewObjMap.size());
                for (Map.Entry viewEntry : viewObjMap.entrySet()) {
                    this.viewNumberObjMap.put(((DynamicObject)viewEntry.getValue()).getString("number"), (DynamicObject)viewEntry.getValue());
                }
            }
        }
        if ((viewObj = this.viewNumberObjMap.get(number)) == null) {
            OrgMsgManager.generateFailMsg(orgParam, number + BaseMessage.getMessage((String)"M00067") + OrgMessage.getMessage((String)"M00016"));
            return null;
        }
        return viewObj;
    }

    private Map<String, DynamicObjectType> getDynamicObjectType(DynamicObject orgObj) {
        if (this.dynamicObjectTypeMap != null) {
            return this.dynamicObjectTypeMap;
        }
        if (orgObj == null) {
            orgObj = BusinessDataServiceHelper.newDynamicObject((String)"bos_org");
        }
        this.dynamicObjectTypeMap = OrgUtils.getOrgEntityDynamicObjectType((DynamicObject)orgObj);
        return this.dynamicObjectTypeMap;
    }

    public void freeze() {
        this.freeze("freeze");
        logger.info("\u3010\u7ec4\u7ec7\u64cd\u4f5c\u670d\u52a1\u63a5\u53e3\u5b9e\u73b0\u7c7b\u3011\u6279\u91cf\u5c01\u5b58\u7ec4\u7ec7\uff1a" + (this.orgParamList == null ? 0 : this.orgParamList.size()));
    }

    public void unFreeze() {
        this.freeze("unfreeze");
        logger.info("\u3010\u7ec4\u7ec7\u64cd\u4f5c\u670d\u52a1\u63a5\u53e3\u5b9e\u73b0\u7c7b\u3011\u6279\u91cf\u89e3\u5c01\u7ec4\u7ec7\uff1a" + (this.orgParamList == null ? 0 : this.orgParamList.size()));
    }

    private void freeze(String operationKey) {
        if (OrgParamValidator.isOrgParamEmpty(this.orgParamList)) {
            return;
        }
        int count = this.orgParamList.size();
        HashMap<Object, OrgParam> orgParamMap = new HashMap<Object, OrgParam>(count);
        boolean isYzjSync = false;
        for (OrgParam orgParam : this.orgParamList) {
            if (orgParam.getId() == 0L) {
                OrgMsgManager.generateFailMsg(orgParam, BaseMessage.getMessage((String)"M00002"));
                continue;
            }
            orgParamMap.put(orgParam.getId(), orgParam);
            if (!orgParam.isYzjSync()) continue;
            isYzjSync = true;
        }
        if (count <= 1000) {
            this.batchFreeze(operationKey, isYzjSync, orgParamMap);
            return;
        }
        String orderBy = "freeze".equals(operationKey) ? "longnumber desc" : "longnumber";
        QFilter viewFilter = new QFilter("view", "=", (Object)1L);
        QFilter orgFilter = new QFilter("org", "in", orgParamMap.keySet());
        QFilter[] filters = new QFilter[]{viewFilter, orgFilter};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"OrgServiceOperationImpl.freeze.batchFreeze", (String)"bos_org_structure", (String)"org", (QFilter[])filters, (String)orderBy);){
            HashMap<Object, OrgParam> batchOrgParamMap = new HashMap<Object, OrgParam>(count);
            for (Row row : dataSet) {
                OrgParam orgParam = (OrgParam)orgParamMap.remove(row.getLong("org"));
                if (orgParam == null) continue;
                batchOrgParamMap.put(orgParam.getId(), orgParam);
                if (batchOrgParamMap.size() < 1000) continue;
                this.batchFreeze(operationKey, isYzjSync, batchOrgParamMap);
                batchOrgParamMap.clear();
            }
            this.batchFreeze(operationKey, isYzjSync, batchOrgParamMap);
            this.batchFreeze(operationKey, isYzjSync, orgParamMap);
        }
    }

    private void batchFreeze(String operationKey, boolean isYzjSync, Map<Object, OrgParam> orgParamMap) {
        if (orgParamMap.isEmpty()) {
            return;
        }
        OperateOption operateOption = this.getOperateOption();
        if ("freeze".equals(operationKey)) {
            operateOption.setVariableValue("doSyncToYunzhijiaOperation", Boolean.toString(isYzjSync));
        }
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)operationKey, (String)"bos_adminorg", (Object[])orgParamMap.keySet().toArray(new Object[0]), (OperateOption)operateOption);
        this.parseOperationResult(operationResult, orgParamMap);
    }

    public void disable() {
        this.executeOperate("disable", batchOrgParamList -> this.batchExecuteById("disable", batchOrgParamList));
    }

    public void enable() {
        this.executeOperate("enable", batchOrgParamList -> this.batchExecuteById("enable", batchOrgParamList));
    }

    public void bizFreeze() {
        this.executeOperate("bizfreeze", batchOrgParamList -> this.batchBizFreeze("bizfreeze", batchOrgParamList));
    }

    public void bizUnfreeze() {
        this.executeOperate("bizunfreeze", batchOrgParamList -> this.batchBizFreeze("bizunfreeze", batchOrgParamList));
    }

    private void batchBizFreeze(String operationKey, List<OrgParam> batchOrgParamList) {
        Map orgBizHandoverMap;
        Map orgParamMap;
        Map paramMap;
        int count = batchOrgParamList.size();
        HashMap<Long, Map> changeRecordMap = new HashMap<Long, Map>(count);
        for (OrgParam orgParam : batchOrgParamList) {
            if (!OrgParamValidator.parseMultiViewMap(orgParam)) continue;
            if (orgParam.getId() <= 0L) {
                OrgMsgManager.generateFailMsg(orgParam, BaseMessage.getMessage((String)"M00002"));
                continue;
            }
            paramMap = changeRecordMap.computeIfAbsent(orgParam.getChangeRecordId(), v -> new HashMap(2));
            orgParamMap = (Map)paramMap.computeIfAbsent("data", v -> new HashMap(count));
            orgBizHandoverMap = (Map)paramMap.computeIfAbsent("orgChangeOperationParam", v -> new HashMap(count));
            Map bizHandoverMap = orgBizHandoverMap.computeIfAbsent(orgParam.getId(), v -> new HashMap(orgParam.getMultiViewMap().size()));
            this.batchBizFreezeParseParam(orgParam, bizHandoverMap);
            orgParamMap.put(orgParam.getId(), orgParam);
            this.genBizFreezeSendMsgParamBy(orgParam, paramMap);
        }
        for (Map.Entry entry : changeRecordMap.entrySet()) {
            paramMap = (Map)entry.getValue();
            orgParamMap = (Map)paramMap.get("data");
            orgBizHandoverMap = (Map)paramMap.get("orgChangeOperationParam");
            OperateOption operateOption = this.getOperateOption();
            Long changRecordId = (Long)entry.getKey();
            operateOption.setVariableValue("orgChangeRecordId", changRecordId.toString());
            operateOption.setVariableValue("orgChangeOperationParam", SerializationUtils.toJsonString((Object)orgBizHandoverMap));
            Object sendMsg = paramMap.get("orgChangeSendMessageParam");
            if (sendMsg != null) {
                paramMap.put("orgChangeSendMessageParam", Boolean.FALSE);
                operateOption.setVariableValue("orgChangeSendMessageParam", sendMsg.toString());
            }
            ArrayList<OrgParam> orgChangeRecordParamList = null;
            if (Objects.equals(changRecordId, 0L)) {
                orgChangeRecordParamList = new ArrayList<OrgParam>(orgParamMap.values());
            }
            this.batchExecuteById(operationKey, orgParamMap, operateOption);
            this.writeBackChangeInfo(orgChangeRecordParamList, operateOption);
        }
    }

    private void genBizFreezeSendMsgParamBy(OrgParam orgParam, Map<String, Object> paramMap) {
        if (orgParam.isSendChangeRecordMsg()) {
            paramMap.put("orgChangeSendMessageParam", Boolean.TRUE);
        } else {
            Boolean sendMsg = (Boolean)paramMap.get("orgChangeSendMessageParam");
            if (sendMsg == null || !sendMsg.booleanValue()) {
                paramMap.put("orgChangeSendMessageParam", Boolean.FALSE);
            }
        }
    }

    private void writeBackChangeInfo(List<OrgParam> orgParamList, OperateOption operateOption) {
        if (CollectionUtils.isEmpty(orgParamList)) {
            return;
        }
        String changRecordIdParam = operateOption.getVariableValue("orgChangeRecordId", "0");
        long changRecordId = Long.parseLong(changRecordIdParam);
        if (Objects.equals(changRecordId, 0L)) {
            return;
        }
        for (OrgParam orgParam : orgParamList) {
            if (!orgParam.isSuccess()) continue;
            orgParam.setChangeRecordId(changRecordId);
        }
    }

    private void batchBizFreezeParseParam(OrgParam orgParam, Map<String, Long> bizHandoverMap) {
        for (Map.Entry entry : orgParam.getMultiViewMap().entrySet()) {
            Object handoverOrgIdParam;
            Map propertyMap;
            Long handoverOrgId = 0L;
            OrgDutyView orgDutyView = (OrgDutyView)entry.getValue();
            if (orgDutyView != null && (propertyMap = orgDutyView.getPropertyMap()) != null && (handoverOrgIdParam = propertyMap.get("handoverOrgId")) instanceof Long) {
                handoverOrgId = (Long)handoverOrgIdParam;
            }
            bizHandoverMap.put((String)entry.getKey(), handoverOrgId);
        }
    }

    private void executeOperate(String operationKey, IBaseBatchHandler handler) {
        if (CollectionUtils.isEmpty(this.orgParamList)) {
            return;
        }
        logger.info("\u3010\u7ec4\u7ec7\u64cd\u4f5c\u670d\u52a1\u63a5\u53e3\u5b9e\u73b0\u7c7b\u3011\u6267\u884c[{}]\u64cd\u4f5c\u7684\u7ec4\u7ec7\u53c2\u6570\u5bf9\u8c61\u6570\u91cf\uff1a{}", (Object)operationKey, (Object)this.orgParamList.size());
        BaseBatchHandler.handle(this.orgParamList, (IBaseBatchHandler)handler);
    }

    private void batchExecuteById(String operationKey, List<OrgParam> batchOrgParamList) {
        HashMap<Object, OrgParam> orgParamMap = new HashMap<Object, OrgParam>(batchOrgParamList.size());
        for (OrgParam orgParam : batchOrgParamList) {
            if (OrgParamValidator.isOrgParamEmpty(orgParam)) continue;
            if (orgParam.getId() <= 0L) {
                OrgMsgManager.generateFailMsg(orgParam, BaseMessage.getMessage((String)"M00002"));
                continue;
            }
            orgParamMap.put(orgParam.getId(), orgParam);
        }
        this.batchExecuteById(operationKey, orgParamMap, null);
    }

    private void batchExecuteById(String operationKey, Map<Object, OrgParam> orgParamMap, OperateOption operateOption) {
        if (orgParamMap.isEmpty()) {
            return;
        }
        Set<Object> ids = orgParamMap.keySet();
        OperationResult opResult = OperationServiceHelper.executeOperate((String)operationKey, (String)"bos_org", (Object[])ids.toArray(new Object[ids.size()]), (OperateOption)operateOption);
        this.parseOperationResult(opResult, orgParamMap);
    }

    private void batchHandle(IBaseBatchHandler handler) {
        if (CollectionUtils.isEmpty(this.orgParamList)) {
            return;
        }
        int size = this.orgParamList.size();
        logger.info("\u3010\u7ec4\u7ec7\u64cd\u4f5c\u670d\u52a1\u63a5\u53e3\u5b9e\u73b0\u7c7b\u3011\u7ec4\u7ec7\u53c2\u6570\u5bf9\u8c61\u6570\u91cf\uff1a" + size);
        if (size == 1) {
            BaseBatchHandler.handle(this.orgParamList, (IBaseBatchHandler)handler);
            return;
        }
        int count = size >= 1000 ? 1000 : size;
        LinkedHashMap<Long, List<OrgParam>> orgParamMap = new LinkedHashMap<Long, List<OrgParam>>(count);
        for (OrgParam orgParam : this.orgParamList) {
            List orgParamList = orgParamMap.computeIfAbsent(orgParam.getId(), v -> new ArrayList(count));
            orgParamList.add(orgParam);
            if (orgParamMap.size() < 1000) continue;
            this.batchHandle(handler, orgParamMap);
        }
        this.batchHandle(handler, orgParamMap);
    }

    private void batchHandle(IBaseBatchHandler handler, Map<Long, List<OrgParam>> orgParamMap) {
        while (!orgParamMap.isEmpty()) {
            ArrayList<OrgParam> batchOrgParamList = new ArrayList<OrgParam>(orgParamMap.size());
            Iterator<Map.Entry<Long, List<OrgParam>>> iterator = orgParamMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Long, List<OrgParam>> entry = iterator.next();
                List<OrgParam> eachOrgParamList = entry.getValue();
                if (entry.getKey() == 0L) {
                    batchOrgParamList.addAll(eachOrgParamList);
                    eachOrgParamList.clear();
                } else {
                    OrgParam orgParam = eachOrgParamList.remove(0);
                    batchOrgParamList.add(orgParam);
                }
                if (batchOrgParamList.size() >= 1000) {
                    BaseBatchHandler.handle(batchOrgParamList, (IBaseBatchHandler)handler);
                    batchOrgParamList.clear();
                }
                if (!eachOrgParamList.isEmpty()) continue;
                iterator.remove();
            }
            BaseBatchHandler.handle(batchOrgParamList, (IBaseBatchHandler)handler);
        }
    }

    private void parseOperationResult(OperationResult opResult, Map<Object, OrgParam> orgParamMap) {
        List ids = opResult.getSuccessPkIds();
        if (Utils.isListNotEmpty((List)ids)) {
            for (Object pk : ids) {
                long id = Long.parseLong(pk.toString());
                OrgMsgManager.generateSuccessMsg(orgParamMap.remove(id), id);
            }
        }
        String msg = null;
        List errorInfoList = opResult.getAllErrorOrValidateInfo();
        if (Utils.isListNotEmpty((List)errorInfoList)) {
            HashSet<Long> errorPks = new HashSet<Long>(errorInfoList.size());
            for (IOperateInfo info : errorInfoList) {
                msg = info.getMessage();
                Object pk = info.getPkValue();
                if (pk == null || "".equals(pk)) continue;
                Long orgId = Long.valueOf(pk.toString());
                errorPks.add(orgId);
                OrgMsgManager.generateFailMsg(orgParamMap.get(orgId), msg);
            }
            orgParamMap.keySet().removeAll(errorPks);
        }
        if (!orgParamMap.isEmpty()) {
            if (StringUtils.isBlank(msg)) {
                msg = opResult.getMessage();
            }
            for (OrgParam orgParam : orgParamMap.values()) {
                OrgMsgManager.generateFailMsg(orgParam, msg);
            }
        }
    }
}

