/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.FilterFunction;
import kd.bos.algo.Row;
import kd.bos.base.cache.BaseOrgCache;
import kd.bos.base.utils.msg.BaseMessage;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.cache.OrgCache;
import kd.bos.org.model.OrgQueryType;
import kd.bos.org.service.OrgRelationService;
import kd.bos.org.utils.OrgUtils;
import kd.bos.org.utils.OrgViewUtils;
import kd.bos.org.utils.Utils;
import kd.bos.orm.ORM;
import kd.bos.orm.impl.ORMUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.yzj.interfaces.IYzjUserService;
import kd.bos.yzj.model.YzjConfig;
import kd.bos.yzj.service.YzjServiceFactory;

public class OrgServiceQueryImpl {
    private static final Log log = LogFactory.getLog(OrgServiceQueryImpl.class);
    private static final String FILTER_PRO_ORG_ENABLE = "org.enable";
    private static final long SCHEMA_ACCOUNTING_ID = 10L;

    public long getRootOrgId() {
        Map<Long, Long> viewId2RootOrgId;
        Long id;
        String rootOrg = BaseOrgCache.getRootOrg();
        if (rootOrg != null) {
            long id2 = 0L;
            try {
                id2 = Long.parseLong(rootOrg);
            }
            catch (Throwable e) {
                log.error("\u89e3\u6790\u7f13\u5b58\u7ec4\u7ec7\u6839\u8282\u70b9\u53d1\u751f\u5f02\u5e38\uff1a" + e.getMessage());
            }
            if (id2 != 0L) {
                return id2;
            }
        }
        if ((id = (viewId2RootOrgId = this.getRootOrgId(Collections.singletonList(15L))).get(15L)) == null) {
            id = 100000L;
        }
        BaseOrgCache.putRootOrg((long)id);
        return id;
    }

    public Map<Long, Long> getRootOrgId(List<Long> viewIds) {
        if (CollectionUtils.isEmpty(viewIds)) {
            return new HashMap<Long, Long>(0);
        }
        String selectProperties = "org,view";
        QFilter viewFilter = new QFilter("view", "in", viewIds);
        QFilter parentFilter = new QFilter("parent", "=", (Object)0);
        QFilter[] filters = new QFilter[]{viewFilter, parentFilter};
        Map rootOrgMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org_structure", (String)selectProperties, (QFilter[])filters, (String)"longnumber");
        HashMap<Long, Long> res = new HashMap<Long, Long>(viewIds.size());
        if (!CollectionUtils.isEmpty((Map)rootOrgMap)) {
            for (Map.Entry rootOrgEntry : rootOrgMap.entrySet()) {
                DynamicObject struObj = (DynamicObject)rootOrgEntry.getValue();
                DynamicObject viewObj = struObj.getDynamicObject("view");
                DynamicObject orgObj = struObj.getDynamicObject("org");
                if (viewObj == null || orgObj == null) continue;
                res.putIfAbsent(viewObj.getLong("id"), orgObj.getLong("id"));
            }
        }
        return res;
    }

    public List<Long> getAllOrgByViewId(long viewId, boolean isIncludeDisable) {
        QFilter viewFilter = new QFilter("view", "=", (Object)viewId);
        return this.getAllOrgByViewNumber(viewFilter, isIncludeDisable);
    }

    public List<Long> getAllOrgByViewNumber(String viewSchemaNumber, boolean isIncludeDisable) {
        QFilter viewFilter = new QFilter("view.number", "=", (Object)viewSchemaNumber);
        return this.getAllOrgByViewNumber(viewFilter, isIncludeDisable);
    }

    private List<Long> getAllOrgByViewNumber(QFilter viewFilter, boolean isIncludeDisable) {
        if (!isIncludeDisable) {
            viewFilter = viewFilter.and(new QFilter(FILTER_PRO_ORG_ENABLE, "=", (Object)Boolean.TRUE));
            viewFilter = viewFilter.and(new QFilter("isfreeze", "=", (Object)Boolean.FALSE));
        }
        QFilter[] filters = new QFilter[]{viewFilter};
        return this.getAllOrgByFilters(filters);
    }

    public List<Long> getAllOrg(String viewSchemaNumber) {
        if (StringUtils.isBlank((CharSequence)viewSchemaNumber)) {
            return new ArrayList<Long>();
        }
        return this.getAllOrgByViewNumber(viewSchemaNumber, false);
    }

    public List<Long> getAllSubordinateOrgs(Long viewId, List<Long> orgIds, boolean isIncludeCurOrg) {
        return this.getAllSubordinateOrgs(viewId, orgIds, isIncludeCurOrg, false);
    }

    public List<Long> getAllSubordinateOrgs(Long viewId, List<Long> orgIds, boolean isIncludeCurOrg, boolean isIncludeDisable) {
        if (Utils.isListEmpty(orgIds) || viewId == null) {
            log.info("[getAllSubordinateOrgs.viewId]\u7ec4\u7ec7\u53c2\u6570\u4e3a\u7a7a\uff0c\u83b7\u53d6\u4e0b\u7ea7\u7ec4\u7ec7\u5931\u8d25\u3002");
            return new ArrayList<Long>(0);
        }
        return new ArrayList<Long>(this.getAllSubordinateOrgs(viewId, orgIds, isIncludeCurOrg, isIncludeDisable, null));
    }

    public List<Long> getAllSubordinateOrgs(String viewSchemaNumber, List<Long> orgIds, boolean isIncludeCurOrg) {
        return this.getAllSubordinateOrgs(viewSchemaNumber, orgIds, isIncludeCurOrg, false);
    }

    public List<Long> getAllSubordinateOrgs(String viewSchemaNumber, List<Long> orgIds, boolean isIncludeCurOrg, boolean isIncludeDisable) {
        if (Utils.isListEmpty(orgIds)) {
            log.info("[getAllSubordinateOrgs.viewNumber]\u7ec4\u7ec7\u53c2\u6570\u4e3a\u7a7a\uff0c\u83b7\u53d6\u4e0b\u7ea7\u7ec4\u7ec7\u5931\u8d25\u3002");
            return new ArrayList<Long>(0);
        }
        QFilter numberFilter = new QFilter("number", "=", (Object)viewSchemaNumber);
        QFilter[] filters = new QFilter[]{numberFilter};
        DynamicObject viewObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org_viewschema", (String)"id", (QFilter[])filters);
        if (viewObj == null) {
            log.error(viewSchemaNumber + "\uff1a[getAllSubordinateOrgs]\u6839\u636e\u7f16\u7801\u67e5\u8be2\u89c6\u56fe\u65b9\u6848ID\u5931\u8d25\u3002");
            return new ArrayList<Long>(0);
        }
        return this.getAllSubordinateOrgs((Long)viewObj.getLong("id"), orgIds, isIncludeCurOrg, isIncludeDisable);
    }

    public Map<Long, List<Long>> getAllSubordinateOrgMap(String viewSchemaNumber, List<Long> orgIds, boolean isIncludeCurOrg) {
        if (Utils.isListEmpty(orgIds)) {
            log.info("[getAllSubordinateOrgMap.viewNumber]\u7ec4\u7ec7\u53c2\u6570\u4e3a\u7a7a\uff0c\u83b7\u53d6\u4e0b\u7ea7\u7ec4\u7ec7\u5931\u8d25\u3002");
            return new HashMap<Long, List<Long>>(0);
        }
        long viewId = this.getViewIdByNumber(viewSchemaNumber);
        if (viewId == 0L) {
            return new HashMap<Long, List<Long>>(0);
        }
        return this.getAllSubordinateOrgMap(viewId, orgIds, isIncludeCurOrg);
    }

    private long getViewIdByNumber(String viewNumber) {
        QFilter numberFilter = new QFilter("number", "=", (Object)viewNumber);
        QFilter[] filters = new QFilter[]{numberFilter};
        DynamicObject viewObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org_viewschema", (String)"id", (QFilter[])filters);
        if (viewObj == null) {
            log.error(viewNumber + "\uff1a[getViewIdByNumber]\u6839\u636e\u7f16\u7801\u67e5\u8be2\u89c6\u56fe\u65b9\u6848ID\u5931\u8d25\u3002");
            return 0L;
        }
        return viewObj.getLong("id");
    }

    public Map<Long, List<Long>> getAllSubordinateOrgMap(long viewId, List<Long> orgIds, boolean isIncludeCurOrg) {
        if (viewId == 0L || CollectionUtils.isEmpty(orgIds)) {
            log.info("[getAllSubordinateOrgMap.viewId]\u7ec4\u7ec7\u53c2\u6570\u4e3a\u7a7a\uff0c\u83b7\u53d6\u4e0b\u7ea7\u7ec4\u7ec7\u5931\u8d25\u3002");
            return new HashMap<Long, List<Long>>(0);
        }
        HashMap<Long, List<Long>> allSubOrgMap = new HashMap<Long, List<Long>>(orgIds.size());
        for (Long orgId : orgIds) {
            allSubOrgMap.put(orgId, new ArrayList(64));
        }
        this.getAllSubordinateOrgs(viewId, orgIds, isIncludeCurOrg, false, allSubOrgMap);
        return allSubOrgMap;
    }

    private List<Long> getAllOrgByFilters(QFilter[] filters) {
        ArrayList<Long> resultList = new ArrayList<Long>(10000);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"OrgServiceQueryImpl.getAllOrgByFilters", (String)"bos_org_structure", (String)"org", (QFilter[])filters, (String)"");){
            for (Row row : dataSet) {
                resultList.add(row.getLong("org"));
            }
        }
        return resultList;
    }

    private Set<Long> getAllSubordinateOrgs(long viewId, List<Long> orgIds, boolean isIncludeCurOrg, boolean isIncludeDisable, Map<Long, List<Long>> allSubOrgMap) {
        if (CollectionUtils.isEmpty(orgIds)) {
            return new HashSet<Long>(0);
        }
        HashSet<Long> allSubOrgIds = new HashSet<Long>(10000);
        QFilter viewFilter = new QFilter("view", "=", (Object)viewId);
        if (!isIncludeDisable) {
            QFilter freezeFilter = new QFilter("isfreeze", "=", (Object)Boolean.FALSE);
            viewFilter = viewFilter.and(freezeFilter);
            QFilter enableFilter = new QFilter(FILTER_PRO_ORG_ENABLE, "=", (Object)Boolean.TRUE);
            viewFilter = viewFilter.and(enableFilter);
        }
        QFilter[] filters = new QFilter[]{viewFilter};
        String selectFields = "id,org,longnumber";
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"OrgServiceQueryImpl.getAllSubordinateOrgs.getAll", (String)"bos_org_structure", (String)selectFields, (QFilter[])filters, (String)"");
             DataSet orderDataSet = dataSet.orderBy(new String[]{"longnumber"});){
            String parentLongNumberStart = null;
            HashSet<Long> paramOrgIs = new HashSet<Long>(orgIds);
            HashMap<String, Long> longNumberStartOrgMap = allSubOrgMap == null ? null : new HashMap<String, Long>(paramOrgIs.size());
            for (Row structureObj : orderDataSet) {
                boolean isNextParentOrg;
                long orgId = structureObj.getLong("org");
                String longNumber = structureObj.getString("longnumber");
                if (longNumberStartOrgMap != null && paramOrgIs.contains(orgId)) {
                    longNumberStartOrgMap.put(longNumber + "!", orgId);
                    if (isIncludeCurOrg) {
                        allSubOrgMap.computeIfAbsent(orgId, k -> new ArrayList()).add(orgId);
                    }
                }
                boolean bl = isNextParentOrg = parentLongNumberStart == null;
                if (!isNextParentOrg && !(isNextParentOrg = allSubOrgMap == null ? this.getAllSubordinateOrgs(orgId, longNumber, parentLongNumberStart, allSubOrgIds) : this.getAllSubordinateOrgsMap(orgId, longNumber, parentLongNumberStart, allSubOrgMap, longNumberStartOrgMap))) {
                    paramOrgIs.remove(orgId);
                }
                if (!isNextParentOrg) continue;
                if (paramOrgIs.isEmpty()) {
                    break;
                }
                if (!paramOrgIs.remove(orgId)) continue;
                parentLongNumberStart = longNumber + "!";
                if (!isIncludeCurOrg) continue;
                allSubOrgIds.add(orgId);
            }
        }
        if (!isIncludeCurOrg && allSubOrgMap == null) {
            allSubOrgIds.removeAll(orgIds);
        }
        return allSubOrgIds;
    }

    private boolean getAllSubordinateOrgs(long orgId, String longNumber, String parentLongNumberStart, Set<Long> allSubOrgIds) {
        boolean isSubOrg = longNumber.startsWith(parentLongNumberStart);
        if (isSubOrg) {
            allSubOrgIds.add(orgId);
        }
        return !isSubOrg;
    }

    private boolean getAllSubordinateOrgsMap(long orgId, String longNumber, String parentLongNumberStart, Map<Long, List<Long>> allSubOrgMap, Map<String, Long> longNumberStartOrgMap) {
        boolean isSubOrg = longNumber.startsWith(parentLongNumberStart);
        if (isSubOrg) {
            for (Map.Entry<String, Long> lnEntry : longNumberStartOrgMap.entrySet()) {
                if (!longNumber.startsWith(lnEntry.getKey())) continue;
                allSubOrgMap.computeIfAbsent(lnEntry.getValue(), k -> new ArrayList()).add(orgId);
            }
        }
        return !isSubOrg;
    }

    public List<Long> getAllSuperiorOrgs(String orgFunction, long orgId) {
        if (orgId == 0L) {
            return new ArrayList<Long>(0);
        }
        Map<Long, List<Long>> parentIdMap = this.getAllSuperiorOrgs(orgFunction, Collections.singletonList(orgId));
        if (CollectionUtils.isEmpty(parentIdMap)) {
            return new ArrayList<Long>(0);
        }
        ArrayList parentIds = parentIdMap.get(orgId);
        return parentIds == null ? new ArrayList(0) : parentIds;
    }

    public Map<Long, List<Long>> getAllSuperiorOrgs(String viewNumber, List<Long> orgIds) {
        if (CollectionUtils.isEmpty(orgIds)) {
            return new HashMap<Long, List<Long>>(0);
        }
        if (StringUtils.isBlank((CharSequence)viewNumber)) {
            viewNumber = "01";
        }
        int count = orgIds.size();
        HashMap<Long, List<Long>> parentIdMap = new HashMap<Long, List<Long>>(count);
        QFilter[] filters = new QFilter[]{new QFilter("number", "=", (Object)viewNumber)};
        DynamicObject viewObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org_viewschema", (String)"id", (QFilter[])filters);
        if (viewObj == null) {
            return parentIdMap;
        }
        long viewId = viewObj.getLong("id");
        QFilter filter = new QFilter("view", "=", (Object)viewId);
        if (orgIds.size() <= 1000) {
            QFilter orgFilter = new QFilter("org", "in", orgIds);
            filter = filter.and(orgFilter);
        }
        return this.getAllSuperiorOrgs(filter, orgIds.size());
    }

    private Map<Long, List<Long>> getAllSuperiorOrgs(QFilter filter, int count) {
        HashMap<Long, List<Long>> parentIdMap = new HashMap<Long, List<Long>>(count);
        HashSet<String> parentNumbers = new HashSet<String>(count);
        HashMap<Long, String> parentLongNumberMap = new HashMap<Long, String>(count);
        HashMap<String, Long> numberIdMap = new HashMap<String, Long>(count);
        QFilter[] filters = new QFilter[]{filter};
        DataSet ds = QueryServiceHelper.queryDataSet((String)"OrgServiceQueryImpl.getAllSuperiorOrgs", (String)"bos_org_structure", (String)"org,longnumber", (QFilter[])filters, (String)"");
        Object object = null;
        try {
            for (Row row : ds) {
                String longNumber = row.getString("longnumber");
                Long orgId = row.getLong("org");
                if (StringUtils.isBlank((CharSequence)longNumber)) {
                    log.error(orgId + "\uff1a\u7ec4\u7ec7\u957f\u7f16\u7801\u4e3a\u7a7a\uff0c\u67e5\u8be2\u4e0a\u7ea7\u7ec4\u7ec7\u5931\u8d25\u3002");
                    parentIdMap.put(orgId, new ArrayList(0));
                    continue;
                }
                if (longNumber.indexOf("!") == -1) {
                    parentIdMap.put(orgId, new ArrayList(0));
                    numberIdMap.put(longNumber, orgId);
                    continue;
                }
                String[] numbers = longNumber.split("!");
                int currentNumberIndex = numbers.length - 1;
                String currentNumber = numbers[currentNumberIndex];
                numberIdMap.put(currentNumber, orgId);
                for (int i = 0; i < currentNumberIndex; ++i) {
                    String number = numbers[i];
                    parentNumbers.add(number);
                }
                parentLongNumberMap.put(orgId, StringUtils.substringBeforeLast((String)longNumber, (String)"!"));
                parentIdMap.put(orgId, new ArrayList(numbers.length));
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (object != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        parentNumbers.removeAll(numberIdMap.keySet());
        numberIdMap.putAll(this.getOrgNumberIdMap(parentNumbers));
        HashMap<String, List<Long>> longNumberIdMap = new HashMap<String, List<Long>>(numberIdMap.size());
        for (Map.Entry entry : parentLongNumberMap.entrySet()) {
            this.getParentIdByLongNumber((List)parentIdMap.get(entry.getKey()), (String)entry.getValue(), numberIdMap, longNumberIdMap);
        }
        return parentIdMap;
    }

    private void getParentIdByLongNumber(List<Long> orgIds, String parentLongNumber, Map<String, Long> numberIdMap, Map<String, List<Long>> longNumberIdMap) {
        List<Long> parentIds = longNumberIdMap.get(parentLongNumber);
        if (parentIds != null) {
            orgIds.addAll(parentIds);
            return;
        }
        String[] numbers = parentLongNumber.split("!");
        if (numbers.length == 0) {
            return;
        }
        for (String number : numbers) {
            Long orgId = numberIdMap.get(number);
            if (orgId == null) {
                log.info(number + "\uff1a\u6839\u636e\u7f16\u7801\u83b7\u53d6\u7ec4\u7ec7ID\u5931\u8d25\u3002");
                continue;
            }
            orgIds.add(orgId);
        }
        longNumberIdMap.put(parentLongNumber, orgIds);
    }

    private Map<String, Long> getOrgNumberIdMap(Collection<String> numbers) {
        if (numbers.isEmpty()) {
            return new HashMap<String, Long>(0);
        }
        QFilter numberFilter = new QFilter("number", "in", numbers);
        QFilter[] filters = new QFilter[]{numberFilter};
        Map orgObjMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"number", (QFilter[])filters);
        if (CollectionUtils.isEmpty((Map)orgObjMap)) {
            return new HashMap<String, Long>(0);
        }
        HashMap<String, Long> numberIdMap = new HashMap<String, Long>(orgObjMap.size());
        for (Map.Entry orgEntry : orgObjMap.entrySet()) {
            DynamicObject orgObj = (DynamicObject)orgEntry.getValue();
            numberIdMap.put(orgObj.getString("number"), orgObj.getLong("id"));
        }
        return numberIdMap;
    }

    public long getParentIdBySelfOrOrgUnitView(long srcParentId, long viewId) {
        return this.getParentIdBySelfOrOrgUnitViewCommon(srcParentId, viewId);
    }

    public long getParentIdBySelfOrOrgUnitView(long srcParentId, String viewNumber) {
        return this.getParentIdBySelfOrOrgUnitViewCommon(srcParentId, viewNumber);
    }

    private long getParentIdBySelfOrOrgUnitViewCommon(long srcParentId, Object viewKey) {
        QFilter filterTreeType;
        QFilter orgFilter = new QFilter("org", "=", (Object)srcParentId);
        ArrayList<Object> viewList = new ArrayList<Object>(2);
        if (viewKey instanceof String) {
            viewList.add(viewKey);
            viewList.add("15");
            filterTreeType = new QFilter("view.number", "in", viewList);
        } else {
            viewList.add(viewKey);
            viewList.add(15L);
            filterTreeType = new QFilter("view", "in", viewList);
        }
        QFilter freezeFilter = new QFilter("isfreeze", "=", (Object)Boolean.FALSE);
        QFilter enableFilter = new QFilter(FILTER_PRO_ORG_ENABLE, "=", (Object)Boolean.TRUE);
        QFilter[] filters = new QFilter[]{orgFilter, filterTreeType, freezeFilter, enableFilter};
        String orgUnitLongnumber = "";
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"OrgServiceQueryImpl.getParentIdBySelfOrOrgUnitViewCommon", (String)"bos_org_structure", (String)"view,org,longnumber", (QFilter[])filters, (String)"longnumber desc");){
            for (Row row : dataSet) {
                if (15L != row.getLong("view")) {
                    long l = row.getLong("org");
                    return l;
                }
                orgUnitLongnumber = row.getString("longnumber");
            }
        }
        return this.getParentIdBySelfOrOrgUnitView(srcParentId, viewKey, orgUnitLongnumber);
    }

    private long getParentIdBySelfOrOrgUnitView(long srcParentId, Object viewKey, String orgUnitLongnumber) {
        long lCurParentID = 0L;
        QFilter freezeFilter = new QFilter("isfreeze", "=", (Object)Boolean.FALSE);
        QFilter enableFilter = new QFilter(FILTER_PRO_ORG_ENABLE, "=", (Object)Boolean.TRUE);
        if (StringUtils.isBlank((CharSequence)orgUnitLongnumber)) {
            QFilter filterUnit = new QFilter("org", "=", (Object)srcParentId);
            QFilter filterView = new QFilter("view", "=", (Object)15L);
            QFilter[] filterUnits = new QFilter[]{filterUnit, filterView, freezeFilter, enableFilter};
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"OrgServiceQueryImpl.getParentIdBySelfOrOrgUnitViewByLongNumber", (String)"bos_org_structure", (String)"longnumber", (QFilter[])filterUnits, (String)"");){
                if (ds.hasNext()) {
                    orgUnitLongnumber = ds.next().getString("longnumber");
                }
            }
        }
        QFilter viewFilter = viewKey instanceof String ? new QFilter("view.number", "=", viewKey) : new QFilter("view", "=", viewKey);
        if (StringUtils.isBlank((CharSequence)orgUnitLongnumber)) {
            return this.getViewRootOrgId(viewFilter);
        }
        String[] parentNumberArr = orgUnitLongnumber.split("!");
        if (parentNumberArr.length <= 1) {
            return this.getViewRootOrgId(viewFilter);
        }
        QFilter numberFilter = new QFilter("org.number", "in", (Object)parentNumberArr);
        QFilter[] filterOrgs = new QFilter[]{numberFilter, viewFilter, freezeFilter, enableFilter};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"OrgServiceQueryImpl.getSamePropertyParentIDByLongNumber", (String)"bos_org_structure", (String)"org", (QFilter[])filterOrgs, (String)"longnumber desc", (int)1);){
            if (dataSet.hasNext()) {
                lCurParentID = dataSet.next().getLong("org");
            }
        }
        if (lCurParentID == 0L) {
            return this.getViewRootOrgId(viewFilter);
        }
        return lCurParentID;
    }

    private long getViewRootOrgId(QFilter viewFilter) {
        long orgId = 0L;
        QFilter parentFilter = new QFilter("parent", "=", (Object)0L);
        QFilter levelFilter = new QFilter("level", "=", (Object)1);
        QFilter[] filters = new QFilter[]{viewFilter, parentFilter, levelFilter};
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"OrgServiceQueryImpl.getViewRootOrgId", (String)"bos_org_structure", (String)"org", (QFilter[])filters, (String)"longnumber", (int)1);){
            if (ds.hasNext()) {
                long l = ds.next().getLong("org");
                return l;
            }
        }
        return orgId;
    }

    public Map<Long, Long> getDirectSuperiorOrg(String viewSchemaNumber, List<Long> orgIds) {
        if (StringUtils.isBlank((CharSequence)viewSchemaNumber)) {
            viewSchemaNumber = "01";
        }
        QFilter viewFilter = new QFilter("view.number", "=", (Object)viewSchemaNumber);
        QFilter orgFilter = new QFilter("org", "in", orgIds);
        String selectFields = "org,parent";
        QFilter[] filters = new QFilter[]{viewFilter, orgFilter};
        Map parentStrcObjMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org_structure", (String)selectFields, (QFilter[])filters);
        if (CollectionUtils.isEmpty((Map)parentStrcObjMap)) {
            return new HashMap<Long, Long>(0);
        }
        HashMap<Long, Long> orgParentMap = new HashMap<Long, Long>(parentStrcObjMap.size());
        for (DynamicObject parentStrcObj : parentStrcObjMap.values()) {
            DynamicObject orgObj = parentStrcObj.getDynamicObject("org");
            if (orgObj == null) continue;
            Long orgId = orgObj.getLong("id");
            DynamicObject parentOrgObj = parentStrcObj.getDynamicObject("parent");
            Long parentId = 0L;
            if (parentOrgObj != null) {
                parentId = parentOrgObj.getLong("id");
            }
            orgParentMap.put(orgId, parentId);
        }
        return orgParentMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public String getOrg(long orgId, long userId, OrgQueryType queryType, List<Long> resultList) {
        OrgServiceQueryImpl.log.info(String.format("\u83b7\u53d6\u7ec4\u7ec7\u7684\u53c2\u6570\uff1a\u7ec4\u7ec7[%s] \u4eba\u5458[%s] \u67e5\u8be2\u7c7b\u578b[%s]", new Object[]{orgId, userId, queryType}));
        resultMsg = "";
        if (queryType == null) {
            resultMsg = ResManager.loadKDString((String)"\u67e5\u8be2\u7c7b\u578b\u4e3a\u7a7a\u3002", (String)"OrgServiceQueryImpl_0", (String)"bos-mservice-org", (Object[])new Object[0]);
            OrgServiceQueryImpl.log.info(resultMsg);
            return resultMsg;
        }
        if (resultList == null) {
            resultMsg = ResManager.loadKDString((String)"\u67e5\u8be2\u7ed3\u679c\u5bf9\u8c61\u4e3a\u7a7a\u3002", (String)"OrgServiceQueryImpl_1", (String)"bos-mservice-org", (Object[])new Object[0]);
            OrgServiceQueryImpl.log.info(resultMsg);
            return resultMsg;
        }
        try {
            switch (2.$SwitchMap$kd$bos$org$model$OrgQueryType[queryType.ordinal()]) {
                case 1: {
                    resultMsg = this.getAllAdminOrg(resultList, false);
                    ** break;
                }
                case 2: {
                    resultMsg = this.getAllAdminOrg(resultList, true);
                    ** break;
                }
                case 3: {
                    orgIds = new ArrayList<Long>();
                    orgIds.add(orgId);
                    resultMsg = this.getAllSuperiorOfOrg(orgIds, resultList, false);
                    ** break;
                }
                case 4: {
                    resultMsg = this.getSuperiorOfUserAllJob(userId, resultList);
                    ** break;
                }
                case 5: {
                    resultMsg = this.getSuperiorOfUserMainJob(userId, resultList);
                    ** break;
                }
                case 6: {
                    resultMsg = this.getSuperiorOfUserPartJob(userId, resultList);
                    ** break;
                }
            }
        }
        catch (Throwable var9_7) {
            if (StringUtils.isNotBlank((CharSequence)resultMsg)) {
                OrgServiceQueryImpl.log.info(String.format("\u83b7\u53d6\u7ec4\u7ec7\u5931\u8d25[%s]\uff1a%s", new Object[]{queryType, resultMsg}));
            } else {
                OrgServiceQueryImpl.log.info(String.format("\u83b7\u53d6\u7ec4\u7ec7\u6210\u529f[%s]\uff1a \u6570\u91cf[%s]", new Object[]{queryType, resultList.size()}));
            }
            throw var9_7;
        }
lbl40:
        // 7 sources

        if (StringUtils.isNotBlank((CharSequence)resultMsg)) {
            OrgServiceQueryImpl.log.info(String.format("\u83b7\u53d6\u7ec4\u7ec7\u5931\u8d25[%s]\uff1a%s", new Object[]{queryType, resultMsg}));
        } else {
            OrgServiceQueryImpl.log.info(String.format("\u83b7\u53d6\u7ec4\u7ec7\u6210\u529f[%s]\uff1a \u6570\u91cf[%s]", new Object[]{queryType, resultList.size()}));
        }
        return resultMsg;
    }

    private String getAllAdminOrg(List<Long> resultList, boolean isIncludeDisable) {
        QFilter viewFilter = OrgViewUtils.getOrgViewFilter((String)"01");
        if (!isIncludeDisable) {
            viewFilter = viewFilter.and(new QFilter(FILTER_PRO_ORG_ENABLE, "=", (Object)Boolean.TRUE));
            viewFilter = viewFilter.and(new QFilter("isfreeze", "=", (Object)Boolean.FALSE));
        }
        QFilter[] filters = new QFilter[]{viewFilter};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"OrgServiceQueryImpl.getAllAdminOrg", (String)"bos_org_structure", (String)"org", (QFilter[])filters, null);){
            for (Row row : dataSet) {
                resultList.add(row.getLong("org"));
            }
        }
        return "";
    }

    private String getAllSuperiorOfOrg(List<Long> orgIds, List<Long> resultList, boolean isIncludeSelf) {
        if (Utils.isListEmpty(orgIds)) {
            return BaseMessage.getMessage((String)"M00015", (Object[])new Object[]{ResManager.loadKDString((String)"\u7ec4\u7ec7\u5185\u7801", (String)"OrgServiceQueryImpl_2", (String)"bos-mservice-org", (Object[])new Object[0])});
        }
        if (isIncludeSelf) {
            resultList.addAll(orgIds);
        }
        orgIds.remove(0L);
        long rootId = this.getRootOrgId();
        orgIds.remove(rootId);
        if (orgIds.isEmpty()) {
            return "";
        }
        QFilter viewFilter = OrgViewUtils.getOrgViewFilter((String)"01");
        QFilter orgFilter = new QFilter("org", "in", orgIds);
        QFilter[] filters = new QFilter[]{viewFilter, orgFilter};
        DynamicObjectCollection struCol = QueryServiceHelper.query((String)"bos_org_structure", (String)"longnumber", (QFilter[])filters);
        if (Utils.isListEmpty((List)struCol)) {
            return BaseMessage.getMessage((String)String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7%1$s", (String)"OrgServiceQueryImpl_3", (String)"bos-mservice-org", (Object[])new Object[0]), "M00062"));
        }
        HashSet superiorLongnumberSet = new HashSet(struCol.size());
        for (DynamicObject struObj : struCol) {
            String longnumber = struObj.getString("longnumber");
            superiorLongnumberSet.addAll(OrgViewUtils.getAllSuperiorLongnumber((String)longnumber));
        }
        if (superiorLongnumberSet.isEmpty()) {
            return "";
        }
        QFilter longnumberFilter = null;
        for (String longnumber : superiorLongnumberSet) {
            QFilter eachFilter = new QFilter("longnumber", "=", (Object)longnumber);
            if (longnumberFilter == null) {
                longnumberFilter = eachFilter;
                continue;
            }
            longnumberFilter = longnumberFilter.or(eachFilter);
        }
        filters = new QFilter[]{viewFilter, longnumberFilter};
        struCol = QueryServiceHelper.query((String)"bos_org_structure", (String)"org", (QFilter[])filters);
        if (Utils.isListEmpty((List)struCol)) {
            return BaseMessage.getMessage((String)String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7%1$s", (String)"OrgServiceQueryImpl_3", (String)"bos-mservice-org", (Object[])new Object[0]), "M00062"));
        }
        for (DynamicObject struObj : struCol) {
            resultList.add(struObj.getLong("org"));
        }
        return "";
    }

    private String getSuperiorOfUserAllJob(long userId, List<Long> resultList) {
        String errorMsg = this.checkUserIdParam(userId);
        if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
            return errorMsg;
        }
        QFilter idFilter = new QFilter("user", "=", (Object)userId);
        QFilter[] filters = new QFilter[]{idFilter};
        return this.getSuperiorOfUser(filters, resultList);
    }

    private String getSuperiorOfUserMainJob(long userId, List<Long> resultList) {
        String errorMsg = this.checkUserIdParam(userId);
        if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
            return errorMsg;
        }
        ArrayList<Long> orgIds = new ArrayList<Long>();
        orgIds.add(UserServiceHelper.getUserMainOrgId((long)userId));
        return this.getAllSuperiorOfOrg(orgIds, resultList, true);
    }

    private String getSuperiorOfUserPartJob(long userId, List<Long> resultList) {
        String errorMsg = this.checkUserIdParam(userId);
        if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
            return errorMsg;
        }
        QFilter idFilter = new QFilter("user", "=", (Object)userId);
        QFilter partJobFilter = new QFilter("ispartjob", "=", (Object)Boolean.TRUE);
        QFilter[] filters = new QFilter[]{idFilter, partJobFilter};
        return this.getSuperiorOfUser(filters, resultList);
    }

    private String checkUserIdParam(long userId) {
        if (userId == 0L) {
            return BaseMessage.getMessage((String)"M00015", (Object[])new Object[]{ResManager.loadKDString((String)"\u4eba\u5458\u5185\u7801", (String)"OrgServiceQueryImpl_4", (String)"bos-mservice-org", (Object[])new Object[0])});
        }
        if (userId == 1L) {
            return ResManager.loadKDString((String)"\u8d85\u7ea7\u7ba1\u7406\u5458\u4e0d\u5b58\u5728\u4e0a\u7ea7\u4efb\u804c\u7ec4\u7ec7\u3002", (String)"OrgServiceQueryImpl_5", (String)"bos-mservice-org", (Object[])new Object[0]);
        }
        return "";
    }

    private String getSuperiorOfUser(QFilter[] filters, List<Long> resultList) {
        Map userPosMap = BusinessDataServiceHelper.loadFromCache((String)"bos_userposition", (String)"org", (QFilter[])filters);
        if (userPosMap == null || userPosMap.isEmpty()) {
            return ResManager.loadKDString((String)"\u67e5\u8be2\u4eba\u5458\u4efb\u804c\u90e8\u95e8\u5931\u8d25\u3002", (String)"OrgServiceQueryImpl_6", (String)"bos-mservice-org", (Object[])new Object[0]);
        }
        ArrayList<Long> orgIds = new ArrayList<Long>();
        for (Map.Entry posEntry : userPosMap.entrySet()) {
            DynamicObject orgObj = ((DynamicObject)posEntry.getValue()).getDynamicObject("org");
            if (orgObj == null) continue;
            orgIds.add(orgObj.getLong("id"));
        }
        return this.getAllSuperiorOfOrg(orgIds, resultList, true);
    }

    public List<DynamicObject> getAllData(String orgViewType, Long currentUserID, Long currentOrgID, QFilter[] filters) {
        ArrayList<DynamicObject> childrendDataList = new ArrayList<DynamicObject>();
        ORM orm = ORM.create();
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        QFilter fftreetype = new QFilter("view.treetype", "=", (Object)orgViewType);
        filterList.add(fftreetype);
        QFilter fisdefault = new QFilter("view.isdefault", "=", (Object)"1");
        filterList.add(fisdefault);
        if (filters != null && filters.length > 0) {
            for (QFilter filter : filters) {
                filterList.add(filter);
            }
        }
        QFilter[] allFilters = new QFilter[filterList.size()];
        for (int i = 0; i < filterList.size(); ++i) {
            allFilters[i] = (QFilter)filterList.get(i);
        }
        DynamicObjectCollection list = orm.query("bos_org_structure", allFilters);
        if (list != null) {
            for (DynamicObject orgView : list) {
                childrendDataList.add(orgView.getDynamicObject("org"));
            }
        }
        return childrendDataList;
    }

    @Deprecated
    public DynamicObject getTreeRootData(String orgViewType, Long currentUserID, Long currentOrgID, QFilter[] filters) {
        DynamicObject structureObj;
        DynamicObject root = null;
        Long parentid = 0L;
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        QFilter fftreetypefilter = new QFilter("view.treetype", "=", (Object)orgViewType);
        filterList.add(fftreetypefilter);
        QFilter ffparentid = new QFilter("parent", "=", (Object)parentid);
        filterList.add(ffparentid);
        QFilter fisdefault = new QFilter("view.isdefault", "=", (Object)Boolean.TRUE);
        filterList.add(fisdefault);
        if (filters != null && filters.length > 0) {
            for (QFilter filter : filters) {
                filterList.add(filter);
            }
        }
        if ((structureObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org_structure", (String)"org", (QFilter[])filterList.toArray(new QFilter[filterList.size()]))) != null) {
            root = structureObj.getDynamicObject("org");
        }
        return root;
    }

    @Deprecated
    public List<DynamicObject> getChildrenData(String orgViewType, Long currentUserID, Long currentOrgID, QFilter[] filters, Long parentID) {
        ArrayList<DynamicObject> childrendDataList = new ArrayList<DynamicObject>();
        ORM orm = ORM.create();
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        QFilter fftreetype = new QFilter("view.treetype", "=", (Object)orgViewType);
        filterList.add(fftreetype);
        QFilter ffparentid = new QFilter("parent", "=", (Object)parentID);
        filterList.add(ffparentid);
        QFilter fisdefault = new QFilter("view.isdefault", "=", (Object)"1");
        filterList.add(fisdefault);
        if (filters != null && filters.length > 0) {
            for (QFilter filter : filters) {
                filterList.add(filter);
            }
        }
        QFilter[] allFilters = new QFilter[filterList.size()];
        for (int i = 0; i < filterList.size(); ++i) {
            allFilters[i] = (QFilter)filterList.get(i);
        }
        DynamicObjectCollection list = orm.query("bos_org_structure", allFilters);
        if (list != null) {
            for (DynamicObject orgView : list) {
                childrendDataList.add(orgView.getDynamicObject("org"));
            }
        }
        return childrendDataList;
    }

    public List<Long> getAuthorizedBizOrgIds(Long userID, String orgFunction, String entityID, String permissionItem, String appId, QFilter otherFilter, String orderBy, int top) {
        return this.getAuthorizedBizOrgIds(userID, orgFunction, entityID, permissionItem, appId, otherFilter, orderBy, -1, top);
    }

    public List<Long> getAuthorizedBizOrgIds(Long userID, String orgFunction, String entityID, String permissionItem, String appId, QFilter otherFilter, String orderBy, int from, int length) {
        ArrayList<Long> orgIds = new ArrayList<Long>(128);
        try (DataSet dataSet = this.getAuthorizedBizOrgDataSet(userID, orgFunction, entityID, permissionItem, appId, otherFilter, "id", orderBy, from, length);){
            for (Row row : dataSet) {
                orgIds.add(row.getLong("id"));
            }
            log.info(String.format("\u901a\u8fc7\u53c2\u6570[userID\uff1a%s][orgFunction\uff1a%s][entityID\uff1a%s][permissionItem\uff1a%s][appId\uff1a%s][otherFilter\uff1a%s][orderBy\uff1a%s][from:%s][length\uff1a%s]\u83b7\u53d6\u5230\u7684\u4e3b\u4e1a\u52a1\u7ec4\u7ec7\u6570\u91cf\u4e3a\uff1a[%s]", userID, orgFunction, entityID, permissionItem, appId, otherFilter, orderBy, from, length, orgIds.size()));
        }
        return orgIds;
    }

    public DynamicObjectCollection getAuthorizedBizOrgs(Long userID, String orgFunction, String entityID, String permissionItem, String appId, QFilter otherFilter, String selectProperties, String orderBy, int top) {
        return this.getAuthorizedBizOrgs(userID, orgFunction, entityID, permissionItem, appId, otherFilter, selectProperties, orderBy, -1, top);
    }

    public DynamicObjectCollection getAuthorizedBizOrgs(Long userID, String orgFunction, String entityID, String permissionItem, String appId, QFilter otherFilter, String selectProperties, String orderBy, int from, int length) {
        try (DataSet dataSet = this.getAuthorizedBizOrgDataSet(userID, orgFunction, entityID, permissionItem, appId, otherFilter, selectProperties, orderBy, from, length);){
            DynamicObjectCollection dynamicObjectCollection = ORMUtil.toDynamicObjectCollection((DataSet)dataSet, (String)"bos_org");
            return dynamicObjectCollection;
        }
    }

    private DataSet getAuthorizedBizOrgDataSet(Long userID, String orgFunction, String entityID, String permissionItem, String appId, QFilter otherFilter, String selectProperties, String orderBy, int top) {
        return this.getAuthorizedBizOrgDataSet(userID, orgFunction, entityID, permissionItem, appId, otherFilter, selectProperties, orderBy, -1, top);
    }

    private DataSet getAuthorizedBizOrgDataSet(Long userID, String orgFunction, String entityID, String permissionItem, String appId, QFilter otherFilter, String selectProperties, String orderBy, int from, int length) {
        QFilter filter = null;
        if (StringUtils.isNotBlank((CharSequence)orgFunction)) {
            filter = new QFilter("structure.view.number", "=", (Object)orgFunction);
        }
        filter = this.addFilter(filter, otherFilter);
        HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAuthorizedBizOrg((Long)userID, (String)orgFunction, (String)appId, (String)entityID, (String)permissionItem);
        List hasPermOrgs = null;
        if (hasPermOrgResult == null) {
            hasPermOrgs = new ArrayList(0);
            log.info("\u83b7\u53d6\u4e3b\u4e1a\u52a1\u7ec4\u7ec7\u6743\u9650\u6b65\u9aa4\uff1a\u83b7\u53d6\u6709\u6743\u9650\u7684\u7ec4\u7ec7\u8303\u56f4\uff1a\u8fd4\u56de\u6743\u9650\u7ed3\u679c\u5bf9\u8c61\u662fnull\u3002");
        } else if (hasPermOrgResult.hasAllOrgPerm()) {
            log.info("\u83b7\u53d6\u4e3b\u4e1a\u52a1\u7ec4\u7ec7\u6743\u9650\u6b65\u9aa4\uff1a\u83b7\u53d6\u6709\u6743\u9650\u7684\u7ec4\u7ec7\u8303\u56f4\uff1a\u5168\u90e8\u7ec4\u7ec7\u3002");
        } else {
            hasPermOrgs = hasPermOrgResult.getHasPermOrgs();
            log.info(hasPermOrgs.size() + "\u83b7\u53d6\u4e3b\u4e1a\u52a1\u7ec4\u7ec7\u6743\u9650\u6b65\u9aa4\uff1a\u83b7\u53d6\u6709\u6743\u9650\u7684\u7ec4\u7ec7\u8303\u56f4\uff1a" + hasPermOrgs);
        }
        if (hasPermOrgs == null) {
            return this.getOrgDataSet(selectProperties, filter, orderBy, from, length);
        }
        int inThreshold = this.getInThreshold();
        if (inThreshold == -1 || hasPermOrgs.size() < inThreshold) {
            QFilter idFilter = new QFilter("id", "in", hasPermOrgs);
            filter = this.addFilter(filter, idFilter);
            return this.getOrgDataSet(selectProperties, filter, orderBy, from, length);
        }
        DataSet orgDataSet = this.getOrgDataSet(selectProperties, filter, orderBy, -1);
        final List finalHasPermOrgs = hasPermOrgs;
        DataSet filterDataSet = orgDataSet.filter(new FilterFunction(){

            public boolean test(Row row) {
                return finalHasPermOrgs.contains(row.getLong("id"));
            }
        });
        if (length > 0) {
            return filterDataSet.top(length);
        }
        return filterDataSet;
    }

    private int getInThreshold() {
        String inEnable = System.getProperty("orm.opt.in.enable", "false");
        if (!Boolean.parseBoolean(inEnable)) {
            return -1;
        }
        String threshold = System.getProperty("orm.opt.in.threshold");
        if (StringUtils.isBlank((CharSequence)threshold)) {
            return -1;
        }
        return Integer.parseInt(threshold);
    }

    public DynamicObject getBizOrg(Long orgID, String orgFunction) {
        if (orgID == 0L || StringUtils.isBlank((CharSequence)orgFunction)) {
            return null;
        }
        String propertyName = this.getBizOrgPropertyName(orgFunction);
        if (StringUtils.isBlank((CharSequence)propertyName)) {
            return null;
        }
        QFilter idFilter = new QFilter("id", "=", (Object)orgID);
        QFilter bizFilter = new QFilter(propertyName, "=", (Object)Boolean.TRUE);
        QFilter[] filters = new QFilter[]{idFilter, bizFilter};
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (QFilter[])filters);
    }

    public String getBizOrgPropertyName(String orgFunction) {
        if (StringUtils.isBlank((CharSequence)orgFunction)) {
            return "";
        }
        if ("15".equals(orgFunction) || "16".equals(orgFunction)) {
            return "";
        }
        String propertyname = OrgCache.getBizOrgPropertyName((String)orgFunction);
        if (StringUtils.isBlank((CharSequence)propertyname)) {
            String selectProperties = "propertyname";
            QFilter defaultFilter = new QFilter("isbasetype", "=", (Object)"1");
            QFilter numberFilter = new QFilter("fnumber", "=", (Object)orgFunction);
            QFilter[] filters = new QFilter[]{defaultFilter, numberFilter};
            DynamicObject orgBizObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org_biz", (String)selectProperties, (QFilter[])filters);
            if (orgBizObj != null) {
                propertyname = orgBizObj.getString("propertyname");
            }
            OrgCache.updateBizOrgPropertyName((String)orgFunction, (String)propertyname);
        }
        return propertyname;
    }

    public DynamicObjectCollection getOrgDutyList() {
        QFilter defaultFilter = new QFilter("isbasetype", "=", (Object)"1");
        QFilter[] filters = new QFilter[]{defaultFilter};
        DynamicObjectCollection orgBizCol = QueryServiceHelper.query((String)"bos_org_biz", (String)"id,fnumber,propertyname property", (QFilter[])filters);
        return orgBizCol;
    }

    public QFilter getBizOrgFilter(String orgFunction) {
        if (StringUtils.isBlank((CharSequence)orgFunction)) {
            log.info("[getBizOrgFilter]\u83b7\u53d6\u4e1a\u52a1\u7ec4\u7ec7\u8fc7\u6ee4\u6761\u4ef6\u65f6\uff0c\u53c2\u6570\u4e3a\u7a7a\u3002");
            return null;
        }
        String propertyname = this.getBizOrgPropertyName(orgFunction);
        if (StringUtils.isBlank((CharSequence)propertyname)) {
            return null;
        }
        return new QFilter(propertyname, "=", (Object)Boolean.TRUE);
    }

    public List<Long> getBizOrgIds(String orgFunction, QFilter otherFilter, String orderBy, int top) {
        return this.getBizOrgIds(orgFunction, otherFilter, orderBy, -1, top);
    }

    public List<Long> getBizOrgIds(String orgFunction, QFilter otherFilter, String orderBy, int from, int length) {
        ArrayList<Long> orgIds = new ArrayList<Long>(10000);
        try (DataSet dataSet = this.getBizOrgDataSet(orgFunction, otherFilter, "id", orderBy, from, length);){
            for (Row row : dataSet) {
                orgIds.add(row.getLong("id"));
            }
        }
        return orgIds;
    }

    public DynamicObjectCollection getBizOrgs(String orgFunction, QFilter otherFilter, String selectProperties, String orderBy, int top) {
        return this.getBizOrgs(orgFunction, otherFilter, selectProperties, orderBy, -1, top);
    }

    public DynamicObjectCollection getBizOrgs(String orgFunction, QFilter otherFilter, String selectProperties, String orderBy, int from, int length) {
        try (DataSet dataSet = this.getBizOrgDataSet(orgFunction, otherFilter, selectProperties, orderBy, from, length);){
            DynamicObjectCollection dynamicObjectCollection = ORMUtil.toDynamicObjectCollection((DataSet)dataSet, (String)"bos_org");
            return dynamicObjectCollection;
        }
    }

    private DataSet getBizOrgDataSet(String orgFunction, QFilter otherFilter, String selectProperties, String orderBy, int top) {
        return this.getBizOrgDataSet(orgFunction, otherFilter, selectProperties, orderBy, -1, top);
    }

    private DataSet getBizOrgDataSet(String orgFunction, QFilter otherFilter, String selectProperties, String orderBy, int from, int length) {
        QFilter orgFilter = this.getBizOrgFilter(orgFunction);
        if (orgFilter == null) {
            orgFilter = otherFilter;
        } else if (otherFilter != null) {
            orgFilter = orgFilter.and(otherFilter);
        }
        return this.getOrgDataSet(selectProperties, orgFilter, orderBy, from, length);
    }

    public List<Long> getOrgByLevel(String orgViewNumber, int level, boolean includeDisable, boolean includeFreeze) {
        if (StringUtils.isBlank((CharSequence)orgViewNumber) || level < 1) {
            return new ArrayList<Long>(0);
        }
        ArrayList<Long> filterOrgIds = new ArrayList<Long>();
        QFilter viewFilter = new QFilter("view.number", "=", (Object)orgViewNumber);
        QFilter levelFilter = new QFilter("level", "=", (Object)level);
        if (!includeDisable) {
            QFilter enableFilter = new QFilter(FILTER_PRO_ORG_ENABLE, "=", (Object)Boolean.TRUE);
            levelFilter = levelFilter.and(enableFilter);
        }
        if (!includeFreeze) {
            QFilter freezeFilter = new QFilter("isfreeze", "=", (Object)Boolean.FALSE);
            levelFilter = levelFilter.and(freezeFilter);
        }
        QFilter[] filters = new QFilter[]{viewFilter, levelFilter};
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"OrgServiceQueryImpl.getOrgByLevel", (String)"bos_org_structure", (String)"org", (QFilter[])filters, (String)"");){
            for (Row row : ds) {
                filterOrgIds.add(row.getLong("org"));
            }
        }
        return filterOrgIds;
    }

    public List<Map<String, Object>> getCorporateOrg(boolean includeDisable) {
        QFilter[] filters;
        Map orgObjMap;
        QFilter patternTypeFilter = new QFilter("orgpattern.patterntype", "in", (Object)new String[]{"1", "2"});
        if (!includeDisable) {
            patternTypeFilter = patternTypeFilter.and(new QFilter("enable", "=", (Object)Boolean.TRUE));
        }
        if (CollectionUtils.isEmpty((Map)(orgObjMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"id,number,name", (QFilter[])(filters = new QFilter[]{patternTypeFilter}))))) {
            return new ArrayList<Map<String, Object>>(0);
        }
        ArrayList<Map<String, Object>> orgList = new ArrayList<Map<String, Object>>(orgObjMap.size());
        for (DynamicObject orgObj : orgObjMap.values()) {
            HashMap<String, Object> orgMap = new HashMap<String, Object>(3);
            orgMap.put("id", orgObj.getPkValue());
            orgMap.put("number", orgObj.get("number"));
            orgMap.put("name", orgObj.get("name"));
            orgList.add(orgMap);
        }
        return orgList;
    }

    public List<Long> filterOrgDuty(List<Long> orgIds, String orgViewNumber, QFilter customOrgFilter, String orderBy, int top) {
        if (orgIds == null || orgIds.isEmpty() || top == 0) {
            return new ArrayList<Long>(0);
        }
        long viewId = this.getViewIdByNumber(orgViewNumber);
        if (viewId == 0L) {
            return new ArrayList<Long>(orgIds);
        }
        ArrayList<Long> filterOrgIds = new ArrayList<Long>(orgIds.size());
        if (customOrgFilter == null && orgIds.size() == 1) {
            QFilter orgFilter;
            QFilter viewFilter = new QFilter("view", "=", (Object)viewId);
            QFilter[] filters = new QFilter[]{viewFilter, orgFilter = new QFilter("org", "=", (Object)orgIds.get(0))};
            DynamicObject structureObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org_structure", (String)"org", (QFilter[])filters);
            if (structureObj != null) {
                filterOrgIds.add(structureObj.getLong("org_id"));
            }
        } else {
            QFilter viewFilter = new QFilter("structure.view", "=", (Object)viewId);
            viewFilter = this.addFilter(viewFilter, customOrgFilter);
            this.filterOrgDuty(orgIds, filterOrgIds, viewFilter, orderBy, top);
        }
        return filterOrgIds;
    }

    private void filterOrgDuty(List<Long> orgIds, List<Long> filterOrgIds, QFilter viewFilter, String orderBy, int top) {
        int inThreshold = this.getInThreshold();
        if (inThreshold == -1 || orgIds.size() < inThreshold) {
            QFilter orgFilter = new QFilter("id", "in", orgIds);
            viewFilter = viewFilter.and(orgFilter);
            try (DataSet orgDataSet = this.getOrgDataSet("id", viewFilter, orderBy, top);){
                for (Row row : orgDataSet) {
                    filterOrgIds.add(row.getLong("id"));
                }
            }
            return;
        }
        log.info("OrgServiceQueryImpl#filterOrgDuty orgIds size = {}", (Object)orgIds.size());
        HashSet<Long> orgIdsSet = new HashSet<Long>(orgIds);
        try (DataSet orgDataSet = this.getOrgDataSet("id", viewFilter, orderBy, -1);){
            for (Row row : orgDataSet) {
                Long id = row.getLong("id");
                if (!orgIdsSet.contains(id)) continue;
                filterOrgIds.add(id);
                if (top <= 0 || filterOrgIds.size() < top) continue;
                break;
            }
        }
        log.info("OrgServiceQueryImpl#filterOrgDuty filterOrgIds size = {}", (Object)filterOrgIds.size());
    }

    public List<Long> filterOrg(List<Long> orgIds, long viewId, boolean isFilterDisable, boolean isFilterFreeze) {
        if (orgIds == null || orgIds.isEmpty()) {
            return new ArrayList<Long>(0);
        }
        ArrayList<Long> filterOrgIds = new ArrayList<Long>(orgIds.size());
        QFilter viewFilter = new QFilter("structure.view", "=", (Object)viewId);
        QFilter orgFilter = new QFilter("id", "in", orgIds);
        if (isFilterDisable) {
            QFilter enableFilter = new QFilter("enable", "=", (Object)true);
            viewFilter.and(enableFilter);
        }
        if (isFilterFreeze) {
            QFilter freezeFilter = new QFilter("structure.isfreeze", "=", (Object)false);
            viewFilter.and(freezeFilter);
        }
        try (DataSet orgDataSet = this.getOrgDataSet("id", viewFilter.and(orgFilter), "", -1);){
            for (Row row : orgDataSet) {
                filterOrgIds.add(row.getLong("id"));
            }
        }
        return filterOrgIds;
    }

    private QFilter addFilter(QFilter srcFilter, QFilter addFilter) {
        if (srcFilter == null) {
            srcFilter = addFilter;
        } else if (addFilter != null) {
            srcFilter = srcFilter.and(addFilter);
        }
        return srcFilter;
    }

    private DataSet getOrgDataSet(String selectFields, QFilter filter, String orderBy, int top) {
        return this.getOrgDataSet(selectFields, filter, orderBy, -1, top);
    }

    private DataSet getOrgDataSet(String selectFields, QFilter filter, String orderBy, int from, int length) {
        if (StringUtils.isBlank((CharSequence)selectFields)) {
            selectFields = "id";
        }
        QFilter[] filters = new QFilter[]{filter};
        if (StringUtils.isBlank((CharSequence)orderBy)) {
            orderBy = OrgUtils.getOrgSortFields();
        }
        ORM orm = ORM.create();
        if (from == -1) {
            return orm.queryDataSet("OrgServiceQueryImpl.getOrgDataSet", "bos_org", selectFields, filters, orderBy, length);
        }
        return orm.queryDataSet("OrgServiceQueryImpl.getOrgDataSet", "bos_org", selectFields, filters, orderBy, from, length);
    }

    public Map<Long, Map<String, Object>> getOrgByPattern(Object viewIDOrNumber, Collection orgIds, boolean isByPatternType, List<Object> patternOrPatternTypes) {
        log.info(String.format("\u6839\u636e\u7ec4\u7ec7\u5f62\u6001\u6216\u8005\u7ec4\u7ec7\u5f62\u6001\u7c7b\u578b\u83b7\u53d6\u6240\u5c5e\u7ec4\u7ec7\uff0c\u53c2\u6570\u4e3a\uff1aviewIDOrNumber\u3010%s\u3011orgIds\u3010%s\u3011isByPatternType\u3010%s\u3011patternOrPatternTypes\u3010%s\u3011", viewIDOrNumber, orgIds, isByPatternType, patternOrPatternTypes));
        if (CollectionUtils.isEmpty((Collection)orgIds) || CollectionUtils.isEmpty(patternOrPatternTypes)) {
            return new HashMap<Long, Map<String, Object>>(0);
        }
        int count = orgIds.size();
        HashSet<String> numbers = new HashSet<String>(count);
        HashMap<Long, String> orgLongNumberMap = new HashMap<Long, String>(count);
        this.getOrgNumberAndLongNumber(viewIDOrNumber, orgIds, numbers, orgLongNumberMap);
        if (CollectionUtils.isEmpty(numbers)) {
            return new HashMap<Long, Map<String, Object>>(0);
        }
        Map<String, Map<String, Object>> numberOrgInfoMap = this.getOrgNumberBelongToOrgInfoMap(numbers, isByPatternType, patternOrPatternTypes);
        if (CollectionUtils.isEmpty(numberOrgInfoMap)) {
            return new HashMap<Long, Map<String, Object>>(0);
        }
        HashMap<Long, Map<String, Object>> belongToOrgInfoMap = new HashMap<Long, Map<String, Object>>(count);
        for (Map.Entry orgEntry : orgLongNumberMap.entrySet()) {
            String[] numberArr = ((String)orgEntry.getValue()).split("!");
            Map<String, Object> orgInfoMap = null;
            for (int i = numberArr.length - 1; i >= 0 && (orgInfoMap = numberOrgInfoMap.get(numberArr[i])) == null; --i) {
            }
            if (orgInfoMap == null) continue;
            belongToOrgInfoMap.put((Long)orgEntry.getKey(), orgInfoMap);
        }
        log.info("\u6839\u636e\u7ec4\u7ec7\u5f62\u6001\u6216\u8005\u7ec4\u7ec7\u5f62\u6001\u7c7b\u578b\u83b7\u53d6\u6240\u5c5e\u7ec4\u7ec7\uff0c\u7ed3\u679c\u4e3a\uff1a" + belongToOrgInfoMap);
        return belongToOrgInfoMap;
    }

    private void getOrgNumberAndLongNumber(Object viewIDOrNumber, Collection orgIds, Set<String> numbers, Map<Long, String> orgLongNumberMap) {
        QFilter viewFilter = StringUtils.isBlank((Object)viewIDOrNumber) ? new QFilter("view", "=", (Object)1L) : (viewIDOrNumber instanceof Long ? new QFilter("view", "=", viewIDOrNumber) : new QFilter("view.number", "=", viewIDOrNumber));
        String selectFields = "org,longnumber";
        QFilter orgFilter = new QFilter("org", "in", (Object)orgIds);
        QFilter[] filters = new QFilter[]{viewFilter, orgFilter};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"OrgServiceQueryImpl.getOrgNumberAndLongNumber", (String)"bos_org_structure", (String)selectFields, (QFilter[])filters, (String)"");){
            for (Row row : dataSet) {
                String[] numberArr;
                String longNumber = row.getString("longnumber");
                if (StringUtils.isBlank((CharSequence)longNumber)) continue;
                orgLongNumberMap.put(row.getLong("org"), longNumber);
                for (String number : numberArr = longNumber.split("!")) {
                    numbers.add(number);
                }
            }
        }
    }

    private Map<String, Map<String, Object>> getOrgNumberBelongToOrgInfoMap(Set<String> numbers, boolean isByPatternType, List<Object> patternOrPatternTypes) {
        HashMap<String, Map<String, Object>> numberOrgMap = new HashMap<String, Map<String, Object>>(numbers.size());
        String selectFields = "id,number,name,uniformsocialcreditcode,ffirmname firmname,faddress address,frepresentative representative,depositbank,bankaccount,ftaxregnum taxregnum,taxpayertype";
        QFilter numberFilter = new QFilter("number", "in", numbers);
        if (isByPatternType) {
            numberFilter = numberFilter.and(new QFilter("orgpattern.patterntype", "in", patternOrPatternTypes));
        } else {
            ArrayList<Long> patternIds = new ArrayList<Long>(patternOrPatternTypes.size());
            for (Object patternId : patternOrPatternTypes) {
                patternIds.add(Long.valueOf(patternId.toString()));
            }
            numberFilter = numberFilter.and(new QFilter("orgpattern", "in", patternIds));
        }
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter[] filters = new QFilter[]{numberFilter, enableFilter};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"OrgServiceQueryImpl.getOrgNumberBelongToOrgInfoMap", (String)"bos_org", (String)selectFields, (QFilter[])filters, (String)"");){
            for (Row row : dataSet) {
                numberOrgMap.put(row.getString("number"), this.genBelongToOrgInfo(row));
            }
        }
        return numberOrgMap;
    }

    private Map<String, Object> genBelongToOrgInfo(Row orgInfo) {
        HashMap<String, Object> returnOrgInfo = new HashMap<String, Object>(16);
        returnOrgInfo.put("id", orgInfo.get("id"));
        returnOrgInfo.put("number", orgInfo.get("number"));
        returnOrgInfo.put("name", orgInfo.get("name"));
        returnOrgInfo.put("uniformsocialcreditcode", orgInfo.get("uniformsocialcreditcode"));
        returnOrgInfo.put("firmname", orgInfo.get("firmname"));
        returnOrgInfo.put("address", orgInfo.get("address"));
        returnOrgInfo.put("representative", orgInfo.get("representative"));
        returnOrgInfo.put("depositbank", orgInfo.get("depositbank"));
        returnOrgInfo.put("bankaccount", orgInfo.get("bankaccount"));
        returnOrgInfo.put("taxregnum", orgInfo.get("taxregnum"));
        returnOrgInfo.put("taxpayertype", orgInfo.get("taxpayertype"));
        return returnOrgInfo;
    }

    public Map<Long, Map<String, Object>> getAccountingBizUnit(long viewId, List<Long> orgIds, boolean isBizUnit, boolean isSearchUpward) {
        log.info(String.format("\u83b7\u53d6\u7ec4\u7ec7\u7684\u6838\u7b97\u4e3b\u4f53\u53c2\u6570\u4e3a\uff1a[\u89c6\u56feID-viewId]%s[\u7ec4\u7ec7ID-orgIds]%s[\u662f\u5426\u53ea\u67e5\u8be2\u4e1a\u52a1\u5b9e\u4f53-isBizUnit]%s[\u662f\u5426\u627e\u4e0a\u7ea7-isSearchUpward]%s", viewId, orgIds, isBizUnit, isSearchUpward));
        HashMap<Long, Map<String, Object>> bizUnitMap = new HashMap<Long, Map<String, Object>>(4);
        if (CollectionUtils.isEmpty(orgIds)) {
            return bizUnitMap;
        }
        ArrayList<Long> tempOrgIds = new ArrayList<Long>(orgIds);
        if (1L == viewId) {
            bizUnitMap.putAll(this.getAccountingBizUnitByRelation(tempOrgIds, isBizUnit));
            tempOrgIds.removeAll(bizUnitMap.keySet());
            if (tempOrgIds.isEmpty()) {
                return bizUnitMap;
            }
        }
        HashMap<Long, Map<String, DynamicObject>> viewOrgNumberObjMap = new HashMap<Long, Map<String, DynamicObject>>(2);
        QFilter idFilter = new QFilter("id", "in", tempOrgIds);
        this.getAccountingBizUnitOrg(idFilter, viewId, viewOrgNumberObjMap, isBizUnit);
        if (viewOrgNumberObjMap.isEmpty()) {
            return bizUnitMap;
        }
        Map accOrgNumberObjMap = (Map)viewOrgNumberObjMap.get(10L);
        if (!CollectionUtils.isEmpty((Map)accOrgNumberObjMap)) {
            for (Map.Entry entry : accOrgNumberObjMap.entrySet()) {
                long orgId;
                DynamicObject structureObj = (DynamicObject)entry.getValue();
                DynamicObject orgObj = structureObj.getDynamicObject("vieworg");
                if (orgObj == null || !tempOrgIds.remove(orgId = orgObj.getLong("id"))) continue;
                this.generateAccountingBizUnit(bizUnitMap, orgId, orgObj);
            }
            if (tempOrgIds.isEmpty()) {
                return bizUnitMap;
            }
        }
        if (isSearchUpward) {
            this.getAccountingBizUnit(viewId, tempOrgIds, isBizUnit, bizUnitMap, viewOrgNumberObjMap);
        }
        return bizUnitMap;
    }

    private void getAccountingBizUnit(long viewId, List<Long> orgIds, boolean isBizUnit, Map<Long, Map<String, Object>> bizUnitMap, Map<Long, Map<String, DynamicObject>> viewOrgNumberObjMap) {
        Map<String, DynamicObject> srcOrgNumberObjMap = viewOrgNumberObjMap.get(viewId);
        if (CollectionUtils.isEmpty(srcOrgNumberObjMap)) {
            log.info("\u83b7\u53d6\u4e1a\u52a1\u7ec4\u7ec7\u7684\u6838\u7b97\u4e3b\u4f53\u5931\u8d25\uff0c\u4e1a\u52a1\u5355\u5143\u4e0d\u5b58\u5728\uff1a" + viewId);
            return;
        }
        HashSet<String> numbers = new HashSet<String>(orgIds.size());
        HashMap orgNumberMap = new HashMap(orgIds.size());
        for (Map.Entry<String, DynamicObject> entry : srcOrgNumberObjMap.entrySet()) {
            long orgId;
            DynamicObject structureObj = entry.getValue();
            DynamicObject orgObj = structureObj.getDynamicObject("vieworg");
            if (orgObj == null || bizUnitMap.containsKey(orgId = orgObj.getLong("id"))) continue;
            String[] numberArr = structureObj.getString("longnumber").split("!");
            HashMap<String, Object> orgMap = new HashMap<String, Object>(2);
            orgMap.put("id", orgId);
            orgMap.put("number", numberArr);
            orgNumberMap.put(entry.getKey(), orgMap);
            numbers.addAll(Arrays.asList(numberArr));
        }
        viewOrgNumberObjMap = new HashMap<Long, Map<String, DynamicObject>>(2);
        QFilter numberFilter = new QFilter("number", "in", numbers);
        this.getAccountingBizUnitOrg(numberFilter, viewId, viewOrgNumberObjMap, isBizUnit);
        if (CollectionUtils.isEmpty(viewOrgNumberObjMap)) {
            return;
        }
        Map<String, DynamicObject> numberAccountingObjMap = viewOrgNumberObjMap.get(10L);
        if (CollectionUtils.isEmpty(numberAccountingObjMap)) {
            return;
        }
        for (Map.Entry entry : orgNumberMap.entrySet()) {
            long orgId;
            DynamicObject structureObj;
            Map orgMap = (Map)entry.getValue();
            String[] numberArr = (String[])orgMap.get("number");
            for (int i = numberArr.length - 1; !(i < 0 || (structureObj = numberAccountingObjMap.get(numberArr[i])) != null && this.generateAccountingBizUnit(bizUnitMap, orgId = ((Long)orgMap.get("id")).longValue(), structureObj.getDynamicObject("vieworg"))); --i) {
            }
        }
    }

    private Map<Long, Map<String, Object>> getAccountingBizUnitByRelation(List<Long> orgIds, boolean isBizUnit) {
        Map<Long, Set<Long>> adminOrgRelationMap = new OrgRelationService().getAdminOrgRelationMap(orgIds, false);
        if (CollectionUtils.isEmpty(adminOrgRelationMap)) {
            return new HashMap<Long, Map<String, Object>>(0);
        }
        HashSet relationOrgList = new HashSet(adminOrgRelationMap.size());
        for (Map.Entry<Long, Set<Long>> entry : adminOrgRelationMap.entrySet()) {
            relationOrgList.addAll(entry.getValue());
        }
        Map<Long, Map<String, Object>> accountingBizUnit = this.getAccountingBizUnit(15L, new ArrayList<Long>(relationOrgList), isBizUnit, false);
        if (CollectionUtils.isEmpty(accountingBizUnit)) {
            return accountingBizUnit;
        }
        HashMap<Long, Map<String, Object>> adminAccountingBizUnitMap = new HashMap<Long, Map<String, Object>>(accountingBizUnit.size());
        block1: for (Map.Entry<Long, Set<Long>> entry : adminOrgRelationMap.entrySet()) {
            for (Long orgUnitId : entry.getValue()) {
                Map<String, Object> bizUnitMap = accountingBizUnit.get(orgUnitId);
                if (bizUnitMap == null) continue;
                adminAccountingBizUnitMap.put(entry.getKey(), bizUnitMap);
                continue block1;
            }
        }
        return adminAccountingBizUnitMap;
    }

    private void getAccountingBizUnitOrg(QFilter filter, long baseViewId, Map<Long, Map<String, DynamicObject>> viewOrgNumberObjMap, boolean isBizUnit) {
        String selectFields = "id,number,structure,structure.view,structure.vieworg,structure.longnumber,structure.isbizunit";
        QFilter[] filters = new QFilter[]{filter};
        Map orgObjMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)selectFields, (QFilter[])filters);
        if (CollectionUtils.isEmpty((Map)orgObjMap)) {
            log.info("\u83b7\u53d6\u4e1a\u52a1\u7ec4\u7ec7\u7684\u6838\u7b97\u4e3b\u4f53\u5931\u8d25\uff0c\u7ec4\u7ec7\u4e0d\u5b58\u5728\uff1a" + filter);
            return;
        }
        HashMap<String, DynamicObject> numberAccStructureMap = new HashMap<String, DynamicObject>();
        viewOrgNumberObjMap.put(10L, numberAccStructureMap);
        HashMap<String, DynamicObject> numberBaseStructureMap = new HashMap<String, DynamicObject>();
        viewOrgNumberObjMap.put(baseViewId, numberBaseStructureMap);
        block0: for (Map.Entry entry : orgObjMap.entrySet()) {
            DynamicObject orgObj = (DynamicObject)entry.getValue();
            String number = orgObj.getString("number");
            DynamicObjectCollection structureObjCol = orgObj.getDynamicObjectCollection("structure");
            DynamicObject accountingObj = null;
            DynamicObject baseViewObj = null;
            for (DynamicObject structureObj : structureObjCol) {
                DynamicObject viewObj = structureObj.getDynamicObject("view");
                if (viewObj == null) continue;
                long viewId = viewObj.getLong("id");
                if (10L == viewId) {
                    accountingObj = structureObj;
                    if (structureObj.getBoolean("isbizunit") || !isBizUnit) {
                        numberAccStructureMap.put(number, structureObj);
                    }
                } else if (baseViewId == viewId) {
                    baseViewObj = structureObj;
                    numberBaseStructureMap.put(number, structureObj);
                }
                if (accountingObj == null || baseViewObj == null) continue;
                continue block0;
            }
        }
    }

    private boolean generateAccountingBizUnit(Map<Long, Map<String, Object>> mpCompanyMap, long orgId, DynamicObject companyOrgObj) {
        if (companyOrgObj == null) {
            return false;
        }
        if (!mpCompanyMap.containsKey(orgId)) {
            HashMap<String, Object> mpCompany = new HashMap<String, Object>(4);
            mpCompany.put("id", companyOrgObj.getPkValue());
            mpCompany.put("number", companyOrgObj.get("number"));
            mpCompany.put("name", companyOrgObj.getString("name"));
            mpCompanyMap.put(orgId, mpCompany);
        }
        return true;
    }

    public Map<Long, Long> getHandoverOrgIds(long bizId, List<Long> orgIds) {
        QFilter orgFilter;
        QFilter bizFilter = new QFilter("biz", "=", (Object)bizId);
        QFilter[] filters = new QFilter[]{bizFilter, orgFilter = new QFilter("org", "in", orgIds)};
        Map objMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org_handover", (String)"org,handoverorg", (QFilter[])filters);
        if (objMap == null || objMap.isEmpty()) {
            return new HashMap<Long, Long>(0);
        }
        HashMap<Long, Long> handoverOrgMap = new HashMap<Long, Long>(objMap.size());
        for (Map.Entry entry : objMap.entrySet()) {
            DynamicObject obj = (DynamicObject)entry.getValue();
            handoverOrgMap.put(obj.getLong("org_id"), obj.getLong("handoverorg_id"));
        }
        return handoverOrgMap;
    }

    public int getYzjConfigSyncMode() {
        IYzjUserService yzjUserService = YzjServiceFactory.getUserService();
        YzjConfig yzjConfig = yzjUserService.getConfig();
        if (yzjConfig != null) {
            return yzjConfig.getSyncMode();
        }
        return 0;
    }
}

