/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.service.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.utils.OrgCheckerUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public abstract class AbstractOrgCheckerExecutor {
    protected static final Log log = LogFactory.getLog(AbstractOrgCheckerExecutor.class);
    protected static final String ENTITY_BOS_ORG_CHECKERREGISTER = "bos_org_checkerregister";
    protected static final String FIELD_APP = "app";
    protected static final String FIELD_SERVICE_FACTORY = "servicefactory";
    protected static final String FIELD_SERVICE_NAME = "servicename";
    protected static final String CHECKER_METHOD = "CHECKER_METHOD";
    protected static final String BATCH_CHECKER_METHOD = "BATCH_CHECKER_METHOD";
    protected static final String OPERATION_DELETE_DUTY = "deleteduty";
    protected static final String OPERATION_FREEZE = "freeze";

    public abstract String check();

    protected String invokeCheckerService(OrgCheckerParam param) {
        Map<String, Object> paramMap = param.getParamMap();
        ArrayList<String> viewNumberList = new ArrayList<String>(64);
        Object viewNumberParam = paramMap.get("view");
        if (viewNumberParam instanceof String) {
            viewNumberList.add(viewNumberParam.toString());
        } else if (viewNumberParam instanceof List) {
            viewNumberList = (List)viewNumberParam;
        }
        long orgId = (Long)paramMap.get("org");
        ArrayList<Long> orgIds = new ArrayList<Long>(1);
        orgIds.add(orgId);
        Map orgViewErrorMap = OrgCheckerUtils.execute((String)param.getOperation(), orgIds, AbstractOrgCheckerExecutor.getViewId(viewNumberList), null);
        StringBuilder errors = new StringBuilder();
        OrgCheckerUtils.mergeResult(null, (Map)orgViewErrorMap, params -> {
            errors.append(params[0]);
            return null;
        });
        return errors.toString();
    }

    private static List<Long> getViewId(List<String> viewNumbers) {
        if (CollectionUtils.isEmpty(viewNumbers)) {
            return new ArrayList<Long>(0);
        }
        ArrayList<Long> viewIds = new ArrayList<Long>(viewNumbers.size());
        QFilter[] filters = new QFilter[]{new QFilter("number", "in", viewNumbers)};
        Map viewObjMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org_viewschema", (QFilter[])filters);
        for (Map.Entry entry : viewObjMap.entrySet()) {
            DynamicObject viewObj = (DynamicObject)entry.getValue();
            viewIds.add(viewObj.getLong("id"));
        }
        return viewIds;
    }

    protected static class OrgCheckerParam {
        private String operation;
        private Map<String, Object> paramMap = new HashMap<String, Object>();

        protected OrgCheckerParam() {
        }

        public String getOperation() {
            return this.operation;
        }

        public void setOperation(String operation) {
            this.operation = operation;
        }

        public Map<String, Object> getParamMap() {
            return this.paramMap;
        }

        public void setParamMap(Map<String, Object> paramMap) {
            this.paramMap = paramMap;
        }
    }
}

