/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.service.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.history.OrgHistoryUtils;
import kd.bos.org.manager.CacheManager;
import kd.bos.org.model.OrgDuty;
import kd.bos.org.model.OrgEntity;
import kd.bos.org.model.OrgParam;
import kd.bos.org.service.impl.OrgFreezeService;
import kd.bos.org.utils.OrgUtils;
import kd.bos.org.utils.OrgViewUtils;
import kd.bos.org.utils.Utils;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class OrgManagerUtils {
    private static final Log log = LogFactory.getLog(OrgManagerUtils.class);

    public static void genOrgUnit(DynamicObject orgUnitObj, Map<String, Object> propertyMap) {
        if (orgUnitObj == null || propertyMap == null || propertyMap.isEmpty()) {
            return;
        }
        boolean isAddnew = false;
        Object idObj = propertyMap.get("id");
        if (idObj == null || "0".equals(idObj.toString())) {
            isAddnew = true;
            Object customOrgId = propertyMap.get("customOrgId");
            long id = 0L;
            if (customOrgId != null) {
                id = (Long)customOrgId;
            }
            if (id == 0L) {
                id = ORM.create().genLongId("bos_org");
            }
            orgUnitObj.set("id", (Object)id);
            orgUnitObj.set("masterid", (Object)id);
            propertyMap.put("id", id);
        }
        for (Map.Entry<String, Object> entry : propertyMap.entrySet()) {
            String propertyKey = entry.getKey();
            if ("id".equals(propertyKey) || "masterid".equals(propertyKey) || "customOrgId".equals(propertyKey)) continue;
            orgUnitObj.set(propertyKey, entry.getValue());
        }
        OrgManagerUtils.genCommonField(orgUnitObj, isAddnew);
    }

    public static DynamicObject genOrgStructure(DynamicObject orgStru, Map<String, Object> propertyMap) {
        boolean isAddnew = false;
        if (orgStru == null) {
            isAddnew = true;
            orgStru = BusinessDataServiceHelper.newDynamicObject((String)"bos_org_structure");
            long id = ORM.create().genLongId("bos_org_structure");
            orgStru.set("id", (Object)id);
            orgStru.set("masterid", (Object)id);
            if (propertyMap != null) {
                propertyMap.put("id", id);
            }
        }
        OrgManagerUtils.genCommonField(orgStru, isAddnew);
        if (propertyMap == null || propertyMap.isEmpty()) {
            return orgStru;
        }
        for (Map.Entry<String, Object> entry : propertyMap.entrySet()) {
            String propertyKey = entry.getKey();
            if ("id".equals(propertyKey) || "masterid".equals(propertyKey) || "customOrgId".equals(propertyKey)) continue;
            orgStru.set(propertyKey, entry.getValue());
        }
        return orgStru;
    }

    public static void genCommonField(DynamicObject obj) {
        if (obj == null) {
            return;
        }
        OrgManagerUtils.genCommonField(obj, true);
    }

    public static void genCommonField(DynamicObject obj, boolean isAddnew) {
        if (obj == null) {
            return;
        }
        String userId = RequestContext.get().getUserId();
        Date dateTime = new Date();
        if (isAddnew) {
            obj.set("creator", (Object)userId);
            obj.set("createtime", (Object)dateTime);
            obj.set("enable", (Object)1);
            obj.set("status", (Object)"C");
        }
        obj.set("modifier", (Object)userId);
        obj.set("modifytime", (Object)dateTime);
    }

    public static void genOrgCommonField(DynamicObject obj, boolean isAddnew) {
        if (obj == null) {
            return;
        }
        String userId = RequestContext.get().getUserId();
        Date dateTime = new Date();
        if (isAddnew) {
            obj.set("creator", (Object)userId);
            obj.set("createtime", (Object)dateTime);
            obj.set("enable", (Object)1);
            obj.set("status", (Object)"C");
            obj.set("startdate", (Object)Utils.getDate((int)0));
            obj.set("enddate", (Object)Utils.getEndDate());
        }
        obj.set("modifier", (Object)userId);
        obj.set("modifytime", (Object)dateTime);
    }

    public static String getOrgNumber(String srcNumber) {
        return OrgManagerUtils.getOrgNumber(srcNumber, false);
    }

    public static String getOrgNumber(String srcNumber, boolean isAdminOrg) {
        if (StringUtils.isBlank((CharSequence)srcNumber)) {
            ICodeRuleService codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
            if (codeRuleService == null) {
                codeRuleService = (ICodeRuleService)TypesContainer.createInstance((String)"kd.bos.coderule.service.CodeRuleServiceImp");
            }
            if (isAdminOrg) {
                DynamicObject orgObj = BusinessDataServiceHelper.newDynamicObject((String)"bos_adminorg");
                srcNumber = codeRuleService.getNumber("bos_adminorg", orgObj, null);
                if (StringUtils.isBlank((CharSequence)srcNumber)) {
                    orgObj = BusinessDataServiceHelper.newDynamicObject((String)"bos_org");
                    srcNumber = codeRuleService.getNumber("bos_org", orgObj, null);
                }
            } else {
                DynamicObject orgObj = BusinessDataServiceHelper.newDynamicObject((String)"bos_org");
                srcNumber = codeRuleService.getNumber("bos_org", orgObj, null);
            }
            if (StringUtils.isBlank((CharSequence)srcNumber)) {
                srcNumber = String.valueOf(System.currentTimeMillis());
            }
        }
        return srcNumber;
    }

    public static String getOrgSelectFields() {
        StringBuilder selectFields = new StringBuilder();
        selectFields.append("id,view,view.number duty,org,org.name name,org.number number");
        selectFields.append(",org.fyzjorgid yzjorgid,parent,yzjparentorgid,org.fiscontrolunit isctrlunit");
        selectFields.append(",isleaf,level,longnumber,fullname,isfreeze,sortcode,sortnumber,isbizunit");
        return selectFields.toString();
    }

    public static String getOrgStrucSelectFields() {
        StringBuilder selectFields = new StringBuilder();
        selectFields.append("id,view,org,yzjorgid,parent,yzjparentorgid,isctrlunit");
        selectFields.append(",isstatsum,isleaf,level,longnumber,fullname,isfreeze,sortcode,sortnumber,isbizunit");
        selectFields.append(",creator,createtime,enable,status,modifier,modifytime");
        return selectFields.toString();
    }

    public static DynamicObject getOrgUnitByFullname(String fullname) {
        if (StringUtils.isBlank((CharSequence)fullname)) {
            return null;
        }
        String selectFields = OrgManagerUtils.getOrgSelectFields();
        QFilter viewFilter = OrgViewUtils.getOrgViewFilter((String)"15");
        QFilter fullnameFilter = new QFilter("fullname", "=", (Object)fullname);
        QFilter[] filters = new QFilter[]{viewFilter, fullnameFilter};
        DynamicObject orgUnit = QueryServiceHelper.queryOne((String)"bos_org_structure", (String)selectFields, (QFilter[])filters);
        return orgUnit;
    }

    public static void updateOrgEnable(List<Long> orgIds, boolean isEnable) {
        if (Utils.isListEmpty(orgIds)) {
            return;
        }
        String selectFields = "id,enable,disabler,disabledate";
        QFilter idFilter = new QFilter("id", "in", orgIds);
        QFilter[] filters = new QFilter[]{idFilter};
        DynamicObject[] updateOrgArr = BusinessDataServiceHelper.load((String)"bos_org", (String)selectFields, (QFilter[])filters);
        if (updateOrgArr == null || updateOrgArr.length == 0) {
            return;
        }
        long currUserId = RequestContext.get().getCurrUserId();
        Date date = new Date();
        for (DynamicObject updateOrg : updateOrgArr) {
            if (isEnable) {
                updateOrg.set("enable", (Object)"1");
                updateOrg.set("disabler", (Object)0L);
                updateOrg.set("disabledate", null);
                continue;
            }
            updateOrg.set("enable", (Object)"0");
            updateOrg.set("disabler", (Object)currUserId);
            updateOrg.set("disabledate", (Object)date);
        }
        SaveServiceHelper.save((DynamicObject[])updateOrgArr);
        CacheManager.removeCacheByPrimaryKey((String)"bos_org", (Object[])new Object[]{orgIds});
    }

    public static boolean freezeOrg(List<Long> orgIds, List<String> errorMsg) {
        return OrgManagerUtils.freezeOrg(orgIds, errorMsg, true);
    }

    @Deprecated
    public static boolean freezeOrg(List<Long> orgIds, List<String> errorMsg, boolean isYzjSync) {
        if (Utils.isListEmpty(orgIds)) {
            log.debug("\u5c01\u5b58\u7ec4\u7ec7ID\u5217\u8868\u4e3a\u7a7a\u3002");
            return true;
        }
        ArrayList<OrgParam> orgParamList = new ArrayList<OrgParam>(orgIds.size());
        for (long orgId : orgIds) {
            OrgParam orgParam = new OrgParam();
            orgParam.setId(orgId);
            orgParam.setDuty("01");
            orgParam.setYzjSync(isYzjSync);
            orgParamList.add(orgParam);
        }
        OrgFreezeService freezeService = new OrgFreezeService(orgParamList);
        freezeService.freeze();
        if (errorMsg != null) {
            for (OrgParam orgParam : orgParamList) {
                if (orgParam.isSuccess()) continue;
                errorMsg.add(orgParam.getMsg());
            }
        }
        return true;
    }

    @Deprecated
    public static String unFreeze(List<Long> orgIds) {
        if (Utils.isListEmpty(orgIds)) {
            log.debug("\u5c01\u5b58\u7ec4\u7ec7ID\u5217\u8868\u4e3a\u7a7a\u3002");
            return "";
        }
        ArrayList<OrgParam> orgParamList = new ArrayList<OrgParam>(orgIds.size());
        for (long orgId : orgIds) {
            OrgParam orgParam = new OrgParam();
            orgParam.setId(orgId);
            orgParam.setDuty("01");
            orgParam.setYzjSync(true);
            orgParamList.add(orgParam);
        }
        OrgFreezeService freezeService = new OrgFreezeService(orgParamList);
        freezeService.unFreeze();
        for (OrgParam orgParam : orgParamList) {
            if (orgParam.isSuccess()) continue;
            return orgParam.getMsg();
        }
        return "";
    }

    public static Map<String, OrgDuty> getAllDuty() {
        Map<String, OrgDuty> viewMap = OrgManagerUtils.getAllViewSchema();
        List dutyCol = OrgUtils.getAllOrgBizNameList();
        if (Utils.isListNotEmpty((List)dutyCol)) {
            for (DynamicObject duty : dutyCol) {
                String number = duty.getString("fnumber");
                OrgDuty orgDuty = viewMap.get(number);
                if (orgDuty == null) continue;
                orgDuty.setFieldName(duty.getString("ffieldname"));
                orgDuty.setPropertyName(duty.getString("propertyname"));
                orgDuty.setUserDefine(duty.getBoolean("fuserdefine"));
            }
        }
        return viewMap;
    }

    public static Map<String, OrgDuty> getAllViewSchema() {
        String selectFields = "id,number,name,treetype,isdefault,enable";
        DynamicObjectCollection viewCol = QueryServiceHelper.query((String)"bos_org_viewschema", (String)selectFields, null);
        if (Utils.isListEmpty((List)viewCol)) {
            return new HashMap<String, OrgDuty>(0);
        }
        HashMap<String, OrgDuty> viewMap = new HashMap<String, OrgDuty>(viewCol.size());
        for (DynamicObject duty : viewCol) {
            String number = duty.getString("number");
            OrgDuty orgDuty = new OrgDuty();
            orgDuty.setId(duty.getLong("id"));
            orgDuty.setNumber(number);
            orgDuty.setTreeType(duty.getString("treetype"));
            orgDuty.setName(duty.getString("name"));
            orgDuty.setDefault(duty.getBoolean("isdefault"));
            orgDuty.setEnable(duty.getBoolean("enable"));
            viewMap.put(number, orgDuty);
        }
        return viewMap;
    }

    public static void updateOrgDuty(OrgEntity orgEntity, boolean isChecked) {
        if (orgEntity == null) {
            return;
        }
        String propertyName = orgEntity.getDuty().getPropertyName();
        if (StringUtils.isBlank((CharSequence)propertyName)) {
            return;
        }
        DynamicObject orgUnitObj = BusinessDataServiceHelper.newDynamicObject((String)"bos_org");
        DynamicObject[] orgUnitArr = (DynamicObject[])BusinessDataServiceHelper.load((Object[])new Object[]{orgEntity.getId()}, (IDataEntityType)orgUnitObj.getDataEntityType());
        if (orgUnitArr == null || orgUnitArr.length == 0) {
            return;
        }
        for (DynamicObject orgUnit : orgUnitArr) {
            orgUnit.set(propertyName, (Object)isChecked);
        }
        SaveServiceHelper.save((DynamicObject[])orgUnitArr);
        CacheManager.removeCache((String)"bos_org");
    }

    public static void deleteOrgStructure(List<OrgEntity> orgEntityList) {
        if (Utils.isListEmpty(orgEntityList)) {
            return;
        }
        QFilter filter = null;
        for (OrgEntity orgEntity : orgEntityList) {
            OrgDuty orgDuty = orgEntity.getDuty();
            QFilter viewFilter = new QFilter("view", "=", (Object)orgDuty.getId());
            QFilter orgFilter = new QFilter("org", "=", (Object)orgEntity.getId());
            viewFilter.and(orgFilter);
            if (filter == null) {
                filter = viewFilter;
                continue;
            }
            filter = filter.or(viewFilter);
        }
        QFilter[] filters = new QFilter[]{filter};
        DeleteServiceHelper.delete((String)"bos_org_structure", (QFilter[])filters);
        CacheManager.removeCache((String)"bos_org_structure");
    }

    public static void saveHistory(long orgId) {
        OrgManagerUtils.saveHistory(Collections.singletonList(orgId));
    }

    public static void saveHistory(List<Long> orgIds) {
        OrgManagerUtils.saveHistory(null, orgIds);
    }

    public static void saveHistory(String orgViewNumber, List<Long> orgIds) {
        if (Utils.isListEmpty(orgIds)) {
            return;
        }
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                OrgHistoryUtils.saveOrgHistory(orgIds);
                OrgManagerUtils.removeOrgCache();
            }
            catch (Exception e) {
                log.info(orgViewNumber + "\uff1a\u4fdd\u5b58\u7ec4\u7ec7\u5386\u53f2\u6570\u636e\u53d1\u73b0\u5f02\u5e38\uff1a" + orgIds + e.getMessage());
                txHandle.markRollback();
            }
        }
    }

    public static void saveOrgStructureHistory(String orgViewNumber, List<Long> orgIds) {
        if (Utils.isListEmpty(orgIds)) {
            return;
        }
        OrgHistoryUtils.saveOrgStructureHistory((String)orgViewNumber, orgIds);
        OrgManagerUtils.removeOrgCache();
    }

    public static void saveOrgStructureDeleteHistory(String orgViewNumber, List<Long> orgIds) {
        if (Utils.isListEmpty(orgIds)) {
            return;
        }
        OrgHistoryUtils.saveOrgStructureDeleteHistory((String)orgViewNumber, orgIds);
        OrgManagerUtils.removeOrgCache();
    }

    private static void removeOrgCache() {
        CacheManager.removeCache((String)"bos_org");
        CacheManager.removeCache((String)"bos_adminorg");
        CacheManager.removeCache((String)"bos_org_structure");
    }
}

