/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.service.common;

import java.util.Collections;
import java.util.List;
import kd.bos.base.utils.msg.BaseMessage;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.log.api.AppLogInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OrgApiResult;
import kd.bos.org.model.OrgEntity;
import kd.bos.org.model.OrgParam;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.log.LogServiceHelper;

public class OrgMsgManager {
    private static final Log log = LogFactory.getLog(OrgMsgManager.class);

    public static void generateFailMsg(List<OrgParam> paramList, String msg) {
        if (CollectionUtils.isEmpty(paramList)) {
            return;
        }
        for (OrgParam orgParam : paramList) {
            OrgMsgManager.generateFailMsg(orgParam, msg);
        }
    }

    public static void generateFailMsg(OrgParam orgParam, String msg) {
        if (orgParam == null) {
            return;
        }
        orgParam.setSuccess(false);
        orgParam.setMsg(msg);
    }

    public static void generateFailMsgWithTargetName(OrgParam orgParam, String msg) {
        if (orgParam == null) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)orgParam.getNumber())) {
            msg = orgParam.getNumber() + BaseMessage.getMessage((String)"M00067") + msg;
        } else if (StringUtils.isNotBlank((CharSequence)orgParam.getName())) {
            msg = orgParam.getName() + BaseMessage.getMessage((String)"M00067") + msg;
        }
        OrgMsgManager.generateFailMsg(orgParam, msg);
    }

    public static void generateFailMsg(List<OrgApiResult> resultList, OrgParam orgParam, String msg) {
        if (orgParam == null) {
            return;
        }
        OrgMsgManager.generateFailMsg(orgParam, msg);
        if (resultList != null) {
            OrgApiResult result = new OrgApiResult(false);
            result.setId(orgParam.getId());
            result.setNumber(orgParam.getNumber());
            result.setName(orgParam.getName());
            result.setErrorMsg(msg);
            resultList.add(result);
        }
    }

    public static void generateSuccessMsg(List<OrgApiResult> resultList, OrgParam orgParam) {
        if (orgParam == null) {
            return;
        }
        OrgApiResult result = new OrgApiResult(true);
        result.setId(orgParam.getId());
        result.setNumber(orgParam.getNumber());
        result.setName(orgParam.getName());
        resultList.add(result);
    }

    public static void generateSuccessMsg(OrgParam orgParam, long orgId) {
        if (orgParam == null) {
            return;
        }
        orgParam.setId(orgId);
        orgParam.setSuccess(true);
    }

    public static void generateYzjFailMsg(OrgParam orgParam, OrgEntity orgEntity) {
        if (orgParam == null || orgEntity == null) {
            return;
        }
        orgParam.setId(orgEntity.getId());
        orgParam.setSuccess(orgEntity.isSuccess());
        orgParam.setMsg(orgEntity.getMsg());
    }

    public static void generateExceptionMsg(Throwable throwable, OrgParam orgParam) {
        if (throwable == null || orgParam == null) {
            return;
        }
        OrgMsgManager.generateExceptionMsg(throwable, Collections.singletonList(orgParam));
    }

    public static void generateExceptionMsg(Throwable throwable, List<OrgParam> paramList) {
        if (throwable == null || CollectionUtils.isEmpty(paramList)) {
            return;
        }
        String msg = "";
        if (throwable instanceof KDBizException) {
            KDBizException kdBizException = (KDBizException)throwable;
            msg = kdBizException.getMessage();
        } else {
            msg = throwable.getMessage() == null ? BaseMessage.getMessage((String)"M00060") : throwable.getMessage();
            msg = BaseMessage.getMessage((String)"M00061", (Object[])new Object[]{msg});
        }
        log.info(msg, (Object)throwable);
        for (OrgParam orgParam : paramList) {
            OrgMsgManager.generateFailMsg(orgParam, msg);
        }
    }

    @Deprecated
    public static void addOperationLog(String OpName, boolean isStart) {
        AppLogInfo appLogInfo = new AppLogInfo();
        appLogInfo.setBizAppID("83bfebc8000037ac");
        appLogInfo.setBizObjID("bos_org");
        appLogInfo.setOpName(OpName);
        appLogInfo.setOpDescription(String.format(ResManager.loadKDString((String)"%1$s\u6267\u884c\u7ec4\u7ec7\u63a5\u53e3\u7684\u201c%2$s\u201d\u64cd\u4f5c\u3002", (String)"OrgMsgManager_0", (String)"bos-mservice-org", (Object[])new Object[0]), isStart ? ResManager.loadKDString((String)"\u5f00\u59cb", (String)"OrgMsgManager_1", (String)"bos-mservice-org", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5b8c\u6210", (String)"OrgMsgManager_2", (String)"bos-mservice-org", (Object[])new Object[0]), OpName));
        LogServiceHelper.addLog((AppLogInfo)appLogInfo);
    }
}

