/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.service.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.base.utils.IBaseCallbackHandler;
import kd.bos.base.utils.msg.OrgMessage;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.org.model.OrgDutyView;
import kd.bos.org.model.OrgParam;
import kd.bos.org.service.common.OrgMsgManager;
import kd.bos.org.service.common.OrgParamValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class OrgOperationObjectLoader {
    private final List<OrgParam> orgParamList;
    private final Map<Object, DynamicObject> sourceOrgMap;
    private final Map<Object, DynamicObject> targetObjMap;
    private final Map<Object, List<OrgParam>> parentOrgParamMap;

    public OrgOperationObjectLoader(List<OrgParam> orgParamList) {
        this.orgParamList = orgParamList;
        int count = this.orgParamList.size();
        this.sourceOrgMap = new LinkedHashMap<Object, DynamicObject>(count);
        this.targetObjMap = new LinkedHashMap<Object, DynamicObject>(count);
        this.parentOrgParamMap = new HashMap<Object, List<OrgParam>>(count);
    }

    public void load(IBaseCallbackHandler handler) {
        int count = this.orgParamList.size();
        HashSet<Long> ids = new HashSet<Long>(count);
        for (OrgParam orgParam : this.orgParamList) {
            if (!OrgParamValidator.parseParamToEntity(orgParam)) continue;
            handler.handle(new Object[]{orgParam});
            if (orgParam.getId() != 0L) {
                ids.add(orgParam.getId());
            }
            for (Map.Entry viewEntry : orgParam.getMultiViewMap().entrySet()) {
                OrgDutyView orgDutyView = (OrgDutyView)viewEntry.getValue();
                if (orgDutyView == null) {
                    OrgMsgManager.generateFailMsg(orgParam, OrgMessage.getMessage((String)"M00002"));
                    continue;
                }
                long parentId = orgDutyView.getParentId();
                if (parentId <= 0L) continue;
                ids.add(parentId);
                this.parentOrgParamMap.computeIfAbsent(parentId, k -> new ArrayList(count)).add(orgParam);
            }
        }
        if (ids.isEmpty()) {
            return;
        }
        MainEntityType orgEntityType = EntityMetadataCache.getDataEntityType((String)"bos_org");
        DynamicObject[] orgObjArr = BusinessDataServiceHelper.load((Object[])ids.toArray(new Long[ids.size()]), (DynamicObjectType)orgEntityType);
        if (orgObjArr == null || orgObjArr.length == 0) {
            return;
        }
        CloneUtils cloneUtils = new CloneUtils(true, false);
        for (DynamicObject orgObj : orgObjArr) {
            Object orgObjPkValue = orgObj.getPkValue();
            this.targetObjMap.put(orgObjPkValue, orgObj);
            this.sourceOrgMap.put(orgObjPkValue, (DynamicObject)cloneUtils.clone((IDataEntityBase)orgObj));
        }
    }

    public Map<Object, DynamicObject> getSourceOrgMap() {
        return this.sourceOrgMap;
    }

    public Map<Object, DynamicObject> getTargetObjMap() {
        return this.targetObjMap;
    }

    public Map<Object, List<OrgParam>> getParentOrgParamMap() {
        return this.parentOrgParamMap;
    }
}

