/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.service.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.utils.BaseUtils;
import kd.bos.base.utils.msg.BaseMessage;
import kd.bos.base.utils.msg.OrgMessage;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.TextProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.CompanyParam;
import kd.bos.org.model.OrgApiResult;
import kd.bos.org.model.OrgDuty;
import kd.bos.org.model.OrgDutyView;
import kd.bos.org.model.OrgParam;
import kd.bos.org.model.ViewSchemaParam;
import kd.bos.org.service.common.AbstractOrgCheckerExecutor;
import kd.bos.org.service.common.OrgDutyCheckerExecutor;
import kd.bos.org.service.common.OrgFreezeCheckerExecutor;
import kd.bos.org.service.common.OrgManagerUtils;
import kd.bos.org.service.common.OrgMsgManager;
import kd.bos.org.utils.OrgUtils;
import kd.bos.org.utils.OrgViewUtils;
import kd.bos.org.utils.Utils;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class OrgParamValidator {
    private static final Log log = LogFactory.getLog(OrgParamValidator.class);

    public static boolean isOrgParamEmpty(List<OrgParam> paramList) {
        if (Utils.isListEmpty(paramList)) {
            log.debug("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            return true;
        }
        return false;
    }

    public static boolean isOrgParamEmpty(OrgParam orgParam) {
        if (orgParam == null) {
            log.debug("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            return true;
        }
        return false;
    }

    public static boolean parseParamToEntity(OrgParam orgParam) {
        CompanyParam company;
        String description;
        String name;
        if (OrgParamValidator.isOrgParamEmpty(orgParam)) {
            return false;
        }
        HashMap<String, Long> orgPropertyMap = orgParam.getPropertyMap();
        if (orgPropertyMap == null) {
            orgPropertyMap = new HashMap<String, Long>(32);
            orgParam.setPropertyMap(orgPropertyMap);
        }
        orgPropertyMap.put("id", orgParam.getId());
        orgPropertyMap.put("customOrgId", orgParam.getCustomOrgId());
        String number = orgParam.getNumber();
        if (StringUtils.isNotBlank((CharSequence)number)) {
            orgPropertyMap.put("number", (Long)((Object)number));
        }
        if (StringUtils.isNotBlank((CharSequence)(name = orgParam.getName()))) {
            orgPropertyMap.put("name", (Long)((Object)name));
        }
        OrgParamValidator.parseOrgPattern(orgParam);
        String yzjOrgId = orgParam.getYzjOrgId();
        if (StringUtils.isNotBlank((CharSequence)yzjOrgId)) {
            orgPropertyMap.put("fyzjorgid", (Long)((Object)yzjOrgId));
        }
        if (StringUtils.isNotBlank((CharSequence)(description = orgParam.getDescription()))) {
            orgPropertyMap.put("fcomment", (Long)((Object)description));
        }
        if ((company = orgParam.getCompany()) != null) {
            orgPropertyMap.put("faddress", (Long)((Object)company.getAddress()));
            orgPropertyMap.put("bankaccount", (Long)((Object)company.getBankAccount()));
            orgPropertyMap.put("fbizscope", (Long)((Object)company.getBizScope()));
            orgPropertyMap.put("businessterm", (Long)((Object)company.getBusinessTerm()));
            orgPropertyMap.put("depositbank", (Long)((Object)company.getDepositBank()));
            orgPropertyMap.put("establishmentdate", (Long)((Object)company.getEstablishmentDate()));
            orgPropertyMap.put("ffirmname", (Long)((Object)company.getName()));
            orgPropertyMap.put("phone", (Long)((Object)company.getPhone()));
            orgPropertyMap.put("registeredcapital", (Long)company.getRegisteredCapital());
            orgPropertyMap.put("frepresentative", (Long)((Object)company.getRepresentative()));
            orgPropertyMap.put("ftaxregnum", (Long)((Object)company.getTaxRegNum()));
            orgPropertyMap.put("ffirmtype", (Long)((Object)company.getType()));
            orgPropertyMap.put("uniformsocialcreditcode", (Long)((Object)company.getUniformSocialCreditCode()));
        }
        return OrgParamValidator.parseMultiViewMap(orgParam);
    }

    public static boolean parseMultiViewMap(OrgParam orgParam) {
        if (OrgParamValidator.isOrgParamEmpty(orgParam)) {
            return false;
        }
        TreeMap<String, OrgDutyView> multiViewMap = orgParam.getMultiViewMap();
        if (multiViewMap == null) {
            multiViewMap = new TreeMap<String, OrgDutyView>();
            orgParam.setMultiViewMap(multiViewMap);
        }
        if (orgParam.getMultiViewMap().isEmpty()) {
            String duty = orgParam.getDuty();
            if (StringUtils.isNotBlank((CharSequence)duty)) {
                OrgDutyView orgDutyView = new OrgDutyView();
                orgDutyView.setParentId(orgParam.getParentId());
                multiViewMap.put(duty, orgDutyView);
            }
        } else {
            for (Map.Entry viewEntry : multiViewMap.entrySet()) {
                if (viewEntry.getValue() != null) continue;
                multiViewMap.put((String)viewEntry.getKey(), new OrgDutyView());
            }
        }
        return true;
    }

    private static boolean parseOrgPattern(OrgParam orgParam) {
        long orgPatternId = orgParam.getOrgPatternId();
        if (orgPatternId > 0L) {
            orgParam.getPropertyMap().put("orgpattern", orgPatternId);
        } else {
            Object orgPattern = orgParam.getPropertyMap().get("orgpattern");
            if (StringUtils.isBlank(orgPattern)) {
                return true;
            }
            if (orgPattern instanceof Long) {
                orgPatternId = (Long)orgPattern;
            } else if (orgPattern instanceof DynamicObject) {
                DynamicObject orgPatternObj = (DynamicObject)orgPattern;
                orgPatternId = orgPatternObj.getLong("id");
            } else {
                try {
                    orgPatternId = Long.parseLong(orgPattern.toString());
                }
                catch (Exception e) {
                    OrgMsgManager.generateFailMsg(orgParam, OrgMessage.getMessage((String)"M00209", (Object[])new Object[]{orgPattern}));
                    return false;
                }
            }
            orgParam.setOrgPatternId(orgPatternId);
        }
        return true;
    }

    public static boolean isAddParamValid(OrgParam orgParam, Map<String, Object> contextMap) {
        if (OrgParamValidator.isOrgParamEmpty(orgParam)) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)orgParam.getName())) {
            OrgMsgManager.generateFailMsg(orgParam, BaseMessage.getMessage((String)"M00004"));
            return false;
        }
        if (!OrgParamValidator.isCustomOrgIdValid(orgParam)) {
            return false;
        }
        if (!OrgParamValidator.parseParamToEntity(orgParam)) {
            return false;
        }
        if (!OrgParamValidator.isDutyValid(orgParam, true)) {
            return false;
        }
        TreeMap<String, DynamicObject> parentObjMap = OrgParamValidator.isParentValid(orgParam, contextMap, true);
        if (!orgParam.isSuccess()) {
            return false;
        }
        if (!OrgParamValidator.isFullnameValid(orgParam, parentObjMap, true)) {
            return false;
        }
        if (!OrgParamValidator.isNumberValid(orgParam, parentObjMap, true)) {
            return false;
        }
        if (!OrgParamValidator.isPatternValid(orgParam, true)) {
            return false;
        }
        DynamicObject orgObj = OrgParamValidator.genInsertOrgObject(orgParam, contextMap, parentObjMap);
        contextMap.put("org", orgObj);
        return true;
    }

    public static boolean isDutyValid(OrgParam orgParam, boolean isAddnew) {
        if (OrgParamValidator.isOrgParamEmpty(orgParam)) {
            return false;
        }
        TreeMap multiViewMap = orgParam.getMultiViewMap();
        if (multiViewMap == null || multiViewMap.isEmpty()) {
            if (isAddnew) {
                OrgMsgManager.generateFailMsg(orgParam, OrgMessage.getMessage((String)"M00002"));
                return false;
            }
            return true;
        }
        ArrayList<String> dutyList = new ArrayList<String>(multiViewMap.size());
        for (Map.Entry viewEntry : multiViewMap.entrySet()) {
            dutyList.add((String)viewEntry.getKey());
        }
        Map<Object, DynamicObject> viewSchemaMap = OrgParamValidator.loadViewSchemaFromCache(dutyList);
        if (viewSchemaMap == null || viewSchemaMap.isEmpty()) {
            OrgMsgManager.generateFailMsg(orgParam, OrgMessage.getMessage((String)"M00015"));
            return false;
        }
        for (DynamicObject viewSchemaObj : viewSchemaMap.values()) {
            String duty = viewSchemaObj.getString("number");
            DynamicObject bizObj = viewSchemaObj.getDynamicObject("treetypeid");
            if (bizObj == null && StringUtils.isBlank((CharSequence)duty)) {
                OrgMsgManager.generateFailMsg(orgParam, duty + BaseMessage.getMessage((String)"M00067") + OrgMessage.getMessage((String)"M00016"));
                return false;
            }
            dutyList.remove(duty);
            OrgDutyView dutyView = (OrgDutyView)multiViewMap.get(duty);
            OrgParamValidator.generateOrgDutyViewParam(dutyView, viewSchemaObj);
        }
        if (!dutyList.isEmpty()) {
            OrgMsgManager.generateFailMsg(orgParam, (String)dutyList.get(0) + BaseMessage.getMessage((String)"M00067") + OrgMessage.getMessage((String)"M00016"));
            return false;
        }
        return true;
    }

    public static Map<Object, DynamicObject> loadViewSchemaFromCache(List<String> numbers) {
        String selectFields = "id,number,name,treetypeid,isdefault";
        QFilter numberFilter = new QFilter("number", "in", numbers);
        QFilter[] filters = new QFilter[]{numberFilter};
        Map viewSchemaMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org_viewschema", (String)selectFields, (QFilter[])filters);
        return viewSchemaMap == null ? new HashMap() : viewSchemaMap;
    }

    public static boolean generateOrgDutyViewParam(OrgDutyView dutyView, DynamicObject viewSchemaObj) {
        if (dutyView == null || viewSchemaObj == null) {
            return false;
        }
        DynamicObject bizObj = viewSchemaObj.getDynamicObject("treetypeid");
        return OrgParamValidator.generateOrgDutyViewParam(dutyView, viewSchemaObj, bizObj);
    }

    public static boolean generateOrgDutyViewParam(OrgDutyView dutyView, DynamicObject viewSchemaObj, DynamicObject bizObj) {
        if (dutyView == null || viewSchemaObj == null) {
            return false;
        }
        OrgDuty orgDuty = dutyView.getDuty();
        if (orgDuty == null) {
            orgDuty = new OrgDuty();
            dutyView.setDuty(orgDuty);
        }
        orgDuty.setId(viewSchemaObj.getLong("id"));
        orgDuty.setNumber(viewSchemaObj.getString("number"));
        orgDuty.setName(viewSchemaObj.getString("name"));
        orgDuty.setDefault(viewSchemaObj.getBoolean("isdefault"));
        if (bizObj != null) {
            orgDuty.setTreeType(bizObj.getString("fnumber"));
            orgDuty.setCategory(bizObj.getString("category"));
            orgDuty.setVisiable(bizObj.getBoolean("visiable"));
            orgDuty.setPropertyName(bizObj.getString("propertyname"));
            orgDuty.setFieldName(bizObj.getString("ffieldname"));
        }
        return true;
    }

    private static DynamicObject genInsertOrgObject(OrgParam orgParam, Map<String, Object> contextMap, TreeMap<String, DynamicObject> parentObjMap) {
        DynamicObject orgObj = null;
        TreeMap multiViewMap = orgParam.getMultiViewMap();
        orgObj = multiViewMap.containsKey("01") ? BusinessDataServiceHelper.newDynamicObject((String)"bos_adminorg") : BusinessDataServiceHelper.newDynamicObject((String)"bos_org");
        boolean isAddnewOrgUnit = true;
        if (!multiViewMap.containsKey("15") && !multiViewMap.containsKey("01")) {
            DynamicObject[] orgUnitArr;
            DynamicObject orgUnitStrucObj;
            String fullname = "";
            DynamicObject parentObj = null;
            if (parentObjMap != null && (parentObj = parentObjMap.get("15")) == null) {
                parentObj = parentObjMap.values().iterator().next();
            }
            if ((orgUnitStrucObj = OrgManagerUtils.getOrgUnitByFullname(fullname = parentObj == null ? orgParam.getName() : parentObj.getString("fullname") + OrgUnitServiceHelper.getOrgSeparation().getFullNameSep() + orgParam.getName())) != null && (orgUnitArr = BusinessDataServiceHelper.load((Object[])new Object[]{orgUnitStrucObj.get("org")}, (DynamicObjectType)orgObj.getDynamicObjectType())) != null && orgUnitArr.length != 0) {
                orgObj = orgUnitArr[0];
                isAddnewOrgUnit = false;
            }
        }
        contextMap.put("addnew", isAddnewOrgUnit);
        if (isAddnewOrgUnit) {
            long id = orgParam.getCustomOrgId();
            if (id == 0L) {
                id = ORM.create().genLongId("bos_org");
            }
            orgObj.set("id", (Object)id);
            orgObj.set("masterid", (Object)id);
            orgObj.set("number", (Object)orgParam.getNumber());
            orgObj.set("name", (Object)orgParam.getName());
            orgObj.set("orgpattern", (Object)orgParam.getOrgPatternId());
        }
        orgParam.setId(orgObj.getLong("id"));
        OrgParamValidator.genOtherInsertOrgPro(orgParam, orgObj);
        OrgManagerUtils.genCommonField(orgObj, isAddnewOrgUnit);
        return orgObj;
    }

    private static void genOtherInsertOrgPro(OrgParam orgParam, DynamicObject orgObj) {
        Map orgPropertyMap = orgParam.getPropertyMap();
        if (CollectionUtils.isEmpty((Map)orgPropertyMap)) {
            return;
        }
        HashSet<String> propertiesNameSet = new HashSet<String>(orgPropertyMap.size());
        for (String propertyKey : orgPropertyMap.keySet()) {
            if ("id".equals(propertyKey) || "masterid".equals(propertyKey) || "number".equals(propertyKey) || "name".equals(propertyKey) || "customOrgId".equals(propertyKey)) continue;
            propertiesNameSet.add(propertyKey);
        }
        if (!propertiesNameSet.isEmpty()) {
            DataEntityPropertyCollection orgProperties = orgObj.getDataEntityType().getProperties();
            for (IDataEntityProperty orgPro : orgProperties) {
                String propertyKey = orgPro.getName();
                if (!propertiesNameSet.contains(propertyKey)) continue;
                orgObj.set(propertyKey, orgPropertyMap.get(propertyKey));
            }
        }
    }

    public static boolean isUpdateParamValid(OrgParam orgParam, Map<String, Object> contextMap) {
        return OrgParamValidator.isUpdateParamValid(orgParam, contextMap, true, new HashMap<Long, OrgParam>(0));
    }

    public static boolean isUpdateParamValid(OrgParam orgParam, Map<String, Object> contextMap, boolean parseParam, Map<Long, OrgParam> allOrgParamMap) {
        QFilter orgFilter;
        QFilter viewFilter;
        QFilter freezeFilter;
        QFilter[] qFilters;
        if (parseParam ? !OrgParamValidator.parseParamToEntity(orgParam) : OrgParamValidator.isOrgParamEmpty(orgParam)) {
            return false;
        }
        if (!OrgParamValidator.isOrgIdValid(orgParam, contextMap)) {
            return false;
        }
        if (!OrgParamValidator.isDutyValid(orgParam, false)) {
            return false;
        }
        DynamicObject orgObj = (DynamicObject)contextMap.get("org");
        TreeMap multiViewMap = orgParam.getMultiViewMap();
        if (multiViewMap != null && multiViewMap.containsKey("01") && QueryServiceHelper.exists((String)"bos_org_structure", (QFilter[])(qFilters = new QFilter[]{freezeFilter = new QFilter("isfreeze", "=", (Object)Boolean.TRUE), viewFilter = new QFilter("view.number", "=", (Object)"01"), orgFilter = new QFilter("org", "=", (Object)orgParam.getId())}))) {
            OrgMsgManager.generateFailMsg(orgParam, OrgMessage.getMessage((String)"M00087", (Object[])new Object[]{orgObj.getString("name")}));
            return false;
        }
        TreeMap<String, DynamicObject> parentObjMap = OrgParamValidator.isParentValid(orgParam, contextMap, false, allOrgParamMap);
        if (!orgParam.isSuccess()) {
            return false;
        }
        if (!OrgParamValidator.isFullnameValid(orgParam, parentObjMap, false)) {
            return false;
        }
        if (!OrgParamValidator.isNumberValid(orgParam, parentObjMap, false)) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)orgParam.getNumber())) {
            orgParam.setNumber(orgObj.getString("number"));
        }
        if (StringUtils.isBlank((CharSequence)orgParam.getName())) {
            orgParam.setName(orgObj.getString("name"));
        }
        return OrgParamValidator.isPatternValid(orgParam, false);
    }

    public static boolean isDeleteParamValid(OrgParam orgParam) {
        if (OrgParamValidator.isOrgParamEmpty(orgParam)) {
            return false;
        }
        if (orgParam.getId() != 0L) {
            OrgMsgManager.generateFailMsg(orgParam, OrgMessage.getMessage((String)"M00088"));
            return false;
        }
        if (!OrgParamValidator.parseParamToEntity(orgParam)) {
            return false;
        }
        HashMap<String, Object> contextMap = new HashMap<String, Object>(1);
        if (!OrgParamValidator.isOrgIdValid(orgParam, contextMap)) {
            return false;
        }
        DynamicObject orgObj = (DynamicObject)contextMap.get("org");
        if (orgObj.getBoolean("fisadministrative")) {
            OrgMsgManager.generateFailMsg(orgParam, OrgMessage.getMessage((String)"M00089"));
            return false;
        }
        return OrgParamValidator.isLeafOrg(orgParam);
    }

    private static boolean isLeafOrg(OrgParam orgParam) {
        QFilter parentFilter = new QFilter("parent", "=", (Object)orgParam.getId());
        QFilter[] filters = new QFilter[]{parentFilter};
        if (QueryServiceHelper.exists((String)"bos_org_structure", (QFilter[])filters)) {
            OrgMsgManager.generateFailMsg(orgParam, OrgMessage.getMessage((String)"M00131"));
            return false;
        }
        return true;
    }

    public static boolean isDisableParamValid(OrgParam orgParam) {
        if (OrgParamValidator.isOrgParamEmpty(orgParam)) {
            return false;
        }
        orgParam.setDuty("15");
        HashMap<String, Object> contextMap = new HashMap<String, Object>(1);
        if (!OrgParamValidator.isOrgIdValid(orgParam, contextMap)) {
            return false;
        }
        DynamicObject orgObj = (DynamicObject)contextMap.get("org");
        if (!orgObj.getBoolean("enable")) {
            OrgMsgManager.generateFailMsg(orgParam, OrgMessage.getMessage((String)"M00090"));
            return false;
        }
        String disableMsg = OrgUtils.isDisableValid((Object)orgParam.getId());
        if (StringUtils.isNotBlank((CharSequence)disableMsg)) {
            OrgMsgManager.generateFailMsg(orgParam, disableMsg);
            return false;
        }
        return true;
    }

    public static boolean isEnableParamValid(OrgParam orgParam) {
        if (OrgParamValidator.isOrgParamEmpty(orgParam)) {
            return false;
        }
        orgParam.setDuty("15");
        HashMap<String, Object> contextMap = new HashMap<String, Object>(1);
        if (!OrgParamValidator.isOrgIdValid(orgParam, contextMap)) {
            return false;
        }
        DynamicObject orgObj = (DynamicObject)contextMap.get("org");
        if (orgObj.getBoolean("enable")) {
            OrgMsgManager.generateFailMsg(orgParam, OrgMessage.getMessage((String)"M00091"));
            return false;
        }
        return true;
    }

    public static boolean isFreezeParamValid(OrgParam orgParam) {
        if (OrgParamValidator.isOrgParamEmpty(orgParam)) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)orgParam.getDuty())) {
            orgParam.setDuty("01");
        }
        if (!OrgParamValidator.isOrgIdValid(orgParam, null)) {
            return false;
        }
        return OrgParamValidator.isFreezeAble(orgParam);
    }

    public static boolean isUnFreezeParamValid(OrgParam orgParam) {
        HashMap<String, Object> contextMap;
        if (OrgParamValidator.isOrgParamEmpty(orgParam)) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)orgParam.getDuty())) {
            orgParam.setDuty("01");
        }
        if (!OrgParamValidator.isOrgIdValid(orgParam, contextMap = new HashMap<String, Object>(1))) {
            return false;
        }
        return OrgParamValidator.isUnFreezeAble(orgParam, contextMap);
    }

    private static boolean isFreezeAble(OrgParam orgParam) {
        OrgFreezeCheckerExecutor checker = new OrgFreezeCheckerExecutor(orgParam.getId());
        String msg = ((AbstractOrgCheckerExecutor)checker).check();
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            OrgMsgManager.generateFailMsg(orgParam, msg);
            return false;
        }
        return true;
    }

    private static boolean isUnFreezeAble(OrgParam orgParam, Map<String, Object> contextMap) {
        long orgId = orgParam.getId();
        String selectFields = "parent,isfreeze,longnumber,fullname";
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter viewFilter = new QFilter("view.number", "=", (Object)"01");
        QFilter[] filters = new QFilter[]{orgFilter, viewFilter};
        DynamicObject structrueObj = QueryServiceHelper.queryOne((String)"bos_org_structure", (String)selectFields, (QFilter[])filters);
        if (structrueObj == null) {
            OrgMsgManager.generateFailMsg(orgParam, OrgMessage.getMessage((String)"M00076", (Object[])new Object[]{orgId}));
            return false;
        }
        DynamicObject orgObj = (DynamicObject)contextMap.get("org");
        String orgNumber = orgObj.getString("number");
        String orgName = orgObj.getString("name");
        if (!structrueObj.getBoolean("isfreeze")) {
            OrgMsgManager.generateFailMsg(orgParam, OrgMessage.getMessage((String)"M00213"));
            return false;
        }
        long oldParentId = structrueObj.getLong("parent");
        orgFilter = new QFilter("org", "=", (Object)oldParentId);
        QFilter freezeFilter = new QFilter("isfreeze", "=", (Object)Boolean.TRUE);
        QFilter[] qFilters = new QFilter[]{orgFilter, freezeFilter, viewFilter};
        if (QueryServiceHelper.exists((String)"bos_org_structure", (QFilter[])qFilters)) {
            OrgMsgManager.generateFailMsg(orgParam, OrgMessage.getMessage((String)"M00216"));
            return false;
        }
        QFilter idFilter = new QFilter("org.id", "!=", (Object)orgParam.getId());
        idFilter = idFilter.and(viewFilter);
        QFilter parentFilter = new QFilter("parent", "=", (Object)oldParentId);
        idFilter = idFilter.and(parentFilter);
        QFilter nameFilter = new QFilter("org.name", "=", (Object)orgName);
        idFilter = idFilter.and(nameFilter);
        return OrgParamValidator.fullNameDuplicateCheck(orgParam, orgNumber, orgName, idFilter);
    }

    public static boolean isOrgIdValid(OrgParam orgParam, Map<String, Object> contextMap) {
        DynamicObject orgPatternObj;
        if (OrgParamValidator.isOrgParamEmpty(orgParam)) {
            return false;
        }
        long orgId = orgParam.getId();
        if (orgId <= 0L) {
            OrgMsgManager.generateFailMsg(orgParam, BaseMessage.getMessage((String)"M00002"));
            return false;
        }
        MainEntityType orgType = EntityMetadataCache.getDataEntityType((String)"bos_adminorg");
        DynamicObject[] orgObjArr = BusinessDataServiceHelper.load((Object[])new Object[]{orgId}, (DynamicObjectType)orgType);
        if (orgObjArr == null || orgObjArr.length == 0) {
            OrgMsgManager.generateFailMsg(orgParam, BaseMessage.getMessage((String)"M00058", (Object[])new Object[]{orgId}));
            return false;
        }
        DynamicObject orgObj = orgObjArr[0];
        if (orgParam.getOrgPatternId() < 0L && (orgPatternObj = orgObj.getDynamicObject("orgpattern")) != null) {
            orgParam.setOrgPatternId(orgPatternObj.getLong("id"));
        }
        if (contextMap != null) {
            contextMap.put("org", orgObj);
        }
        return true;
    }

    public static boolean isCustomOrgIdValid(OrgParam orgParam) {
        if (OrgParamValidator.isOrgParamEmpty(orgParam)) {
            return false;
        }
        long customOrgId = orgParam.getCustomOrgId();
        if (customOrgId != 0L && QueryServiceHelper.exists((String)"bos_org", (Object)customOrgId)) {
            OrgMsgManager.generateFailMsg(orgParam, customOrgId + "\uff1a" + BaseMessage.getMessage((String)"M00018"));
            return false;
        }
        return true;
    }

    private static boolean isNumberValid(OrgParam orgParam, TreeMap<String, DynamicObject> parentObjMap, boolean isAddNew) {
        String number = orgParam.getNumber();
        if (StringUtils.isBlank((CharSequence)number)) {
            if (isAddNew) {
                number = OrgManagerUtils.getOrgNumber(orgParam.getNumber(), "01".equals(orgParam.getDuty()));
                orgParam.setNumber(number);
            }
            return true;
        }
        String msg = OrgViewUtils.isOrgNumberExists((long)orgParam.getId(), (String)number);
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            OrgMsgManager.generateFailMsg(orgParam, number + "\uff1a" + msg);
            return false;
        }
        if (StringUtils.isNotBlank((CharSequence)number) && StringUtils.isNotBlank((CharSequence)(msg = OrgViewUtils.isOrgNumberValid((String)number)))) {
            OrgMsgManager.generateFailMsg(orgParam, msg);
            return false;
        }
        return OrgParamValidator.isLongNumberValid(orgParam, parentObjMap);
    }

    public static boolean isLongNumberValid(OrgParam orgParam, Map<String, DynamicObject> parentObjMap) {
        if (OrgParamValidator.isOrgParamEmpty(orgParam)) {
            return false;
        }
        String number = orgParam.getNumber();
        if (StringUtils.isBlank((CharSequence)number)) {
            return true;
        }
        if (CollectionUtils.isEmpty(parentObjMap)) {
            return true;
        }
        int longnumberMaxLen = OrgParamValidator.getStructureProMaxLength("longnumber");
        for (Map.Entry<String, DynamicObject> dutyEntry : parentObjMap.entrySet()) {
            DynamicObject parentObj = dutyEntry.getValue();
            String longNumber = "";
            longNumber = parentObj == null ? number : parentObj.getString("longnumber") + "!" + number;
            if (longNumber.length() <= longnumberMaxLen) continue;
            OrgMsgManager.generateFailMsg(orgParam, OrgMessage.getMessage((String)"M00137", (Object[])new Object[]{longnumberMaxLen}));
            return false;
        }
        return true;
    }

    public static boolean isFullnameValid(OrgParam orgParam, Map<String, DynamicObject> parentObjMap, boolean isAddNew) {
        String msg;
        if (OrgParamValidator.isOrgParamEmpty(orgParam)) {
            return false;
        }
        String name = orgParam.getName();
        if (StringUtils.isBlank((CharSequence)name) && isAddNew) {
            OrgMsgManager.generateFailMsg(orgParam, BaseMessage.getMessage((String)"M00004"));
            return false;
        }
        if (StringUtils.isNotBlank((CharSequence)name) && StringUtils.isNotBlank((CharSequence)(msg = OrgViewUtils.isOrgNameValid((String)name)))) {
            OrgMsgManager.generateFailMsg(orgParam, msg);
            return false;
        }
        if (parentObjMap == null) {
            return true;
        }
        QFilter filter = null;
        int fullNameMaxLen = OrgParamValidator.getStructureProMaxLength("fullname");
        for (Map.Entry<String, DynamicObject> dutyEntry : parentObjMap.entrySet()) {
            QFilter fullnameFilter;
            DynamicObject parentObj = dutyEntry.getValue();
            QFilter viewFilter = new QFilter("view.number", "=", (Object)dutyEntry.getKey());
            String fullname = "";
            if (parentObj == null) {
                fullname = name;
                fullnameFilter = new QFilter("fullname", "=", (Object)fullname);
                viewFilter = viewFilter.and(fullnameFilter);
            } else {
                fullname = parentObj.getString("fullname") + OrgUnitServiceHelper.getOrgSeparation().getFullNameSep() + name;
                fullnameFilter = new QFilter("fullname", "=", (Object)fullname);
                viewFilter = viewFilter.and(fullnameFilter);
            }
            if (fullname.length() > fullNameMaxLen) {
                OrgMsgManager.generateFailMsg(orgParam, OrgMessage.getMessage((String)"M00138", (Object[])new Object[]{fullNameMaxLen}));
                return false;
            }
            if (filter == null) {
                filter = viewFilter;
                continue;
            }
            filter = filter.or(viewFilter);
        }
        if (filter == null) {
            return true;
        }
        if (!isAddNew) {
            QFilter orgFilter = new QFilter("org", "!=", (Object)orgParam.getId());
            filter = filter.and(orgFilter);
        }
        return OrgParamValidator.fullNameDuplicateCheck(orgParam, name, filter);
    }

    public static boolean fullNameDuplicateCheck(OrgParam orgParam, String name, QFilter filter) {
        return OrgParamValidator.fullNameDuplicateCheck(orgParam, "", name, filter);
    }

    public static boolean fullNameDuplicateCheck(OrgParam orgParam, String number, String name, QFilter filter) {
        if (orgParam == null || orgParam.isHandleFrozenOrg()) {
            return true;
        }
        QFilter freezeFilter = new QFilter("isfreeze", "=", (Object)Boolean.FALSE);
        QFilter[] filters = new QFilter[]{filter, freezeFilter};
        String selectFields = "view.treetypeid.fname,view.isdefault isdefault,view.name view";
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"OrgParamValidator.fullNameDuplicateCheck", (String)"bos_org_structure", (String)selectFields, (QFilter[])filters, null, (int)1);){
            if (ds.hasNext()) {
                Row row = ds.next();
                String viewName = row.getBoolean("isdefault") != false ? row.getString("view.treetypeid.fname") : row.getString("view");
                String subject = name;
                if (StringUtils.isNotBlank((CharSequence)orgParam.getNumber())) {
                    subject = orgParam.getNumber();
                } else if (StringUtils.isNotBlank((CharSequence)number)) {
                    subject = number;
                }
                OrgMsgManager.generateFailMsg(orgParam, OrgMessage.getMessage((String)"M00139", (Object[])new Object[]{subject, viewName}));
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    public static boolean fullNameDuplicateCheck(OrgParam orgParam, DynamicObject orgObj, String viewNumber, long parentId) {
        if (orgParam == null || orgParam.isHandleFrozenOrg()) {
            return true;
        }
        OrmLocaleValue nameLocaleValue = (OrmLocaleValue)orgObj.get("name");
        if (nameLocaleValue == null) {
            return true;
        }
        QFilter freezeFilter = new QFilter("isfreeze", "=", (Object)Boolean.FALSE);
        QFilter viewFilter = new QFilter("view.number", "=", (Object)viewNumber);
        freezeFilter = freezeFilter.and(viewFilter);
        String selectFields = "org,view";
        QFilter parentFilter = new QFilter("parent", "=", (Object)parentId);
        QFilter[] filters = new QFilter[]{freezeFilter = freezeFilter.and(parentFilter)};
        DynamicObject[] structObjArr = BusinessDataServiceHelper.load((String)"bos_org_structure", (String)selectFields, (QFilter[])filters);
        if (structObjArr == null || structObjArr.length == 0) {
            return true;
        }
        long orgId = orgObj.getLong("id");
        String currentLang = RequestContext.get().getLang().name();
        String currentLocaleName = nameLocaleValue.get((Object)currentLang);
        Map enableLangMap = BaseUtils.getEnableLangMap();
        TreeMap nameTreeMap = new TreeMap(nameLocaleValue);
        Iterator nameItr = nameTreeMap.entrySet().iterator();
        while (nameItr.hasNext()) {
            if (enableLangMap.containsKey(nameItr.next().getKey())) continue;
            nameItr.remove();
        }
        nameTreeMap.remove(currentLang);
        for (DynamicObject structObj : structObjArr) {
            DynamicObject bizObj;
            OrmLocaleValue rowName;
            Long rowOrgId;
            DynamicObject rowOrgObj = structObj.getDynamicObject("org");
            DynamicObject rowViewObj = structObj.getDynamicObject("view");
            if (rowOrgObj == null || rowViewObj == null || (rowOrgId = Long.valueOf(rowOrgObj.getLong("id"))) == orgId || (rowName = (OrmLocaleValue)rowOrgObj.get("name")) == null) continue;
            boolean isSameName = false;
            String language = "";
            if (currentLocaleName != null && currentLocaleName.equals(rowName.get((Object)currentLang))) {
                isSameName = true;
                language = OrgParamValidator.getLanguageName(currentLang);
            } else {
                for (Map.Entry nameEntry : nameTreeMap.entrySet()) {
                    if (!StringUtils.isNotBlank((CharSequence)((CharSequence)nameEntry.getValue())) || !((String)nameEntry.getValue()).equals(rowName.get(nameEntry.getKey()))) continue;
                    isSameName = true;
                    language = OrgParamValidator.getLanguageName((String)nameEntry.getKey());
                    break;
                }
            }
            if (!isSameName) continue;
            String viewName = null;
            if (rowViewObj.getBoolean("isdefault") && (bizObj = rowViewObj.getDynamicObject("treetypeid")) != null) {
                viewName = bizObj.getString("fname");
            }
            if (viewName == null) {
                viewName = rowViewObj.getString("name");
            }
            OrgMsgManager.generateFailMsg(orgParam, OrgMessage.getMessage((String)"M00144", (Object[])new Object[]{viewName, language}));
            return false;
        }
        return true;
    }

    public static String getLanguageName(String key) {
        QFilter[] filters = new QFilter[]{new QFilter("number", "=", (Object)key)};
        DynamicObject languageObj = BusinessDataServiceHelper.loadSingleFromCache((String)"inte_enabledlanguage", (String)"name", (QFilter[])filters);
        String language = languageObj == null ? ((languageObj = BusinessDataServiceHelper.loadSingleFromCache((String)"inte_language", (String)"name", (QFilter[])filters)) == null ? "" : languageObj.getString("name")) : languageObj.getString("name");
        return language;
    }

    private static int getStructureProMaxLength(String proName) {
        MainEntityType structEntityType = EntityMetadataCache.getDataEntityType((String)"bos_org_structure");
        DynamicProperty property = structEntityType.getProperty(proName);
        if (property instanceof TextProp) {
            TextProp textProp = (TextProp)property;
            return textProp.getMaxLenth();
        }
        return 0;
    }

    private static boolean isPatternValid(OrgParam orgParam, boolean isAddNew) {
        long patternId = orgParam.getOrgPatternId();
        QFilter filter = null;
        if (patternId <= 0L) {
            String patternNumber = orgParam.getOrgPatternNumber();
            if (StringUtils.isNotBlank((CharSequence)patternNumber)) {
                filter = new QFilter("number", "=", (Object)patternNumber.trim());
            }
        } else {
            filter = new QFilter("id", "=", (Object)patternId);
        }
        boolean isGalaxyUltimate = OrgUnitServiceHelper.isGalaxyUltimate();
        long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
        if (filter == null) {
            if (isAddNew) {
                if (isGalaxyUltimate && rootOrgId == orgParam.getId()) {
                    orgParam.setOrgPatternId(7L);
                } else {
                    orgParam.setOrgPatternId(4L);
                }
            }
            return true;
        }
        String selectProperties = "id,number,patterntype";
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter[] qFilters = new QFilter[]{filter, enableFilter};
        DynamicObject patternObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org_pattern", (String)selectProperties, (QFilter[])qFilters);
        if (patternObj == null) {
            OrgMsgManager.generateFailMsg(orgParam, OrgMessage.getMessage((String)"M00019"));
            return false;
        }
        if (!OrgParamValidator.checkPatternValidForGalaxy(isGalaxyUltimate, patternObj, orgParam, rootOrgId)) {
            return false;
        }
        orgParam.setOrgPatternId(patternObj.getLong("id"));
        orgParam.setOrgPatternNumber(patternObj.getString("number"));
        return true;
    }

    public static boolean checkPatternValidForGalaxy(boolean isGalaxyUltimate, DynamicObject patternObj, OrgParam orgParam, long rootOrgId) {
        if (!isGalaxyUltimate || patternObj == null || orgParam == null) {
            return true;
        }
        long orgPatternId = patternObj.getLong("id");
        String patternType = patternObj.getString("patterntype");
        boolean isCorporateType = "1".equals(patternType);
        if (rootOrgId == orgParam.getId()) {
            if (7L != orgPatternId && 8L != orgPatternId) {
                if (StringUtils.isBlank((CharSequence)orgParam.getName())) {
                    OrgMsgManager.generateFailMsgWithTargetName(orgParam, OrgMessage.getMessage((String)"M00145"));
                } else {
                    OrgMsgManager.generateFailMsgWithTargetName(orgParam, String.format(OrgMessage.getMessage((String)"M00148"), orgParam.getName()));
                }
                return false;
            }
        } else {
            if (7L == orgPatternId || 8L == orgPatternId) {
                if (StringUtils.isBlank((CharSequence)orgParam.getName())) {
                    OrgMsgManager.generateFailMsgWithTargetName(orgParam, OrgMessage.getMessage((String)"M00146"));
                } else {
                    OrgMsgManager.generateFailMsgWithTargetName(orgParam, OrgMessage.getMessage((String)"M00149", (Object[])new Object[]{orgParam.getName()}));
                }
                return false;
            }
            if (isCorporateType) {
                OrgDutyView orgUnitView = OrgParamValidator.getOrgUnitView(orgParam, rootOrgId, orgPatternId, patternType);
                if (orgUnitView == null) {
                    return true;
                }
                if (orgUnitView.getParentId() != 0L && orgUnitView.getParentId() != rootOrgId) {
                    if (StringUtils.isBlank((CharSequence)orgParam.getName())) {
                        OrgMsgManager.generateFailMsgWithTargetName(orgParam, OrgMessage.getMessage((String)"M00147"));
                    } else {
                        OrgMsgManager.generateFailMsgWithTargetName(orgParam, String.format(OrgMessage.getMessage((String)"M00150"), orgParam.getName()));
                    }
                    return false;
                }
            }
        }
        return !isCorporateType || OrgParamValidator.checkCorporateLimitCountOfGalaxy(orgParam);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static OrgDutyView getOrgUnitView(OrgParam orgParam, long rootOrgId, long dbOrgPatternId, String patternType) {
        TreeMap multiViewMap = orgParam.getMultiViewMap();
        OrgDutyView orgDutyView = (OrgDutyView)multiViewMap.get("15");
        if (orgDutyView != null) {
            return orgDutyView;
        }
        if (orgParam.getId() <= 0L) {
            for (Map.Entry viewEntry : multiViewMap.entrySet()) {
                OrgDutyView dutyView = (OrgDutyView)viewEntry.getValue();
                OrgDuty duty = dutyView.getDuty();
                if ((duty == null || !"1".equals(duty.getCategory())) && "01".equals(viewEntry.getKey())) continue;
                return (OrgDutyView)viewEntry.getValue();
            }
            return orgDutyView;
        } else {
            if (orgParam.getId() != rootOrgId && dbOrgPatternId != 7L && !"1".equals(patternType)) return orgDutyView;
            QFilter viewFilter = new QFilter("view", "=", (Object)15L);
            QFilter orgFilter = new QFilter("org", "=", (Object)orgParam.getId());
            QFilter[] filters = new QFilter[]{viewFilter, orgFilter};
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"OrgParamValidator.getOrgUnitView", (String)"bos_org_structure", (String)"id,parent", (QFilter[])filters, (String)"");){
                if (!dataSet.hasNext()) return orgDutyView;
                Row row = dataSet.next();
                orgDutyView = new OrgDutyView(row.getLong("parent").longValue());
                return orgDutyView;
            }
        }
    }

    public static boolean checkCorporateLimitCountOfGalaxy(OrgParam orgParam) {
        int corporateOrgCount;
        if (OrgParamValidator.isOrgParamEmpty(orgParam)) {
            return false;
        }
        int corporateLimitCount = OrgUnitServiceHelper.getCorporateLimitCountOfGalaxy();
        List corporateOrgIds = OrgUtils.getCorporateOrgIds((boolean)false);
        if (orgParam.getId() > 0L) {
            corporateOrgIds.remove(orgParam.getId());
        }
        if ((corporateOrgCount = corporateOrgIds.size()) >= corporateLimitCount) {
            OrgMsgManager.generateFailMsgWithTargetName(orgParam, OrgMessage.getMessage((String)"M00152", (Object[])new Object[]{corporateLimitCount, corporateOrgCount - corporateLimitCount + 1}));
            return false;
        }
        return true;
    }

    public static TreeMap<String, DynamicObject> isParentValid(OrgParam orgParam, Map<String, Object> contextMap, boolean isAddNew) {
        return OrgParamValidator.isParentValid(orgParam, contextMap, isAddNew, new HashMap<Long, OrgParam>(0));
    }

    public static TreeMap<String, DynamicObject> isParentValid(OrgParam orgParam, Map<String, Object> contextMap, boolean isAddNew, Map<Long, OrgParam> allOrgParamMap) {
        QFilter[] filters;
        TreeMap multiViewMap;
        if (OrgParamValidator.isOrgParamEmpty(orgParam)) {
            return null;
        }
        TreeMap<String, DynamicObject> oldOrgViewMap = null;
        if (!isAddNew) {
            oldOrgViewMap = OrgParamValidator.getOldOrgStructureMap(orgParam, contextMap);
        }
        if ((multiViewMap = orgParam.getMultiViewMap()) == null || multiViewMap.isEmpty()) {
            return null;
        }
        TreeMap<String, DynamicObject> viewParentMap = new TreeMap<String, DynamicObject>();
        ArrayList<String> viewList = new ArrayList<String>(multiViewMap.size());
        QFilter filter = OrgParamValidator.getParentValidFilter(orgParam, isAddNew, allOrgParamMap, viewParentMap, viewList);
        if (filter == null) {
            return null;
        }
        String selectFields = OrgManagerUtils.getOrgStrucSelectFields();
        DynamicObject[] parentObjArr = BusinessDataServiceHelper.load((String)"bos_org_structure", (String)selectFields, (QFilter[])(filters = new QFilter[]{filter}));
        if (parentObjArr == null || parentObjArr.length == 0) {
            OrgMsgManager.generateFailMsg(orgParam, OrgMessage.getMessage((String)"M00010"));
            return null;
        }
        for (DynamicObject parentObj : parentObjArr) {
            DynamicObject oldOrgObj;
            DynamicObject viewObj;
            DynamicObject orgObj = parentObj.getDynamicObject("org");
            if (orgObj == null || (viewObj = parentObj.getDynamicObject("view")) == null) continue;
            String viewNumber = viewObj.getString("number");
            if (!OrgParamValidator.checkParentFreezeStatus(orgParam, parentObj)) {
                return null;
            }
            if ("14".equals(viewObj.getString("treetype")) && !parentObj.getBoolean("isctrlunit")) {
                OrgMsgManager.generateFailMsg(orgParam, OrgMessage.getMessage((String)"M00101", (Object[])new Object[]{orgObj.getString("number")}));
                return null;
            }
            if (oldOrgViewMap != null && (oldOrgObj = oldOrgViewMap.get(viewNumber)) != null) {
                String parentLongnumber = parentObj.getString("longnumber");
                String oldLongnumber = oldOrgObj.getString("longnumber");
                if (StringUtils.isNotBlank((CharSequence)oldLongnumber) && parentLongnumber.startsWith(oldLongnumber + "!")) {
                    OrgMsgManager.generateFailMsg(orgParam, OrgMessage.getMessage((String)"M00012"));
                    return null;
                }
            }
            viewList.remove(viewNumber);
            viewParentMap.put(viewNumber, parentObj);
        }
        if (!viewList.isEmpty()) {
            OrgMsgManager.generateFailMsg(orgParam, OrgMessage.getMessage((String)"M00092", (Object[])new Object[]{viewList.get(0)}));
            return null;
        }
        contextMap.put("parent", viewParentMap);
        return viewParentMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static QFilter getParentValidFilter(OrgParam orgParam, boolean isAddNew, Map<Long, OrgParam> allOrgParamMap, TreeMap<String, DynamicObject> viewParentMap, List<String> viewList) {
        QFilter filter = null;
        long orgId = orgParam.getId();
        for (Map.Entry entry : orgParam.getMultiViewMap().entrySet()) {
            String duty = (String)entry.getKey();
            viewParentMap.put(duty, null);
            OrgDutyView orgDutyView = (OrgDutyView)entry.getValue();
            long parentId = orgDutyView.getParentId();
            if (parentId == 0L) {
                if (!OrgParamValidator.isParentValidWithoutOtherRootOrg(orgParam, isAddNew, duty, allOrgParamMap)) return null;
                parentId = orgDutyView.getParentId();
            } else {
                if (OrgUnitServiceHelper.getRootOrgId() == orgId) {
                    if ("15".equals(duty)) {
                        OrgMsgManager.generateFailMsg(orgParam, OrgMessage.getMessage((String)"M00097"));
                        return null;
                    }
                    if ("01".equals(duty)) {
                        OrgMsgManager.generateFailMsg(orgParam, OrgMessage.getMessage((String)"M00098"));
                        return null;
                    }
                }
                if (orgId == parentId) {
                    OrgMsgManager.generateFailMsg(orgParam, OrgMessage.getMessage((String)"M00011"));
                    return null;
                }
            }
            if (parentId == 0L) continue;
            QFilter orgViewFilter = new QFilter("org", "=", (Object)parentId);
            viewList.add(duty);
            QFilter viewFilter = new QFilter("view.number", "=", (Object)duty);
            orgViewFilter = orgViewFilter.and(viewFilter);
            if (filter == null) {
                filter = orgViewFilter;
                continue;
            }
            filter = filter.or(orgViewFilter);
        }
        return filter;
    }

    private static boolean checkParentFreezeStatus(OrgParam orgParam, DynamicObject parentObj) {
        if (orgParam.isHandleFrozenOrg()) {
            return true;
        }
        if (parentObj.getBoolean("isfreeze")) {
            OrgMsgManager.generateFailMsg(orgParam, OrgMessage.getMessage((String)"M00216"));
            return false;
        }
        return true;
    }

    private static boolean isParentValidWithoutOtherRootOrg(OrgParam orgParam, boolean isAddNew, String duty, Map<Long, OrgParam> allOrgParamMap) {
        long orgId = orgParam.getId();
        OrgDutyView orgDutyView = (OrgDutyView)orgParam.getMultiViewMap().get(duty);
        QFilter viewFilter = new QFilter("view.number", "=", (Object)duty);
        QFilter parentFilter = new QFilter("parent", "=", (Object)0L);
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        parentFilter = parentFilter.or(orgFilter);
        QFilter[] filters = new QFilter[]{viewFilter, parentFilter};
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"OrgParamValidator.isParentValid", (String)"bos_org_structure", (String)"org,parent,org.number number,org.name name", (QFilter[])filters, (String)"");){
            String rootOrgName = "";
            long rootOrgId = 0L;
            long dbParentId = 0L;
            boolean isCurrentOrgStructureExists = false;
            for (Row row : ds) {
                long tempParentId = row.getLong("parent");
                long tempOrgId = row.getLong("org");
                if (tempParentId == 0L) {
                    rootOrgName = row.getString("name");
                    rootOrgId = tempOrgId;
                }
                if (orgId != tempOrgId) continue;
                isCurrentOrgStructureExists = true;
                dbParentId = tempParentId;
                if (StringUtils.isBlank((CharSequence)orgParam.getNumber())) {
                    orgParam.setNumber(row.getString("number"));
                }
                if (!StringUtils.isBlank((CharSequence)orgParam.getName())) continue;
                orgParam.setName(row.getString("name"));
            }
            if (!isCurrentOrgStructureExists && orgId != 0L) {
                OrgMsgManager.generateFailMsg(orgParam, OrgMessage.getMessage((String)"M00102", (Object[])new Object[]{orgId, orgDutyView.getDuty().getName()}));
                boolean bl = false;
                return bl;
            }
            if (orgDutyView.getParentId() == 0L) {
                OrgDutyView oldRootView;
                TreeMap oldRootViewMap;
                OrgParam oldRootParam;
                boolean hasDuplicateRootOrg = true;
                if (rootOrgId != orgId && (oldRootParam = allOrgParamMap.get(rootOrgId)) != null && (oldRootViewMap = oldRootParam.getMultiViewMap()) != null && (oldRootView = (OrgDutyView)oldRootViewMap.get(duty)) != null && oldRootView.getParentId() != 0L) {
                    hasDuplicateRootOrg = false;
                }
                if (hasDuplicateRootOrg) {
                    if (isAddNew) {
                        OrgMsgManager.generateFailMsg(orgParam, OrgMessage.getMessage((String)"M00021"));
                        boolean bl = false;
                        return bl;
                    }
                    orgDutyView.setParentId(dbParentId);
                }
            }
        }
        return true;
    }

    private static TreeMap<String, DynamicObject> getOldOrgStructureMap(OrgParam orgParam, Map<String, Object> contextMap) {
        QFilter orgFilter;
        QFilter[] filters;
        String selectFields = OrgManagerUtils.getOrgStrucSelectFields();
        DynamicObject[] strucObjArr = BusinessDataServiceHelper.load((String)"bos_org_structure", (String)selectFields, (QFilter[])(filters = new QFilter[]{orgFilter = new QFilter("org", "=", (Object)orgParam.getId())}));
        if (strucObjArr == null || strucObjArr.length == 0) {
            return null;
        }
        TreeMap<String, DynamicObject> viewParentMap = new TreeMap<String, DynamicObject>();
        for (DynamicObject strucObjObj : strucObjArr) {
            DynamicObject viewObj = strucObjObj.getDynamicObject("view");
            if (viewObj == null) continue;
            String viewNumber = viewObj.getString("number");
            viewParentMap.put(viewNumber, strucObjObj);
        }
        contextMap.put("orgstructure", viewParentMap);
        return viewParentMap;
    }

    public static boolean isAddDutyParamValid(OrgParam orgParam, Map<String, Object> contextMap) {
        if (!OrgParamValidator.parseParamToEntity(orgParam)) {
            return false;
        }
        if (!OrgParamValidator.isOrgIdValid(orgParam, contextMap)) {
            return false;
        }
        DynamicObject orgObj = (DynamicObject)contextMap.get("org");
        orgParam.setNumber(orgObj.getString("number"));
        orgParam.setName(orgObj.getString("name"));
        TreeMap multiViewMap = orgParam.getMultiViewMap();
        if (multiViewMap == null || multiViewMap.isEmpty()) {
            OrgMsgManager.generateFailMsg(orgParam, OrgMessage.getMessage((String)"M00002"));
            return false;
        }
        if (!OrgParamValidator.isDutyValid(orgParam, false)) {
            return false;
        }
        ArrayList<String> dutyList = new ArrayList<String>(multiViewMap.size());
        ArrayList<String> rootDutyList = new ArrayList<String>();
        QFilter checkParentFilter = null;
        long orgId = orgParam.getId();
        for (Map.Entry dutyEntry : multiViewMap.entrySet()) {
            String duty = (String)dutyEntry.getKey();
            if (StringUtils.isBlank((CharSequence)duty)) {
                OrgMsgManager.generateFailMsg(orgParam, OrgMessage.getMessage((String)"M00002"));
                return false;
            }
            dutyList.add(duty);
            OrgDutyView orgDutyView = (OrgDutyView)dutyEntry.getValue();
            long parentId = orgDutyView.getParentId();
            if (parentId == 0L) {
                rootDutyList.add(duty);
                continue;
            }
            if (orgId == parentId) {
                OrgMsgManager.generateFailMsg(orgParam, OrgMessage.getMessage((String)"M00011"));
                return false;
            }
            QFilter viewFilter = new QFilter("view.number", "=", (Object)duty);
            QFilter orgFilter = new QFilter("org", "=", (Object)parentId);
            orgFilter = orgFilter.and(viewFilter);
            if (checkParentFilter == null) {
                checkParentFilter = orgFilter;
                continue;
            }
            checkParentFilter = checkParentFilter.or(orgFilter);
        }
        if (!OrgParamValidator.isAddDutyFitOrgManageMode(orgParam, dutyList)) {
            return false;
        }
        if (!OrgParamValidator.isOrgHasDefaultViewSchema(orgParam, dutyList)) {
            return false;
        }
        if (!rootDutyList.isEmpty()) {
            QFilter viewFilter = new QFilter("view.number", "in", rootDutyList);
            QFilter parentFilter = new QFilter("parent", "=", (Object)0);
            QFilter[] qFilters = new QFilter[]{viewFilter, parentFilter};
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"OrgParamValidator.isAddDutyParamValid.rootduty", (String)"bos_org_structure", (String)"view.name name", (QFilter[])qFilters, (String)"", (int)1);){
                if (dataSet.hasNext()) {
                    OrgMsgManager.generateFailMsg(orgParam, OrgMessage.getMessage((String)"M00132", (Object[])new Object[]{dataSet.next().getString("name")}));
                    boolean bl = false;
                    return bl;
                }
            }
        }
        if (!OrgParamValidator.isParentDutyValid(orgParam, checkParentFilter, contextMap)) {
            return false;
        }
        TreeMap parentObjMap = (TreeMap)contextMap.get("parent");
        if (!OrgParamValidator.isFullnameValid(orgParam, parentObjMap, true)) {
            return false;
        }
        return OrgParamValidator.isLongNumberValid(orgParam, parentObjMap);
    }

    private static boolean isOrgHasDefaultViewSchema(OrgParam orgParam, List<String> dutyList) {
        if (dutyList.isEmpty()) {
            OrgMsgManager.generateFailMsg(orgParam, OrgMessage.getMessage((String)"M00002"));
            return false;
        }
        QFilter[] filters = null;
        Map objectDynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org_viewschema", filters);
        if (objectDynamicObjectMap == null || objectDynamicObjectMap.isEmpty()) {
            OrgMsgManager.generateFailMsg(orgParam, OrgMessage.getMessage((String)"M00016"));
            return false;
        }
        int viewCount = objectDynamicObjectMap.size();
        HashMap<String, String> treetypeMap = new HashMap<String, String>(viewCount);
        HashMap<String, String> viewNameMap = new HashMap<String, String>(viewCount);
        ArrayList<String> treetypeList = new ArrayList<String>(dutyList.size());
        for (DynamicObject viewSchemaObj : objectDynamicObjectMap.values()) {
            String viewNumber = viewSchemaObj.getString("number");
            viewNameMap.put(viewNumber, viewSchemaObj.getString("name"));
            String treetype = viewSchemaObj.getString("treetype");
            if ("16".equals(treetype) || !dutyList.contains(viewNumber) || dutyList.contains(treetype)) continue;
            treetypeMap.put(treetype, viewNumber);
            treetypeList.add(treetype);
        }
        if (treetypeList.isEmpty()) {
            return true;
        }
        String selectFields = "id,view";
        QFilter treetypeFilter = new QFilter("view.treetype", "in", treetypeList);
        QFilter defaultFilter = new QFilter("view.isdefault", "=", (Object)Boolean.TRUE);
        QFilter orgFilter = new QFilter("org", "=", (Object)orgParam.getId());
        filters = new QFilter[]{treetypeFilter, defaultFilter, orgFilter};
        Map structureMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org_structure", (String)selectFields, (QFilter[])filters);
        if (!CollectionUtils.isEmpty((Map)structureMap)) {
            for (DynamicObject structureObj : structureMap.values()) {
                DynamicObject viewObj = structureObj.getDynamicObject("view");
                if (viewObj == null) continue;
                treetypeList.remove(viewObj.getString("treetype"));
            }
        }
        if (!treetypeList.isEmpty()) {
            String treetype = (String)treetypeList.get(0);
            String viewNumber = (String)treetypeMap.get(treetype);
            String viewName = (String)viewNameMap.get(viewNumber);
            OrgMsgManager.generateFailMsg(orgParam, OrgMessage.getMessage((String)"M00103", (Object[])new Object[]{orgParam.getName(), viewName, viewNameMap.get(treetype)}));
            return false;
        }
        return true;
    }

    private static boolean isParentDutyValid(OrgParam orgParam, QFilter checkParentFilter, Map<String, Object> contextMap) {
        QFilter[] filters;
        if (checkParentFilter == null) {
            return true;
        }
        String selectFields = OrgManagerUtils.getOrgStrucSelectFields();
        DynamicObject[] parentObjArr = BusinessDataServiceHelper.load((String)"bos_org_structure", (String)selectFields, (QFilter[])(filters = new QFilter[]{checkParentFilter}));
        if (parentObjArr == null || parentObjArr.length == 0) {
            OrgMsgManager.generateFailMsg(orgParam, OrgMessage.getMessage((String)"M00010"));
            return false;
        }
        TreeMap<String, DynamicObject> parentObjMap = new TreeMap<String, DynamicObject>();
        for (DynamicObject parentObj : parentObjArr) {
            if (parentObj.getBoolean("isfreeze")) {
                OrgMsgManager.generateFailMsg(orgParam, OrgMessage.getMessage((String)"M00009"));
                return false;
            }
            DynamicObject viewObj = parentObj.getDynamicObject("view");
            String viewNumber = viewObj.getString("number");
            if ("14".equals(viewNumber) && !parentObj.getBoolean("isctrlunit")) {
                OrgMsgManager.generateFailMsg(orgParam, OrgMessage.getMessage((String)"M00104"));
                return false;
            }
            parentObjMap.put(viewNumber, parentObj);
        }
        contextMap.put("parent", parentObjMap);
        return true;
    }

    public static boolean isAddDutyFitOrgManageMode(OrgParam orgParam, List<String> dutyList) {
        if (OrgParamValidator.isOrgParamEmpty(orgParam) || dutyList == null) {
            return false;
        }
        long orgId = orgParam.getId();
        ArrayList<String> checkDutyList = new ArrayList<String>(dutyList);
        checkDutyList.remove("01");
        checkDutyList.remove("15");
        if (checkDutyList.isEmpty()) {
            return true;
        }
        int orgManageMode = OrgUnitServiceHelper.getOrgmanageMode();
        if (1 != orgManageMode) {
            return true;
        }
        QFilter enableFilter = new QFilter("org.enable", "=", (Object)Boolean.TRUE);
        QFilter viewFilter = new QFilter("view.number", "in", checkDutyList);
        enableFilter = enableFilter.and(viewFilter);
        QFilter orgFilter = new QFilter("org", "!=", (Object)orgId);
        QFilter[] qFilters = new QFilter[]{enableFilter, orgFilter};
        String selectFields = "org.name org,view.name view";
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"kd.bos.org.service.common.OrgParamValidator.isAddDutyFitOrgManageMode", (String)"bos_org_structure", (String)selectFields, (QFilter[])qFilters, (String)"level", (int)1);){
            if (ds.hasNext()) {
                Row row = ds.next();
                OrgMsgManager.generateFailMsg(orgParam, OrgMessage.getMessage((String)"M00105", (Object[])new Object[]{row.getString("view")}));
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    public static boolean isDeleteDutyParamValid(OrgParam orgParam, Map<String, Object> contextMap) {
        if (!OrgParamValidator.parseParamToEntity(orgParam)) {
            return false;
        }
        if (contextMap == null) {
            contextMap = new HashMap<String, Object>();
        }
        if (!OrgParamValidator.isOrgIdValid(orgParam, contextMap)) {
            return false;
        }
        DynamicObject orgObj = (DynamicObject)contextMap.get("org");
        orgParam.setNumber(orgObj.getString("number"));
        orgParam.setName(orgObj.getString("name"));
        TreeMap multiViewMap = orgParam.getMultiViewMap();
        if (multiViewMap == null || multiViewMap.isEmpty()) {
            OrgMsgManager.generateFailMsg(orgParam, OrgMessage.getMessage((String)"M00002"));
            return false;
        }
        ArrayList<String> dutyList = new ArrayList<String>(multiViewMap.size());
        boolean isIncludeOrgUnit = false;
        for (String duty : multiViewMap.keySet()) {
            if (StringUtils.isBlank((CharSequence)duty)) {
                OrgMsgManager.generateFailMsg(orgParam, OrgMessage.getMessage((String)"M00002"));
                return false;
            }
            dutyList.add(duty);
            if (!orgObj.getBoolean("isbizorg") && "01".equals(duty)) {
                OrgMsgManager.generateFailMsg(orgParam, OrgMessage.getMessage((String)"M00089"));
                return false;
            }
            if (!"15".equals(duty)) continue;
            isIncludeOrgUnit = true;
        }
        long orgId = orgParam.getId();
        OrgDutyCheckerExecutor dutyChecker = new OrgDutyCheckerExecutor(orgId, dutyList);
        String errorMsg = ((AbstractOrgCheckerExecutor)dutyChecker).check();
        if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
            OrgMsgManager.generateFailMsg(orgParam, orgParam.getName() + "\uff1a" + errorMsg);
            return false;
        }
        String selectProperties = "id,view,org,parent,yzjorgid,yzjparentorgid,longnumber,fullname,level,isleaf";
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter[] filters = new QFilter[]{orgFilter};
        DynamicObject[] orgStructureObjArr = BusinessDataServiceHelper.load((String)"bos_org_structure", (String)selectProperties, (QFilter[])filters);
        if (orgStructureObjArr == null || orgStructureObjArr.length == 0) {
            OrgMsgManager.generateFailMsg(orgParam, OrgMessage.getMessage((String)"M00106"));
            return false;
        }
        TreeMap<String, DynamicObject> orgStructureMap = new TreeMap<String, DynamicObject>();
        boolean hasOtherDuty = false;
        boolean isAdminOrg = orgObj.getBoolean("fisadministrative");
        HashSet<String> deletedTreetypeSet = new HashSet<String>();
        ArrayList<String> tempDutyList = new ArrayList<String>(dutyList);
        HashMap<String, List<String>> treetypeMap = new HashMap<String, List<String>>();
        HashMap<String, String> viewNameMap = new HashMap<String, String>();
        for (DynamicObject orgStructureObj : orgStructureObjArr) {
            DynamicObject viewObj = orgStructureObj.getDynamicObject("view");
            if (viewObj == null) {
                OrgMsgManager.generateFailMsg(orgParam, OrgMessage.getMessage((String)"M00106"));
                return false;
            }
            String viewNumber = viewObj.getString("number");
            String treetype = viewObj.getString("treetype");
            ArrayList<String> viewNumberList = (ArrayList<String>)treetypeMap.get(treetype);
            if (viewNumberList == null) {
                viewNumberList = new ArrayList<String>();
                treetypeMap.put(treetype, viewNumberList);
            }
            viewNumberList.add(viewNumber);
            if (dutyList.contains(viewNumber)) {
                if (viewObj.getBoolean("isdefault")) {
                    deletedTreetypeSet.add(treetype);
                    viewNameMap.put(treetype, viewObj.getString("name"));
                }
                orgStructureMap.put(viewNumber, orgStructureObj);
                dutyList.remove(viewNumber);
                continue;
            }
            if (!isIncludeOrgUnit || isAdminOrg || "15".equals(viewNumber) || "16".equals(viewNumber)) continue;
            hasOtherDuty = true;
        }
        if (!OrgParamValidator.isNoOtherBizView(orgParam, tempDutyList, deletedTreetypeSet, treetypeMap, viewNameMap)) {
            return false;
        }
        if (isIncludeOrgUnit) {
            if (hasOtherDuty) {
                OrgMsgManager.generateFailMsg(orgParam, OrgMessage.getMessage((String)"M00107"));
                return false;
            }
            if (!isAdminOrg) {
                OrgMsgManager.generateFailMsg(orgParam, OrgMessage.getMessage((String)"M00108"));
                return false;
            }
        }
        contextMap.put("orgstructure", orgStructureMap);
        return true;
    }

    private static boolean isNoOtherBizView(OrgParam orgParam, List<String> dutyList, Set<String> deletedTreetypeSet, Map<String, List<String>> treetypeMap, Map<String, String> viewNameMap) {
        if (deletedTreetypeSet.isEmpty()) {
            return true;
        }
        deletedTreetypeSet.remove("01");
        deletedTreetypeSet.remove("16");
        for (String treetype : deletedTreetypeSet) {
            List<String> viewList = treetypeMap.get(treetype);
            viewList.removeAll(dutyList);
            if (viewList.isEmpty()) continue;
            String viewNumber = viewList.get(0);
            OrgMsgManager.generateFailMsg(orgParam, OrgMessage.getMessage((String)"M00109", (Object[])new Object[]{orgParam.getName(), viewNameMap.get(treetype), OrgParamValidator.getViewSchemaNameByNumber(viewNumber)}));
            return false;
        }
        return true;
    }

    private static String getViewSchemaNameByNumber(String number) {
        QFilter numberFilter = new QFilter("number", "=", (Object)number);
        QFilter[] filters = new QFilter[]{numberFilter};
        DynamicObject schemaObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org_viewschema", (String)"name", (QFilter[])filters);
        if (schemaObj == null) {
            return number;
        }
        return schemaObj.getString("name");
    }

    public static OrgApiResult checkSaveViewSchemaParam(ViewSchemaParam param) {
        OrgApiResult result = new OrgApiResult(true);
        if (param == null) {
            result.setSuccess(false);
            result.setErrorMsg(BaseMessage.getMessage((String)"M00014"));
            return result;
        }
        long id = param.getId();
        long customId = param.getCustomId();
        if (id == 0L && customId != 0L && QueryServiceHelper.exists((String)"bos_org_viewschema", (Object)customId)) {
            OrgParamValidator.genErrorMsg(result, customId + "\uff1a" + BaseMessage.getMessage((String)"M00018"));
        }
        if (result.isSuccess()) {
            OrgParamValidator.checkViewTypeValid(param, result);
        }
        return result;
    }

    private static void checkViewTypeValid(ViewSchemaParam param, OrgApiResult result) {
        String viewType = param.getViewType();
        if (StringUtils.isBlank((CharSequence)viewType)) {
            if (param.getId() == 0L) {
                DynamicObject bizObj;
                if (param.getViewTypeId() != 0L && (bizObj = BusinessDataServiceHelper.loadSingleFromCache((Object)param.getViewTypeId(), (String)"bos_org_biz")) != null) {
                    param.setViewType(bizObj.getString("fnumber"));
                    return;
                }
                OrgParamValidator.genErrorMsg(result, OrgMessage.getMessage((String)"M00001"));
                return;
            }
        } else {
            QFilter numberFilter = new QFilter("fnumber", "=", (Object)viewType);
            QFilter[] filters = new QFilter[]{numberFilter};
            DynamicObject bizObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org_biz", (QFilter[])filters);
            if (bizObj == null) {
                OrgParamValidator.genErrorMsg(result, OrgMessage.getMessage((String)"M00022", (Object[])new Object[]{viewType}));
                return;
            }
            param.setViewTypeId(bizObj.getLong("id"));
        }
    }

    public static void genApiResult(ApiResult executeResult, OrgApiResult result) {
        if (executeResult == null) {
            OrgParamValidator.genErrorMsg(result, BaseMessage.getMessage((String)"M00059"));
        } else {
            Object data = executeResult.getData();
            if (data instanceof OperationResult) {
                OrgParamValidator.genOperationResult((OperationResult)data, result);
            } else {
                OrgParamValidator.genErrorMsg(result, executeResult.getMessage());
            }
        }
    }

    public static void genOperationResult(OperationResult executeResult, OrgApiResult result) {
        if (executeResult == null) {
            OrgParamValidator.genErrorMsg(result, BaseMessage.getMessage((String)"M00059"));
        } else {
            result.setSuccess(true);
            OrgApiResult eachResult = null;
            List ids = executeResult.getSuccessPkIds();
            ArrayList<String> pkStringList = new ArrayList<String>();
            if (Utils.isListNotEmpty((List)ids)) {
                String pk = String.valueOf(ids.get(0));
                pkStringList.add(pk);
                eachResult = new OrgApiResult(true);
                eachResult.setId(Long.parseLong(pk));
                result.getResultList().add(eachResult);
                result.setId(Long.parseLong(pk));
            }
            if (!executeResult.isSuccess()) {
                OrgParamValidator.genOperationFailResult(executeResult, result, pkStringList, eachResult);
            }
        }
    }

    private static void genOperationFailResult(OperationResult executeResult, OrgApiResult result, List<String> pkStringList, OrgApiResult eachResult) {
        String errorMsg = executeResult.getMessage();
        List errorInfoList = executeResult.getAllErrorOrValidateInfo();
        if (Utils.isListEmpty((List)errorInfoList)) {
            OrgParamValidator.genErrorMsg(result, StringUtils.isBlank((CharSequence)errorMsg) ? BaseMessage.getMessage((String)"M00059") : errorMsg);
        } else {
            for (IOperateInfo info : errorInfoList) {
                String pk = String.valueOf(info.getPkValue());
                if (pkStringList.contains(pk)) continue;
                eachResult = new OrgApiResult();
                eachResult.setId(Long.parseLong(pk));
                errorMsg = info.getMessage();
                if (StringUtils.isBlank((CharSequence)errorMsg)) {
                    errorMsg = info.getTitle();
                }
                OrgParamValidator.genErrorMsg(eachResult, errorMsg);
                result.getResultList().add(eachResult);
                OrgParamValidator.genErrorMsg(result, errorMsg);
            }
        }
    }

    public static void genErrorMsg(OrgApiResult result, String errorMsg) {
        if (result == null) {
            return;
        }
        result.setSuccess(false);
        result.setErrorMsg(errorMsg);
    }
}

