/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.task.change;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import kd.bos.base.utils.msg.OrgMessage;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.org.model.OrgDutyView;
import kd.bos.org.model.OrgParam;
import kd.bos.org.task.change.AbstractOrgChangeEvent;
import kd.bos.org.utils.OrgChangeType;

public abstract class OrgBizFreezeChangeCommonEvent
extends AbstractOrgChangeEvent {
    public OrgBizFreezeChangeCommonEvent(DynamicObject changeObject, OrgChangeType orgChangeType, Map<String, Object> taskEventParamMap) {
        super(changeObject, orgChangeType, taskEventParamMap);
    }

    @Override
    protected void validate() {
        long changRecordId = this.changeObject.getLong("id");
        DynamicObjectCollection entryEntity = this.changeObject.getDynamicObjectCollection("entryentity");
        ArrayList<OrgParam> orgParamList = new ArrayList<OrgParam>(entryEntity.size());
        for (DynamicObject entryObj : entryEntity) {
            DynamicObject orgObj = entryObj.getDynamicObject("org");
            if (orgObj == null) {
                this.addErrorMessage(entryObj, OrgMessage.getMessage((String)"M00199"));
                continue;
            }
            DynamicObject bizObj = entryObj.getDynamicObject("biz");
            if (bizObj == null) {
                this.addErrorMessage(entryObj, OrgMessage.getMessage((String)"M00001"));
                continue;
            }
            OrgParam orgParam = new OrgParam();
            orgParamList.add(orgParam);
            orgParam.setChangeRecordId(changRecordId);
            orgParam.setId(orgObj.getLong("id"));
            TreeMap<String, OrgDutyView> multiViewMap = new TreeMap<String, OrgDutyView>();
            orgParam.setMultiViewMap(multiViewMap);
            OrgDutyView orgDutyView = new OrgDutyView();
            multiViewMap.put(bizObj.getString("fnumber"), orgDutyView);
            HashMap<String, Long> propertyMap = new HashMap<String, Long>(2);
            orgDutyView.setPropertyMap(propertyMap);
            DynamicObject handoverOrgObj = entryObj.getDynamicObject("handoverorg");
            long handoverOrgId = handoverOrgObj == null ? 0L : handoverOrgObj.getLong("id");
            propertyMap.put("handoverOrgId", handoverOrgId);
        }
        this.taskEventParamMap.put("OrgChangeEventOrgParam", orgParamList);
    }
}

