/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.task.change;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.task.change.AbstractOrgChangeEvent;
import kd.bos.org.task.change.OrgBizFreezeChangeEvent;
import kd.bos.org.task.change.OrgBizUnFreezeChangeEvent;
import kd.bos.org.task.change.OrgResetRootChangeEvent;
import kd.bos.org.utils.OrgChangeType;

public class OrgChangeEventFactory {
    private static final Log log = LogFactory.getLog(OrgChangeEventFactory.class);

    public static AbstractOrgChangeEvent get(DynamicObject changeObject, Map<String, Object> taskEventParamMap) {
        AbstractOrgChangeEvent event;
        String changeType = changeObject.getString("changetype");
        if (OrgChangeType.RESETROOT.getChangeType().equals(changeType)) {
            event = new OrgResetRootChangeEvent(changeObject, OrgChangeType.RESETROOT, taskEventParamMap);
        } else if (OrgChangeType.BIZFREEZE.getChangeType().equals(changeType)) {
            event = new OrgBizFreezeChangeEvent(changeObject, OrgChangeType.BIZFREEZE, taskEventParamMap);
        } else if (OrgChangeType.BIZUNFREEZE.getChangeType().equals(changeType)) {
            event = new OrgBizUnFreezeChangeEvent(changeObject, OrgChangeType.BIZUNFREEZE, taskEventParamMap);
        } else {
            log.info(changeType + "\uff1a\u53d8\u66f4\u7c7b\u578b\u4e0d\u5b58\u5728\uff0c\u6216\u8005\u672a\u6dfb\u52a0\u5b9e\u73b0\u7c7b\u3002");
            return null;
        }
        return event;
    }
}

