/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.task.change;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.base.utils.msg.BaseMessage;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.task.change.AbstractOrgChangeEvent;
import kd.bos.org.task.change.OrgChangeEventFactory;
import kd.bos.org.utils.TaskStatus;
import kd.bos.org.utils.Utils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class OrgChangeTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(OrgChangeTask.class);
    private List<AbstractOrgChangeEvent> changeEvents = new ArrayList<AbstractOrgChangeEvent>();

    public void execute(RequestContext requestContext, Map<String, Object> taskParamMap) throws KDException {
        log.info("\u5f00\u59cb\u6267\u884c\u7ec4\u7ec7\u53d8\u66f4\u4efb\u52a1\u3002");
        try {
            this.buildEvent(taskParamMap);
            if (!this.changeEvents.isEmpty()) {
                this.execute();
                this.afterDoOperation();
            }
        }
        catch (Exception e) {
            log.info("\u6267\u884c\u7ec4\u7ec7\u53d8\u66f4\u8c03\u5ea6\u4efb\u52a1\u53d1\u751f\u5f02\u5e38\u3002", (Object)e);
            this.endWithException(e);
        }
        log.info("\u5b8c\u6210\u6267\u884c\u7ec4\u7ec7\u53d8\u66f4\u4efb\u52a1\uff1a" + this.changeEvents.size());
    }

    private void buildEvent(Map<String, Object> taskParamMap) {
        QFilter executionDateFilter = new QFilter("executiondate", "=", (Object)Utils.getDate((int)0));
        QFilter executionStatusFilter = new QFilter("executionstatus", "=", (Object)TaskStatus.A);
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter[] filters = new QFilter[]{executionDateFilter, executionStatusFilter, enableFilter};
        Map changeRecordMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org_changerecord", (QFilter[])filters);
        if (CollectionUtils.isEmpty((Map)changeRecordMap)) {
            return;
        }
        long currUserId = RequestContext.get().getCurrUserId();
        Date modifyTime = Calendar.getInstance().getTime();
        for (Map.Entry entry : changeRecordMap.entrySet()) {
            DynamicObject changeObject = (DynamicObject)entry.getValue();
            changeObject.set("modifier", (Object)currUserId);
            changeObject.set("modifytime", (Object)modifyTime);
            String changeType = changeObject.getString("changetype");
            if (StringUtils.isBlank((CharSequence)changeType)) {
                this.genExceptionChangeObject(changeObject, ResManager.loadKDString((String)"\u201c\u53d8\u66f4\u7c7b\u578b\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OrgChangeTask_0", (String)"bos-mservice-org", (Object[])new Object[0]));
                continue;
            }
            AbstractOrgChangeEvent event = OrgChangeEventFactory.get(changeObject, taskParamMap);
            if (event == null) {
                this.genExceptionChangeObject(changeObject, ResManager.loadKDString((String)"\u201c\u53d8\u66f4\u7c7b\u578b\u201d\u5bf9\u5e94\u7684\u5904\u7406\u7c7b\u4e0d\u5b58\u5728\u3002", (String)"OrgChangeTask_1", (String)"bos-mservice-org", (Object[])new Object[0]));
                continue;
            }
            changeObject.set("executionstatus", (Object)TaskStatus.B);
            event.validate();
            this.changeEvents.add(event);
        }
        SaveServiceHelper.save((DynamicObject[])changeRecordMap.values().toArray(new DynamicObject[0]));
    }

    private void execute() {
        for (AbstractOrgChangeEvent event : this.changeEvents) {
            event.execute();
        }
    }

    private void endWithException(Exception e) {
        String exceptionMessage;
        if (e.getMessage() == null) {
            exceptionMessage = BaseMessage.getMessage((String)"M00060");
        } else {
            exceptionMessage = e.getMessage();
            if (exceptionMessage.length() > 255) {
                exceptionMessage = exceptionMessage.substring(0, 255);
            }
        }
        Object[] changeRecordIds = new Object[this.changeEvents.size()];
        DynamicObjectType dynamicObjectType = null;
        for (int i = 0; i < this.changeEvents.size(); ++i) {
            AbstractOrgChangeEvent event = this.changeEvents.get(i);
            DynamicObject changeObject = event.getChangeObject();
            changeRecordIds[i] = changeObject.getPkValue();
            if (dynamicObjectType != null) continue;
            dynamicObjectType = changeObject.getDynamicObjectType();
        }
        if (dynamicObjectType == null) {
            return;
        }
        DynamicObject[] changeObjects = BusinessDataServiceHelper.load((Object[])changeRecordIds, dynamicObjectType);
        if (changeObjects == null || changeObjects.length == 0) {
            return;
        }
        for (DynamicObject changeObject : changeObjects) {
            this.genExceptionChangeObject(changeObject, exceptionMessage);
        }
        SaveServiceHelper.save((DynamicObject[])changeObjects);
    }

    private void genExceptionChangeObject(DynamicObject changeObject, String exceptionMessage) {
        changeObject.set("executionstatus", (Object)TaskStatus.E);
        changeObject.set("result", (Object)exceptionMessage);
        changeObject.set("failcount", (Object)changeObject.getInt("totalcount"));
    }

    private void afterDoOperation() {
        for (AbstractOrgChangeEvent event : this.changeEvents) {
            event.afterDoOperation();
        }
    }
}

