/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.task.change;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.utils.BaseUtils;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.task.change.AbstractOrgChangeEvent;
import kd.bos.org.utils.OrgChangeType;
import kd.bos.org.utils.OrgUtils;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;

public class OrgResetRootChangeEvent
extends AbstractOrgChangeEvent {
    private static final Log logger = LogFactory.getLog(OrgResetRootChangeEvent.class);

    public OrgResetRootChangeEvent(DynamicObject changeObject, OrgChangeType orgChangeType, Map<String, Object> taskEventParamMap) {
        super(changeObject, orgChangeType, taskEventParamMap);
    }

    @Override
    protected void execute() {
        logger.info("OrgResetRootChangeEvent#newRootOrg start,bos_org_changerecord number is {},params is {}", this.changeObject.get("number"), (Object)this.taskEventParamMap);
        try (TXHandle h1 = TX.required();){
            try {
                Map<Object, DynamicObject> viewIdRootOrgObjMap = this.loadViewIdRootOrgObjMap();
                DynamicObject newRoot = this.newRootOrgByOrgUnitRootObj(viewIdRootOrgObjMap.get(15L), viewIdRootOrgObjMap, this.taskEventParamMap);
                Map<Object, DynamicObject> viewIdViewObjMap = this.loadViewIdViewObjMap();
                Map<Object, DynamicObject> viewIdRootOrgObjMap1 = this.loadViewIdRootOrgObjMap();
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("orgChangeRecordId", this.changeObject.getString("id"));
                Set<DynamicObject> roots = this.changeParent(newRoot, viewIdRootOrgObjMap1, viewIdViewObjMap, operateOption);
                this.newOperateOption(newRoot, operateOption);
                OperationResult operationResult = OperationServiceHelper.executeOperate((String)"resetroot", (String)"bos_org", (DynamicObject[])roots.toArray(new DynamicObject[roots.size()]), (OperateOption)operateOption);
                String operationResultError = BaseUtils.getOperationResultError((OperationResult)operationResult, (boolean)true);
                if (StringUtils.isNotBlank((CharSequence)operationResultError)) {
                    logger.info("kd.bos.org.task.change.OrgResetRootChangeEvent#newRootOrg fail,message is {},allErrorOrValidateInfo is {}", (Object)operationResult.getMessage(), (Object)operationResult.getAllErrorOrValidateInfo());
                    throw new KDBizException(operationResultError);
                }
            }
            catch (Exception e) {
                h1.markRollback();
                logger.error("\u91cd\u7f6e\u6839\u7ec4\u7ec7\u4efb\u52a1\u5931\u8d25", (Object)e.getMessage());
                throw new KDBizException(e.getMessage());
            }
            logger.info("OrgResetRootChangeEvent#newRootOrg end");
        }
    }

    private void newOperateOption(DynamicObject newRoot, OperateOption operateOption) {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>(8);
        map.put("changerecordid", Long.valueOf(this.changeObject.getLong("id")));
        DynamicObjectCollection viewDoc = this.changeObject.getDynamicObjectCollection("entryentity");
        int count = viewDoc.size();
        ArrayList synViews = new ArrayList(count);
        ArrayList unSynViews = new ArrayList(count);
        for (DynamicObject obj : viewDoc) {
            HashMap<String, Object> view = new HashMap<String, Object>(4);
            DynamicObject viewObj = obj.getDynamicObject("view");
            DynamicObject orgObj = obj.getDynamicObject("org");
            if (viewObj == null || orgObj == null) continue;
            view.put("viewid", viewObj.getPkValue());
            view.put("oldrootid", orgObj.getPkValue());
            if (!ObjectUtils.isEmpty((Object)obj.get("biz"))) {
                view.put("newrootid", newRoot.getPkValue());
                synViews.add(view);
                continue;
            }
            view.put("newrootid", orgObj.getPkValue());
            unSynViews.add(view);
        }
        map.put("synviews", synViews);
        map.put("unsynviews", unSynViews);
        operateOption.setVariableValue("base_orgchange_resetroot", SerializationUtils.toJsonString(map));
    }

    private DynamicObject newRootOrgByOrgUnitRootObj(DynamicObject orgUnitRootObj, Map<Object, DynamicObject> viewIdRootOrgObjMap, Map<String, Object> params) {
        DynamicObject newRoot = new DynamicObject(orgUnitRootObj.getDynamicObjectType());
        ORM orm = ORM.create();
        long id = orm.genLongId("bos_org");
        newRoot.set("id", (Object)id);
        newRoot.set("number", params.get("newrootorgnumber"));
        newRoot.set("name", params.get("newrootorgname"));
        this.copy(orgUnitRootObj, newRoot, viewIdRootOrgObjMap);
        return newRoot;
    }

    private Map<Object, DynamicObject> loadViewIdRootOrgObjMap() {
        QFilter parent = new QFilter("parent", "=", (Object)0);
        QFilter level = new QFilter("level", "=", (Object)1);
        QFilter[] filters = new QFilter[]{parent, level};
        DynamicObjectCollection structureDoc = QueryServiceHelper.query((String)"bos_org_structure", (String)"view,org", (QFilter[])filters);
        HashMap<Object, Object> viewIdRootOrgIdMap = new HashMap<Object, Object>(structureDoc.size());
        structureDoc.forEach(e -> viewIdRootOrgIdMap.put(e.get("view"), e.get("org")));
        Set rootOrgIds = viewIdRootOrgIdMap.values().stream().collect(Collectors.toSet());
        HashMap<Object, DynamicObject> result = new HashMap<Object, DynamicObject>(structureDoc.size());
        DynamicObject[] orgObjArr = BusinessDataServiceHelper.load((Object[])rootOrgIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bos_org"));
        HashMap orgIdOrgObjMap = new HashMap(orgObjArr.length);
        Arrays.stream(orgObjArr).forEach(e -> orgIdOrgObjMap.put(e.getPkValue(), e));
        viewIdRootOrgIdMap.forEach((viewId, rootOrgId) -> {
            DynamicObject cfr_ignored_0 = (DynamicObject)result.put(viewId, (DynamicObject)orgIdOrgObjMap.get(rootOrgId));
        });
        return result;
    }

    private Set<Long> getSynViewIds() {
        DynamicObjectCollection viewDoc = this.changeObject.getDynamicObjectCollection("entryentity");
        HashSet<Long> synViewIds = new HashSet<Long>(viewDoc.size());
        for (DynamicObject obj : viewDoc) {
            if (ObjectUtils.isEmpty((Object)obj.get("biz")) || ObjectUtils.isEmpty((Object)obj.get("view"))) continue;
            synViewIds.add(obj.getDynamicObject("view").getLong("id"));
        }
        return synViewIds;
    }

    private void copy(DynamicObject oldRoot, DynamicObject newRoot, Map<Object, DynamicObject> viewIdRootOrgObjMap) {
        this.copyBaseInfo(oldRoot, newRoot, new String[]{"simplename", "orgpattern", "fcomment"});
        this.copyBiz(oldRoot, newRoot);
        this.copyBizView(oldRoot, newRoot, viewIdRootOrgObjMap);
    }

    private void copyBaseInfo(DynamicObject oldRoot, DynamicObject newRoot, String[] fields) {
        for (String field : fields) {
            newRoot.set(field, oldRoot.get(field));
        }
    }

    private void copyBiz(DynamicObject oldRoot, DynamicObject newRoot) {
        List lstSysBizs = OrgUtils.getAllOrgBizNameList();
        Set collect = oldRoot.getDynamicObjectType().getProperties().stream().map(e -> e.getName()).collect(Collectors.toSet());
        for (DynamicObject bizObj : lstSysBizs) {
            String propertyName = bizObj.getString("propertyname");
            if (!collect.contains(propertyName)) continue;
            newRoot.set(propertyName, oldRoot.get(propertyName));
        }
    }

    private void copyBizView(DynamicObject oldRoot, DynamicObject newRoot, Map<Object, DynamicObject> viewIdRootOrgObjMap) {
        DynamicObjectCollection newStructureEntry = newRoot.getDynamicObjectCollection("structure");
        DynamicObjectType structureType = newStructureEntry.getDynamicObjectType();
        oldRoot = BusinessDataServiceHelper.loadSingle((Object)oldRoot.getPkValue(), (String)"bos_org");
        DynamicObject viewOrgObj = this.copyDynamicObjectOnlyId(newRoot);
        Set<Object> copyViewIds = this.queryBaseViewIds();
        for (DynamicObject oldStructureObj : oldRoot.getDynamicObjectCollection("structure")) {
            if (ObjectUtils.isEmpty((Object)oldStructureObj.getDynamicObject("view")) || !copyViewIds.contains(oldStructureObj.getDynamicObject("view").getPkValue())) continue;
            logger.info("OrgResetRootChangeEvent#copyBizView oldRoot view is {}", (Object)oldStructureObj.getDynamicObject("view").getString("number"));
            DynamicObject newStructureObj = new DynamicObject(structureType);
            newStructureObj.set("vieworg", (Object)viewOrgObj);
            newStructureObj.set("view", (Object)oldStructureObj.getDynamicObject("view"));
            newStructureObj.set("viewparent", (Object)viewIdRootOrgObjMap.getOrDefault(oldStructureObj.getDynamicObject("view").getPkValue(), oldRoot));
            newStructureEntry.add((Object)newStructureObj);
        }
    }

    private Map<Object, DynamicObject> loadViewIdViewObjMap() {
        String selectFields = "id,number,name,treetype,treetypeid,isdefault";
        QFilter[] filters = new QFilter[]{new QFilter("isdefault", "=", (Object)Boolean.TRUE)};
        Map viewIdViewObjMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org_viewschema", (String)selectFields, (QFilter[])filters);
        return viewIdViewObjMap;
    }

    private Set<DynamicObject> changeParent(DynamicObject newRoot, Map<Object, DynamicObject> viewIdRootOrgObjMap, Map<Object, DynamicObject> viewIdViewObjMap, OperateOption operateOption) {
        HashSet<DynamicObject> result = new HashSet<DynamicObject>();
        Set<Long> synViewIds = this.getSynViewIds();
        DynamicObjectCollection structureDoc = newRoot.getDynamicObjectCollection("structure");
        DynamicObject toNewRoot = this.copyDynamicObjectOnlyId(newRoot);
        HashMap<Long, Map> orgBizHandoverMap = new HashMap<Long, Map>(viewIdViewObjMap.size());
        for (DynamicObject structureObj : structureDoc) {
            DynamicObject viewObj = viewIdViewObjMap.get(structureObj.getDynamicObject("view").getPkValue());
            if (viewObj == null || viewObj.getDynamicObject("treetypeid") == null || !synViewIds.contains(viewObj.getLong("id"))) continue;
            logger.info("OrgResetRootChangeEvent#changeParent synviewid is {}", (Object)viewObj.getLong("id"));
            structureObj.set("viewparent", null);
            DynamicObject oldViewRootOrgObj = viewIdRootOrgObjMap.get(viewObj.getPkValue());
            if (oldViewRootOrgObj == null) continue;
            Map bizHandoverMap = orgBizHandoverMap.computeIfAbsent(oldViewRootOrgObj.getLong("id"), v -> new HashMap(64));
            DynamicObjectCollection oldStructureDoc = oldViewRootOrgObj.getDynamicObjectCollection("structure");
            DynamicObject dynamicObject = null;
            for (DynamicObject oldStructureObj : oldStructureDoc) {
                DynamicObject oldViewObj = oldStructureObj.getDynamicObject("view");
                if (ObjectUtils.isEmpty((Object)oldViewObj) || !oldViewObj.getPkValue().equals(viewObj.getPkValue())) continue;
                dynamicObject = oldStructureObj;
                DynamicObject bizObj = oldViewObj.getDynamicObject("treetypeid");
                if (bizObj == null) break;
                bizHandoverMap.put(bizObj.getString("fnumber"), 0L);
                break;
            }
            if (ObjectUtils.isEmpty(dynamicObject)) continue;
            dynamicObject.set("viewparent", (Object)toNewRoot);
            result.add(oldViewRootOrgObj);
        }
        result.add(newRoot);
        operateOption.setVariableValue("orgChangeOperationParam", SerializationUtils.toJsonString(orgBizHandoverMap));
        return result;
    }

    private DynamicObject copyDynamicObjectOnlyId(DynamicObject newRoot) {
        Map orgEntityTypeMap = OrgUtils.getOrgEntityDynamicObjectType((DynamicObject)newRoot);
        DynamicObjectType orgType = (DynamicObjectType)orgEntityTypeMap.get("org");
        DynamicObject toNewRoot = new DynamicObject(orgType);
        toNewRoot.set("id", (Object)newRoot.getLong("id"));
        return toNewRoot;
    }

    private Set<Object> queryBaseViewIds() {
        HashSet<Object> showViewIds = new HashSet<Object>();
        StringBuilder urcQuery = new StringBuilder();
        BillEntityType dt = (BillEntityType)EntityMetadataCache.getDataEntityType((String)"bos_org_viewschema");
        String dbRouteKey = dt.getDBRouteKey();
        urcQuery.append(" select vs.fid,vs.fnumber,vs.ftreetype,biz.fnumber,biz.fname,biz.ffieldname,biz.fpropertyname from t_org_bizlist biz ");
        urcQuery.append(" inner join t_org_viewschema vs ");
        urcQuery.append(" on biz.fid = vs.ftreetypeid ");
        urcQuery.append(" where biz.fenable = '1' and biz.fvisiable = '1' and biz.fbasemaintain = '1' and vs.fisdefault='1'; ");
        try (DataSet ds = DB.queryDataSet((String)OrgResetRootChangeEvent.class.getName(), (DBRoute)DBRoute.of((String)dbRouteKey), (String)urcQuery.toString());){
            Iterator iter = ds.iterator();
            while (iter.hasNext()) {
                showViewIds.add(((Row)iter.next()).get("fid"));
            }
        }
        return showViewIds;
    }
}

