/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.upgrade;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.util.CollectionUtils;

public class OrgRelationDeptPermUpgradeService
implements IUpgradeService {
    private static final String lockKey = "ORGRELATIONDEPTPERMUPGRADESERVICE#BOS_ORG_DEPT#BOS_ORG_ORGRELATION_DEPT";
    private static final Log logger = LogFactory.getLog(OrgRelationDeptPermUpgradeService.class);
    private static final String oldEntityTypeId = "bos_org_dept";
    private static final String newEntityTypeId = "bos_org_orgrelation_dept";
    private static final String PERMITEM_CHAXUN = "47150e89000000ac";
    private static final String PERMITEM_YICHU = "0=KX5+RLFFVN";
    private static final String PERMITEM_TIANJIA = "0=KX5+RHU1BB";
    private static final String PERMITEM_SHANCHU = "4715e1f1000000ac";
    private static final String PERMITEM_XINZENG = "47156aff000000ac";
    private static final String PERMITEM_XIUGAI = "4715a0df000000ac";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        logger.info("OrgRelationDeptPermUpgradeService#afterExecuteSqlWithResult start");
        UpgradeResult result = new UpgradeResult();
        DLock lock = DLock.create((String)lockKey);
        if (!lock.tryLock()) {
            logger.info("OrgRelationDeptPermUpgradeService#afterExecuteSqlWithResult tryLock fail");
            result.setSuccess(false);
            return result;
        }
        result.setSuccess(true);
        try (TXHandle tx = TX.requiresNew();){
            try {
                this.upgradeChaXunChaXun();
                this.upgradeYiChu2ShanChu();
                this.upgradeTianJia2XinZeng_XiuGai_BaoCun();
            }
            catch (Exception e) {
                tx.markRollback();
                result.setSuccess(false);
                logger.error("OrgRelationDeptPermUpgradeService#afterExecuteSqlWithResult error", (Throwable)e);
            }
        }
        finally {
            lock.unlock();
        }
        logger.info("OrgRelationDeptPermUpgradeService#afterExecuteSqlWithResult end,result is {}", (Object)result);
        return result;
    }

    private void upgradeChaXunChaXun() {
        this.copyPermForUserPermDetail(oldEntityTypeId, newEntityTypeId, PERMITEM_CHAXUN, PERMITEM_CHAXUN);
        this.copyPermForRolePermDetail(oldEntityTypeId, newEntityTypeId, PERMITEM_CHAXUN, PERMITEM_CHAXUN);
        this.copyPermForDisFunPerm(oldEntityTypeId, newEntityTypeId, PERMITEM_CHAXUN, PERMITEM_CHAXUN);
        this.copyPermForBizRolePerm(oldEntityTypeId, newEntityTypeId, PERMITEM_CHAXUN, PERMITEM_CHAXUN);
        this.copyPermForBizRoleDisPerm(oldEntityTypeId, newEntityTypeId, PERMITEM_CHAXUN, PERMITEM_CHAXUN);
    }

    private void upgradeYiChu2ShanChu() {
        this.copyPermForUserPermDetail(oldEntityTypeId, newEntityTypeId, PERMITEM_YICHU, PERMITEM_SHANCHU);
        this.copyPermForRolePermDetail(oldEntityTypeId, newEntityTypeId, PERMITEM_YICHU, PERMITEM_SHANCHU);
        this.copyPermForDisFunPerm(oldEntityTypeId, newEntityTypeId, PERMITEM_YICHU, PERMITEM_SHANCHU);
        this.copyPermForBizRolePerm(oldEntityTypeId, newEntityTypeId, PERMITEM_YICHU, PERMITEM_SHANCHU);
        this.copyPermForBizRoleDisPerm(oldEntityTypeId, newEntityTypeId, PERMITEM_YICHU, PERMITEM_SHANCHU);
    }

    private void upgradeTianJia2XinZeng_XiuGai_BaoCun() {
        this.copyPermForUserPermDetail(oldEntityTypeId, newEntityTypeId, PERMITEM_TIANJIA, PERMITEM_XINZENG, PERMITEM_XIUGAI);
        this.copyPermForRolePermDetail(oldEntityTypeId, newEntityTypeId, PERMITEM_TIANJIA, PERMITEM_XINZENG, PERMITEM_XIUGAI);
        this.copyPermForDisFunPerm(oldEntityTypeId, newEntityTypeId, PERMITEM_TIANJIA, PERMITEM_XINZENG, PERMITEM_XIUGAI);
        this.copyPermForBizRolePerm(oldEntityTypeId, newEntityTypeId, PERMITEM_TIANJIA, PERMITEM_XINZENG, PERMITEM_XIUGAI);
        this.copyPermForBizRoleDisPerm(oldEntityTypeId, newEntityTypeId, PERMITEM_TIANJIA, PERMITEM_XINZENG, PERMITEM_XIUGAI);
    }

    private void copyPermForRolePermDetail(String oldEntityTypeId, String newEntityTypeId, String oldPermIemId, String ... newPermItemIds) {
        try (DataSet dataSet = this.queryForRolePermDetail(oldEntityTypeId, oldPermIemId);){
            HashSet<String> exist = new HashSet<String>();
            int count = this.existForRolePermDetail(exist, dataSet.copy(), newEntityTypeId, newPermItemIds);
            this.insertForUserRolePermDetail(exist, dataSet, count, newEntityTypeId, newPermItemIds);
        }
    }

    private int existForRolePermDetail(final Set<String> exist, DataSet dataSet, String newEntityTypeId, String ... newPermItemIds) {
        HashSet<Object> bizAppIds = new HashSet<Object>();
        HashSet<Object> roleIds = new HashSet<Object>();
        int count = 0;
        for (Row row : dataSet) {
            bizAppIds.add(row.get("fbizappid"));
            roleIds.add(row.get("froleid"));
            ++count;
        }
        SqlBuilder existSql = new SqlBuilder();
        existSql.append("select fbizappid,fentitytypeid,fpermitemid,froleid from t_perm_rolepermdetial", new Object[0]);
        existSql.append(" where fentitytypeid = ?", new Object[]{newEntityTypeId});
        existSql.appendIn(" and fpermitemid", (Object[])newPermItemIds);
        if (!CollectionUtils.isEmpty(bizAppIds)) {
            existSql.appendIn(" and fbizappid ", bizAppIds.toArray());
        }
        if (!CollectionUtils.isEmpty(roleIds)) {
            existSql.appendIn(" and froleid", roleIds.toArray());
        }
        DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)existSql, (ResultSetHandler)new ResultSetHandler<Set<String>>(){

            public Set<String> handle(ResultSet rs) throws SQLException {
                while (rs.next()) {
                    exist.add(rs.getObject("fbizappid") + "_" + rs.getObject("fentitytypeid") + "_" + rs.getObject("fpermitemid") + "_" + rs.getObject("froleid"));
                }
                return exist;
            }
        });
        return count;
    }

    private void insertForUserRolePermDetail(Set<String> exist, DataSet dataSet, int count, String newEntityTypeId, String ... newPermItemIds) {
        StringBuilder insertSql = new StringBuilder();
        insertSql.append("INSERT INTO t_perm_rolepermdetial");
        insertSql.append(" (fid, fentryid, fseq, fcontrolmode, fpermitemid, finheritmode, fentitytypeid, fbizappid, froleid)");
        insertSql.append(" VALUES(?,?,?,?,?,?,?,?,?);");
        String[] entryIds = DB.genStringIds((String)"t_perm_rolepermdetial", (int)(count * newPermItemIds.length));
        int index = 0;
        ArrayList<Object[]> insertParams = new ArrayList<Object[]>(10);
        for (Row row : dataSet) {
            for (String newPermItemId : newPermItemIds) {
                String unique = row.get("fbizappid") + "_" + newEntityTypeId + "_" + newPermItemId + "_" + row.get("froleid");
                if (exist.contains(unique)) continue;
                Object[] params = new Object[]{row.get("fid"), entryIds[index++], row.get("fseq"), row.get("fcontrolmode"), newPermItemId, row.get("finheritmode"), newEntityTypeId, row.get("fbizappid"), row.get("froleid")};
                insertParams.add(params);
            }
        }
        if (insertParams.size() <= 0) {
            return;
        }
        DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql.toString(), insertParams);
    }

    private DataSet queryForRolePermDetail(String oldEntityTypeId, String oldPermIemId) {
        StringBuilder querySql = new StringBuilder();
        querySql.append("select fid, fentryid, fseq, fcontrolmode, fpermitemid, finheritmode, fentitytypeid, fbizappid, froleid from t_perm_rolepermdetial ");
        querySql.append(" where fentitytypeid = ?");
        querySql.append(" and fpermitemid = ? ;");
        Object[] queryParam = new Object[]{oldEntityTypeId, oldPermIemId};
        return DB.queryDataSet((String)"OrgRelationDeptPermUpgradeService#queryForRolePermDetail", (DBRoute)DBRoute.basedata, (String)querySql.toString(), (Object[])queryParam);
    }

    private void copyPermForDisFunPerm(String oldEntityTypeId, String newEntityTypeId, String oldPermIemId, String ... newPermItemIds) {
        try (DataSet dataSet = this.queryForDisFunPerm(oldEntityTypeId, oldPermIemId);){
            HashSet<String> exist = new HashSet<String>();
            int count = this.existForDisFunPerm(exist, dataSet.copy(), newEntityTypeId, newPermItemIds);
            this.insertForUserRoleDisFunPerm(exist, dataSet, count, newEntityTypeId, newPermItemIds);
        }
    }

    private int existForDisFunPerm(final Set<String> exist, DataSet dataSet, String newEntityTypeId, String ... newPermItemIds) {
        HashSet<Object> userIds = new HashSet<Object>();
        HashSet<Object> orgIds = new HashSet<Object>();
        HashSet<Object> bizAppIds = new HashSet<Object>();
        int count = 0;
        for (Row row : dataSet) {
            userIds.add(row.get("fuserid"));
            orgIds.add(row.get("forgid"));
            bizAppIds.add(row.get("fbizappid"));
            ++count;
        }
        SqlBuilder existSql = new SqlBuilder();
        existSql.append("select fuserid,forgid,fbizappid,fentitytypeid,fpermitemid,fdimtype,fisincludesuborg from t_perm_disfunperm", new Object[0]);
        existSql.append(" where fentitytypeid = ?", new Object[]{newEntityTypeId});
        existSql.appendIn(" and fpermitemid", (Object[])newPermItemIds);
        if (!CollectionUtils.isEmpty(userIds)) {
            existSql.appendIn(" and fuserid ", userIds.toArray());
        }
        if (!CollectionUtils.isEmpty(orgIds)) {
            existSql.appendIn(" and forgid ", orgIds.toArray());
        }
        if (!CollectionUtils.isEmpty(bizAppIds)) {
            existSql.appendIn(" and fbizappid", bizAppIds.toArray());
        }
        DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)existSql, (ResultSetHandler)new ResultSetHandler<Set<String>>(){

            public Set<String> handle(ResultSet rs) throws SQLException {
                while (rs.next()) {
                    exist.add(rs.getObject("fuserid") + "_" + rs.getObject("forgid") + "_" + rs.getObject("fbizappid") + "_" + rs.getObject("fentitytypeid") + "_" + rs.getObject("fpermitemid") + "_" + rs.getObject("fdimtype") + "_" + rs.getObject("fisincludesuborg"));
                }
                return exist;
            }
        });
        return count;
    }

    private void insertForUserRoleDisFunPerm(Set<String> exist, DataSet copy, int count, String newEntityTypeId, String ... newPermItemIds) {
        StringBuilder insertSql = new StringBuilder();
        insertSql.append("INSERT INTO t_perm_disfunperm");
        insertSql.append(" (fid, fuserid, forgid, fpermitemid, fentitytypeid, fentryid, ffrom, fbizappid, fsource, fbizroleid, fdimtype, fisincludesuborg)");
        insertSql.append(" VALUES(?,?,?,?,?,?,?,?,?,?,?,?);");
        ArrayList<Object[]> insertParams = new ArrayList<Object[]>(10);
        String[] ids = DB.genStringIds((String)"t_perm_rolepermdetial", (int)(count * newPermItemIds.length));
        int index = 0;
        for (Row row : copy) {
            for (String newPermItemId : newPermItemIds) {
                String unique = row.get("fuserid") + "_" + row.get("forgid") + "_" + row.get("fbizappid") + "_" + newEntityTypeId + "_" + newPermItemId + "_" + row.get("fdimtype") + "_" + row.get("fisincludesuborg");
                if (exist.contains(unique)) continue;
                Object[] params = new Object[]{ids[index++], row.get("fuserid"), row.get("forgid"), newPermItemId, newEntityTypeId, row.get("fentryid"), row.get("ffrom"), row.get("fbizappid"), row.get("fsource"), row.get("fbizroleid"), row.get("fdimtype"), row.get("fisincludesuborg")};
                insertParams.add(params);
            }
        }
        if (insertParams.size() <= 0) {
            return;
        }
        DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql.toString(), insertParams);
    }

    private DataSet queryForDisFunPerm(String oldEntityTypeId, String oldPermIemId) {
        StringBuilder querySql = new StringBuilder();
        querySql.append("select fid, fuserid, forgid, fpermitemid, fentitytypeid, fentryid, ffrom, fbizappid, fsource, fbizroleid, fdimtype, fisincludesuborg from t_perm_disfunperm ");
        querySql.append(" where fentitytypeid = ?");
        querySql.append(" and fpermitemid = ? ;");
        Object[] queryParam = new Object[]{oldEntityTypeId, oldPermIemId};
        return DB.queryDataSet((String)"OrgRelationDeptPermUpgradeService#queryForDisFunPerm", (DBRoute)DBRoute.basedata, (String)querySql.toString(), (Object[])queryParam);
    }

    private void copyPermForBizRolePerm(String oldEntityTypeId, String newEntityTypeId, String oldPermIemId, String ... newPermItemIds) {
        try (DataSet dataSet = this.queryForBizRolePerm(oldEntityTypeId, oldPermIemId);){
            HashSet<String> exist = new HashSet<String>();
            int count = this.existForBizRolePerm(exist, dataSet.copy(), newEntityTypeId, newPermItemIds);
            this.insertForBizRolePerm(exist, dataSet, count, newEntityTypeId, newPermItemIds);
        }
    }

    private int existForBizRolePerm(final Set<String> exist, DataSet dataSet, String newEntityTypeId, String[] newPermItemIds) {
        HashSet<Object> ids = new HashSet<Object>();
        HashSet<Object> bizAppIds = new HashSet<Object>();
        int count = 0;
        for (Row row : dataSet) {
            ids.add(row.get("fid"));
            bizAppIds.add(row.get("fbizappid"));
            ++count;
        }
        SqlBuilder existSql = new SqlBuilder();
        existSql.append("select fentryid, fid, fseq, fpermitemid, fentitytypeid, fbizappid from t_perm_bizroleperm", new Object[0]);
        existSql.append(" where fentitytypeid = ?", new Object[]{newEntityTypeId});
        existSql.appendIn(" and fpermitemid", (Object[])newPermItemIds);
        if (!CollectionUtils.isEmpty(ids)) {
            existSql.appendIn(" and  fid ", ids.toArray());
        }
        if (!CollectionUtils.isEmpty(bizAppIds)) {
            existSql.appendIn(" and fbizappid ", bizAppIds.toArray());
        }
        DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)existSql, (ResultSetHandler)new ResultSetHandler<Set<String>>(){

            public Set<String> handle(ResultSet rs) throws SQLException {
                while (rs.next()) {
                    exist.add(rs.getObject("fid") + "_" + rs.getObject("fpermitemid") + "_" + rs.getObject("fentitytypeid") + "_" + rs.getObject("fbizappid"));
                }
                return exist;
            }
        });
        return count;
    }

    private void insertForBizRolePerm(Set<String> exist, DataSet dataSet, int count, String newEntityTypeId, String[] newPermItemIds) {
        StringBuilder insertSql = new StringBuilder();
        insertSql.append("INSERT INTO t_perm_bizroleperm");
        insertSql.append(" (fentryid, fid, fseq, fpermitemid, fentitytypeid, fbizappid)");
        insertSql.append(" VALUES(?,?,?,?,?,?);");
        long[] entryIds = DB.genLongIds((String)"t_perm_rolepermdetial", (int)(count * newPermItemIds.length));
        int index = 0;
        ArrayList<Object[]> insertParams = new ArrayList<Object[]>(10);
        for (Row row : dataSet) {
            for (String newPermItemId : newPermItemIds) {
                String unique = row.get("fid") + "_" + newPermItemId + "_" + newEntityTypeId + "_" + row.get("fbizappid");
                if (exist.contains(unique)) continue;
                Object[] params = new Object[]{entryIds[index++], row.get("fid"), row.get("fseq"), newPermItemId, newEntityTypeId, row.get("fbizappid")};
                insertParams.add(params);
            }
        }
        if (insertParams.size() <= 0) {
            return;
        }
        DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql.toString(), insertParams);
    }

    private DataSet queryForBizRolePerm(String oldEntityTypeId, String oldPermIemId) {
        StringBuilder querySql = new StringBuilder();
        querySql.append("select fentryid, fid, fseq, fpermitemid, fentitytypeid, fbizappid from t_perm_bizroleperm ");
        querySql.append(" where fentitytypeid = ?");
        querySql.append(" and fpermitemid = ? ;");
        Object[] queryParam = new Object[]{oldEntityTypeId, oldPermIemId};
        return DB.queryDataSet((String)"", (DBRoute)DBRoute.basedata, (String)querySql.toString(), (Object[])queryParam);
    }

    private void copyPermForBizRoleDisPerm(String oldEntityTypeId, String newEntityTypeId, String oldPermIemId, String ... newPermItemIds) {
        try (DataSet dataSet = this.queryForBizRoleDisPerm(oldEntityTypeId, oldPermIemId);){
            HashSet<String> exist = new HashSet<String>();
            int count = this.existForBizRoleDisPerm(exist, dataSet.copy(), newEntityTypeId, newPermItemIds);
            this.insertForBizRoleDisPerm(exist, dataSet, count, newEntityTypeId, newPermItemIds);
        }
    }

    private int existForBizRoleDisPerm(final Set<String> exist, DataSet dataSet, String newEntityTypeId, String[] newPermItemIds) {
        HashSet<Object> ids = new HashSet<Object>();
        HashSet<Object> bizAppIds = new HashSet<Object>();
        int count = 0;
        for (Row row : dataSet) {
            ids.add(row.get("fid"));
            bizAppIds.add(row.get("fbizappid"));
            ++count;
        }
        SqlBuilder existSql = new SqlBuilder();
        existSql.append("select fentryid, fid, fseq, fpermitemid, fentitytypeid, fbizappid from t_perm_bizroledisperm", new Object[0]);
        existSql.append(" where fentitytypeid = ?", new Object[]{newEntityTypeId});
        existSql.appendIn(" and fpermitemid", (Object[])newPermItemIds);
        if (!CollectionUtils.isEmpty(ids)) {
            existSql.appendIn(" and  fid ", ids.toArray());
        }
        if (!CollectionUtils.isEmpty(bizAppIds)) {
            existSql.appendIn(" and fbizappid ", bizAppIds.toArray());
        }
        DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)existSql, (ResultSetHandler)new ResultSetHandler<Set<String>>(){

            public Set<String> handle(ResultSet rs) throws SQLException {
                while (rs.next()) {
                    exist.add(rs.getObject("fid") + "_" + rs.getObject("fpermitemid") + "_" + rs.getObject("fentitytypeid") + "_" + rs.getObject("fbizappid"));
                }
                return exist;
            }
        });
        return count;
    }

    private void insertForBizRoleDisPerm(Set<String> exist, DataSet dataSet, int count, String newEntityTypeId, String[] newPermItemIds) {
        StringBuilder insertSql = new StringBuilder();
        insertSql.append("INSERT INTO t_perm_bizroledisperm");
        insertSql.append(" (fentryid, fid, fseq, fpermitemid, fentitytypeid, fbizappid)");
        insertSql.append(" VALUES(?,?,?,?,?,?);");
        long[] entryIds = DB.genLongIds((String)"t_perm_rolepermdetial", (int)(count * newPermItemIds.length));
        int index = 0;
        ArrayList<Object[]> insertParams = new ArrayList<Object[]>(count * newPermItemIds.length);
        for (Row row : dataSet) {
            for (String newPermItemId : newPermItemIds) {
                String unique = row.get("fid") + "_" + newPermItemId + "_" + newEntityTypeId + "_" + row.get("fbizappid");
                if (exist.contains(unique)) continue;
                Object[] params = new Object[]{entryIds[index++], row.get("fid"), row.get("fseq"), newPermItemId, newEntityTypeId, row.get("fbizappid")};
                insertParams.add(params);
            }
        }
        if (insertParams.size() <= 0) {
            return;
        }
        DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql.toString(), insertParams);
    }

    private DataSet queryForBizRoleDisPerm(String oldEntityTypeId, String oldPermIemId) {
        StringBuilder querySql = new StringBuilder();
        querySql.append("select fentryid, fid, fseq, fpermitemid, fentitytypeid, fbizappid from t_perm_bizroledisperm ");
        querySql.append(" where fentitytypeid = ?");
        querySql.append(" and fpermitemid = ? ;");
        Object[] queryParam = new Object[]{oldEntityTypeId, oldPermIemId};
        return DB.queryDataSet((String)"OrgRelationDeptPermUpgradeService#queryForBizRoleDisPerm", (DBRoute)DBRoute.basedata, (String)querySql.toString(), (Object[])queryParam);
    }

    private void copyPermForUserPermDetail(String oldEntityTypeId, String newEntityTypeId, String oldPermIemId, String ... newPermItemIds) {
        try (DataSet dataSet = this.queryForUserPermDetail(oldEntityTypeId, oldPermIemId);){
            HashSet<String> exist = new HashSet<String>();
            int count = this.existForUserPermDetail(exist, dataSet.copy(), newEntityTypeId, newPermItemIds);
            this.insertForUserPermDetail(exist, dataSet, count, newEntityTypeId, newPermItemIds);
        }
    }

    private DataSet queryForUserPermDetail(String oldEntityTypeId, String oldPermIemId) {
        StringBuilder querySql = new StringBuilder();
        querySql.append("select fid, fuserid, fdimtype, fdimid, fisincludesub, fentryid, fseq, fcontrolmode, fpermitemid, fentitytypeid, fbizappid, fsource, fbizroleid from t_perm_userpermdetail ");
        querySql.append(" where fentitytypeid = ?");
        querySql.append(" and fpermitemid = ? ;");
        Object[] queryParam = new Object[]{oldEntityTypeId, oldPermIemId};
        return DB.queryDataSet((String)"OrgRelationDeptPermUpgradeService#queryForUserPermDetail", (DBRoute)DBRoute.basedata, (String)querySql.toString(), (Object[])queryParam);
    }

    private int existForUserPermDetail(final Set<String> exist, DataSet dataSet, String newEntityTypeId, String ... newPermItemIds) {
        HashSet<Object> userIds = new HashSet<Object>();
        HashSet<Object> bizAppIds = new HashSet<Object>();
        HashSet<Object> dimIds = new HashSet<Object>();
        int count = 0;
        for (Row row : dataSet) {
            userIds.add(row.get("fuserid"));
            bizAppIds.add(row.get("fbizappid"));
            dimIds.add(row.get("fdimid"));
            ++count;
        }
        SqlBuilder existSql = new SqlBuilder();
        existSql.append("select fuserid,fbizappid,fentitytypeid,fpermitemid,fdimid,fdimtype,fisincludesub from t_perm_userpermdetail", new Object[0]);
        existSql.append(" where fentitytypeid = ?", new Object[]{newEntityTypeId});
        existSql.appendIn(" and fpermitemid", (Object[])newPermItemIds);
        if (!CollectionUtils.isEmpty(userIds)) {
            existSql.appendIn(" and  fuserid ", userIds.toArray());
        }
        if (!CollectionUtils.isEmpty(bizAppIds)) {
            existSql.appendIn(" and fbizappid ", bizAppIds.toArray());
        }
        if (!CollectionUtils.isEmpty(dimIds)) {
            existSql.appendIn(" and fdimid ", dimIds.toArray());
        }
        DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)existSql, (ResultSetHandler)new ResultSetHandler<Set<String>>(){

            public Set<String> handle(ResultSet rs) throws SQLException {
                while (rs.next()) {
                    exist.add(rs.getObject("fuserid") + "_" + rs.getObject("fbizappid") + "_" + rs.getObject("fentitytypeid") + "_" + rs.getObject("fpermitemid") + "_" + rs.getObject("fdimid") + "_" + rs.getObject("fdimtype") + "_" + rs.getObject("fisincludesub"));
                }
                return exist;
            }
        });
        return count;
    }

    private void insertForUserPermDetail(Set<String> exist, DataSet dataSet, int count, String newEntityTypeId, String ... newPermItemIds) {
        StringBuilder insertSql = new StringBuilder();
        insertSql.append("INSERT INTO t_perm_userpermdetail");
        insertSql.append(" (fid, fuserid, fdimtype, fdimid, fisincludesub, fentryid, fseq, fcontrolmode, fpermitemid, fentitytypeid, fbizappid, fsource, fbizroleid)");
        insertSql.append(" VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?);");
        ArrayList<Object[]> insertParams = new ArrayList<Object[]>(10);
        long[] entryIds = DB.genLongIds((String)"t_perm_userpermdetail", (int)(count * newPermItemIds.length));
        int index = 0;
        for (Row row : dataSet) {
            for (String newPermItemId : newPermItemIds) {
                String unique = row.get("fuserid") + "_" + row.get("fbizappid") + "_" + newEntityTypeId + "_" + newPermItemId + "_" + row.get("fdimid") + "_" + row.get("fdimtype") + "_" + row.get("fisincludesub");
                if (exist.contains(unique)) continue;
                Object[] params = new Object[]{row.get("fid"), row.get("fuserid"), row.get("fdimtype"), row.get("fdimid"), row.get("fisincludesub"), String.valueOf(entryIds[index++]), row.get("fseq"), row.get("fcontrolmode"), newPermItemId, newEntityTypeId, row.get("fbizappid"), row.get("fsource"), row.get("fbizroleid")};
                insertParams.add(params);
            }
        }
        if (insertParams.size() <= 0) {
            return;
        }
        DB.executeBatch((DBRoute)DBRoute.basedata, (String)insertSql.toString(), insertParams);
    }
}

