/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.upgrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.utils.OrgViewUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class OrgSortNumberUpgradeService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(OrgSortNumberUpgradeService.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            DynamicObject[] viewObjs;
            for (DynamicObject view : viewObjs = BusinessDataServiceHelper.load((String)"bos_org_viewschema", (String)"id", (QFilter[])new QFilter[0])) {
                if (view == null) continue;
                long viewId = view.getLong("id");
                Map<Long, Map<String, Object>> orgStructureParam = this.getOrgStructureParam(viewId);
                this.upgradeSortNumber(orgStructureParam);
            }
            result.setSuccess(true);
            result.setLog("OrgSortNumberUpgradeService data update success");
        }
        catch (Exception e) {
            logger.warn("OrgSortNumberUpgradeService--beforeExecuteSqlWithResult", (Throwable)e);
            result.setErrorInfo(e.getMessage());
            result.setLog(e.getMessage());
            result.setSuccess(false);
        }
        logger.info("OrgSortNumberUpgradeService.end");
        return result;
    }

    private Map<Long, Map<String, Object>> getOrgStructureParam(long viewId) {
        String sql = "select fid,fparentid,flevel,fsortcode,fsortnumber from t_org_structure where fviewid = " + viewId + " order by fsortcode asc";
        return (Map)DB.query((DBRoute)DBRoute.basedata, (String)sql, null, rs -> {
            HashMap orgStructureParam = new HashMap(rs.getFetchSize());
            while (rs.next()) {
                HashMap<String, Number> param = new HashMap<String, Number>(3);
                param.put("parentid", rs.getLong("fparentid"));
                param.put("level", rs.getInt("flevel"));
                param.put("sortnumber", rs.getLong("fsortnumber"));
                orgStructureParam.put(rs.getLong("fid"), param);
            }
            return orgStructureParam;
        });
    }

    private void upgradeSortNumber(Map<Long, Map<String, Object>> excludeNumberSet) {
        HashMap<Long, Integer> sortMap = new HashMap<Long, Integer>(excludeNumberSet.size());
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(excludeNumberSet.size());
        for (Map.Entry<Long, Map<String, Object>> userData : excludeNumberSet.entrySet()) {
            long id = userData.getKey();
            Map<String, Object> paramMap = userData.getValue();
            long parentId = (Long)paramMap.get("parentid");
            long sortNumber = (Long)paramMap.get("sortnumber");
            int sort = 1;
            int level = (Integer)paramMap.get("level");
            if (sortMap.get(parentId) != null) {
                sort = (Integer)sortMap.get(parentId) + 1;
            }
            if (sortNumber == 0L) {
                Object[] param = new Object[]{OrgViewUtils.getOrgSortCode((int)level, (int)sort), id};
                paramsList.add(param);
            }
            sortMap.put(parentId, sort);
        }
        if (CollectionUtils.isEmpty(paramsList)) {
            return;
        }
        String updateSql = "update t_org_structure set fsortnumber = ? where fid = ?";
        DB.executeBatch((DBRoute)DBRoute.basedata, (String)updateSql, paramsList);
    }
}

