/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.base.cache;

import java.util.HashMap;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class BaseOrgCacheMrg {
    private static final String REGION_BASEORG = "BASEORG";
    private static DistributeSessionlessCache CACHE = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("BASEORG", new DistributeCacheHAPolicy(true, true));
    private static Log logger = LogFactory.getLog(BaseOrgCacheMrg.class);
    private static final String TYPE_COMMON = "COMMON";

    private static String getAcctId() {
        String acctId = CacheKeyUtil.getAcctId();
        if (acctId == null || acctId.length() == 0) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u4e2d\u5fc3\u4e3a\u7a7a\u3002", (String)"BaseOrgCacheMrg_0", (String)"bos-org-common", (Object[])new Object[0]));
        }
        return acctId;
    }

    public static String getType4Common() {
        return "COMMON_" + BaseOrgCacheMrg.getAcctId();
    }

    public static void putCache(String key, String value) {
        BaseOrgCacheMrg.putCache(BaseOrgCacheMrg.getType4Common(), key, value);
    }

    public static void putCache(String type, String key, String value) {
        try {
            CACHE.put(type, key, (Object)value);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    public static void putCache(String type, Map<String, String> values) {
        try {
            CACHE.put(type, values);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    public static String getCache(String type, String key) {
        try {
            return (String)CACHE.get(type, key);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            return null;
        }
    }

    public static Map<String, String> getCache(String type) {
        HashMap kvs;
        try {
            kvs = CACHE.getAll(type);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            kvs = new HashMap(0);
        }
        return kvs;
    }

    public static String getCacheByKey(String key) {
        return BaseOrgCacheMrg.getCache(BaseOrgCacheMrg.getType4Common(), key);
    }

    public static void clearCache(String type) {
        try {
            CACHE.removeType(type);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    public static void clearCache(String type, String key) {
        try {
            CACHE.remove(type, key);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    public static void clearCache(String type, String[] keys) {
        try {
            CACHE.remove(type, keys);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    public static void clearCacheByKey(String key) {
        BaseOrgCacheMrg.clearCache(BaseOrgCacheMrg.getType4Common(), key);
    }
}

