/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.base.utils;

import java.util.ArrayList;
import java.util.List;
import kd.bos.base.utils.IBaseBatchHandler;
import kd.bos.orm.util.CollectionUtils;

public class BaseBatchHandler {
    public static final int LIMIT = 1000;

    public static <T> void handle(List<T> srcList, IBaseBatchHandler handler) {
        List<List<T>> partitionList = BaseBatchHandler.partitionList(srcList, 1000);
        for (List<T> batchList : partitionList) {
            handler.Handle(batchList);
        }
    }

    public static <T> void handle(List<T> srcList, int limit, IBaseBatchHandler handler) {
        List<List<T>> partitionList = BaseBatchHandler.partitionList(srcList, limit);
        for (List<T> batchList : partitionList) {
            handler.Handle(batchList);
        }
    }

    public static <T> List<List<T>> partitionList(List<T> srcList, int limit) {
        if (CollectionUtils.isEmpty(srcList)) {
            return new ArrayList<List<T>>(0);
        }
        int size = srcList.size();
        if (size <= limit) {
            ArrayList<List<T>> partitionList = new ArrayList<List<T>>(1);
            partitionList.add(srcList);
            return partitionList;
        }
        int currentIndex = size / limit + 1;
        boolean special = size % limit == 0;
        ArrayList<List<T>> partitionList = new ArrayList<List<T>>(currentIndex);
        for (int i = 0; i < currentIndex; ++i) {
            List<T> batchList;
            if (i == currentIndex - 1) {
                if (special) break;
                batchList = srcList.subList(limit * i, size);
            } else {
                batchList = srcList.subList(limit * i, limit * (i + 1));
            }
            partitionList.add(batchList);
        }
        return partitionList;
    }
}

