/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.base.utils;

import java.awt.GraphicsEnvironment;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import kd.bos.orm.util.CollectionUtils;

public class BaseFontSingleton {
    private static final String[] CHINESE_FONTS = new String[]{"Microsoft YaHei", "Microsoft YaHei UI", "Microsoft YaHei UI Light", "\u5fae\u8f6f\u96c5\u9ed1", "\u5fae\u8f6f\u96c5\u9ed1 Light", "\u534e\u6587\u4e2d\u5b8b", "\u534e\u6587\u4eff\u5b8b", "\u534e\u6587\u5b8b\u4f53", "\u534e\u6587\u6977\u4f53", "\u534e\u6587\u7ec6\u9ed1", "\u65b9\u6b63\u9ed1\u4f53", "\u65b9\u6b63\u4eff\u5b8b", "\u65b9\u6b63\u4eff\u5b8b", "\u65b9\u6b63\u6977\u4f53", "\u65b9\u6b63\u8212\u4f53", "\u5b8b\u4f53", "\u65b0\u5b8b\u4f53", "Arial Unicode MS", "Dialog", "DialogInput", "Microsoft JhengHei", "Microsoft JhengHei Light", "Microsoft JhengHei UI", "Microsoft JhengHei UI Light", "SansSerif", "Dejavu Sans", "SurSong"};
    private static BaseFontSingleton font;
    private static final Set<String> localFonts;
    private static String chineseFont;

    private BaseFontSingleton() {
        this.initLocalFonts();
    }

    public static BaseFontSingleton getFont() {
        if (font == null) {
            font = new BaseFontSingleton();
        }
        return font;
    }

    public Set<String> getLocalFonts() {
        return localFonts;
    }

    public String getChineseFont() {
        if (chineseFont != null) {
            return chineseFont;
        }
        chineseFont = this.getChineseFont(CHINESE_FONTS[0]);
        return chineseFont;
    }

    public String getChineseFont(String defaultFont) {
        if (CollectionUtils.isEmpty(localFonts) || localFonts.contains(defaultFont)) {
            return defaultFont;
        }
        for (String font : CHINESE_FONTS) {
            if (font.equals(defaultFont) || !localFonts.contains(font)) continue;
            return font;
        }
        return defaultFont;
    }

    private void initLocalFonts() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        if (ge == null) {
            return;
        }
        String[] fontName = ge.getAvailableFontFamilyNames();
        if (fontName == null) {
            return;
        }
        localFonts.addAll(Arrays.asList(fontName));
    }

    static {
        localFonts = new HashSet<String>();
    }
}

