/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.base.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import kd.bos.base.utils.BaseBatchHandler;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonBaseDataFilterColumn;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BaseDataCustomControllerEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import org.apache.commons.codec.binary.Base64;

public class BaseUtils {
    private static final Log log = LogFactory.getLog(BaseUtils.class);
    public static final String FILE_PATH_SEPARATOR = "/";
    public static final String FILE_NAME_SEPARATOR = "-";
    public static final String CHINESE_REGEX = "[\u4e00-\u9fa5]";
    private static final String[] chars = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
    private static final int IN_FILTER_THRESHOLD = 100000;

    private BaseUtils() {
    }

    public static String generateShortUUID() {
        StringBuilder shortBuffer = new StringBuilder();
        String uuid = UUID.randomUUID().toString().replace(FILE_NAME_SEPARATOR, "");
        for (int i = 0; i < 8; ++i) {
            String str = uuid.substring(i * 4, i * 4 + 4);
            int x = Integer.parseInt(str, 16);
            shortBuffer.append(chars[x % 62]);
        }
        return shortBuffer.toString();
    }

    public static boolean isChinese(String charaString) {
        if (StringUtils.isBlank((CharSequence)charaString)) {
            return false;
        }
        return charaString.matches(CHINESE_REGEX);
    }

    public static Map<String, String> getEnableLangMap() {
        HashMap<String, String> languageNameMap;
        Map languageObjMap = BusinessDataServiceHelper.loadFromCache((String)"inte_enabledlanguage", (String)"number,name", null);
        if (CollectionUtils.isEmpty((Map)languageObjMap)) {
            languageNameMap = new HashMap<String, String>(0);
        } else {
            languageNameMap = new HashMap(languageObjMap.size());
            for (Map.Entry entry : languageObjMap.entrySet()) {
                DynamicObject languageObj = (DynamicObject)entry.getValue();
                languageNameMap.put(languageObj.getString("number"), languageObj.getString("name"));
            }
        }
        log.info("\u5f53\u524d\u542f\u7528\u7684\u5168\u90e8\u8bed\u8a00\u79cd\u7c7b\uff1a" + languageNameMap);
        return languageNameMap;
    }

    public static IFormView getFormViewByControllerEvent(BaseDataCustomControllerEvent event) {
        if (event == null) {
            return null;
        }
        Object source = event.getSource();
        if (source == null) {
            return null;
        }
        IFormView formView = null;
        try {
            if (source instanceof IFormView) {
                formView = (IFormView)source;
            } else if (source instanceof AbstractFormPlugin) {
                AbstractFormPlugin plugin = (AbstractFormPlugin)event.getSource();
                formView = plugin.getView();
            } else if (source instanceof BillList) {
                BillList billList = (BillList)source;
                formView = billList.getView();
            } else if (source instanceof CommonBaseDataFilterColumn) {
                CommonBaseDataFilterColumn filterColumn = (CommonBaseDataFilterColumn)source;
                formView = filterColumn.getView();
            } else if (source instanceof BasedataEdit) {
                BasedataEdit basedataEdit = (BasedataEdit)source;
                formView = basedataEdit.getView();
            } else {
                String pageId = event.getListShowParameter().getPageId();
                formView = SessionManager.getCurrent().getViewNoPlugin(pageId);
            }
            BaseUtils.getFormViewByControllerEventLog(event, formView);
        }
        catch (Exception e) {
            log.warn("\u83b7\u53d6\u8868\u5355\u89c6\u56fe\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38\u7684\u7c7b\u578b\uff1a" + source.getClass().getName(), (Throwable)e);
        }
        return formView;
    }

    private static void getFormViewByControllerEventLog(BaseDataCustomControllerEvent event, IFormView formView) {
        if (formView == null) {
            return;
        }
        try {
            String parentPageId = event.getListShowParameter().getParentPageId();
            IFormView parentView = formView.getViewNoPlugin(parentPageId);
            if (parentView != null) {
                log.info(String.format("\u3010\u8fc7\u6ee4\u63a7\u5236\u5668\u3011\u83b7\u53d6\u8868\u5355\u89c6\u56fe\u5bf9\u8c61\uff1a\u3010\u8868\u5355\u3011%s\u3010\u7236\u8868\u5355\u3011%s\u3010\u7236\u5b9e\u4f53\u3011%s", formView.getFormShowParameter().getFormId(), parentView.getFormShowParameter().getFormId(), parentView.getEntityId()));
            }
        }
        catch (Exception e) {
            log.warn("\u83b7\u53d6\u4e0a\u7ea7\u8868\u5355\u89c6\u56fe\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
        }
    }

    public static String getOperationResultError(OperationResult operationResult, boolean jointAll) {
        if (operationResult == null) {
            return "";
        }
        List allErrorOrValidateInfo = operationResult.getAllErrorOrValidateInfo();
        if (!CollectionUtils.isEmpty((Collection)allErrorOrValidateInfo)) {
            if (jointAll) {
                StringBuilder error = new StringBuilder();
                for (IOperateInfo operateInfo : allErrorOrValidateInfo) {
                    error.append(operateInfo.getMessage());
                }
                return error.toString();
            }
            return ((IOperateInfo)allErrorOrValidateInfo.get(0)).getMessage();
        }
        if (!operationResult.isSuccess()) {
            return operationResult.getMessage();
        }
        return "";
    }

    public static Map<String, Map<String, Object>> getFuzzySearchPropConfig(String formId) {
        Object object;
        HashMap<String, Map<String, Object>> field2ComboConfig = new HashMap<String, Map<String, Object>>(16);
        try {
            object = SystemParamServiceHelper.getBillParameter((String)formId, (String)"entryentity");
        }
        catch (Exception e) {
            return field2ComboConfig;
        }
        if (object == null || !(object instanceof DynamicObjectCollection)) {
            return field2ComboConfig;
        }
        DynamicObjectCollection doc = (DynamicObjectCollection)object;
        for (DynamicObject dynamicObject : doc) {
            String field = dynamicObject.getString("fieldid");
            HashMap<String, Comparable<Boolean>> comboConfig = new HashMap<String, Comparable<Boolean>>(4);
            comboConfig.put("iscombolistshow", Boolean.valueOf(dynamicObject.getBoolean("iscombolistshow")));
            comboConfig.put("issearch", Boolean.valueOf(dynamicObject.getBoolean("issearch")));
            comboConfig.put("fieldwidth", dynamicObject.getBigDecimal("fieldwidth"));
            field2ComboConfig.put(field, comboConfig);
        }
        return field2ComboConfig;
    }

    public static List<String> getMulComboValues(String value) {
        if (value == null) {
            return new ArrayList<String>(0);
        }
        String[] valueArr = value.split(",");
        ArrayList<String> values = new ArrayList<String>(valueArr.length);
        for (String str : valueArr) {
            if (!StringUtils.isNotBlank((CharSequence)str)) continue;
            values.add(str);
        }
        return values;
    }

    public static OperateOption getOperateOption(boolean skipCheckPermission) {
        String skipCheckPermissionParam = Boolean.toString(skipCheckPermission);
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("ishasright", skipCheckPermissionParam);
        operateOption.setVariableValue("skipCheckDataPermission", skipCheckPermissionParam);
        operateOption.setVariableValue("skipCheckSpecialDataPermission", skipCheckPermissionParam);
        return operateOption;
    }

    public static String compress(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        GZIPOutputStream gzip = null;
        try {
            gzip = new GZIPOutputStream(out);
            gzip.write(str.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            log.warn("BaseUtils.compress error", (Throwable)e);
            throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
        }
        finally {
            if (gzip != null) {
                try {
                    gzip.close();
                }
                catch (Exception e) {
                    log.warn("BaseUtils.compress gzip close error", (Throwable)e);
                }
            }
        }
        return new String(Base64.encodeBase64((byte[])out.toByteArray()), StandardCharsets.UTF_8);
    }

    public static String uncompress(String compressedStr) {
        if (compressedStr == null) {
            return null;
        }
        ByteArrayOutputStream out = null;
        ByteArrayInputStream in = null;
        GZIPInputStream gZipIns = null;
        byte[] compressed = null;
        String decompressedStr = null;
        try {
            out = new ByteArrayOutputStream();
            compressed = Base64.decodeBase64((String)compressedStr);
            in = new ByteArrayInputStream(compressed);
            gZipIns = new GZIPInputStream(in);
            byte[] buffer = new byte[1024];
            int offset = -1;
            while ((offset = gZipIns.read(buffer)) != -1) {
                out.write(buffer, 0, offset);
            }
            decompressedStr = out.toString();
        }
        catch (Exception e) {
            log.warn("BaseUtils.uncompress error", (Throwable)e);
            throw new KDBizException(new ErrorCode("0", e.getMessage()), new Object[0]);
        }
        finally {
            if (gZipIns != null) {
                try {
                    gZipIns.close();
                }
                catch (Exception e) {
                    log.warn("BaseUtils.uncompress gZipIns close error", (Throwable)e);
                }
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {
                    log.warn("BaseUtils.uncompress in close error", (Throwable)e);
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {
                    log.warn("BaseUtils.uncompress out close error", (Throwable)e);
                }
            }
        }
        return decompressedStr;
    }

    public static QFilter getSplitIdFilter(QFilter filter, List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return filter;
        }
        ArrayList orFilters = new ArrayList();
        BaseBatchHandler.handle(ids, 100000, batchList -> orFilters.add(new QFilter("id", "in", (Object)batchList)));
        for (QFilter orFilter : orFilters) {
            if (filter == null) {
                filter = orFilter;
                continue;
            }
            filter = filter.or(orFilter);
        }
        return filter;
    }
}

