/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.base.utils;

import java.util.HashMap;
import java.util.Map;
import kd.bos.logging.Log;

@Deprecated
public class CostLog {
    private Log log;
    private final Map<Object, Tag> costMap;
    private static final String SPLIT = "--";
    private static final long SLOW_TIME = 300L;

    public CostLog(Log log) {
        this.log = log;
        this.costMap = new HashMap<Object, Tag>();
    }

    public void info(Object ... messages) {
        if (messages == null || messages.length == 0) {
            return;
        }
        StringBuilder logInfo = new StringBuilder();
        StringBuilder msgInfo = new StringBuilder();
        for (Object msg : messages) {
            msgInfo.append(SPLIT);
            msgInfo.append(msg);
        }
        Object traceId = messages[0];
        Tag tag = this.costMap.remove(traceId);
        if (tag == null) {
            StringBuilder stackTrace = new StringBuilder();
            try {
                StackTraceElement[] stackTraceArr = new Throwable().getStackTrace();
                if (stackTraceArr != null && stackTraceArr.length > 1) {
                    StackTraceElement stackTraceElement = stackTraceArr[1];
                    stackTrace.append(stackTraceElement.getClassName());
                    stackTrace.append(".");
                    stackTrace.append(stackTraceElement.getMethodName());
                    stackTrace.append("(");
                    stackTrace.append(stackTraceElement.getLineNumber());
                    stackTrace.append(")");
                }
            }
            catch (Exception e) {
                this.log.info("\u83b7\u53d6\u65b9\u6cd5\u540d\u51fa\u9519\uff1a" + msgInfo);
            }
            tag = new Tag(System.currentTimeMillis(), stackTrace.toString());
            this.costMap.put(traceId, tag);
            logInfo.append(tag.getStackTrace());
            logInfo.append(SPLIT);
            logInfo.append("start");
            logInfo.append((CharSequence)msgInfo);
        } else {
            logInfo.append(tag.getStackTrace());
            logInfo.append(SPLIT);
            logInfo.append("end");
            logInfo.append((CharSequence)msgInfo);
            logInfo.append(SPLIT);
            logInfo.append("Cost=");
            long cost = System.currentTimeMillis() - tag.getStartTime();
            logInfo.append(cost);
            logInfo.append("ms");
            if (cost > 300L) {
                logInfo.append(SPLIT);
                logInfo.append("Slow");
            }
        }
        this.log.info(logInfo.toString());
    }

    static class Tag {
        private long startTime;
        private String stackTrace;

        public Tag(long startTime, String stackTrace) {
            this.startTime = startTime;
            this.stackTrace = stackTrace;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public void setStartTime(long startTime) {
            this.startTime = startTime;
        }

        public String getStackTrace() {
            return this.stackTrace;
        }

        public void setStackTrace(String stackTrace) {
            this.stackTrace = stackTrace;
        }
    }
}

