/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.base.utils.image;

import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.security.SecureRandom;
import kd.bos.base.utils.BaseFontSingleton;
import kd.bos.dataentity.utils.StringUtils;

public class ImageParam {
    private String path;
    private int width = 180;
    private int height = 180;
    private String writing;
    private Font writingFont;
    private Color writingColor;
    private Color backgroundColor;
    private String formatName = "png";
    private boolean CreateNewFileWhenExists;
    private int gender;
    private SecureRandom secureRandom;
    private static final Color MAN_COLOR = new Color(33, 150, 243);
    private static final Color WOMAN_COLOR = new Color(240, 76, 118);
    private static final Color RANDOM_COLOR_ONE = new Color(37, 186, 153);
    private static final Color RANDOM_COLOR_TWO = new Color(59, 174, 203);
    private static final Color RANDOM_COLOR_THREE = new Color(165, 113, 226);
    private static final Color RANDOM_COLOR_FOUR = new Color(223, 105, 91);
    private static final Color RANDOM_COLOR_FIVE = new Color(160, 86, 90);
    private static final Color RANDOM_COLOR_SIX = new Color(233, 160, 12);
    private static final Color[] RANDOM_COLOR = new Color[]{RANDOM_COLOR_ONE, RANDOM_COLOR_TWO, RANDOM_COLOR_THREE, RANDOM_COLOR_FOUR, RANDOM_COLOR_FIVE, RANDOM_COLOR_SIX};

    public String getName() {
        if (this.path == null) {
            return "";
        }
        if (this.path.endsWith(File.separator)) {
            return StringUtils.substringAfterLast((String)this.path, (String)File.separator);
        }
        return StringUtils.substringAfterLast((String)this.path, (String)"/");
    }

    public int getGender() {
        return this.gender;
    }

    public void setGender(int gender) {
        this.gender = gender;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public String getWriting() {
        return this.writing;
    }

    public void setWriting(String writing) {
        this.writing = writing;
    }

    public Font getWritingFont() {
        if (this.writingFont == null) {
            this.writingFont = new Font(BaseFontSingleton.getFont().getChineseFont(), 0, 80);
        }
        return this.writingFont;
    }

    public void setWritingFont(Font writingFont) {
        this.writingFont = writingFont;
    }

    public Color getWritingColor() {
        return this.writingColor == null ? Color.WHITE : this.writingColor;
    }

    public void setWritingColor(Color writingColor) {
        this.writingColor = writingColor;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor == null ? this.randomColor() : this.backgroundColor;
    }

    public Color getBackgroudColorByGender() {
        Color genderColor = null;
        genderColor = this.getGender() == 1 ? MAN_COLOR : (this.getGender() == 2 ? WOMAN_COLOR : this.getBackgroundColor());
        return genderColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public String getFormatName() {
        return this.formatName;
    }

    public void setFormatName(String formatName) {
        this.formatName = formatName;
    }

    public boolean isCreateNewFileWhenExists() {
        return this.CreateNewFileWhenExists;
    }

    public void setCreateNewFileWhenExists(boolean createNewFileWhenExists) {
        this.CreateNewFileWhenExists = createNewFileWhenExists;
    }

    private Color randomColor() {
        if (this.secureRandom == null) {
            this.secureRandom = new SecureRandom();
        }
        int index = this.secureRandom.nextInt(RANDOM_COLOR.length);
        return RANDOM_COLOR[index];
    }
}

