/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.base.utils.image;

import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageOutputStream;
import kd.bos.base.utils.image.ImageParam;
import kd.bos.context.RequestContext;
import kd.bos.devportal.api.BizAppService;
import kd.bos.entity.AppMetadataCache;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.service.attachment.FileItemExt;
import kd.bos.service.attachment.FileSource;

public class ImageUtils {
    private static final Log logger = LogFactory.getLog(ImageUtils.class);
    public static final String FOLDER_IMAGES = "images";
    private static final String DATE_FOLDER_FORMAT = "yyyyMM";
    public static final String EXTENSION_PNG = ".png";

    private ImageUtils() {
    }

    public static Map<ImageParam, BufferedImage> createBufferedImage(List<ImageParam> imageList) {
        if (CollectionUtils.isEmpty(imageList)) {
            return new HashMap<ImageParam, BufferedImage>(0);
        }
        HashMap<ImageParam, BufferedImage> bufferedImageMap = new HashMap<ImageParam, BufferedImage>(imageList.size());
        for (ImageParam imageParam : imageList) {
            bufferedImageMap.put(imageParam, ImageUtils.createBufferedImage(imageParam));
        }
        return bufferedImageMap;
    }

    private static BufferedImage createBufferedImage(ImageParam imageParam) {
        int width = imageParam.getWidth();
        int height = imageParam.getHeight();
        BufferedImage bi = new BufferedImage(width, height, 1);
        Graphics2D g2 = (Graphics2D)bi.getGraphics();
        g2.setColor(imageParam.getBackgroudColorByGender());
        g2.fillRect(0, 0, width, width);
        if (imageParam.getWriting() != null && imageParam.getWriting().trim().length() != 0) {
            g2.setFont(imageParam.getWritingFont());
            g2.setColor(imageParam.getWritingColor());
            FontRenderContext context = g2.getFontRenderContext();
            Rectangle2D bounds = imageParam.getWritingFont().getStringBounds(imageParam.getWriting(), context);
            double x = ((double)width - bounds.getWidth()) / 2.0;
            double y = ((double)height - bounds.getHeight()) / 2.0;
            double ascent = -bounds.getY();
            double baseY = y + ascent;
            g2.drawString(imageParam.getWriting(), (int)x, (int)baseY);
        }
        g2.dispose();
        return bi;
    }

    public static Map<ImageParam, InputStream> createImageInputStream(List<ImageParam> imageList) {
        Map<ImageParam, BufferedImage> bufferedImageMap = ImageUtils.createBufferedImage(imageList);
        if (CollectionUtils.isEmpty(bufferedImageMap)) {
            return new HashMap<ImageParam, InputStream>(0);
        }
        HashMap<ImageParam, InputStream> inputStreamMap = new HashMap<ImageParam, InputStream>(bufferedImageMap.size());
        try {
            for (Map.Entry<ImageParam, BufferedImage> bufferedImageEntry : bufferedImageMap.entrySet()) {
                ByteArrayOutputStream bs = new ByteArrayOutputStream();
                ImageOutputStream imOut = ImageIO.createImageOutputStream(bs);
                ImageParam imageParam = bufferedImageEntry.getKey();
                ImageIO.write((RenderedImage)bufferedImageEntry.getValue(), imageParam.getFormatName(), imOut);
                inputStreamMap.put(imageParam, new ByteArrayInputStream(bs.toByteArray()));
            }
        }
        catch (IOException e) {
            logger.info("\u751f\u6210\u56fe\u7247\u8f93\u5165\u6d41\u5931\u8d25\uff1a" + e.getMessage());
        }
        return inputStreamMap;
    }

    public static Map<ImageParam, FileItem> createUploadFileItem(List<ImageParam> imageList) {
        Map<ImageParam, InputStream> inputStreamMap = ImageUtils.createImageInputStream(imageList);
        if (CollectionUtils.isEmpty(inputStreamMap)) {
            return new HashMap<ImageParam, FileItem>(0);
        }
        HashMap<ImageParam, FileItem> fileItemMap = new HashMap<ImageParam, FileItem>(inputStreamMap.size());
        for (Map.Entry<ImageParam, InputStream> inputStreamEntry : inputStreamMap.entrySet()) {
            ImageParam imageParam = inputStreamEntry.getKey();
            FileItemExt fileItem = new FileItemExt(imageParam.getName(), imageParam.getPath(), inputStreamEntry.getValue());
            fileItem.setSource(FileSource.USER_AVATAR);
            fileItem.setCreateNewFileWhenExists(imageParam.isCreateNewFileWhenExists());
            fileItemMap.put(imageParam, (FileItem)fileItem);
        }
        return fileItemMap;
    }

    public static void uploadImage(List<ImageParam> imageList) {
        Map<ImageParam, FileItem> fileItemMap = ImageUtils.createUploadFileItem(imageList);
        if (CollectionUtils.isEmpty(fileItemMap)) {
            return;
        }
        FileService fileService = FileServiceFactory.getImageFileService();
        for (Map.Entry<ImageParam, FileItem> fileItemEntry : fileItemMap.entrySet()) {
            ImageParam imageParam = fileItemEntry.getKey();
            FileItem fileItem = fileItemEntry.getValue();
            String fileServerPath = fileService.upload(fileItem);
            imageParam.setPath(fileServerPath);
        }
    }

    public static void uploadImage(ImageParam imageParam) {
        if (imageParam == null) {
            return;
        }
        ArrayList<ImageParam> imageList = new ArrayList<ImageParam>(1);
        imageList.add(imageParam);
        ImageUtils.uploadImage(imageList);
    }

    public static String getImageAbstractFolder(String entryEntityNumber) {
        StringBuilder path = new StringBuilder("/");
        path.append(RequestContext.get().getTenantId());
        path.append("/");
        path.append(RequestContext.get().getAccountId());
        path.append("/");
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FOLDER_FORMAT);
        String date = sdf.format(new Date());
        path.append(date);
        path.append("/");
        BizAppService bizAppService = (BizAppService)ServiceFactory.getService(BizAppService.class);
        String appId = bizAppService.getAppIdByFormNum(entryEntityNumber);
        String appNumber = AppMetadataCache.getAppNumberById((String)appId);
        path.append(appNumber);
        path.append("/");
        path.append(entryEntityNumber);
        path.append("/");
        path.append(FOLDER_IMAGES);
        path.append("/");
        return path.toString();
    }
}

