/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.base.utils.msg;

import java.util.Map;
import kd.bos.base.utils.IBaseCallback;
import kd.bos.base.utils.msg.BaseMessage;
import kd.bos.base.utils.msg.IBaseMessage;
import kd.bos.base.utils.msg.MultiLangEnumBridge;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.form.IFormView;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class BaseMessageUtils {
    private static final String SPLIT_OBJECT = "\uff1a";

    public static String getMessage(Map<String, MultiLangEnumBridge> messageMap, String code) {
        MultiLangEnumBridge bridge = messageMap.get(code);
        if (bridge == null) {
            return code;
        }
        return bridge.loadKDString();
    }

    public static String getMessage(IBaseMessage baseMessage, String code) {
        if (baseMessage == null) {
            return code;
        }
        MultiLangEnumBridge bridge = baseMessage.getMultiLangEnumBridge();
        if (bridge == null) {
            return code;
        }
        return bridge.loadKDString();
    }

    public static String getMessage(Map<String, MultiLangEnumBridge> messageMap, String code, Object ... params) {
        MultiLangEnumBridge bridge = messageMap.get(code);
        if (bridge == null) {
            return code;
        }
        return bridge.loadKDString(params);
    }

    public static String getMessage(IBaseMessage baseMessage, String code, Object ... params) {
        if (baseMessage == null) {
            return code;
        }
        MultiLangEnumBridge bridge = baseMessage.getMultiLangEnumBridge();
        if (bridge == null) {
            return code;
        }
        return bridge.loadKDString(params);
    }

    public static String getMessageWithObj(Map<String, MultiLangEnumBridge> messageMap, String code, String fieldObj, Object ... params) {
        return fieldObj + SPLIT_OBJECT + BaseMessageUtils.getMessage(messageMap, code, params);
    }

    public static String getMessageWithObj(IBaseMessage baseMessage, String code, String fieldObj, Object ... params) {
        return fieldObj + SPLIT_OBJECT + BaseMessageUtils.getMessage(baseMessage, code, params);
    }

    public static void showLoading(IFormView view, IBaseCallback handler) {
        BaseMessageUtils.showLoading(view, BaseMessage.getMessage("M00064"), handler);
    }

    public static void showLoading(IFormView view, String message, IBaseCallback handler) {
        if (view == null || handler == null) {
            return;
        }
        view.showLoading(new LocaleString(message));
        handler.handle();
        view.hideLoading();
    }
}

