/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.base.utils.user;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.utils.BaseUtils;
import kd.bos.base.utils.image.ImageParam;
import kd.bos.base.utils.image.ImageUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.IPageCache;
import kd.bos.i18n.mservice.I18nServiceHelper;
import kd.bos.lang.HZPinyin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;

public class UserUtils {
    private static final Log logger = LogFactory.getLog(UserUtils.class);
    public static final int LENGTH_LIMIT_FULL_PINYIN_ = 100;
    public static final int LENGTH_LIMIT_SIMPLE_PINYIN = 50;
    public static final int USERNAME_MIN_LENGTH = 1;
    public static final int USERNAME_MAX_LENGTH = 32;
    public static final String FOLDER_AVATAR = "avatar";
    private static final String USER_USERTYPE = "user.usertype";
    public static final String PARAM_EXTERNAL_USER_TYPE_ALL = "all";
    public static final String PARAM_EXTERNAL_USER_TYPE = "externalUserType";
    public static final String CACHE_ADMIN_CHARGE_USER = "cache_admin_charge_user";
    public static final String PARAM_IS_ORG_BASE_ADMIN = "isOrgBaseAdmin";
    public static final long NAME_MERGE_STYLE = 1997239714909794304L;
    public static final String NS_NAME_STYLE = "ns_namestyle";
    public static final String NS_FIRST_NAME = "ns_firstname";

    private UserUtils() {
    }

    public static void transUserNamePinyin(DynamicObject userObj, Set<String> existsUserNames) {
        UserUtils.transUserNamePinyin(userObj, existsUserNames, true);
    }

    public static void transUserNamePinyin(DynamicObject userObj, Set<String> existsUserNames, boolean isSettingUsername) {
        if (userObj == null) {
            return;
        }
        String name = userObj.getString("name");
        if (StringUtils.isBlank((CharSequence)name)) {
            if (isSettingUsername && StringUtils.isBlank((CharSequence)userObj.getString("username"))) {
                userObj.set("username", (Object)String.valueOf(DB.genLongId((String)"bos_user")));
            }
            return;
        }
        String fullPinyin = UserUtils.getFullSpellByName(name);
        if (StringUtils.isBlank((Object)userObj.get("fullpinyin"))) {
            userObj.set("fullpinyin", (Object)fullPinyin);
        }
        if (isSettingUsername && StringUtils.isBlank((Object)userObj.get("username"))) {
            String userName = UserUtils.getUserNameByFormatedFullPinyin(userObj.getLong("id"), fullPinyin, existsUserNames);
            userObj.set("username", (Object)userName);
        }
        if (StringUtils.isBlank((Object)userObj.get("simplepinyin"))) {
            userObj.set("simplepinyin", (Object)UserUtils.getFirstSpellByName(name));
        }
    }

    public static String getFullSpellByName(String name) {
        String fullPinyin = "";
        try {
            fullPinyin = HZPinyin.getFullSpell((String)name, (String)"");
            fullPinyin = UserUtils.formatNameSpell(fullPinyin);
            if (fullPinyin.length() > 100) {
                fullPinyin = fullPinyin.substring(0, 100);
            }
        }
        catch (UnsupportedEncodingException e) {
            logger.info("\u7ffb\u8bd1\u4eba\u5458\u59d3\u540d\u5168\u62fc\u5931\u8d25\uff1a" + e.getMessage(), (Object)e);
        }
        return fullPinyin;
    }

    public static String getFirstSpellByName(String name) {
        String firstSpell = "";
        try {
            firstSpell = HZPinyin.getFirstSpell((String)name);
            firstSpell = UserUtils.formatNameSpell(firstSpell);
            if (firstSpell.length() > 50) {
                firstSpell = firstSpell.substring(0, 50);
            }
        }
        catch (UnsupportedEncodingException e) {
            logger.info("\u7ffb\u8bd1\u4eba\u5458\u59d3\u540d\u7b80\u62fc\u5931\u8d25\uff1a" + e.getMessage(), (Object)e);
        }
        return firstSpell;
    }

    public static String getUserNameByFullPinyin(long userId, String fullPingyin, Set<String> existsUserNames) {
        return UserUtils.getUserNameByFullPinyin(userId, fullPingyin, existsUserNames, true);
    }

    public static String getUserNameByFullPinyin(long userId, String fullPingyin, Set<String> existsUserNames, boolean checkFromDb) {
        return UserUtils.getUserNameByFormatedFullPinyin(userId, UserUtils.formatNameSpell(fullPingyin), existsUserNames, checkFromDb);
    }

    public static String getUserNameByFormatedFullPinyin(long userId, String fullPingyin, Set<String> existsUserNames) {
        return UserUtils.getUserNameByFormatedFullPinyin(userId, fullPingyin, existsUserNames, true);
    }

    private static String getUserNameByFormatedFullPinyin(long userId, String fullPingyin, Set<String> existsUserNames, boolean checkFromDb) {
        String userName = null;
        if (StringUtils.isNotBlank((CharSequence)fullPingyin)) {
            int length = fullPingyin.length();
            if (length > 32) {
                fullPingyin = fullPingyin.substring(0, 32);
            } else if (length < 1) {
                fullPingyin = "user_" + fullPingyin;
            }
            userName = UserUtils.doGetUserNameByFullPinyin(userId, fullPingyin, existsUserNames, checkFromDb);
        }
        if (StringUtils.isBlank(userName)) {
            userName = String.valueOf(userId > 0L ? userId : DB.genLongId((String)"bos_user"));
            if (existsUserNames != null) {
                existsUserNames.add(userName);
            }
        }
        return userName;
    }

    public static String formatNameSpell(String fullPingyin) {
        if (StringUtils.isBlank((CharSequence)fullPingyin)) {
            return "";
        }
        fullPingyin = fullPingyin.replace("^", "");
        return fullPingyin.replaceAll("[^a-z^A-Z^0-9]", "");
    }

    private static String doGetUserNameByFullPinyin(long userId, String fullPingyin, Set<String> existsUserNames, boolean checkFromDb) {
        Set<Object> dbUserNames;
        Set<Object> set = dbUserNames = checkFromDb ? UserUtils.getExistsUserNames(userId, fullPingyin) : new HashSet();
        if (existsUserNames == null) {
            existsUserNames = dbUserNames;
        } else {
            existsUserNames.addAll(dbUserNames);
        }
        String userName = UserUtils.addNumberToUserName(fullPingyin, existsUserNames);
        if (userName.length() > 32) {
            if (fullPingyin.length() == 1) {
                return "";
            }
            fullPingyin = fullPingyin.substring(0, fullPingyin.length() - 1);
            return UserUtils.doGetUserNameByFullPinyin(userId, fullPingyin, existsUserNames, checkFromDb);
        }
        existsUserNames.add(userName);
        return userName;
    }

    public static Set<String> getExistsUserNames(long userId, String fullPingyin) {
        HashSet<String> existsUserNames = new HashSet<String>();
        QFilter usernameFilter = QFilter.like((String)"username", (String)(fullPingyin + "%"));
        QFilter[] filters = new QFilter[]{usernameFilter};
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"UserUtils.getExistsUserNames", (String)"bos_user", (String)"id,username", (QFilter[])filters, (String)"");){
            for (Row row : dataSet) {
                String userName;
                if (userId == row.getLong("id") || (userName = row.getString("username")) == null) continue;
                existsUserNames.add(userName);
                existsUserNames.add(userName.toLowerCase());
            }
        }
        return existsUserNames;
    }

    public static Map<String, Map<Long, String>> getAllUserNames(boolean lowerCaseKey, String prefix) {
        String whereSql = "";
        if (StringUtils.isNotBlank((CharSequence)prefix)) {
            whereSql = String.format(" where fusername like '%s%%' or fusername like '%s%%'", prefix.toUpperCase(), prefix.toLowerCase());
        }
        Map userNameMap = (Map)DB.query((DBRoute)DBRoute.base, (String)("select fid id,fusername username from t_sec_user_u" + whereSql), resultSet -> {
            HashMap<String, Map> existsMap = new HashMap<String, Map>(1024);
            while (resultSet.next()) {
                String userName;
                long id = resultSet.getLong("id");
                String key = userName = resultSet.getString("username");
                if (lowerCaseKey) {
                    key = key.toLowerCase();
                }
                existsMap.computeIfAbsent(key, v -> new HashMap(4)).put(id, userName);
            }
            return existsMap;
        });
        return userNameMap;
    }

    private static String addNumberToUserName(String baseUserName, Set<String> existsUserNames) {
        int number = 1;
        String newUserName = baseUserName;
        while (existsUserNames.contains(newUserName.toLowerCase()) || existsUserNames.contains(newUserName)) {
            newUserName = baseUserName + number++;
        }
        return newUserName;
    }

    public static void createAvatar(List<DynamicObject> userObjList) {
        if (CollectionUtils.isEmpty(userObjList)) {
            return;
        }
        UserUtils.createAvatar(userObjList.toArray(new DynamicObject[userObjList.size()]));
    }

    public static void createAvatar(DynamicObject[] userObjArr) {
        if (userObjArr == null || userObjArr.length == 0) {
            return;
        }
        String userAvatarFolder = UserUtils.getUserImageAbstractFolder();
        try {
            for (DynamicObject userObj : userObjArr) {
                String avatarPath = userObj.getString("picturefield");
                if (!StringUtils.isBlank((CharSequence)avatarPath)) continue;
                ImageParam imageParam = new ImageParam();
                imageParam.setGender(userObj.getInt("gender"));
                imageParam.setPath(UserUtils.createAvatarPath(userAvatarFolder, userObj));
                imageParam.setWriting(UserUtils.getImageWriting(userObj.getString("name")));
                imageParam.setCreateNewFileWhenExists(true);
                ImageUtils.uploadImage(imageParam);
                userObj.set("picturefield", (Object)imageParam.getPath());
            }
        }
        catch (Exception e) {
            logger.info("\u521b\u5efa\u4eba\u5458\u5934\u50cf\u53d1\u751f\u5f02\u5e38\uff1a" + e.getMessage(), (Object)e);
        }
    }

    public static String getUserImageAbstractFolder() {
        String userAvatarFolder = ImageUtils.getImageAbstractFolder("bos_user");
        userAvatarFolder = userAvatarFolder + FOLDER_AVATAR + "/";
        return userAvatarFolder;
    }

    private static String createAvatarPath(String userAvatarFolder, DynamicObject userObj) {
        StringBuilder path = new StringBuilder(userAvatarFolder);
        path.append(userObj.getString("fullpinyin"));
        path.append("-");
        path.append(BaseUtils.generateShortUUID());
        path.append(".png");
        return path.toString();
    }

    private static String getImageWriting(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return "";
        }
        String tempName = name.replace(" ", "");
        char[] chars = tempName.toCharArray();
        int len = chars.length;
        if (len < 2) {
            return tempName;
        }
        String lastChar = String.valueOf(chars[len - 1]);
        if (BaseUtils.isChinese(lastChar)) {
            return lastChar;
        }
        String fistChar = String.valueOf(chars[0]);
        if (BaseUtils.isChinese(fistChar)) {
            return fistChar;
        }
        String secondChar = String.valueOf(chars[1]);
        if (BaseUtils.isChinese(secondChar)) {
            return secondChar;
        }
        return fistChar + secondChar;
    }

    public static void parseUserType(DynamicObject userObj) {
        UserUtils.parseUserType(userObj, UserUtils.getAllUserType());
    }

    public static void parseUserType(DynamicObject userObj, Map<Object, DynamicObject> userTypeMap) {
        DynamicObjectCollection userTypesCol;
        if (userObj == null) {
            return;
        }
        if (userTypeMap == null) {
            userTypeMap = UserUtils.getAllUserType();
        }
        if (!CollectionUtils.isEmpty((Collection)(userTypesCol = userObj.getDynamicObjectCollection("usertypes")))) {
            StringJoiner sj = new StringJoiner(",");
            for (DynamicObject userTypeEditObj : userTypesCol) {
                DynamicObject userTypeObj = userTypeEditObj.getDynamicObject("fbasedataid");
                if (userTypeObj == null) continue;
                sj.add(userTypeObj.getPkValue().toString());
            }
            userObj.set("usertype", (Object)sj.toString());
            return;
        }
        String paramUserTypeStr = userObj.getString("usertype");
        ArrayList<Long> paramUserTypeList = new ArrayList<Long>();
        if (StringUtils.isNotBlank((CharSequence)paramUserTypeStr)) {
            String[] paramUserTypeArr;
            for (String userTypeId : paramUserTypeArr = paramUserTypeStr.split(",")) {
                if (!StringUtils.isNotBlank((CharSequence)userTypeId)) continue;
                paramUserTypeList.add(Long.valueOf(userTypeId));
            }
        }
        if (paramUserTypeList.isEmpty()) {
            if (userObj.getDataEntityState().getFromDatabase()) {
                return;
            }
            paramUserTypeList.add(Long.valueOf("1"));
        }
        DynamicObjectType userTypesDynamicObjectType = userTypesCol.getDynamicObjectType();
        StringJoiner sj = new StringJoiner(",");
        for (Long userTypeId : paramUserTypeList) {
            DynamicObject userTypeObj = userTypeMap.get(userTypeId);
            if (userTypeObj == null) continue;
            DynamicObject userTypeEditObj = new DynamicObject(userTypesDynamicObjectType);
            userTypeEditObj.set("fbasedataid", (Object)userTypeObj);
            userTypesCol.add((Object)userTypeEditObj);
            sj.add(Long.toString(userTypeId));
        }
        userObj.set("usertype", (Object)sj.toString());
    }

    public static Map<Object, DynamicObject> getAllUserType() {
        return UserUtils.getAllUserType(null, false);
    }

    public static Map<Object, DynamicObject> getAllUserType(String category, boolean onlyVisible) {
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        if (StringUtils.isNotBlank((CharSequence)category)) {
            enableFilter = enableFilter.and(new QFilter("category", "=", (Object)category));
        }
        if (onlyVisible) {
            enableFilter = enableFilter.and(new QFilter("isvisible", "=", (Object)Boolean.TRUE));
        }
        QFilter[] filters = new QFilter[]{enableFilter};
        return BusinessDataServiceHelper.loadFromCache((String)"bos_usertype", (QFilter[])filters);
    }

    public static List<Long> getAllUserTypeId(String category, boolean onlyVisible) {
        Map<Object, DynamicObject> userTypeObjMap = UserUtils.getAllUserType(category, onlyVisible);
        if (CollectionUtils.isEmpty(userTypeObjMap)) {
            return new ArrayList<Long>(0);
        }
        ArrayList<Long> userTypeIds = new ArrayList<Long>(userTypeObjMap.size());
        for (Map.Entry<Object, DynamicObject> entry : userTypeObjMap.entrySet()) {
            userTypeIds.add((Long)entry.getKey());
        }
        return userTypeIds;
    }

    public static QFilter getVisibleUserTypeJoinFilter() {
        return UserUtils.getUserTypesLikeFilter(UserUtils.getUserTypeByCategory(null));
    }

    public static QFilter getUserTypeJoinFilter(String category) {
        return UserUtils.getUserTypesLikeFilter(UserUtils.getUserTypeByCategory(category));
    }

    public static List<Long> getUserTypeByCategory(String category) {
        QFilter[] filters;
        Map usertypeObjMap;
        QFilter visibleFilter = new QFilter("isvisible", "=", (Object)Boolean.TRUE);
        if (StringUtils.isNotBlank((CharSequence)category)) {
            QFilter categoryFilter = new QFilter("category", "=", (Object)category);
            visibleFilter = visibleFilter.and(categoryFilter);
        }
        if (CollectionUtils.isEmpty((Map)(usertypeObjMap = BusinessDataServiceHelper.loadFromCache((String)"bos_usertype", (QFilter[])(filters = new QFilter[]{visibleFilter}))))) {
            return new ArrayList<Long>(0);
        }
        ArrayList<Long> ids = new ArrayList<Long>(usertypeObjMap.size());
        for (DynamicObject usertypeObj : usertypeObjMap.values()) {
            ids.add(usertypeObj.getLong("id"));
        }
        return ids;
    }

    public static QFilter getUserTypeJoinFilter(long userTypeId) {
        return UserUtils.getUserTypeLikeFilter(Long.toString(userTypeId));
    }

    public static QFilter getUserTypeJoinNotEqualsFilter(String userTypeId) {
        return new QFilter("usertype", "!=", (Object)userTypeId);
    }

    public static QFilter getUserTypeJoinNotEqualsFilter(long userTypeId) {
        return UserUtils.getUserTypeJoinNotEqualsFilter(Long.toString(userTypeId));
    }

    public static QFilter getUserTypeJoinFilter(List<Long> userTypeIds) {
        return UserUtils.getUserTypesLikeFilter(userTypeIds);
    }

    public static QFilter getUserTypeJoinFilter(String category, List<Long> userTypeIds) {
        if (CollectionUtils.isEmpty(userTypeIds)) {
            return new QFilter("id", "in", new ArrayList(0));
        }
        ArrayList<Long> userTypeByCategory = new ArrayList<Long>(userTypeIds);
        if (StringUtils.isNotBlank((CharSequence)category)) {
            userTypeByCategory.retainAll(UserUtils.getUserTypeByCategory(category));
        }
        return UserUtils.getUserTypeJoinFilter(userTypeByCategory);
    }

    public static QFilter getUserTypesLikeFilter(List<Long> userTypeIds) {
        QFilter userTypeFilter = null;
        if (userTypeIds == null) {
            return null;
        }
        if (userTypeIds.isEmpty()) {
            userTypeFilter = new QFilter("usertype", "in", userTypeIds);
        } else {
            for (Long userTypeId : userTypeIds) {
                if (userTypeFilter == null) {
                    userTypeFilter = UserUtils.getUserTypeLikeFilter(Long.toString(userTypeId));
                    continue;
                }
                userTypeFilter = userTypeFilter.or(UserUtils.getUserTypeLikeFilter(Long.toString(userTypeId)));
            }
        }
        return userTypeFilter;
    }

    public static QFilter getUserTypeLikeFilter(String userTypeId) {
        QFilter userTypeFilter = new QFilter("usertype", "=", (Object)userTypeId);
        userTypeFilter = userTypeFilter.or(QFilter.like((String)"usertype", (String)(userTypeId + ",%")));
        userTypeFilter = userTypeFilter.or(QFilter.like((String)"usertype", (String)("%," + userTypeId)));
        userTypeFilter = userTypeFilter.or(QFilter.like((String)"usertype", (String)("%," + userTypeId + ",%")));
        return userTypeFilter;
    }

    public static QFilter getUserTypeRefLikeFilter(String userTypeId) {
        QFilter userTypeFilter = new QFilter(USER_USERTYPE, "=", (Object)userTypeId);
        userTypeFilter = userTypeFilter.or(QFilter.like((String)USER_USERTYPE, (String)(userTypeId + ",%")));
        userTypeFilter = userTypeFilter.or(QFilter.like((String)USER_USERTYPE, (String)("%," + userTypeId)));
        userTypeFilter = userTypeFilter.or(QFilter.like((String)USER_USERTYPE, (String)("%," + userTypeId + ",%")));
        return userTypeFilter;
    }

    public static boolean checkUserTypeCategory(DynamicObject userObj, String category) {
        if (userObj == null || category == null) {
            return false;
        }
        DynamicObjectCollection userTypesCol = userObj.getDynamicObjectCollection("usertypes");
        if (CollectionUtils.isEmpty((Collection)userTypesCol)) {
            return false;
        }
        ArrayList<Object> userTypeIds = new ArrayList<Object>(userTypesCol.size());
        for (DynamicObject userTypeEditObj : userTypesCol) {
            DynamicObject userTypeObj = userTypeEditObj.getDynamicObject("fbasedataid");
            if (userTypeObj == null) continue;
            userTypeIds.add(userTypeObj.getPkValue());
        }
        if (userTypeIds.isEmpty()) {
            return false;
        }
        QFilter idFilter = new QFilter("id", "in", userTypeIds);
        QFilter categoryFilter = new QFilter("category", "=", (Object)category);
        QFilter[] filters = new QFilter[]{idFilter, categoryFilter};
        return QueryServiceHelper.exists((String)"bos_usertype", (QFilter[])filters);
    }

    public static boolean checkUserType(DynamicObject userObj, Long userTypeId) {
        if (userObj == null || userTypeId == null) {
            return false;
        }
        DynamicObjectCollection userTypesCol = userObj.getDynamicObjectCollection("usertypes");
        if (CollectionUtils.isEmpty((Collection)userTypesCol)) {
            return false;
        }
        for (DynamicObject userTypeEditObj : userTypesCol) {
            DynamicObject userTypeObj = userTypeEditObj.getDynamicObject("fbasedataid");
            if (userTypeObj == null || !userTypeId.equals(userTypeObj.getPkValue())) continue;
            return true;
        }
        return false;
    }

    public static QFilter getAdminChargeUsersFilter(long userId, ListShowParameter listShowParameter, IPageCache pageCache) {
        if (listShowParameter == null) {
            return null;
        }
        String cacheAdminChargeUsers = null;
        if (pageCache != null) {
            cacheAdminChargeUsers = pageCache.get(CACHE_ADMIN_CHARGE_USER);
        }
        QFilter filter = null;
        if (cacheAdminChargeUsers == null) {
            filter = UserUtils.getAdminChargeUsersFilter(userId, listShowParameter);
            if (pageCache != null) {
                if (filter == null) {
                    pageCache.put(CACHE_ADMIN_CHARGE_USER, "");
                } else {
                    pageCache.put(CACHE_ADMIN_CHARGE_USER, filter.toSerializedString());
                }
            }
        } else if (StringUtils.isNotBlank((CharSequence)cacheAdminChargeUsers)) {
            filter = QFilter.fromSerializedString((String)cacheAdminChargeUsers);
        }
        return filter;
    }

    private static QFilter getAdminChargeUsersFilter(long userId, ListShowParameter listShowParameter) {
        HasPermOrgResult hasPermOrgResult;
        QFilter filter = null;
        Map customParams = listShowParameter.getCustomParams();
        Object isAddChargeOrgFilter = customParams.get(PARAM_IS_ORG_BASE_ADMIN);
        boolean isAddChargeOrg = false;
        if (isAddChargeOrgFilter != null && Boolean.parseBoolean(isAddChargeOrgFilter.toString())) {
            isAddChargeOrg = true;
            hasPermOrgResult = PermissionServiceHelper.getAdminChargeOrg((Long)userId, (String)"01", (boolean)false);
            logger.info("\u3010\u4eba\u5458\u3011\u83b7\u53d6\u7ba1\u7406\u5458\u7ba1\u8f96\u8303\u56f4\u7684\u7ec4\u7ec7\u4f5c\u4e3a\u8fc7\u6ee4\u6761\u4ef6\uff1a" + (hasPermOrgResult == null ? null : hasPermOrgResult.getHasPermOrgs()));
        } else {
            hasPermOrgResult = UserUtils.getUserHasPermOrgs(userId, listShowParameter);
            logger.info("\u3010\u4eba\u5458\u3011\u83b7\u53d6\u6709\u6743\u9650\u7684\u7ec4\u7ec7\u4f5c\u4e3a\u8fc7\u6ee4\u6761\u4ef6\uff1a" + (hasPermOrgResult == null ? null : hasPermOrgResult.getHasPermOrgs()));
        }
        if (hasPermOrgResult != null && !hasPermOrgResult.hasAllOrgPerm()) {
            filter = new QFilter("entryentity.dpt", "in", (Object)hasPermOrgResult.getHasPermOrgs());
            Set<Long> otherPermUserIds = UserUtils.getOtherPermUserIds(userId, listShowParameter, hasPermOrgResult, isAddChargeOrg);
            if (!otherPermUserIds.isEmpty()) {
                filter = BaseUtils.getSplitIdFilter(filter, new ArrayList<Long>(otherPermUserIds));
            }
        }
        return filter;
    }

    private static HasPermOrgResult getUserHasPermOrgs(long userId, ListShowParameter listShowParameter) {
        Object isAddUserPermOrgFilter = listShowParameter.getCustomParam("isAddUserPermOrgFilter");
        if (isAddUserPermOrgFilter == null || !Boolean.parseBoolean(isAddUserPermOrgFilter.toString())) {
            return null;
        }
        HasPermOrgResult permOrg = PermissionServiceHelper.getUserHasPermOrgs((long)userId, (boolean)false);
        return permOrg;
    }

    private static Set<Long> getOtherPermUserIds(long userId, ListShowParameter listShowParameter, HasPermOrgResult hasPermOrgResult, boolean isAddChargeOrg) {
        List adminExtraUser;
        Set allPartnerUsersOfOrg;
        HashSet<Long> otherUserIds = new HashSet<Long>(1000);
        if (!(listShowParameter.isLookUp() && !StringUtils.isNotBlank((CharSequence)((CharSequence)listShowParameter.getCustomParam(PARAM_EXTERNAL_USER_TYPE))) || CollectionUtils.isEmpty((Collection)(allPartnerUsersOfOrg = UserServiceHelper.getAllPartnerUsersOfOrg((List)hasPermOrgResult.getHasPermOrgs(), (boolean)false, (boolean)true))))) {
            otherUserIds.addAll(allPartnerUsersOfOrg);
            logger.info("\u3010\u4eba\u5458\u3011\u5546\u52a1\u4f19\u4f34\u7528\u6237\u8fc7\u6ee4\u6761\u4ef6\uff1a" + allPartnerUsersOfOrg);
        }
        if (isAddChargeOrg && !CollectionUtils.isEmpty((Collection)(adminExtraUser = PermissionServiceHelper.getAdminExtraUser((Long)userId)))) {
            otherUserIds.addAll(adminExtraUser);
            logger.info("\u3010\u4eba\u5458\u3011\u884c\u653f\u7ec4\u7ec7\u7ba1\u8f96\u8303\u56f4\u5916\u7528\u6237\u8fc7\u6ee4\u6761\u4ef6\uff1a" + adminExtraUser);
        }
        return otherUserIds;
    }

    public static long getNameMergeStyleId() {
        if (UserUtils.isChineseUserNameMergeStyle()) {
            return 1997239714909794304L;
        }
        return 0L;
    }

    public static DynamicObject getNameMergeStyleDynamicObject(DynamicObject userObj) {
        BasedataProp nsNameStylePro;
        if (userObj == null) {
            return null;
        }
        if (UserUtils.isChineseUserNameMergeStyle() && (nsNameStylePro = (BasedataProp)userObj.getDynamicObjectType().getProperty(NS_NAME_STYLE)) != null) {
            return BusinessDataServiceHelper.loadSingleFromCache((Object)1997239714909794304L, (DynamicObjectType)((DynamicObjectType)nsNameStylePro.getComplexType()));
        }
        return null;
    }

    private static boolean isChineseUserNameMergeStyle() {
        Long countryId = I18nServiceHelper.getDefaultCountry();
        if (countryId == null) {
            return false;
        }
        if (1000001L == countryId) {
            Object usernameStyleKey = SystemParamServiceHelper.getBillParameter((String)"bos_user", (String)"usernamestyle");
            return !ObjectUtils.isEmpty((Object)usernameStyleKey) && 1997239714909794304L == Long.parseLong(usernameStyleKey.toString());
        }
        return false;
    }
}

