/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.org.history;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.base.utils.BaseBatchHandler;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.utils.DynamicObjectUtils;
import kd.bos.org.utils.Utils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;

public class OrgHistoryUtils {
    private static final Log logger = LogFactory.getLog(OrgHistoryUtils.class);

    public static void saveOrgHistory(List<Long> orgIds) {
        if (CollectionUtils.isEmpty(orgIds)) {
            return;
        }
        ThreadPools.executeOnceIncludeRequestContext((String)"saveOrgHistory", () -> OrgHistoryUtils.save(orgIds));
    }

    public static void save(List<Long> orgIds) {
        DynamicObjectUtils.saveHistory("bos_org", orgIds, params -> {
            DynamicObject[] objArr = (DynamicObject[])params[0];
            boolean includeExtendProp = (Boolean)params[1];
            return OrgHistoryUtils.copyOrgToHistory(objArr, includeExtendProp);
        });
    }

    public static void saveOrgDeleteHistory(List<Long> orgIds) {
        if (CollectionUtils.isEmpty(orgIds)) {
            return;
        }
        logger.info("\u4fdd\u5b58\u7ec4\u7ec7\u5220\u9664\u5386\u53f2\uff1a" + orgIds.size());
        ThreadPools.executeOnceIncludeRequestContext((String)"saveOrgDeleteHistory", () -> BaseBatchHandler.handle(orgIds, batchList -> OrgHistoryUtils.updateOrgHistory(batchList, Utils.getDate((int)0))));
    }

    public static DynamicObject[] genOrgHistoryObject(List<Long> orgIds) {
        if (Utils.isListEmpty(orgIds)) {
            return new DynamicObject[0];
        }
        DynamicObject orgType = BusinessDataServiceHelper.newDynamicObject((String)"bos_org");
        DynamicObject[] orgArr = (DynamicObject[])BusinessDataServiceHelper.load((Object[])orgIds.toArray(new Object[orgIds.size()]), (IDataEntityType)orgType.getDataEntityType());
        if (orgArr == null || orgArr.length == 0) {
            return new DynamicObject[0];
        }
        return OrgHistoryUtils.copyOrgToHistory(orgArr, orgIds);
    }

    public static DynamicObject[] copyOrgToHistory(DynamicObject[] orgArr, List<Long> orgIds) {
        return OrgHistoryUtils.copyOrgToHistory(orgArr, true);
    }

    private static DynamicObject[] copyOrgToHistory(DynamicObject[] orgArr, boolean includeExtendProp) {
        Date today = Utils.getDate((int)0);
        Date endDate = Utils.getEndDate();
        HashMap<String, String> transKeyMap = new HashMap<String, String>(1);
        transKeyMap.put("id", "org");
        DynamicObject[] orgHistoryArr = new DynamicObject[orgArr.length];
        int index = 0;
        long curUserId = RequestContext.get().getCurrUserId();
        Date curTime = Calendar.getInstance().getTime();
        DynamicObjectType orgHistoryType = DynamicObjectUtils.getDynamicObjectType("bos_org_history", includeExtendProp);
        for (DynamicObject org : orgArr) {
            DynamicObject history = new DynamicObject(orgHistoryType);
            DynamicObjectUtils.copy(org, history, transKeyMap);
            history.set("creator", (Object)curUserId);
            history.set("createtime", (Object)curTime);
            history.set("modifier", (Object)curUserId);
            history.set("modifytime", (Object)curTime);
            history.set("startdate", (Object)today);
            history.set("enddate", (Object)endDate);
            for (DynamicObject structureObj : history.getDynamicObjectCollection("structure")) {
                structureObj.set("viewcreator", (Object)curUserId);
                structureObj.set("viewcreatetime", (Object)curTime);
                structureObj.set("viewmodifier", (Object)curUserId);
                structureObj.set("viewmodifytime", (Object)curTime);
                structureObj.set("viewstartdate", (Object)today);
                structureObj.set("viewenddate", (Object)endDate);
            }
            orgHistoryArr[index++] = history;
        }
        return orgHistoryArr;
    }

    private static List<Long> updateOrgHistory(List<Long> orgIds, Date today) {
        String selectFields = "id,org,startdate,enddate,modifier,modifytime";
        QFilter orgFilter = new QFilter("org", "in", orgIds);
        QFilter startDateFilter = new QFilter("startdate", "<=", (Object)today);
        QFilter endDateFilter = new QFilter("enddate", ">=", (Object)today);
        QFilter[] filters = new QFilter[]{orgFilter, startDateFilter, endDateFilter};
        DynamicObject[] orgArr = BusinessDataServiceHelper.load((String)"bos_org_history", (String)selectFields, (QFilter[])filters);
        if (orgArr == null || orgArr.length == 0) {
            return new ArrayList<Long>(0);
        }
        ArrayList<Long> oldOrgIds = new ArrayList<Long>(orgArr.length);
        long curUserId = RequestContext.get().getCurrUserId();
        Date curTime = Calendar.getInstance().getTime();
        for (DynamicObject orgHistory : orgArr) {
            orgHistory.set("modifier", (Object)curUserId);
            orgHistory.set("modifytime", (Object)curTime);
            Date startdate = orgHistory.getDate("startdate");
            if (startdate != null && startdate.compareTo(today) > 0) {
                orgHistory.set("startdate", (Object)today);
            }
            orgHistory.set("enddate", (Object)today);
            oldOrgIds.add(orgHistory.getLong("org"));
        }
        SaveServiceHelper.save((DynamicObject[])orgArr);
        return oldOrgIds;
    }

    public static void saveOrgStructureHistory(List<Long> orgIds) {
        OrgHistoryUtils.saveOrgStructureHistory(null, orgIds);
    }

    public static void saveOrgStructureHistory(String orgViewNumber, List<Long> orgIds) {
        BaseBatchHandler.handle(orgIds, batchList -> OrgHistoryUtils.saveOrgStructureHistoryById(OrgHistoryUtils.getOrgStructurePkByOrgId(orgViewNumber, batchList)));
    }

    public static void saveOrgStructureHistoryById(List<Long> ids) {
        DynamicObjectUtils.saveHistory("bos_org_structure", ids, params -> {
            DynamicObject[] objArr = (DynamicObject[])params[0];
            boolean includeExtendProp = (Boolean)params[1];
            return OrgHistoryUtils.copyOrgStructureToHistory(objArr, includeExtendProp);
        });
    }

    public static void saveOrgStructureDeleteHistory(List<Long> orgIds) {
        OrgHistoryUtils.saveOrgStructureDeleteHistory(null, orgIds);
    }

    public static void saveOrgStructureDeleteHistory(String orgViewNumber, List<Long> orgIds) {
        BaseBatchHandler.handle(orgIds, batchList -> OrgHistoryUtils.saveOrgStructureDeleteHistoryById(OrgHistoryUtils.getOrgStructureHistoryPkByOrgId(orgViewNumber, batchList)));
    }

    public static void saveOrgStructureDeleteHistoryById(List<Long> ids) {
        ThreadPools.executeOnceIncludeRequestContext((String)"saveOrgStructureHistoryById", () -> BaseBatchHandler.handle(ids, batchList -> OrgHistoryUtils.updateOrgStructureHistory(batchList, Utils.getDate((int)0))));
    }

    private static List<Long> getOrgStructurePkByOrgId(String orgViewNumber, List<Long> orgIds) {
        QFilter[] filters;
        DynamicObjectCollection orgCol;
        String selectFields = "id";
        QFilter orgFilter = new QFilter("org", "in", orgIds);
        if (StringUtils.isNotBlank((CharSequence)orgViewNumber)) {
            QFilter viewFilter = new QFilter("view.number", "=", (Object)orgViewNumber);
            orgFilter = orgFilter.and(viewFilter);
        }
        if (Utils.isListEmpty((List)(orgCol = QueryServiceHelper.query((String)"bos_org_structure", (String)selectFields, (QFilter[])(filters = new QFilter[]{orgFilter}))))) {
            return new ArrayList<Long>(0);
        }
        ArrayList<Long> ids = new ArrayList<Long>(orgCol.size());
        for (DynamicObject org : orgCol) {
            ids.add(org.getLong("id"));
        }
        return ids;
    }

    private static List<Long> getOrgStructureHistoryPkByOrgId(String orgViewNumber, List<Long> orgIds) {
        String selectFields = "id";
        QFilter orgFilter = new QFilter("org", "in", orgIds);
        if (StringUtils.isNotBlank((CharSequence)orgViewNumber)) {
            QFilter viewFilter = new QFilter("view.number", "=", (Object)orgViewNumber);
            orgFilter = orgFilter.and(viewFilter);
        }
        Date today = Utils.getDate((int)0);
        QFilter startDateFilter = new QFilter("startdate", "<=", (Object)today);
        QFilter endDateFilter = new QFilter("enddate", ">=", (Object)today);
        QFilter[] filters = new QFilter[]{orgFilter, startDateFilter, endDateFilter};
        DynamicObjectCollection orgCol = QueryServiceHelper.query((String)"bos_org_structure_history", (String)selectFields, (QFilter[])filters);
        if (Utils.isListEmpty((List)orgCol)) {
            return new ArrayList<Long>(0);
        }
        ArrayList<Long> ids = new ArrayList<Long>(orgCol.size());
        for (DynamicObject org : orgCol) {
            ids.add(org.getLong("id"));
        }
        return ids;
    }

    public static DynamicObject[] genOrgStructureHistoryObject(List<Long> ids) {
        if (Utils.isListEmpty(ids)) {
            return new DynamicObject[0];
        }
        DynamicObject type = BusinessDataServiceHelper.newDynamicObject((String)"bos_org_structure");
        DynamicObject[] sourceArr = (DynamicObject[])BusinessDataServiceHelper.load((Object[])ids.toArray(new Object[ids.size()]), (IDataEntityType)type.getDataEntityType());
        if (sourceArr == null || sourceArr.length == 0) {
            return new DynamicObject[0];
        }
        return OrgHistoryUtils.copyOrgStructureToHistory(sourceArr, ids);
    }

    public static DynamicObject[] copyOrgStructureToHistory(DynamicObject[] orgArr, List<Long> ids) {
        return OrgHistoryUtils.copyOrgStructureToHistory(orgArr, true);
    }

    private static DynamicObject[] copyOrgStructureToHistory(DynamicObject[] orgArr, boolean includeExtendProp) {
        Date today = Utils.getDate((int)0);
        Date endDate = Utils.getEndDate();
        HashMap<String, String> transKeyMap = new HashMap<String, String>(1);
        transKeyMap.put("id", "org");
        DynamicObject[] orgHistoryArr = new DynamicObject[orgArr.length];
        int index = 0;
        long curUserId = RequestContext.get().getCurrUserId();
        Date curTime = Calendar.getInstance().getTime();
        DynamicObjectType dynamicObjectType = DynamicObjectUtils.getDynamicObjectType("bos_org_structure_history", includeExtendProp);
        for (DynamicObject org : orgArr) {
            DynamicObject history = new DynamicObject(dynamicObjectType);
            DynamicObjectUtils.copy(org, history, transKeyMap);
            history.set("creator", (Object)curUserId);
            history.set("createtime", (Object)curTime);
            history.set("modifier", (Object)curUserId);
            history.set("modifytime", (Object)curTime);
            history.set("startdate", (Object)today);
            history.set("enddate", (Object)endDate);
            orgHistoryArr[index++] = history;
        }
        return orgHistoryArr;
    }

    private static List<Long> updateOrgStructureHistory(List<Long> ids, Date today) {
        if (Utils.isListEmpty(ids)) {
            return new ArrayList<Long>(0);
        }
        String selectFields = "id,startdate,enddate,modifier,modifytime";
        QFilter orgFilter = new QFilter("id", "in", ids);
        QFilter startDateFilter = new QFilter("startdate", "<=", (Object)today);
        QFilter endDateFilter = new QFilter("enddate", ">=", (Object)today);
        QFilter[] filters = new QFilter[]{orgFilter, startDateFilter, endDateFilter};
        DynamicObject[] orgArr = BusinessDataServiceHelper.load((String)"bos_org_structure_history", (String)selectFields, (QFilter[])filters);
        if (orgArr == null || orgArr.length == 0) {
            return new ArrayList<Long>(0);
        }
        ArrayList<Long> oldIds = new ArrayList<Long>(orgArr.length);
        long curUserId = RequestContext.get().getCurrUserId();
        Date curTime = Calendar.getInstance().getTime();
        for (DynamicObject orgHistory : orgArr) {
            orgHistory.set("modifier", (Object)curUserId);
            orgHistory.set("modifytime", (Object)curTime);
            Date startdate = orgHistory.getDate("startdate");
            if (startdate != null && startdate.compareTo(today) > 0) {
                orgHistory.set("startdate", (Object)today);
            }
            orgHistory.set("enddate", (Object)today);
            oldIds.add(orgHistory.getLong("id"));
        }
        SaveServiceHelper.save((DynamicObject[])orgArr);
        return oldIds;
    }
}

